/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsLogHandler;
import com.ibm.ws.logging.WsMessageRouter;
import com.ibm.ws.logging.internal.osgi.MessageRouterImpl;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WsMessageRouterImpl
extends MessageRouterImpl
implements WsMessageRouter {
    private static final ReentrantReadWriteLock RERWLOCK = new ReentrantReadWriteLock(true);
    private final ConcurrentMap<String, WsLogHandler> wsLogHandlerServices = new ConcurrentHashMap<String, WsLogHandler>();
    private Queue<RoutedMessage> earlierMessages;

    protected WsMessageRouterImpl() {
    }

    public void setEarlierMessages(Queue<RoutedMessage> earlierMessages) {
        this.earlierMessages = earlierMessages;
    }

    protected boolean shouldRouteMessageToLogHandler(RoutedMessage routedMessage, String logHandlerId) {
        if (routedMessage == null) {
            return false;
        }
        Set<String> logHandlerIds = this.getLogHandlersForMsgId("*");
        if (logHandlerIds != null && logHandlerIds.contains(logHandlerId)) {
            return true;
        }
        logHandlerIds = this.getLogHandlersForMessage(routedMessage.getFormattedMsg());
        return logHandlerIds == null ? false : logHandlerIds.contains(logHandlerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWsLogHandler(String id, WsLogHandler ref) {
        if (id != null && ref != null) {
            RERWLOCK.writeLock().lock();
            try {
                this.wsLogHandlerServices.put(id, ref);
                if (this.earlierMessages == null) {
                    return;
                }
                for (RoutedMessage earlierMessage : this.earlierMessages.toArray(new RoutedMessage[this.earlierMessages.size()])) {
                    if (!this.shouldRouteMessageToLogHandler(earlierMessage, id)) continue;
                    this.routeTo(earlierMessage, id);
                }
            }
            finally {
                RERWLOCK.writeLock().unlock();
            }
        }
    }

    public void unsetWsLogHandler(String id, WsLogHandler ref) {
        if (id != null) {
            if (ref == null) {
                this.wsLogHandlerServices.remove(id);
            } else {
                this.wsLogHandlerServices.remove(id, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean route(RoutedMessage routedMessage) {
        if (routedMessage == null) {
            return true;
        }
        RERWLOCK.readLock().lock();
        try {
            Set<String> logHandlerIds;
            Set<String> routeAllMsgsToTheseLogHandlers;
            if (this.earlierMessages != null) {
                this.earlierMessages.add(routedMessage);
            }
            if ((routeAllMsgsToTheseLogHandlers = this.getLogHandlersForMsgId("*")) != null) {
                this.routeToAll(routedMessage, routeAllMsgsToTheseLogHandlers);
            }
            if ((logHandlerIds = this.getLogHandlersForMessage(routedMessage.getFormattedMsg())) == null) {
                boolean bl = true;
                return bl;
            }
            if (routeAllMsgsToTheseLogHandlers != null) {
                if (!logHandlerIds.equals(routeAllMsgsToTheseLogHandlers)) {
                    HashSet<String> tempLogHandlerIds = new HashSet<String>();
                    for (String id : logHandlerIds) {
                        if (!id.equals("DEFAULT") && !id.equals("-DEFAULT") && !id.equals("+DEFAULT") && routeAllMsgsToTheseLogHandlers.contains(id)) continue;
                        tempLogHandlerIds.add(id);
                    }
                    boolean bl = this.routeToAll(routedMessage, tempLogHandlerIds);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = this.routeToAll(routedMessage, logHandlerIds);
            return bl;
        }
        finally {
            RERWLOCK.readLock().unlock();
        }
    }

    protected boolean routeToAll(RoutedMessage routedMessage, Set<String> logHandlerIds) {
        boolean logNormally = false;
        for (String logHandlerId : logHandlerIds) {
            if (logHandlerId.equals("DEFAULT")) {
                logNormally = true;
                continue;
            }
            this.routeTo(routedMessage, logHandlerId);
        }
        return logNormally;
    }

    protected void routeTo(RoutedMessage routedMessage, String logHandlerId) {
        WsLogHandler wsLogHandler = (WsLogHandler)this.wsLogHandlerServices.get(logHandlerId);
        if (wsLogHandler != null) {
            wsLogHandler.publish(routedMessage);
        }
    }
}

