/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CircuitBreakerConfig
extends AbstractAnnotationConfig<CircuitBreaker>
implements CircuitBreaker {
    private static final TraceComponent tc = Tr.register(CircuitBreakerConfig.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Class<? extends Throwable>[]> failOnConfig = this.getParameterConfigClassArray("failOn", Throwable.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Long> delayConfig = this.getParameterConfig("delay", Long.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<ChronoUnit> delayUnitConfig = this.getParameterConfig("delayUnit", ChronoUnit.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Integer> requestVolumeThresholdConfig = this.getParameterConfig("requestVolumeThreshold", Integer.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Double> failureRatioConfig = this.getParameterConfig("failureRatio", Double.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Integer> successThresholdConfig = this.getParameterConfig("successThreshold", Integer.class);
    static final long serialVersionUID = 8791599519303219224L;

    public CircuitBreakerConfig(Class<?> annotatedClass, CircuitBreaker annotation) {
        super(annotatedClass, annotation, CircuitBreaker.class);
    }

    public CircuitBreakerConfig(Method annotatedMethod, Class<?> annotatedClass, CircuitBreaker annotation) {
        super(annotatedMethod, annotatedClass, annotation, CircuitBreaker.class);
    }

    public Class<? extends Throwable>[] failOn() {
        return this.failOnConfig.getValue();
    }

    public long delay() {
        return this.delayConfig.getValue();
    }

    public ChronoUnit delayUnit() {
        return this.delayUnitConfig.getValue();
    }

    public int requestVolumeThreshold() {
        return this.requestVolumeThresholdConfig.getValue();
    }

    public double failureRatio() {
        return this.failureRatioConfig.getValue();
    }

    public int successThreshold() {
        return this.successThresholdConfig.getValue();
    }

    @Override
    public void validate() {
        String target = this.getTargetName();
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"circuitBreaker.parameter.delay.invalid.value.CWMFT5012E", (Object[])new Object[]{"delay", this.delay(), target}));
        }
        if (this.failureRatio() < 0.0 || this.failureRatio() > 1.0) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"circuitBreaker.parameter.failureRatio.invalid.value.CWMFT5013E", (Object[])new Object[]{"failureRatio", this.failureRatio(), target}));
        }
        if (this.requestVolumeThreshold() < 1) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"circuitBreaker.parameter.requestVolumeThreshold.invalid.value.CWMFT5014E", (Object[])new Object[]{"requestVolumeThreshold", this.requestVolumeThreshold(), target}));
        }
        if (this.successThreshold() < 1) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"circuitBreaker.parameter.successThreshold.invalid.value.CWMFT5015E", (Object[])new Object[]{"successThreshold", this.successThreshold(), target}));
        }
        if (this.failOn().length == 0) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"circuitBreaker.parameter.failOn.invalid.value.CWMFT5018E", (Object[])new Object[]{"failOn", target}));
        }
    }

    public CircuitBreakerPolicy generatePolicy() {
        Class[] failOn = this.failOn();
        Duration delay = Duration.of(this.delay(), this.delayUnit());
        int requestVolumeThreshold = this.requestVolumeThreshold();
        double failureRatio = this.failureRatio();
        int successThreshold = this.successThreshold();
        CircuitBreakerPolicy circuitBreakerPolicy = FaultToleranceProvider.newCircuitBreakerPolicy();
        circuitBreakerPolicy.setFailOn(failOn);
        circuitBreakerPolicy.setDelay(delay);
        circuitBreakerPolicy.setRequestVolumeThreshold(requestVolumeThreshold);
        circuitBreakerPolicy.setFailureRatio(failureRatio);
        circuitBreakerPolicy.setSuccessThreshold(successThreshold);
        return circuitBreakerPolicy;
    }
}

