/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.adaptable.module.structure.StructureHelper;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.ExtendedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.app.manager.springboot.container.SpringBootConfig;
import com.ibm.ws.app.manager.springboot.container.SpringBootConfigFactory;
import com.ibm.ws.app.manager.springboot.container.config.ConfigElement;
import com.ibm.ws.app.manager.springboot.container.config.ConfigElementList;
import com.ibm.ws.app.manager.springboot.container.config.KeyStore;
import com.ibm.ws.app.manager.springboot.container.config.ServerConfiguration;
import com.ibm.ws.app.manager.springboot.container.config.SpringConfiguration;
import com.ibm.ws.app.manager.springboot.container.config.VirtualHost;
import com.ibm.ws.app.manager.springboot.internal.LibIndexCache;
import com.ibm.ws.app.manager.springboot.internal.ServerConfigurationWriter;
import com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationFactory;
import com.ibm.ws.app.manager.springboot.internal.SpringBootModuleInfo;
import com.ibm.ws.app.manager.springboot.support.ContainerInstanceFactory;
import com.ibm.ws.app.manager.springboot.support.SpringBootApplication;
import com.ibm.ws.app.manager.springboot.util.SpringBootManifest;
import com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.metadata.extended.NestedModuleMetaDataFactory;
import com.ibm.ws.dynamic.bundle.BundleFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AddEntryToOverlay;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.InterpretedContainer;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpringBootApplicationImpl
extends DeployedAppInfoBase
implements SpringBootConfigFactory,
SpringBootApplication {
    private static final TraceComponent tc = Tr.register(SpringBootApplicationImpl.class);
    private final ApplicationInformation<DeployedAppInfo> applicationInformation;
    private final ArtifactContainer rawContainer;
    private final SpringBootManifest springBootManifest;
    private final SpringBootApplicationFactory factory;
    private final Throwable initError;
    private final SpringModuleContainerInfo springContainerModuleInfo;
    private final AtomicReference<ServiceRegistration<SpringBootConfigFactory>> springBootConfigReg = new AtomicReference();
    private final AtomicInteger nextConfigId = new AtomicInteger(0);
    private final int id;
    private final Set<Runnable> shutdownHooks = new CopyOnWriteArraySet<Runnable>();
    private final AtomicBoolean uninstalled = new AtomicBoolean();
    private final List<String> appArgs;
    private volatile AtomicReference<String> applicationActivated;
    static final long serialVersionUID = 5933097056288250438L;

    /*
     * WARNING - void declaration
     */
    public SpringBootApplicationImpl(ApplicationInformation<DeployedAppInfo> applicationInformation, SpringBootApplicationFactory factory, int id) throws UnableToAdaptException {
        super(applicationInformation, (DeployedAppInfoFactoryBase)factory);
        this.id = id;
        this.factory = factory;
        this.applicationInformation = applicationInformation;
        SpringBootManifest manifest = null;
        ArtifactContainer newContainer = null;
        List<ContainerInfo> infos = null;
        SpringModuleContainerInfo mci = null;
        Object error = null;
        try {
            newContainer = SpringBootApplicationImpl.storeLibs(applicationInformation, SpringBootApplicationImpl.getRawContainer(applicationInformation), manifest, factory);
            manifest = SpringBootApplicationImpl.getSpringBootManifest(applicationInformation);
            infos = SpringBootApplicationImpl.getContainerInfos(applicationInformation.getContainer(), factory, manifest);
            String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)applicationInformation.getLocation());
            mci = new SpringModuleContainerInfo(factory.getSpringBootSupport(), factory.getModuleHandler(), (List)factory.getModuleMetaDataExtenders().get("web"), (List)factory.getNestedModuleMetaDataFactories().get("web"), applicationInformation.getContainer(), null, moduleURI, this.moduleClassesInfo, infos);
            this.moduleContainerInfos.add(mci);
        }
        catch (UnableToAdaptException moduleURI) {
            void e;
            FFDCFilter.processException((Throwable)moduleURI, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"517", (Object)this, (Object[])new Object[]{applicationInformation, factory, id});
            error = e;
        }
        this.springBootManifest = manifest;
        this.rawContainer = newContainer;
        this.springContainerModuleInfo = mci;
        this.initError = error;
        Object appArgsProp = applicationInformation.getConfigProperty("applicationArgument");
        this.appArgs = appArgsProp instanceof String[] ? Collections.unmodifiableList(new ArrayList<String>(Arrays.asList((String[])appArgsProp))) : Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SpringBootManifest getSpringBootManifest(ApplicationInformation<DeployedAppInfo> appInfo) throws UnableToAdaptException {
        Entry manifestEntry = appInfo.getContainer().getEntry("META-INF/MANIFEST.MF");
        if (manifestEntry == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"error.no.manifest.found", (Object[])new Object[]{appInfo.getName()}));
        }
        try {
            SpringBootManifest springBootManifest;
            InputStream mfIn222;
            block13: {
                mfIn222 = (InputStream)manifestEntry.adapt(InputStream.class);
                Throwable throwable = null;
                try {
                    SpringBootManifest sbm = new SpringBootManifest(new Manifest(mfIn222));
                    if (sbm.getSpringStartClass() == null) {
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"error.no.spring.class.found", (Object[])new Object[0]));
                    }
                    springBootManifest = sbm;
                    if (mfIn222 == null) return springBootManifest;
                    if (throwable == null) break block13;
                }
                catch (Throwable throwable3) {
                    try {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"538", null, (Object[])new Object[]{appInfo});
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (mfIn222 == null) throw throwable4;
                        if (throwable == null) {
                            mfIn222.close();
                            throw throwable4;
                        }
                        try {
                            mfIn222.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            FFDCFilter.processException((Throwable)throwable5, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"544", null, (Object[])new Object[]{appInfo});
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                try {
                    mfIn222.close();
                    return springBootManifest;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"544", null, (Object[])new Object[]{appInfo});
                    throwable.addSuppressed(throwable2);
                    return springBootManifest;
                }
            }
            mfIn222.close();
            return springBootManifest;
        }
        catch (IOException mfIn222) {
            void e;
            FFDCFilter.processException((Throwable)mfIn222, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"544", null, (Object[])new Object[]{appInfo});
            throw new UnableToAdaptException((Throwable)e);
        }
    }

    private static ArtifactContainer getRawContainer(ApplicationInformation<DeployedAppInfo> applicationInformation) throws UnableToAdaptException {
        Container container = applicationInformation.getContainer();
        final AtomicReference rawContainer = new AtomicReference();
        ((InterpretedContainer)container.adapt(InterpretedContainer.class)).setStructureHelper(new StructureHelper(){
            static final long serialVersionUID = 2744683933028001907L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public boolean isValid(ArtifactContainer e, String path) {
                return false;
            }

            public boolean isRoot(ArtifactContainer e) {
                rawContainer.set(e);
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return (ArtifactContainer)rawContainer.get();
    }

    /*
     * WARNING - void declaration
     */
    private static ArtifactContainer storeLibs(ApplicationInformation<DeployedAppInfo> applicationInformation, ArtifactContainer rawContainer, SpringBootManifest springBootManifest, SpringBootApplicationFactory factory) {
        String location = applicationInformation.getLocation();
        if (location.toLowerCase().endsWith(".xml")) {
            return rawContainer;
        }
        Container container = applicationInformation.getContainer();
        Entry entry = container.getEntry("META-INF/spring.lib.index");
        if (entry != null) {
            return rawContainer;
        }
        File springAppFile = new File(location);
        if (springAppFile.isDirectory()) {
            return rawContainer;
        }
        WsResource thinAppsDir = factory.getLocationAdmin().resolveResource("${server.workarea.dir}/spring/spring.thin.apps/");
        thinAppsDir.create();
        WsResource thinSpringAppResource = factory.getLocationAdmin().resolveResource("${server.workarea.dir}/spring/spring.thin.apps/" + applicationInformation.getName() + "." + "spring");
        File thinSpringAppFile = thinSpringAppResource.asFile();
        try {
            if (thinSpringAppFile.exists()) {
                if (thinSpringAppFile.lastModified() != springAppFile.lastModified()) {
                    SpringBootApplicationImpl.thinSpringApp(factory.getLibIndexCache(), springAppFile, thinSpringAppFile, springAppFile.lastModified());
                }
            } else {
                SpringBootApplicationImpl.thinSpringApp(factory.getLibIndexCache(), springAppFile, thinSpringAppFile, springAppFile.lastModified());
            }
            ArtifactContainer artifactContainer = SpringBootApplicationImpl.setupArtifactContainer(thinSpringAppFile, factory);
            container = SpringBootApplicationImpl.setupContainer(applicationInformation.getPid(), artifactContainer, factory);
            applicationInformation.setContainer(container);
            return artifactContainer;
        }
        catch (IOException | NoSuchAlgorithmException artifactContainer) {
            void e;
            FFDCFilter.processException((Throwable)artifactContainer, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"614", null, (Object[])new Object[]{applicationInformation, rawContainer, springBootManifest, factory});
            Tr.error((TraceComponent)tc, (String)"warning.could.not.thin.application", (Object[])new Object[]{applicationInformation.getName(), e.getMessage()});
            return rawContainer;
        }
    }

    private static void thinSpringApp(LibIndexCache libIndexCache, File springAppFile, File thinSpringAppFile, long lastModified) throws IOException, NoSuchAlgorithmException {
        File parent = libIndexCache.getLibIndexParent();
        File workarea = libIndexCache.getLibIndexWorkarea();
        SpringBootThinUtil springBootThinUtil = new SpringBootThinUtil(springAppFile, thinSpringAppFile, workarea, parent);
        springBootThinUtil.execute();
        thinSpringAppFile.setLastModified(lastModified);
    }

    private static ArtifactContainer setupArtifactContainer(File f, SpringBootApplicationFactory factory) throws IOException {
        File cacheDir = factory.getDataDir("cache");
        return factory.getArtifactFactory().getContainer(cacheDir, (Object)f);
    }

    private static Container setupContainer(String pid, ArtifactContainer artifactContainer, SpringBootApplicationFactory factory) throws IOException {
        File cacheAdapt = factory.getDataDir("cacheAdapt");
        File cacheOverlay = factory.getDataDir("cacheOverlay");
        return factory.getModuleFactory().getContainer(cacheAdapt, cacheOverlay, artifactContainer);
    }

    Throwable getError() {
        return this.initError;
    }

    SpringBootManifest getSpringBootManifest() {
        return this.springBootManifest;
    }

    List<String> getAppArgs() {
        return this.appArgs;
    }

    @Override
    public Container createContainerFor(String id) throws IOException, UnableToAdaptException {
        Container container = SpringBootApplicationImpl.setupContainer(this.applicationInformation.getPid(), this.rawContainer, this.factory);
        AddEntryToOverlay virtualHostBnd = (AddEntryToOverlay)container.adapt(AddEntryToOverlay.class);
        virtualHostBnd.add("WEB-INF/ibm-web-bnd.xml", this.getVirtualHostConfig("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-bnd \n        xmlns=\"http://websphere.ibm.com/xml/ns/javaee\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:schemaLocation=\"http://websphere.ibm.com/xml/ns/javaee http://websphere.ibm.com/xml/ns/javaee/ibm-web-bnd_1_0.xsd\"\n        version=\"1.0\">\n\n        <virtual-host name=\"", id, "\" />\n</web-bnd>"));
        virtualHostBnd.add("WEB-INF/ibm-web-bnd.xmi", this.getVirtualHostConfig("<webappbnd:WebAppBinding\nxmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\"\nxmlns:webappbnd=\"webappbnd.xmi\"\nvirtualHostName=\"", id, "\">\n</webappbnd:WebAppBinding>"));
        return container;
    }

    @Override
    public ModuleClassesContainerInfo getSpringClassesContainerInfo() {
        return this.springContainerModuleInfo;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.springContainerModuleInfo.getClassLoader();
    }

    @Override
    public ExtendedApplicationInfo createApplicationInfo(String id, Container appContainer) {
        ExtendedApplicationInfo appInfo = this.appInfoFactory.createApplicationInfo(this.getName() + "." + id, this.springContainerModuleInfo.moduleName + "." + id, appContainer, null, null);
        return appInfo;
    }

    @Override
    public void destroyApplicationInfo(ExtendedApplicationInfo appInfo) {
        this.appInfoFactory.destroyApplicationInfo((ApplicationInfo)appInfo);
    }

    public boolean uninstallApp() {
        if (this.uninstalled.getAndSet(true)) {
            return true;
        }
        try {
            boolean bl = super.uninstallApp();
            return bl;
        }
        finally {
            AtomicReference<String> current = this.applicationActivated;
            if (current != null) {
                current.compareAndSet(this.applicationInformation.getName(), null);
            }
        }
    }

    private String getVirtualHostConfig(String start, String virtualHostId, String end) {
        StringBuilder builder = new StringBuilder(start);
        builder.append(virtualHostId);
        builder.append(end);
        return builder.toString();
    }

    private static List<ContainerInfo> getContainerInfos(Container container, SpringBootApplicationFactory factory, SpringBootManifest manifest) throws UnableToAdaptException {
        Entry indexFile;
        Container classesContainer;
        ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
        Entry classesEntry = container.getEntry(manifest.getSpringBootClasses());
        if (classesEntry != null && (classesContainer = (Container)classesEntry.adapt(Container.class)) != null) {
            ContainerInfoImpl containerInfo = new ContainerInfoImpl(ContainerInfo.Type.WEB_INF_CLASSES, manifest.getSpringBootClasses(), classesContainer);
            containerInfos.add(containerInfo);
        }
        if ((indexFile = container.getEntry("META-INF/spring.lib.index")) != null) {
            containerInfos.addAll(SpringBootApplicationImpl.getStoredIndexClassesInfos(indexFile, factory.getLibIndexCache()));
        } else {
            containerInfos.addAll(SpringBootApplicationImpl.getSpringBootLibs(container, manifest, new ArrayList<String>()));
        }
        for (Container supportContainer : factory.getSpringBootSupport()) {
            Entry supportEntry = (Entry)supportContainer.adapt(Entry.class);
            ContainerInfoImpl containerInfo = new ContainerInfoImpl(ContainerInfo.Type.WEB_INF_LIB, manifest.getSpringBootLib() + '/' + supportEntry.getName(), supportContainer);
            containerInfos.add(containerInfo);
        }
        return Collections.unmodifiableList(containerInfos);
    }

    private static List<ContainerInfo> getSpringBootLibs(Container moduleContainer, SpringBootManifest manifest, ArrayList<String> resolved) throws UnableToAdaptException {
        ArrayList<ContainerInfo> result = new ArrayList<ContainerInfo>();
        Entry libEntry = moduleContainer.getEntry(manifest.getSpringBootLib());
        if (libEntry != null) {
            Container libContainer = (Container)libEntry.adapt(Container.class);
            SpringBootThinUtil.StarterFilter starterFilter = SpringBootThinUtil.getStarterFilter(SpringBootApplicationImpl.stringStream(libContainer));
            if (libContainer != null) {
                for (Entry entry : libContainer) {
                    if (starterFilter.apply(entry.getName()).booleanValue()) continue;
                    String jarEntryName = entry.getName();
                    Container jarContainer = (Container)entry.adapt(Container.class);
                    if (jarContainer == null) continue;
                    ContainerInfoImpl containerInfo = new ContainerInfoImpl(ContainerInfo.Type.WEB_INF_LIB, manifest.getSpringBootLib() + '/' + jarEntryName, jarContainer);
                    result.add(containerInfo);
                    ManifestClassPathUtils.addCompleteJarEntryUrls(result, (Entry)entry, resolved);
                }
            }
        }
        return result;
    }

    public static Stream<String> stringStream(Container container) {
        Stream<String> stream = StreamSupport.stream(container.spliterator(), false).map(entry -> entry.getName());
        return stream;
    }

    private static List<ContainerInfo> getStoredIndexClassesInfos(Entry indexFile, LibIndexCache libIndexCache) throws UnableToAdaptException {
        ArrayList<ContainerInfo> result = new ArrayList<ContainerInfo>();
        Map<String, String> indexMap = SpringBootApplicationImpl.readIndex(indexFile);
        for (Map.Entry<String, String> entry : indexMap.entrySet()) {
            Container libContainer = libIndexCache.getLibraryContainer(entry);
            if (libContainer == null) {
                throw new UnableToAdaptException("No library found for:" + entry.getKey() + "=" + entry.getValue());
            }
            ContainerInfoImpl containerInfo = new ContainerInfoImpl(ContainerInfo.Type.WEB_INF_LIB, entry.getKey(), libContainer);
            result.add(containerInfo);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> readIndex(Entry indexFile) throws UnableToAdaptException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            InputStream in;
            block13: {
                in = (InputStream)indexFile.adapt(InputStream.class);
                Throwable throwable = null;
                try {
                    if (in != null) {
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        while ((line = br.readLine()) != null) {
                            String[] values = line.split("=");
                            result.put(values[0], values[1]);
                        }
                    }
                    if (in == null) return result;
                    if (throwable == null) break block13;
                }
                catch (Throwable throwable3) {
                    try {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"779", null, (Object[])new Object[]{indexFile});
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (in == null) throw throwable4;
                        if (throwable == null) {
                            in.close();
                            throw throwable4;
                        }
                        try {
                            in.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            FFDCFilter.processException((Throwable)throwable5, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"788", null, (Object[])new Object[]{indexFile});
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                try {
                    in.close();
                    return result;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"788", null, (Object[])new Object[]{indexFile});
                    throwable.addSuppressed(throwable2);
                    return result;
                }
            }
            in.close();
            return result;
        }
        catch (IOException in) {
            void e;
            FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"788", null, (Object[])new Object[]{indexFile});
            throw new UnableToAdaptException((Throwable)e);
        }
    }

    public List<ModuleClassesContainerInfo> getModuleClassesContainerInfo() {
        return Collections.singletonList(this.springContainerModuleInfo);
    }

    public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
        if (moduleInfo instanceof SpringBootModuleInfo) {
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String appName = appInfo.getDeploymentName();
            String moduleName = moduleInfo.getURI();
            ClassLoadingService cls = this.classLoadingService;
            ArrayList<Container> containers = new ArrayList<Container>();
            Iterator<ContainerInfo> infos = moduleClassesContainers.iterator();
            if (infos.hasNext()) {
                infos.next();
                while (infos.hasNext()) {
                    containers.add(infos.next().getContainer());
                }
                containers.add(moduleClassesContainers.get(0).getContainer());
            }
            GatewayConfiguration gwCfg = cls.createGatewayConfiguration().setApplicationName(appName).setDynamicImportPackage(new String[]{"*"});
            ProtectionDomain protectionDomain = this.getProtectionDomain();
            ClassLoaderConfiguration clCfg = cls.createClassLoaderConfiguration().setId(cls.createIdentity("SpringModule", appName + "#" + moduleName)).setProtectionDomain(protectionDomain).setIncludeAppExtensions(true);
            return this.createTopLevelClassLoader(containers, gwCfg, clCfg);
        }
        return null;
    }

    protected ExtendedApplicationInfo createApplicationInfo() {
        ExtendedApplicationInfo appInfo = this.appInfoFactory.createApplicationInfo(this.getName(), this.springContainerModuleInfo.moduleName, this.getContainer(), (ApplicationClassesContainerInfo)this, this.getConfigHelper());
        this.springContainerModuleInfo.moduleName = appInfo.getName();
        return appInfo;
    }

    void registerSpringConfigFactory() {
        ClassLoader cl;
        for (cl = this.springContainerModuleInfo.getClassLoader(); cl != null && !(cl instanceof BundleReference); cl = cl.getParent()) {
        }
        if (cl == null) {
            throw new IllegalStateException("Did not find a BundleReference class loader.");
        }
        Bundle b = ((BundleReference)cl).getBundle();
        BundleContext context = b.getBundleContext();
        this.springBootConfigReg.updateAndGet(r -> {
            if (r != null) {
                r.unregister();
            }
            return context.registerService(SpringBootConfigFactory.class, (Object)this, null);
        });
    }

    @FFDCIgnore(value={IllegalStateException.class})
    void unregisterSpringConfigFactory() {
        try {
            this.springBootConfigReg.updateAndGet(r -> {
                if (r != null) {
                    r.unregister();
                }
                return null;
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public SpringBootConfig createSpringBootConfig() {
        return new SpringBootConfigImpl(this.nextConfigId.getAndIncrement());
    }

    @Override
    public void addShutdownHook(Runnable hook) {
        this.shutdownHooks.add(hook);
    }

    @Override
    public void removeShutdownHook(Runnable hook) {
        this.shutdownHooks.remove(hook);
    }

    void callShutdownHooks() {
        for (Runnable hook : this.shutdownHooks) {
            try {
                hook.run();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl", (String)"923", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void rootContextClosed() {
        this.uninstallApp();
    }

    @Override
    public File getServerDir() {
        return this.factory.getLocationAdmin().resolveResource("${server.config.dir}/").asFile();
    }

    void setApplicationActivated(AtomicReference<String> applicationActivated) {
        this.applicationActivated = applicationActivated;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class SpringBootConfigImpl
    implements SpringBootConfig {
        private final String id;
        private final AtomicReference<ServerConfiguration> serverConfig = new AtomicReference();
        private final AtomicReference<Bundle> virtualHostConfig = new AtomicReference();
        private final AtomicReference<ContainerInstanceFactory.Instance> configInstance = new AtomicReference();
        static final long serialVersionUID = -4366728056499921345L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SpringBootConfigImpl(int id) {
            this.id = SpringBootApplicationImpl.this.id + "-" + id;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> void configure(ServerConfiguration config, T helperParam, Class<T> type, SpringConfiguration additionalConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SpringConfiguration Info = " + additionalConfig), (Object[])new Object[0]);
            }
            if (tc.isWarningEnabled()) {
                if (additionalConfig.isCompression_configured_in_spring_app()) {
                    Tr.warning((TraceComponent)tc, (String)"warning.spring_config.ignored.compression", (Object[])new Object[0]);
                }
                if (additionalConfig.isSession_configured_in_spring_app()) {
                    Tr.warning((TraceComponent)tc, (String)"warning.spring_config.ignored.session", (Object[])new Object[0]);
                }
            }
            if (!config.getSsls().isEmpty() && !this.isSSLEnabled()) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"error.missing.ssl", (Object[])new Object[0]));
            }
            ContainerInstanceFactory<T> containerInstanceFactory = SpringBootApplicationImpl.this.factory.getContainerInstanceFactory(type);
            if (containerInstanceFactory == null) {
                throw new IllegalStateException("No configuration helper found for: " + type);
            }
            if (!this.serverConfig.compareAndSet(null, config)) {
                throw new IllegalStateException("Server configuration already set.");
            }
            String virtualHostId = "default_host";
            ConfigElementList<VirtualHost> virtualHosts = config.getVirtualHosts();
            if (!virtualHosts.isEmpty()) {
                virtualHostId = ((VirtualHost)config.getVirtualHosts().iterator().next()).getId();
            }
            try {
                if (!this.configInstance.compareAndSet(null, containerInstanceFactory.intialize(SpringBootApplicationImpl.this, this.id, virtualHostId, helperParam, additionalConfig))) {
                    throw new IllegalStateException("Config instance already created.");
                }
            }
            catch (MetaDataException | UnableToAdaptException | IOException throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"230", (Object)this, (Object[])new Object[]{config, helperParam, type, additionalConfig});
                throw new IllegalArgumentException((Throwable)e);
            }
        }

        private boolean isSSLEnabled() {
            Bundle systemBundle = SpringBootApplicationImpl.this.factory.getBundleContext().getBundle("System Bundle");
            FrameworkWiring fwkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            Collection packages = fwkWiring.findProviders(new Requirement(){
                static final long serialVersionUID = 2519850139086320871L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Resource getResource() {
                    return null;
                }

                public String getNamespace() {
                    return "osgi.wiring.package";
                }

                public Map<String, String> getDirectives() {
                    return Collections.singletonMap("filter", "(osgi.wiring.package=com.ibm.ws.ssl)");
                }

                public Map<String, Object> getAttributes() {
                    return Collections.emptyMap();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            return !packages.isEmpty();
        }

        @Override
        public void start() {
            ServerConfiguration config = this.serverConfig.getAndSet(null);
            if (config == null) {
                throw new IllegalStateException("No server configuration set.");
            }
            ContainerInstanceFactory.Instance instance = this.configInstance.get();
            if (instance == null) {
                throw new IllegalStateException("No Config instance set.");
            }
            this.checkExistingConfig(config);
            if (!config.getVirtualHosts().isEmpty()) {
                this.virtualHostConfig.updateAndGet(b -> this.installVirtualHostBundle((Bundle)b, config));
            }
            instance.start();
        }

        @Override
        public void stop() {
            this.virtualHostConfig.getAndUpdate(b -> {
                if (b != null) {
                    try {
                        if (!FrameworkState.isStopping()) {
                            b.uninstall();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (BundleException bundleException) {
                        // empty catch block
                    }
                }
                return null;
            });
            this.configInstance.getAndUpdate(i -> {
                if (i != null) {
                    i.stop();
                }
                return null;
            });
        }

        /*
         * WARNING - void declaration
         */
        private Bundle installVirtualHostBundle(Bundle previous, ServerConfiguration libertyConfig) {
            if (previous != null) {
                try {
                    previous.uninstall();
                }
                catch (BundleException bundleException) {
                    FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"316", (Object)this, (Object[])new Object[]{previous, libertyConfig});
                }
            }
            BundleContext context = SpringBootApplicationImpl.this.factory.getBundleContext();
            BundleFactory factory = new BundleFactory();
            String name = "com.ibm.ws.app.manager.springboot." + this.id;
            factory.setBundleName(name);
            factory.setBundleSymbolicName(name);
            factory.setBundleLocationPrefix("springBootVirtualHost@");
            factory.setBundleLocation("springBoot:" + this.id);
            factory.setDefaultInstance(this.getDefaultInstances(libertyConfig, this.id));
            factory.setBundleContext(context);
            factory.addManifestAttribute("IBM-Default-Config", Collections.singleton("OSGI-INF/wlp/defaultInstances.xml"));
            String configCap = "liberty.springboot.config; liberty.springboot.config=\"" + this.id + "\"";
            factory.addManifestAttribute("Provide-Capability", Collections.singleton(configCap));
            Bundle b = factory.createBundle();
            ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(((BundleStartLevel)context.getBundle().adapt(BundleStartLevel.class)).getStartLevel());
            try {
                b.start(1);
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"336", (Object)this, (Object[])new Object[]{previous, libertyConfig});
                throw new IllegalStateException((Throwable)e);
            }
            return b;
        }

        private void checkExistingConfig(ServerConfiguration libertyConfig) {
            ConfigElementList<VirtualHost> hosts = libertyConfig.getVirtualHosts();
            if (hosts.isEmpty()) {
                return;
            }
            String requestedPort = ((VirtualHost)hosts.get(0)).getId().substring("springBootVirtualHost-".length());
            if (this.checkVirtualHost(libertyConfig, requestedPort)) {
                return;
            }
            if (this.checkHttpEndpoint(libertyConfig, requestedPort)) {
                return;
            }
            if (this.checkSsl(libertyConfig, requestedPort)) {
                return;
            }
            this.checkKeyStores(libertyConfig);
        }

        private boolean checkVirtualHost(ServerConfiguration sc, String requestedPort) {
            String virtualHostFilter = this.createFilter("com.ibm.ws.http.virtualhost", "springBootVirtualHost-" + requestedPort);
            return this.checkConfigElement(sc, virtualHostFilter, sc.getVirtualHosts(), sc.getHttpEndpoints(), sc.getSsls(), sc.getKeyStores());
        }

        private boolean checkHttpEndpoint(ServerConfiguration sc, String requestedPort) {
            String endpointFilter = this.createFilter("com.ibm.ws.http", "springBootHttpEndpoint-" + requestedPort);
            return this.checkConfigElement(sc, endpointFilter, sc.getHttpEndpoints(), sc.getSsls(), sc.getKeyStores());
        }

        private boolean checkSsl(ServerConfiguration sc, String requestedPort) {
            String sslFilter = this.createFilter("com.ibm.ws.ssl.repertoire", "springBootSsl-" + requestedPort);
            return this.checkConfigElement(sc, sslFilter, sc.getSsls(), sc.getKeyStores());
        }

        /*
         * WARNING - void declaration
         */
        private boolean checkConfigElement(ServerConfiguration libertyConfig, String filter, List<? extends ConfigElement> toCheck, List ... lowerPriority) {
            boolean result = false;
            try {
                if (toCheck.isEmpty()) {
                    result = true;
                    boolean bl = true;
                    return bl;
                }
                Configuration[] existing = SpringBootApplicationImpl.this.factory.getConfigurationAdmin().listConfigurations(filter);
                result = existing != null && existing.length > 0;
                boolean bl = result;
                return bl;
            }
            catch (IOException | InvalidSyntaxException existing) {
                void e;
                FFDCFilter.processException((Throwable)existing, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"398", (Object)this, (Object[])new Object[]{libertyConfig, filter, toCheck, lowerPriority});
                throw new RuntimeException((Throwable)e);
            }
            finally {
                if (result) {
                    toCheck.clear();
                    for (List toClear : lowerPriority) {
                        toClear.clear();
                    }
                }
            }
        }

        private String createFilter(String factoryPid, String id) {
            StringBuilder sb = new StringBuilder();
            sb.append("(&");
            sb.append('(').append("service.factoryPid").append('=').append(factoryPid).append(')');
            sb.append('(').append("id=").append(id).append(')');
            sb.append(')');
            return sb.toString();
        }

        private boolean checkKeyStores(ServerConfiguration sc) {
            boolean result = false;
            ConfigElementList<KeyStore> keyStores = sc.getKeyStores();
            Iterator iKeyStores = keyStores.iterator();
            while (iKeyStores.hasNext()) {
                KeyStore keyStore = (KeyStore)iKeyStores.next();
                if (!this.checkKeyStore(keyStore)) continue;
                iKeyStores.remove();
                result = true;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private boolean checkKeyStore(KeyStore keyStore) {
            try {
                String filter = this.createFilter("com.ibm.ws.ssl.keystore", keyStore.getId());
                Configuration[] existing = SpringBootApplicationImpl.this.factory.getConfigurationAdmin().listConfigurations(filter);
                return existing != null && existing.length > 0;
            }
            catch (IOException | InvalidSyntaxException filter) {
                void e;
                FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"444", (Object)this, (Object[])new Object[]{keyStore});
                throw new RuntimeException((Throwable)e);
            }
        }

        @FFDCIgnore(value={IOException.class})
        private String getDefaultInstances(ServerConfiguration libertyConfig, String configId) {
            if (libertyConfig.getVirtualHosts().size() > 1) {
                throw new IllegalStateException("Only one virtualHost is allowed: " + libertyConfig.getVirtualHosts());
            }
            if (libertyConfig.getHttpEndpoints().size() > 1) {
                throw new IllegalStateException("Only one httpEndpoint is allowed: " + libertyConfig.getHttpEndpoints());
            }
            if (libertyConfig.getSsls().size() > 1) {
                throw new IllegalStateException("Only one ssl is allowed: " + libertyConfig.getSsls());
            }
            StringWriter result = new StringWriter();
            try {
                ServerConfigurationWriter.getInstance().write(libertyConfig, result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (JAXBException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringBootConfigImpl", (String)"467", (Object)this, (Object[])new Object[]{libertyConfig, configId});
                throw new RuntimeException(e);
            }
            return result.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SpringBootConfigImpl.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ContainerInfoImpl
    implements ContainerInfo {
        private final ContainerInfo.Type type;
        private final String name;
        private final Container container;
        static final long serialVersionUID = 5496252071648882436L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerInfoImpl(ContainerInfo.Type type, String name, Container container) {
            this.type = type;
            this.name = name;
            this.container = container;
        }

        public ContainerInfo.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.container;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContainerInfoImpl.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class SpringModuleContainerInfo
    extends SimpleDeployedAppInfoBase.ModuleContainerInfoBase {
        static final long serialVersionUID = -1621036262939138287L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SpringModuleContainerInfo(List<Container> springBootSupport, ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, SimpleDeployedAppInfoBase.ModuleClassesInfoProvider moduleClassesInfo, List<ContainerInfo> containerInfos) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.WEB_MODULE, moduleClassesInfo, WebApp.class);
            this.classesContainerInfo.addAll(containerInfos);
        }

        /*
         * WARNING - void declaration
         */
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            try {
                SpringBootModuleInfo springModuleInfo = new SpringBootModuleInfo(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, moduleClassLoaderFactory, this.getSpringBootApplication());
                return springModuleInfo;
            }
            catch (UnableToAdaptException springModuleInfo) {
                void e;
                FFDCFilter.processException((Throwable)springModuleInfo, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl$SpringModuleContainerInfo", (String)"141", (Object)((Object)this), (Object[])new Object[]{appInfo, moduleClassLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"createModuleInfo", (Object)((Object)this));
                return null;
            }
        }

        SpringBootApplicationImpl getSpringBootApplication() {
            return SpringBootApplicationImpl.this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SpringModuleContainerInfo.class);
        }
    }
}

