/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public abstract class SpringBootSupport {
    private static final TraceComponent tc = Tr.register(SpringBootSupport.class);
    protected List<String> jars;
    static final long serialVersionUID = -1753858012759392536L;

    public List<String> getJarPaths() {
        return this.jars;
    }

    @Activate
    protected void activate(BundleContext context) {
        this.jars = this.getJarPaths(context);
    }

    private List<String> getJarPaths(BundleContext context) {
        Bundle b = context.getBundle();
        BundleRevision rev = (BundleRevision)b.adapt(BundleRevision.class);
        List supportCaps = rev.getDeclaredCapabilities("spring.boot.support");
        if (supportCaps.isEmpty()) {
            FFDCFilter.processException((Throwable)new RuntimeException("No Spring Boot support capability found in: " + b.getSymbolicName()), (String)SpringBootSupport.class.getName(), (String)"getJarPaths");
            return Collections.emptyList();
        }
        BundleCapability supportCap = (BundleCapability)supportCaps.iterator().next();
        List jarsAttr = (List)supportCap.getAttributes().get("jars");
        if (jarsAttr == null || jarsAttr.isEmpty()) {
            FFDCFilter.processException((Throwable)new RuntimeException("No Spring Boot support jars found in: " + supportCap), (String)SpringBootSupport.class.getName(), (String)"getJarPaths");
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(jarsAttr.size());
        for (String jarPath : jarsAttr) {
            URL jarEntry = b.getEntry(jarPath);
            if (jarEntry != null) {
                result.add(jarPath);
                continue;
            }
            FFDCFilter.processException((Throwable)new RuntimeException("No Spring Boot jars found at path: " + jarPath), (String)SpringBootSupport.class.getName(), (String)"getJarPaths");
        }
        return Collections.unmodifiableList(result);
    }
}

