/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class FrameworkEventAdapter
implements FrameworkListener {
    private static final String FRAMEWORK_EVENT_TOPIC_PREFIX = "org/osgi/framework/FrameworkEvent/";
    private final EventAdmin eventAdmin;
    static final long serialVersionUID = -1092610607214715909L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FrameworkEventAdapter(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        Throwable throwable;
        String topic = this.getTopic(frameworkEvent);
        if (topic == null) {
            return;
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("event", frameworkEvent);
        Bundle bundle = frameworkEvent.getBundle();
        if (bundle != null) {
            eventProperties.put("bundle.id", bundle.getBundleId());
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName != null) {
                eventProperties.put("bundle.symbolicName", symbolicName);
            }
            eventProperties.put("bundle", bundle);
        }
        if ((throwable = frameworkEvent.getThrowable()) != null) {
            eventProperties.put("exception.class", throwable.getClass().getName());
            String message = throwable.getMessage();
            if (message != null) {
                eventProperties.put("exception.message", message);
            }
            eventProperties.put("exception", throwable);
        }
        Event event = new Event(topic, eventProperties);
        this.eventAdmin.postEvent(event);
    }

    private String getTopic(FrameworkEvent frameworkEvent) {
        StringBuilder topic = new StringBuilder(FRAMEWORK_EVENT_TOPIC_PREFIX);
        switch (frameworkEvent.getType()) {
            case 1: {
                topic.append("STARTED");
                break;
            }
            case 2: {
                topic.append("ERROR");
                break;
            }
            case 4: {
                topic.append("PACKAGES_REFRESHED");
                break;
            }
            case 8: {
                topic.append("STARTLEVEL_CHANGED");
                break;
            }
            case 16: {
                topic.append("WARNING");
                break;
            }
            case 32: {
                topic.append("INFO");
                break;
            }
            default: {
                return null;
            }
        }
        return topic.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FrameworkEventAdapter.class);
    }
}

