/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

class IDLEntityDescriptor
extends ValueDescriptor {
    private final boolean isCorba;
    private final Class helperType;
    private volatile Method readMethod = null;
    private volatile Method writeMethod = null;
    private volatile Method typeMethod = null;

    IDLEntityDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
        this.isCorba = Object.class.isAssignableFrom(type);
        try {
            String helperName = type.getName() + "Helper";
            this.helperType = Util.loadClass((String)helperName, null, (ClassLoader)type.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("cannot load IDL Helper class for " + type, ex);
        }
    }

    @Override
    protected final String genIDLName() {
        return "org_omg_boxedIDL_" + super.genIDLName();
    }

    private Method getReadMethod() {
        if (null == this.readMethod) {
            this.readMethod = this.genHelperMethod("read");
        }
        return this.readMethod;
    }

    private Method getWriteMethod() {
        if (null == this.writeMethod) {
            this.writeMethod = this.genHelperMethod("write");
        }
        return this.writeMethod;
    }

    private Method getTypeMethod() {
        if (null == this.typeMethod) {
            this.typeMethod = this.genHelperMethod("type");
        }
        return this.typeMethod;
    }

    private Method genHelperMethod(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                for (Method m : IDLEntityDescriptor.this.helperType.getDeclaredMethods()) {
                    if (!m.getName().equals(name)) continue;
                    return m;
                }
                throw new RuntimeException("Unable to find " + name + " method for " + IDLEntityDescriptor.this.helperType.getName());
            }
        });
    }

    @Override
    public java.lang.Object read(org.omg.CORBA.portable.InputStream in) {
        InputStream _in = (InputStream)in;
        if (this.isCorba) {
            return _in.read_Object(this.type);
        }
        return _in.read_value(this.getRepositoryID());
    }

    @Override
    public Serializable readValue(org.omg.CORBA.portable.InputStream in, Map<Integer, Serializable> offsetMap, Integer offset) {
        try {
            Serializable value = (Serializable)this.getReadMethod().invoke(null, in);
            offsetMap.put(offset, value);
            return value;
        }
        catch (InvocationTargetException ex) {
            throw (MARSHAL)new MARSHAL("" + ex.getCause()).initCause(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    public void write(org.omg.CORBA.portable.OutputStream out, java.lang.Object val) {
        OutputStream _out = (OutputStream)out;
        if (val instanceof ObjectImpl) {
            _out.write_Object((Object)val);
        } else {
            _out.write_value((Serializable)val, this.getRepositoryID());
        }
    }

    @Override
    public void writeValue(org.omg.CORBA.portable.OutputStream out, Serializable val) {
        try {
            this.getWriteMethod().invoke(null, out, val);
        }
        catch (InvocationTargetException ex) {
            throw (MARSHAL)new MARSHAL("" + ex.getCause()).initCause(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    protected TypeCode genTypeCode() {
        try {
            return (TypeCode)this.getTypeMethod().invoke(null, new java.lang.Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw (MARSHAL)new MARSHAL("" + ex.getCause()).initCause(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }
}

