/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureResourceImpl;
import com.ibm.ws.kernel.feature.internal.subsystem.HeaderElementDefinitionImpl;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class KernelFeatureDefinitionImpl
extends SubsystemFeatureDefinitionImpl {
    private static final String OSGI_PKG_PREFIX = "org.osgi.";
    private static volatile List<ProvisioningFeatureDefinition> kernelDefs;
    private static String installRoot;
    private static volatile String kernelApiServices;
    private final boolean isSystemBundleProvider = Boolean.parseBoolean(super.getHeader("WebSphere-SystemBundleProvider"));
    private final Collection<HeaderElementDefinition> sysPkgApiHeader;
    private final Collection<HeaderElementDefinition> sysPkgSpiHeader;
    static final long serialVersionUID = 4046445846388115771L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static List<ProvisioningFeatureDefinition> getKernelFeatures(BundleContext ctx, WsLocationAdmin locationService) {
        List<ProvisioningFeatureDefinition> result = kernelDefs;
        if (result == null) {
            result = kernelDefs = KernelFeatureDefinitionImpl.getKernelFeatures(ctx, locationService, false);
        }
        return result;
    }

    public static void dispose() {
        kernelDefs = null;
    }

    public static Collection<ProvisioningFeatureDefinition> getAllKernelFeatures(BundleContext ctx, WsLocationAdmin locationService) {
        return KernelFeatureDefinitionImpl.getKernelFeatures(ctx, locationService, true);
    }

    public static String getKernelApiServices() {
        return kernelApiServices;
    }

    private static List<ProvisioningFeatureDefinition> getKernelFeatures(BundleContext ctx, WsLocationAdmin locationService, boolean listAll) {
        if (installRoot == null) {
            String path = locationService.resolveString("${wlp.install.dir}");
            installRoot = new File(path).getAbsolutePath();
        }
        ArrayList<ProvisioningFeatureDefinition> kernelFeatures = new ArrayList<ProvisioningFeatureDefinition>();
        if (listAll) {
            WsResource platformDir = locationService.resolveResource("${wlp.install.dir}/lib/platform/");
            Iterator mfFileNames = platformDir.getChildren(".*\\.mf");
            while (mfFileNames.hasNext()) {
                WsResource kdr = platformDir.getChild((String)mfFileNames.next());
                try {
                    KernelFeatureDefinitionImpl kDef = new KernelFeatureDefinitionImpl(ctx, kdr, locationService);
                    kernelFeatures.add(kDef);
                }
                catch (IOException kDef) {
                    FFDCFilter.processException((Throwable)kDef, (String)"com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl", (String)"117", null, (Object[])new Object[]{ctx, locationService, listAll});
                }
            }
        } else {
            WsResource kdr;
            String websphereKernel = "${wlp.install.dir}/lib/platform/${websphere.kernel}.mf";
            String websphereLogProvider = "${wlp.install.dir}/lib/platform/${websphere.log.provider}.mf";
            String websphereOsExtension = "${wlp.install.dir}/lib/platform/${websphere.os.extension}.mf";
            WsResource websphereKernelResource = locationService.resolveResource(locationService.resolveString(websphereKernel));
            WsResource websphereLogProviderResource = locationService.resolveResource(locationService.resolveString(websphereLogProvider));
            LinkedList<WsResource> resources = new LinkedList<WsResource>();
            resources.add(websphereKernelResource);
            resources.add(websphereLogProviderResource);
            if (ctx.getProperty("websphere.os.extension") != null) {
                WsResource websphereOsExtensionResource = locationService.resolveResource(locationService.resolveString(websphereOsExtension));
                resources.add(websphereOsExtensionResource);
            }
            while ((kdr = (WsResource)resources.poll()) != null) {
                try {
                    KernelFeatureDefinitionImpl kDef = new KernelFeatureDefinitionImpl(ctx, kdr, locationService);
                    kernelFeatures.add(kDef);
                    for (FeatureResource fr : kDef.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
                        String location = fr.getLocation();
                        if (location == null) continue;
                        WsResource res = locationService.resolveResource("${wlp.install.dir}/" + location);
                        resources.add(res);
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl", (String)"164", null, (Object[])new Object[]{ctx, locationService, listAll});
                }
            }
        }
        return kernelFeatures;
    }

    private KernelFeatureDefinitionImpl(BundleContext ctx, WsResource resource, WsLocationAdmin locationService) throws IOException {
        super("", resource.asFile());
        if (this.isSystemBundleProvider) {
            String bundleExports;
            this.sysPkgApiHeader = new ArrayList<HeaderElementDefinition>();
            this.sysPkgSpiHeader = new ArrayList<HeaderElementDefinition>();
            this.sysPkgApiHeader.addAll(super.getHeaderElements("IBM-API-Package"));
            this.sysPkgSpiHeader.addAll(super.getHeaderElements("IBM-SPI-Package"));
            Bundle systemBundle = ctx.getBundle("System Bundle");
            if (systemBundle != null && (bundleExports = (String)systemBundle.getHeaders("").get("Export-Package")) != null) {
                List exports = ManifestHeaderProcessor.parseExportString((String)bundleExports);
                for (ManifestHeaderProcessor.NameValuePair nvp : exports) {
                    Map attrs = nvp.getAttributes();
                    String pkgName = nvp.getName();
                    String spiType = (String)attrs.remove("ibm-spi-type");
                    String apiType = (String)attrs.remove("ibm-api-type");
                    if (apiType != null) {
                        attrs.put("type", apiType);
                        this.sysPkgApiHeader.add(new HeaderElementDefinitionImpl(pkgName, attrs));
                        continue;
                    }
                    if (spiType != null) {
                        attrs.put("type", spiType);
                        this.sysPkgSpiHeader.add(new HeaderElementDefinitionImpl(pkgName, attrs));
                        continue;
                    }
                    if (!pkgName.startsWith(OSGI_PKG_PREFIX)) continue;
                    attrs.put("type", "spec");
                    this.sysPkgSpiHeader.add(new HeaderElementDefinitionImpl(pkgName, attrs));
                }
            }
        } else {
            this.sysPkgApiHeader = null;
            this.sysPkgSpiHeader = null;
        }
        this.addKernelApiServices(this.getApiServices());
    }

    private void addKernelApiServices(String newServices) {
        String services = kernelApiServices;
        services = services != null && !services.isEmpty() ? services + "," + newServices : newServices;
        kernelApiServices = services;
    }

    private void addAllBeneath(String installRoot, File f, Collection<FeatureResource> result, String osTag) {
        if (f.exists()) {
            if (f.isFile()) {
                HashMap<String, String> attrs = new HashMap<String, String>(2);
                String location = f.getAbsolutePath().replaceFirst(installRoot, "");
                attrs.put("location:", location);
                attrs.put("type", "file");
                if (osTag != null) {
                    attrs.put("os", osTag);
                }
                result.add(new FeatureResourceImpl(f.getPath(), attrs, "", this.getFeatureName()));
            } else if (f.isDirectory()) {
                for (File c : f.listFiles()) {
                    this.addAllBeneath(installRoot, c, result, osTag);
                }
            }
        }
    }

    @Override
    public Collection<FeatureResource> getConstituents(SubsystemContentType type) {
        if (this.isSystemBundleProvider) {
            ArrayList<FeatureResource> result = new ArrayList<FeatureResource>();
            result.addAll(super.getConstituents(type));
            if (type == null || type == SubsystemContentType.FILE_TYPE) {
                String installRootString = Pattern.quote(installRoot);
                File f = new File(installRoot, "lib/versions");
                this.addAllBeneath(installRootString, f, result, null);
                f = new File(installRoot, "lib/platform");
                this.addAllBeneath(installRootString, f, result, null);
                f = new File(installRoot, "lib/fixes");
                this.addAllBeneath(installRootString, f, result, null);
            }
            return Collections.unmodifiableCollection(result);
        }
        return super.getConstituents(type);
    }

    @Override
    public Collection<HeaderElementDefinition> getHeaderElements(String header) {
        if (this.isSystemBundleProvider) {
            if ("IBM-API-Package".equals(header)) {
                return Collections.unmodifiableCollection(this.sysPkgApiHeader);
            }
            if ("IBM-SPI-Package".equals(header)) {
                return Collections.unmodifiableCollection(this.sysPkgSpiHeader);
            }
        }
        return super.getHeaderElements(header);
    }

    @Override
    public String getHeader(String header) {
        if (this.isSystemBundleProvider) {
            if ("IBM-API-Package".equals(header)) {
                return this.generateHeaderFromDefinitions("IBM-MergedApiPackage", this.sysPkgApiHeader);
            }
            if ("IBM-SPI-Package".equals(header)) {
                return this.generateHeaderFromDefinitions("IBM-MergedSpiPackage", this.sysPkgSpiHeader);
            }
        }
        return super.getHeader(header);
    }

    @Override
    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        return true;
    }

    @Override
    public boolean isKernel() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private String generateHeaderFromDefinitions(String mergedHeader, Collection<HeaderElementDefinition> headerDefs) {
        String mergedValue = super.getHeader(mergedHeader);
        if (mergedValue == null) {
            StringBuilder headerBuilder = new StringBuilder();
            for (HeaderElementDefinition hed : headerDefs) {
                if (headerBuilder.length() > 0) {
                    headerBuilder.append(",");
                }
                StringBuilder element = new StringBuilder(hed.getSymbolicName());
                for (Map.Entry<String, String> attr : hed.getAttributes().entrySet()) {
                    element.append(";");
                    element.append(attr.getKey());
                    element.append("=");
                    element.append(attr.getValue());
                }
                for (Map.Entry<String, String> directive : hed.getDirectives().entrySet()) {
                    String key = directive.getKey();
                    element.append(";");
                    element.append(key);
                    element.append(":=");
                    element.append(directive.getValue());
                }
                headerBuilder.append(element.toString());
            }
            mergedValue = headerBuilder.toString();
            this.setHeader(mergedHeader, mergedValue);
        }
        return mergedValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(KernelFeatureDefinitionImpl.class);
        kernelDefs = null;
        installRoot = null;
        kernelApiServices = null;
    }
}

