/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;

public class ZipLicenseProvider
implements LicenseProvider {
    private final ZipFile zipFile;
    private final ZipEntry laZipEntry;
    private final ZipEntry liZipEntry;
    private final String pName;
    private final String lName;
    private static LicenseProvider instance;
    private static final String PROGRAM_NAME = "Program Name:";
    private static final String PROGRAM_NAME_PROGRAM_NUMBER = "Program Name (Program Number):";

    private ZipLicenseProvider(ZipFile zipFile, ZipEntry laZipEntry, ZipEntry liZipEntry, String pName, String lName) {
        this.zipFile = zipFile;
        this.laZipEntry = laZipEntry;
        this.liZipEntry = liZipEntry;
        this.pName = pName;
        this.lName = lName;
    }

    public static ReturnCode buildInstance(ZipFile zipFile, String laPrefix, String liPrefix) {
        ZipEntry laZipEntry = null;
        ZipEntry liZipEntry = null;
        ZipEntry liEnglishZipEntry = null;
        try {
            laZipEntry = SelfExtractUtils.getLicenseFile(zipFile, laPrefix);
            liZipEntry = SelfExtractUtils.getLicenseFile(zipFile, liPrefix);
            liEnglishZipEntry = zipFile.getEntry(liPrefix + (liPrefix.endsWith("_") ? "" : "_") + "en");
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (zipFile == null || laZipEntry == null || liZipEntry == null || liEnglishZipEntry == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        String lName = ZipLicenseProvider.getLicenseName(zipFile, laZipEntry);
        String pName = ZipLicenseProvider.getProgramName(zipFile, liEnglishZipEntry);
        if (pName == null || lName == null) {
            return new ReturnCode(2, "licenseNotFound", new Object[0]);
        }
        instance = new ZipLicenseProvider(zipFile, laZipEntry, liZipEntry, pName, lName);
        return ReturnCode.OK;
    }

    public static LicenseProvider createInstance(ZipFile zipFile, String laPrefix) {
        if (zipFile == null) {
            return null;
        }
        ZipEntry laZipEntry = null;
        try {
            laZipEntry = SelfExtractUtils.getLicenseFile(zipFile, laPrefix);
        }
        catch (Exception e) {
            return null;
        }
        String lName = ZipLicenseProvider.getLicenseName(zipFile, laZipEntry);
        if (lName == null) {
            return null;
        }
        return new ZipLicenseProvider(zipFile, laZipEntry, null, null, lName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLicenseName(ZipFile zipFile, ZipEntry laZipEntry) {
        block10: {
            String string;
            String line;
            BufferedReader r;
            block7: {
                block8: {
                    String sixTh_line;
                    block9: {
                        r = null;
                        r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(laZipEntry), "UTF-16"));
                        line = r.readLine();
                        sixTh_line = "";
                        if (!zipFile.getName().contains("base") && !zipFile.getName().contains("core") && !zipFile.getName().contains("nd")) break block7;
                        for (int i = 0; i < 5; ++i) {
                            sixTh_line = r.readLine();
                        }
                        if (sixTh_line == null) break block8;
                        int startIndex = sixTh_line.indexOf("IBM");
                        if (startIndex <= 0) break block9;
                        String string2 = sixTh_line.substring(startIndex, sixTh_line.length()).trim();
                        SelfExtractUtils.tryToClose(r);
                        return string2;
                    }
                    String string3 = sixTh_line;
                    SelfExtractUtils.tryToClose(r);
                    return string3;
                }
                String string4 = line;
                SelfExtractUtils.tryToClose(r);
                return string4;
            }
            try {
                string = line;
            }
            catch (IOException iOException) {
                SelfExtractUtils.tryToClose(r);
                break block10;
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(r);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(r);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProgramName(ZipFile zipFile, ZipEntry liEnglishZipEntry) {
        r = null;
        line = null;
        try {
            i = 0;
            r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(liEnglishZipEntry), "UTF-16"));
            while (true) {
                line = r.readLine();
                if (line == null) continue;
                if (!line.startsWith("Program Name:")) ** GOTO lbl-1000
                versionIndex = (line = line.substring("Program Name:".length() + 1)).indexOf(" V");
                if (versionIndex > 0) {
                    var6_8 = line.substring(0, versionIndex).trim();
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var4_5) {
            SelfExtractUtils.tryToClose(r);
            return null;
            catch (Throwable var8_13) {
                SelfExtractUtils.tryToClose(r);
                throw var8_13;
            }
        }
        SelfExtractUtils.tryToClose(r);
        return var6_8;
lbl-1000:
        // 1 sources

        {
            var6_9 = line;
        }
        SelfExtractUtils.tryToClose(r);
        return var6_9;
lbl-1000:
        // 1 sources

        {
            if (!line.startsWith("Program Name (Program Number):") || (nextLine = r.readLine()) == null) ** GOTO lbl-1000
            versionIndex = nextLine.indexOf(" V");
            if (versionIndex <= 0) ** GOTO lbl-1000
            var7_11 = nextLine.substring(0, versionIndex).trim();
        }
        SelfExtractUtils.tryToClose(r);
        return var7_11;
lbl-1000:
        // 1 sources

        {
            var7_12 = nextLine;
        }
        SelfExtractUtils.tryToClose(r);
        return var7_12;
lbl-1000:
        // 2 sources

        {
            if (line != null && i++ < 30) ** continue;
        }
        SelfExtractUtils.tryToClose(r);
        return null;
    }

    public static LicenseProvider getInstance() {
        return instance;
    }

    @Override
    public InputStream getLicenseAgreement() {
        try {
            return this.zipFile.getInputStream(this.laZipEntry);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getLicenseInformation() {
        try {
            if (this.liZipEntry != null) {
                return this.zipFile.getInputStream(this.liZipEntry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getProgramName() {
        return this.pName;
    }

    @Override
    public String getLicenseName() {
        return this.lName;
    }
}

