/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HashtableLoginModule
extends ServerCommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(HashtableLoginModule.class);
    private Object customCacheKey = null;
    private String uniqueUserId = null;
    private String username = null;
    private String urAuthenticatedId = null;
    private String customRealm = null;
    private String internalAuthProvider = null;
    private final String[] hashtableLoginProperties = new String[]{"com.ibm.wsspi.security.cred.uniqueId", "com.ibm.wsspi.security.cred.userId", "com.ibm.wsspi.security.cred.securityName", "com.ibm.wsspi.security.cred.realm", "com.ibm.wsspi.security.cred.cacheKey", "com.ibm.ws.authentication.internal.assertion", "com.ibm.ws.authentication.internal.json.web.token", "com.ibm.ws.authentication.internal.auth.provider"};
    private final String[] userIdOnlyProperties = new String[]{"com.ibm.wsspi.security.cred.userId", "com.ibm.ws.authentication.internal.assertion"};
    private boolean uniquedIdAndSecurityNameLogin = false;
    private boolean useIdAndPasswordLogin = false;
    private boolean userIdNoPasswordLogin = false;
    private Hashtable<String, ?> customProperties = null;
    private boolean customPropertiesFromSubject = false;
    static final long serialVersionUID = 5577702779370047404L;

    @Override
    public Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        return null;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.isAlreadyProcessed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Already processed by other login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (this.customProperties == null && this.subject != null) {
            SubjectHelper subjectHelper = new SubjectHelper();
            this.customProperties = subjectHelper.getHashtableFromSubject(this.subject, this.hashtableLoginProperties);
            if (this.customProperties != null) {
                this.customPropertiesFromSubject = true;
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", this.customProperties);
            }
        }
        if (this.customProperties == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Hashtable could be found, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.customCacheKey = this.getCustomCacheKey(this.customProperties);
        this.customRealm = (String)this.customProperties.get("com.ibm.wsspi.security.cred.realm");
        this.internalAuthProvider = (String)this.customProperties.get("com.ibm.ws.authentication.internal.auth.provider");
        String uniqueId = (String)this.customProperties.get("com.ibm.wsspi.security.cred.uniqueId");
        String securityName = (String)this.customProperties.get("com.ibm.wsspi.security.cred.securityName");
        String userId = (String)this.customProperties.get("com.ibm.wsspi.security.cred.userId");
        String password = (String)this.customProperties.get("com.ibm.wsspi.security.cred.password");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && userId != null && uniqueId != null && securityName != null) {
            Tr.debug((TraceComponent)tc, (String)"The userId is set in addition to uniqueId and securityName. Only the uniqueId and securityName will be used to create the subject.", (Object[])new Object[0]);
        }
        if (userId != null && password != null) {
            return this.handleUserIdAndPassword(userId, password);
        }
        if (uniqueId != null && securityName != null) {
            return this.handleUniquedIdAndSecurityName(uniqueId, securityName, this.customProperties);
        }
        if (userId != null && this.allowLoginWithIdOnly(this.customProperties)) {
            return this.handleUserId(userId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Not enough information in Hashtable to continue, abstaining.", (Object[])new Object[0]);
        }
        return false;
    }

    private boolean allowLoginWithIdOnly(Hashtable<String, ?> customProperties) {
        AuthenticationService authService = this.getAuthenticationService();
        if (authService != null && authService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            return true;
        }
        Boolean assertion = Boolean.FALSE;
        if (this.customPropertiesFromSubject) {
            Object value = customProperties.get("com.ibm.ws.authentication.internal.assertion");
            assertion = (Boolean)(value != null ? value : Boolean.FALSE);
            this.removeInternalAssertionHashtable(customProperties, this.userIdOnlyProperties);
        } else {
            String[] hashtableInternalProperty = new String[]{"com.ibm.ws.authentication.internal.assertion"};
            Hashtable internalProperties = this.subjectHelper.getHashtableFromSubject(this.subject, hashtableInternalProperty);
            if (internalProperties != null && !internalProperties.isEmpty()) {
                assertion = Boolean.TRUE;
                this.removeInternalAssertionHashtable(internalProperties, this.userIdOnlyProperties);
            }
        }
        return assertion != false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleUserId(String userId) throws AuthenticationException {
        this.userIdNoPasswordLogin = true;
        this.setAlreadyProcessed();
        try {
            this.setAlreadyProcessed();
            this.userIdNoPasswordLogin = true;
            UserRegistry userRegistry = this.getUserRegistry();
            String ret = userRegistry.getUniqueUserId(userId);
            if (ret != null) {
                this.username = userId;
                this.uniqueUserId = ret;
                this.setUpTemporarySubject();
                this.updateSharedState();
                return true;
            }
        }
        catch (EntryNotFoundException userRegistry) {
            void e;
            FFDCFilter.processException((Throwable)userRegistry, (String)"com.ibm.ws.security.authentication.jaas.modules.HashtableLoginModule", (String)"189", (Object)this, (Object[])new Object[]{userId});
            Tr.audit((TraceComponent)tc, (String)"JAAS_AUTHENTICATION_FAILED_BADUSER", (Object[])new Object[]{userId});
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.HashtableLoginModule", (String)"192", (Object)this, (Object[])new Object[]{userId});
            throw new AuthenticationException(e.getLocalizedMessage(), e);
        }
        return false;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private boolean handleUserIdAndPassword(String userId, String password) throws AuthenticationException, LoginException {
        try {
            this.setAlreadyProcessed();
            this.useIdAndPasswordLogin = true;
            UserRegistry userRegistry = this.getUserRegistry();
            this.urAuthenticatedId = userRegistry.checkPassword(userId, password);
            if (this.urAuthenticatedId != null) {
                this.username = this.getSecurityName(userId, this.urAuthenticatedId);
                this.uniqueUserId = userRegistry.getUniqueUserId(this.urAuthenticatedId);
                this.setUpTemporarySubject();
                this.updateSharedState();
                return true;
            }
            Tr.audit((TraceComponent)tc, (String)"JAAS_AUTHENTICATION_FAILED_BADUSERPWD", (Object[])new Object[]{userId});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"JAAS_AUTHENTICATION_FAILED_BADUSERPWD", (Object[])new Object[]{userId}, (String)"CWWKS1100A: Authentication failed for the userid {0}. A bad userid and/or password was specified."));
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.HashtableLoginModule", (String)"232", (Object)this, (Object[])new Object[]{userId, password});
            throw new AuthenticationException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleUniquedIdAndSecurityName(String uniqueId, String securityName, Hashtable<String, ?> customProperties) throws AuthenticationException {
        this.setAlreadyProcessed();
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrivateCredentials().add(customProperties);
        this.uniquedIdAndSecurityNameLogin = true;
        this.uniqueUserId = uniqueId;
        this.username = securityName;
        String accessId = uniqueId;
        try {
            if (!AccessIdUtil.isUserAccessId((String)accessId)) {
                accessId = AccessIdUtil.createAccessId((String)"user", (String)this.getRealm(customProperties), (String)this.username);
            }
            this.setWSPrincipal(this.temporarySubject, this.username, accessId, "hashtable");
            this.setCredentials(this.temporarySubject, this.username, null);
            this.setOtherPrincipals(this.temporarySubject, this.username, accessId, "hashtable", customProperties);
            this.updateSharedState();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.jaas.modules.HashtableLoginModule", (String)"263", (Object)this, (Object[])new Object[]{uniqueId, securityName, customProperties});
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String getRealm(Hashtable<String, ?> customProperties) {
        String realm = this.customRealm;
        if (realm == null) {
            block5: {
                realm = AccessIdUtil.getRealm((String)this.uniqueUserId);
                if (realm == null) {
                    try {
                        UserRegistry userRegistry = this.getUserRegistry();
                        realm = userRegistry.getRealm();
                    }
                    catch (RegistryException registryException) {
                        void e;
                        FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.authentication.jaas.modules.HashtableLoginModule", (String)"282", (Object)this, (Object[])new Object[]{customProperties});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)("getUserRegistry() caught an exception: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
            if (realm == null) {
                realm = "defaultRealm";
            }
        }
        return realm;
    }

    private void setUpTemporarySubject() throws Exception {
        this.temporarySubject = new Subject();
        UserRegistry userRegistry = this.getUserRegistry();
        String accessId = AccessIdUtil.createAccessId((String)"user", (String)userRegistry.getRealm(), (String)this.uniqueUserId);
        this.setWSPrincipal(this.temporarySubject, this.username, accessId, "hashtable");
        this.setCredentials(this.temporarySubject, this.username, this.urAuthenticatedId);
        this.setOtherPrincipals(this.temporarySubject, this.username, accessId, "hashtable", this.customProperties);
    }

    private Object getCustomCacheKey(Hashtable<String, ?> customProperties) {
        Object cacheKey = customProperties.get("com.ibm.wsspi.security.cred.cacheKey");
        if (cacheKey != null && cacheKey instanceof String && ((String)cacheKey).equals("")) {
            cacheKey = null;
        }
        return cacheKey;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!(this.customCacheKey != null || this.uniquedIdAndSecurityNameLogin || this.useIdAndPasswordLogin || this.userIdNoPasswordLogin)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.uniquedIdAndSecurityNameLogin || this.useIdAndPasswordLogin || this.userIdNoPasswordLogin) {
            this.setUpSubject();
        }
        if (this.customCacheKey != null || this.customRealm != null || this.internalAuthProvider != null) {
            this.addCustomAttributesToSSOToken();
            JwtSSOTokenHelper.addAttributesToJwtSSOToken((Subject)this.subject);
        }
        return true;
    }

    private void addCustomAttributesToSSOToken() {
        SingleSignonToken ssoToken = this.getSSOToken(this.subject);
        if (ssoToken != null) {
            if (this.customCacheKey != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add custom cache key into SSOToken", (Object[])new Object[0]);
                }
                ssoToken.addAttribute("com.ibm.wsspi.security.cred.cacheKey", (String)this.customCacheKey);
            }
            if (this.customRealm != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add custom realm into SSOToken", (Object[])new Object[0]);
                }
                ssoToken.addAttribute("com.ibm.wsspi.security.cred.realm", this.customRealm);
            }
            if (this.internalAuthProvider != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add authentication provider into SSOToken", (Object[])new Object[0]);
                }
                ssoToken.addAttribute("com.ibm.ws.authentication.internal.auth.provider", this.internalAuthProvider);
            }
        }
    }

    @Override
    public boolean abort() {
        return this.cleanup();
    }

    @Override
    public boolean logout() {
        return this.cleanup();
    }

    private boolean cleanup() {
        this.cleanUpSubject();
        this.customCacheKey = null;
        this.username = null;
        this.uniqueUserId = null;
        this.urAuthenticatedId = null;
        return true;
    }
}

