/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfigChangeEvent;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfigChangeListener;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationMetaDataListener.class, WebAppSecurityConfigChangeListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class ApplicationUtils
implements ApplicationMetaDataListener,
WebAppSecurityConfigChangeListener {
    private static final TraceComponent tc = Tr.register(ApplicationUtils.class);
    private static final Set<String> appsToRestart = new HashSet<String>();
    private static final String REFERENCE_APP_COORD = "appCoord";
    private static ComponentContext context;
    static final SecureAction priv;
    static final long serialVersionUID = 5589868373485894731L;

    @Activate
    protected void activate(ComponentContext cc) {
        context = cc;
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    @Reference(name="appCoord")
    protected void setAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    protected void unsetAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    public static void registerApplication(String appName) {
        appsToRestart.add(appName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(appName + " is added. Number of JSR375 Applications : " + appsToRestart.size()), (Object[])new Object[0]);
        }
    }

    public void notifyWebAppSecurityConfigChanged(WebAppSecurityConfigChangeEvent event) {
        List attributes = event.getModifiedAttributeList();
        if (ApplicationUtils.isAppRestartRequired(attributes)) {
            ApplicationUtils.recycleApplications();
        }
    }

    public void applicationMetaDataCreated(MetaDataEvent<ApplicationMetaData> event) throws MetaDataException {
    }

    public void applicationMetaDataDestroyed(MetaDataEvent<ApplicationMetaData> event) {
        String appName = ((ApplicationMetaData)event.getMetaData()).getJ2EEName().getApplication();
        if (appsToRestart.remove(appName) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(appName + " is removed. Number of JSR375 Applications : " + appsToRestart.size()), (Object[])new Object[0]);
        }
    }

    protected static boolean isAppRestartRequired(List<String> delta) {
        return delta != null && (delta.contains("allowFailOverToBasicAuth") || delta.contains("loginFormURL") || delta.contains("loginErrorURL") || delta.contains("allowAuthenticationFailOverToAuthMethod") || delta.contains("overrideHttpAuthMethod") || delta.contains("contextRootForFormAuthenticationMechanism") || delta.contains("basicAuthenticationMechanismRealmName"));
    }

    private static void recycleApplications() {
        if (FrameworkState.isStopping()) {
            return;
        }
        if (!appsToRestart.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Recycling JSR375 applications", (Object[])new Object[]{appsToRestart});
            }
            ApplicationRecycleCoordinator appCoord = (ApplicationRecycleCoordinator)priv.locateService(context, REFERENCE_APP_COORD);
            appCoord.recycleApplications(appsToRestart);
            appsToRestart.clear();
        }
    }

    protected boolean isApplicationRegistered(String appName) {
        return appsToRestart.contains(appName);
    }

    protected int numberOfApplications() {
        return appsToRestart.size();
    }

    protected void clearApplications() {
        appsToRestart.clear();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    }
}

