/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.h2internal.hpack.HpackUtils;
import com.ibm.ws.http.channel.h2internal.hpack.IntegerRepresentation;
import com.ibm.ws.http.channel.h2internal.huffman.HuffmanDecoder;
import com.ibm.ws.http.channel.h2internal.huffman.HuffmanEncoder;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class H2Headers {
    private static final TraceComponent tc = Tr.register(H2Headers.class, (String)"GenericBNF", null);

    public static H2HeaderField decodeHeader(WsByteBuffer buffer, H2HeaderTable table) throws CompressionException {
        return H2Headers.decodeHeader(buffer, table, true, false, null);
    }

    public static H2HeaderField decodeHeader(WsByteBuffer buffer, H2HeaderTable table, boolean isFirstHeader, boolean isTrailerBlock, H2ConnectionSettings settings) throws CompressionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decodeHeader", (Object[])new Object[0]);
        }
        if (!table.isDynamicTableValid()) {
            throw new CompressionException("The context for this dynamic table is not valid.");
        }
        if (buffer == null || !buffer.hasRemaining()) {
            throw new CompressionException("Invalid attempt to decode empty or null buffer.");
        }
        byte currentByte = buffer.get();
        buffer.position(buffer.position() - 1);
        byte maskedByte = HpackUtils.format(currentByte, HpackConstants.MASK_0F);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Operation Byte: " + HpackUtils.byteToHexString(currentByte)), (Object[])new Object[0]);
        }
        int decodedInteger = 0;
        H2HeaderField header = null;
        if (maskedByte < HpackConstants.MASK_00) {
            if (currentByte == HpackConstants.MASK_80) {
                throw new CompressionException("An indexed header cannot have an index of 0");
            }
            decodedInteger = IntegerRepresentation.decode(buffer, HpackConstants.ByteFormatType.INDEXED);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Operation byte indicated header is already indexed at index location: " + decodedInteger + ". Searching table..."), (Object[])new Object[0]);
            }
            if ((header = table.getHeaderEntry(decodedInteger)) == null) {
                throw new CompressionException("Received an invalid header index");
            }
            H2Headers.checkIsValidH2Header(header, isTrailerBlock);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found header: [" + header.getName() + ", " + header.getValue() + "]"), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"decodeHeader");
            }
            return header;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Header not fully indexed in table, determining indexing type.", (Object[])new Object[0]);
        }
        if (maskedByte >= HpackConstants.MASK_4F) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Indexing decode type: INCREMENTAL", (Object[])new Object[0]);
            }
            header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.INCREMENTAL);
        } else {
            if (maskedByte >= HpackConstants.MASK_2F) {
                if (!isFirstHeader) {
                    throw new CompressionException("dynamic table size update must occur at the beginning of the first header block");
                }
                int fragmentLength = IntegerRepresentation.decode(buffer, HpackConstants.ByteFormatType.TABLE_UPDATE);
                if (settings != null && fragmentLength > settings.getHeaderTableSize()) {
                    throw new CompressionException("dynamic table size update size was larger than SETTINGS_HEADER_TABLE_SIZE");
                }
                table.updateTableSize(fragmentLength);
                return null;
            }
            if (maskedByte == HpackConstants.MASK_1F) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Indexing decode type: NEVERINDEX", (Object[])new Object[0]);
                }
                header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.NEVERINDEX);
            } else if (maskedByte == HpackConstants.MASK_0F) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Indexing decode type: NOINDEXING", (Object[])new Object[0]);
                }
                header = H2Headers.decodeHeader(buffer, table, HpackConstants.ByteFormatType.NOINDEXING);
            }
        }
        H2Headers.checkIsValidH2Header(header, isTrailerBlock);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Decoded the header: [" + header.getName() + ", " + header.getValue() + "]"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodeHeader");
        }
        return header;
    }

    private static H2HeaderField decodeHeader(WsByteBuffer buffer, H2HeaderTable table, HpackConstants.ByteFormatType type) throws CompressionException {
        String decodedName;
        int integerLength = 0;
        integerLength = IntegerRepresentation.decode(buffer, type);
        if (integerLength > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Operation byte indicates header name is indexed at location " + integerLength + ". Searching table for header name..."), (Object[])new Object[0]);
            }
            decodedName = table.getHeaderEntry(integerLength).getName();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Decoding header name.", (Object[])new Object[0]);
            }
            if ((decodedName = H2Headers.decodeFragment(buffer)).trim().isEmpty()) {
                throw new CompressionException("Header field names must not be empty.");
            }
            if (!HpackUtils.isAllLower(decodedName)) {
                throw new CompressionException("Header field names must not contain uppercase characters. Decoded header name: " + decodedName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Decoding header value.", (Object[])new Object[0]);
        }
        String decodedValue = H2Headers.decodeFragment(buffer);
        H2HeaderField header = new H2HeaderField(decodedName, decodedValue);
        if (type == HpackConstants.ByteFormatType.INCREMENTAL) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incremental indexing: adding decoded header to table.", (Object[])new Object[0]);
            }
            table.addHeaderEntry(header);
        }
        return header;
    }

    private static String decodeFragment(WsByteBuffer buffer) throws CompressionException {
        String decodedResult = null;
        try {
            boolean huffman;
            byte currentByte = buffer.get();
            buffer.position(buffer.position() - 1);
            boolean bl = huffman = HpackUtils.getBit(currentByte, 7) == 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Decoding using huffman encoding: " + huffman), (Object[])new Object[0]);
            }
            int fragmentLength = IntegerRepresentation.decode(buffer, HpackConstants.ByteFormatType.HUFFMAN);
            byte[] bytes = new byte[fragmentLength];
            buffer.get(bytes);
            if (huffman && bytes.length > 0) {
                HuffmanDecoder decoder = new HuffmanDecoder();
                bytes = decoder.convertHuffmanToAscii(bytes);
            }
            decodedResult = new String(bytes, Charset.forName("US-ASCII"));
        }
        catch (Exception e) {
            throw new CompressionException("Received an invalid header block fragment");
        }
        return decodedResult;
    }

    public static byte[] encodeHeader(H2HeaderTable table, String name, String value, HpackConstants.LiteralIndexType type) throws CompressionException, IOException {
        return H2Headers.encodeHeader(table, name, value, type, true);
    }

    public static byte[] encodeHeader(H2HeaderTable table, String name, String value, HpackConstants.LiteralIndexType type, boolean huffman) throws CompressionException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encodeHeader", (Object[])new Object[]{"Encoding [" + name + ", " + value});
        }
        if (table == null || !table.isDynamicTableValid()) {
            throw new CompressionException("The context for this dynamic table is not valid.");
        }
        ByteArrayOutputStream encodedHeader = new ByteArrayOutputStream();
        String compliantName = name.toLowerCase();
        int indexLocation = 0;
        H2HeaderField indexedHeader = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Searching in table for header...", (Object[])new Object[0]);
        }
        if ((indexedHeader = table.getHeaderEntry(compliantName, value)) != null) {
            indexLocation = indexedHeader.getCurrentIndex();
            if (indexedHeader.getValueHash() == value.hashCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Header name and value found in table at index location: " + indexLocation + ". Encoding header as INDEXED."), (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"encodeHeader");
                }
                return IntegerRepresentation.encode(indexLocation, HpackConstants.ByteFormatType.INDEXED);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found header name in table at location: " + indexLocation + "."), (Object[])new Object[0]);
            }
        }
        encodedHeader.write(IntegerRepresentation.encode(indexLocation, type));
        if (indexLocation == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header name not found in table, encoding header name...", (Object[])new Object[0]);
            }
            H2Headers.encodeFragment(encodedHeader, compliantName, huffman);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Encoding header value...", (Object[])new Object[0]);
        }
        H2Headers.encodeFragment(encodedHeader, value, huffman);
        if (type == HpackConstants.LiteralIndexType.INDEX) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incremental indexing: adding encoded header to table.", (Object[])new Object[0]);
            }
            table.addHeaderEntry(new H2HeaderField(compliantName, value));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encodeHeader");
        }
        return encodedHeader.toByteArray();
    }

    private static void encodeFragment(ByteArrayOutputStream encodedHeader, String headerFragment, boolean huffman) throws CompressionException, IOException {
        byte[] fragmentBytes = headerFragment.getBytes("US-ASCII");
        HpackConstants.ByteFormatType encodingType = HpackConstants.ByteFormatType.NOHUFFMAN;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Encoding using huffman encoding: " + huffman), (Object[])new Object[0]);
        }
        if (huffman) {
            fragmentBytes = HuffmanEncoder.convertAsciiToHuffman(fragmentBytes);
            encodingType = HpackConstants.ByteFormatType.HUFFMAN;
        }
        encodedHeader.write(IntegerRepresentation.encode(fragmentBytes.length, encodingType));
        encodedHeader.write(fragmentBytes);
    }

    private static void checkIsValidH2Header(H2HeaderField header, boolean isTrailerField) throws CompressionException {
        if (!header.getName().startsWith(":")) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            for (String name : HpackConstants.connectionSpecificHeaderList) {
                if (!name.equalsIgnoreCase(headerName)) continue;
                throw new CompressionException("Invalid Connection header received: " + header.toString());
            }
            if ("Connection".equalsIgnoreCase(headerName) && !"TE".equalsIgnoreCase(headerValue)) {
                throw new CompressionException("Invalid Connection header received: " + header.toString());
            }
            if ("TE".equalsIgnoreCase(headerName) && !"trailers".equalsIgnoreCase(headerValue)) {
                throw new CompressionException("Invalid header: TE header must have value \"trailers\": " + header.toString());
            }
        } else if (isTrailerField) {
            throw new CompressionException("Psuedo-headers are not allowed in trailers: " + header.toString());
        }
    }

    public static boolean checkIsValidH2WriteHeader(String headerName) {
        if (!headerName.startsWith(":")) {
            if ("Connection".equalsIgnoreCase(headerName)) {
                return false;
            }
            if ("TE".equalsIgnoreCase(headerName)) {
                return false;
            }
        }
        return true;
    }

    public static int getContentLengthValue(H2HeaderField header) {
        if ("content-length".equalsIgnoreCase(header.getName())) {
            return Integer.parseInt(header.getValue());
        }
        return -1;
    }
}

