/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.sse.atmosphere;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.sse.SseFeature;
import org.apache.cxf.jaxrs.sse.atmosphere.SseAtmosphereInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public class AtmosphereSseServletDestination
extends ServletDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereSseServletDestination.class);
    private AtmosphereFramework framework = this.create();

    public AtmosphereSseServletDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, String path) throws IOException {
        super(bus, registry, ei, path);
        bus.getFeatures().add(new SseFeature());
    }

    private AtmosphereFramework create() {
        AtmosphereFramework instance = new AtmosphereFramework(true, false);
        instance.interceptor((AtmosphereInterceptor)new SseAtmosphereInterceptor());
        instance.addInitParameter("org.atmosphere.useNative", "true");
        instance.addInitParameter("org.atmosphere.useWebSocket", "true");
        instance.addInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults", "true");
        instance.addInitParameter("org.atmosphere.cpr.AsynchronousProcessor.closeOnCancel", "true");
        instance.addInitParameter("org.atmosphere.cpr.broadcaster.maxProcessingThreads", "20");
        instance.addInitParameter("org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads", "20");
        instance.addInitParameter("org.atmosphere.websocket.suppressJSR356", "true");
        instance.setBroadcasterCacheClassName(UUIDBroadcasterCache.class.getName());
        instance.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
        return instance;
    }

    public void onServletConfigAvailable(ServletConfig config) throws ServletException {
        Object container = config.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
        if (container != null) {
            if (this.framework.initialized()) {
                this.framework.destroy();
            }
            this.framework = this.create();
            this.framework.addInitParameter("org.atmosphere.useNative", "false");
            this.framework.addInitParameter("org.atmosphere.websocket.suppressJSR356", "false");
            this.framework.init(config);
        }
    }

    public void finalizeConfig() {
        if (this.framework.initialized()) {
            return;
        }
        final ServletContext ctx = (ServletContext)this.bus.getExtension(ServletContext.class);
        if (ctx != null) {
            try {
                this.framework.init(new ServletConfig(){

                    public String getServletName() {
                        return null;
                    }

                    public ServletContext getServletContext() {
                        return ctx;
                    }

                    public String getInitParameter(String name) {
                        return null;
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return null;
                    }
                });
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        } else {
            this.framework.init();
        }
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)req), AtmosphereResponseImpl.wrap((HttpServletResponse)resp));
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception ex) {
            LOG.warning("Graceful shutdown was not successful: " + ex.getMessage());
        }
        finally {
            super.shutdown();
        }
    }

    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        this.adjustContentLength(outMessage);
        return super.flushHeaders(outMessage, getStream);
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        this.adjustContentLength(outMessage);
        return super.flushHeaders(outMessage);
    }

    private void adjustContentLength(Message outMessage) {
        String contentType = (String)outMessage.get((Object)"Content-Type");
        if ("text/event-stream".equalsIgnoreCase(contentType)) {
            Map headers = Headers.getSetProtocolHeaders((Message)outMessage);
            headers.put("Content-Length", Collections.singletonList("-1"));
        }
    }

    private class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            try {
                AtmosphereSseServletDestination.super.invoke(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to invoke service", e);
            }
        }
    }
}

