/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.IdentifiedLoader;
import com.ibm.ws.classloading.internal.NativeLibrary;
import com.ibm.ws.classloading.internal.NativeLibraryAdapter;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.CacheHashMap;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
abstract class ContainerClassLoader
extends IdentifiedLoader {
    static final TraceComponent tc = Tr.register(ContainerClassLoader.class);
    static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private volatile SmartClassPath smartClassPath = new UnreadSmartClassPath();
    private final List<UniversalContainer> nativeLibraryContainers = new ArrayList<UniversalContainer>();
    private final ClassRedefiner redefiner;
    protected static final ExecutorService mapCreationQueue = Executors.newSingleThreadExecutor(new ThreadFactory(){
        static final long serialVersionUID = -5799275501645335577L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("ClassloaderMapProcessing" + t.getName());
            return t;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    });
    static final long serialVersionUID = 7249739282446266343L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static byte[] getBytes(InputStream stream, int knownSize) throws IOException {
        int read;
        if (knownSize == -1) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                int read2;
                byte[] bytes = new byte[1024];
                while (0 <= (read2 = stream.read(bytes))) {
                    byteOut.write(bytes, 0, read2);
                }
                byte[] byArray = byteOut.toByteArray();
                return byArray;
            }
            finally {
                Util.tryToClose(byteOut);
            }
        }
        byte[] bytes = new byte[knownSize];
        int offset = 0;
        while (knownSize > 0 && (read = stream.read(bytes, offset, knownSize)) > 0) {
            offset += read;
            knownSize -= read;
        }
        byte[] byArray = bytes;
        return byArray;
        finally {
            Util.tryToClose(stream);
        }
    }

    public ContainerClassLoader(List<Container> classpath, ClassLoader parent, ClassRedefiner redefiner) {
        super(parent);
        JarCacheDisabler.disableJarCaching();
        if (classpath != null) {
            for (Container c : classpath) {
                this.smartClassPath.addContainer(c);
            }
        }
        this.redefiner = redefiner;
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null) {
            return url;
        }
        url = this.smartClassPath.getResourceURL(name);
        if (url == null && !name.endsWith("/") && (url = super.findResource(name)) != null) {
            url = ContainerClassLoader.stripTrailingSlash(url);
        }
        return url;
    }

    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        CompositeEnumeration enumerations = new CompositeEnumeration(super.findResources(name));
        Collection<URL> urls = this.smartClassPath.getResourceURLs(name);
        if (!name.endsWith("/")) {
            enumerations.add(super.findResources(name + "/"));
            HashMap<String, URL> resourceMap = new HashMap<String, URL>();
            URL url = null;
            while (enumerations.hasMoreElements()) {
                url = ContainerClassLoader.stripTrailingSlash((URL)enumerations.nextElement());
                resourceMap.put(url.toExternalForm(), url);
            }
            enumerations = new CompositeEnumeration(Collections.enumeration(resourceMap.values()));
        }
        enumerations.add(Collections.enumeration(urls));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (enumerations.hasMoreElements()) {
                URL url = (URL)enumerations.nextElement();
                urlList.add(url);
                sb.append("\n  ").append(url);
                ++i;
            }
            sb.append("\n  ").append("Total elements: ").append(i);
            enumerations = new CompositeEnumeration(Collections.enumeration(urlList));
            Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
        return enumerations;
    }

    @Override
    protected String findLibrary(String libName) {
        String mappedName = System.mapLibraryName(libName);
        for (UniversalContainer uc : this.nativeLibraryContainers) {
            String path;
            UniversalContainer.UniversalResource ur = uc.getResource(mappedName);
            if (ur == null || (path = ur.getNativeLibraryPath()) == null) continue;
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteResourceInformation findBytes(String resourceName) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            ByteResourceInformation byteResourceInformation = this.smartClassPath.getByteResourceInformation(resourceName);
            return byteResourceInformation;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public Package definePackage(String name, Manifest manifest, URL sealBase) throws IllegalArgumentException {
        Attributes mA = manifest.getMainAttributes();
        String specTitle = mA.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = mA.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = mA.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = mA.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = mA.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = mA.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealedString = mA.getValue(Attributes.Name.SEALED);
        Boolean sealed = sealedString == null ? Boolean.FALSE.booleanValue() : sealedString.equalsIgnoreCase("true");
        String unixName = name.replaceAll("\\.", "/") + "/";
        mA = manifest.getAttributes(unixName);
        if (mA != null) {
            String s = mA.getValue(Attributes.Name.SPECIFICATION_TITLE);
            if (s != null) {
                specTitle = s;
            }
            if ((s = mA.getValue(Attributes.Name.SPECIFICATION_VERSION)) != null) {
                specVersion = s;
            }
            if ((s = mA.getValue(Attributes.Name.SPECIFICATION_VENDOR)) != null) {
                specVendor = s;
            }
            if ((s = mA.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) != null) {
                implTitle = s;
            }
            if ((s = mA.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) != null) {
                implVersion = s;
            }
            if ((s = mA.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) != null) {
                implVendor = s;
            }
            if ((s = mA.getValue(Attributes.Name.SEALED)) != null) {
                sealed = s.equalsIgnoreCase("true");
            }
        }
        if (!sealed.booleanValue()) {
            sealBase = null;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    protected void addToClassPath(Iterable<ArtifactContainer> artifacts) {
        for (ArtifactContainer art : artifacts) {
            this.smartClassPath.addArtifactContainer(art);
        }
    }

    @FFDCIgnore(value={NullPointerException.class})
    protected void addLibraryFile(File f) {
        block7: {
            ArtifactContainerFactory acf;
            if (!f.exists()) {
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"cls.library.archive", (Object[])new Object[]{f, new FileNotFoundException(f.getName())});
                }
                return;
            }
            if (!f.isDirectory() && !this.isArchive(f)) {
                return;
            }
            BundleContext bc = FrameworkUtil.getBundle(ContainerClassLoader.class).getBundleContext();
            ServiceReference acfsr = bc.getServiceReference(ArtifactContainerFactory.class);
            if (acfsr != null && (acf = (ArtifactContainerFactory)bc.getService(acfsr)) != null) {
                try {
                    ArtifactContainer ac = acf.getContainer(bc.getBundle().getDataFile(""), (Object)f);
                    this.smartClassPath.addArtifactContainer(ac);
                }
                catch (NullPointerException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception while adding files to classpath", (Object[])new Object[]{e});
                    }
                    if (!tc.isInfoEnabled()) break block7;
                    Tr.info((TraceComponent)tc, (String)"cls.library.file.forbidden", (Object[])new Object[]{f});
                }
            }
        }
    }

    protected void addNativeLibraryContainer(Container container) {
        this.nativeLibraryContainers.add(new ContainerUniversalContainer(container));
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private boolean isArchive(File f) {
        final File target = f;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = 8308255063509451161L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    new ZipFile(target).close();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception innerException = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The following file can not be added to the classpath " + f + " due to error "), (Object[])new Object[]{innerException});
            }
            return false;
        }
        return true;
    }

    protected void lazyInit() {
    }

    private static URL stripTrailingSlash(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
            try {
                url = new URL(externalForm);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"1536", null, (Object[])new Object[]{url});
            }
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public boolean redefineClasses(Notifier.Notification notification) {
        boolean success;
        if (notification.getPaths().isEmpty()) {
            return true;
        }
        Container container = notification.getContainer();
        if (!this.smartClassPath.containsContainer(container)) {
            success = true;
        } else {
            ArrayList<String> classFilePaths = new ArrayList<String>();
            for (String path : notification.getPaths()) {
                if (!path.endsWith(".class")) continue;
                classFilePaths.add(path);
            }
            if (classFilePaths.isEmpty()) {
                return true;
            }
            if (this.redefiner != null && this.redefiner.canRedefine()) {
                success = true;
                HashSet<ClassDefinition> classesToRedefine = new HashSet<ClassDefinition>();
                for (String path : classFilePaths) {
                    String className = ContainerClassLoader.convertToClassName(path);
                    Class<?> clazz = this.findLoadedClass(className);
                    if (clazz != null && clazz.getClassLoader() == this) {
                        try {
                            InputStream is = (InputStream)container.getEntry(path).adapt(InputStream.class);
                            byte[] classBytes = ContainerClassLoader.loadBytes(is);
                            ClassDefinition def = new ClassDefinition(clazz, classBytes);
                            classesToRedefine.add(def);
                            continue;
                        }
                        catch (Exception is) {
                            void e;
                            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"1605", (Object)this, (Object[])new Object[]{notification});
                            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".redefineClasses"), (String)"1557", (Object)this, (Object[])new Object[]{className, notification.getContainer(), path});
                            success = false;
                            break;
                        }
                    }
                    if (clazz != null) continue;
                    return false;
                }
                if (success && !classesToRedefine.isEmpty()) {
                    success = this.redefiner.redefineClasses(classesToRedefine);
                }
            } else {
                success = false;
            }
        }
        return success;
    }

    private static String convertToClassName(String fileName) {
        String className = fileName.replace(".class", "");
        className = className.replace("WEB-INF/classes/", "");
        className = className.replace('/', '.');
        if ((className = className.replace('\\', '.')).startsWith(".")) {
            className = className.substring(1);
        }
        return className;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static byte[] loadBytes(final InputStream is) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){
                static final long serialVersionUID = 3670361014069677938L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Trivial
                public byte[] run() throws IOException {
                    byte[] buf = new byte[2048];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int bytesRead = is.read(buf);
                        while (bytesRead > -1) {
                            baos.write(buf, 0, bytesRead);
                            bytesRead = is.read(buf);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    return baos.toByteArray();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CCL: blocking the new map building thread", (Object[])new Object[0]);
        }
        mapCreationQueue.submit(new Runnable(){
            static final long serialVersionUID = 6253493480160996126L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                block4: {
                    BundleContext bc;
                    Bundle b = FrameworkUtil.getBundle(ContainerClassLoader.class);
                    if (b != null && (bc = b.getBundleContext()) != null) {
                        ServiceTracker st = new ServiceTracker(bc, ServerStarted.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServerStarted, ServerStarted>(){
                            static final long serialVersionUID = -6003806214263243709L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            public ServerStarted addingService(ServiceReference<ServerStarted> arg0) {
                                return null;
                            }

                            public void modifiedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            public void removedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class);
                            }
                        });
                        try {
                            st.waitForService(120000L);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to server start notify", (Object[])new Object[0]);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2", (String)"631", (Object)this, (Object[])new Object[0]);
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to interrupt", (Object[])new Object[0]);
                        }
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ArtifactEntryByteResourceInformation
    implements ByteResourceInformation {
        private final byte[] bytes;
        private final ArtifactEntry resourceEntry;
        private final ArtifactContainer resourceContainer;
        private final String resourcePath;
        private Manifest manifest;
        private boolean manifestLoaded;
        static final long serialVersionUID = 6803311093041945688L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ArtifactEntryByteResourceInformation(byte[] bytes, ArtifactEntry resourceUrl, ArtifactContainer root, String resourcePath) {
            this.bytes = bytes;
            this.resourceEntry = resourceUrl;
            this.resourceContainer = root;
            this.resourcePath = resourcePath;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @FFDCIgnore(value={IOException.class})
        public Manifest getManifest() {
            if (!this.manifestLoaded) {
                this.manifestLoaded = true;
                ArtifactEntry e = this.resourceContainer.getEntry("META-INF/MANIFEST.MF");
                if (e != null) {
                    InputStream manifestStream = null;
                    try {
                        manifestStream = e.getInputStream();
                        if (manifestStream != null) {
                            Manifest manifestLoading;
                            this.manifest = manifestLoading = new Manifest(manifestStream);
                        }
                    }
                    catch (IOException e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"IOException thrown opening resource {0}", (Object[])new Object[]{this.resourceEntry.getResource()});
                        }
                    }
                    finally {
                        Util.tryToClose(manifestStream);
                    }
                }
            }
            return this.manifest;
        }

        @Override
        public URL getResourceUrl() {
            return this.resourceEntry.getResource();
        }

        @Override
        public String getResourcePath() {
            return this.resourcePath;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactEntryByteResourceInformation.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class EntryByteResourceInformation
    implements ByteResourceInformation {
        private final byte[] bytes;
        private final Entry resourceEntry;
        private final Container resourceContainer;
        private final String resourcePath;
        private Manifest manifest;
        private boolean manifestLoaded;
        static final long serialVersionUID = 3028210382439240345L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EntryByteResourceInformation(byte[] bytes, Entry resourceUrl, Container root, String resourcePath) {
            this.bytes = bytes;
            this.resourceEntry = resourceUrl;
            this.resourceContainer = root;
            this.resourcePath = resourcePath;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        @FFDCIgnore(value={IOException.class})
        public Manifest getManifest() {
            if (!this.manifestLoaded) {
                this.manifestLoaded = true;
                Entry e = this.resourceContainer.getEntry("META-INF/MANIFEST.MF");
                if (e != null) {
                    InputStream manifestStream;
                    block8: {
                        manifestStream = null;
                        try {
                            Manifest manifestLoading;
                            manifestStream = (InputStream)e.adapt(InputStream.class);
                            if (manifestStream == null) break block8;
                            this.manifest = manifestLoading = new Manifest(manifestStream);
                        }
                        catch (UnableToAdaptException manifestLoading) {
                            block9: {
                                FFDCFilter.processException((Throwable)manifestLoading, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryByteResourceInformation", (String)"1151", (Object)this, (Object[])new Object[0]);
                                if (!tc.isDebugEnabled()) break block9;
                                Tr.debug((TraceComponent)tc, (String)"UnableToAdaptException thrown opening resource {0}", (Object[])new Object[]{this.resourceEntry.getResource()});
                            }
                            Util.tryToClose(manifestStream);
                        }
                        catch (IOException e2) {
                            block10: {
                                if (!tc.isDebugEnabled()) break block10;
                                Tr.debug((TraceComponent)tc, (String)"IOException thrown opening resource {0}", (Object[])new Object[]{this.resourceEntry.getResource()});
                                {
                                    catch (Throwable throwable) {
                                        Util.tryToClose(manifestStream);
                                        throw throwable;
                                    }
                                }
                            }
                            Util.tryToClose(manifestStream);
                        }
                    }
                    Util.tryToClose(manifestStream);
                }
            }
            return this.manifest;
        }

        @Override
        public URL getResourceUrl() {
            return this.resourceEntry.getResource();
        }

        @Override
        public String getResourcePath() {
            return this.resourcePath;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EntryByteResourceInformation.class);
        }
    }

    protected static interface ByteResourceInformation {
        public byte[] getBytes();

        public Manifest getManifest();

        public URL getResourceUrl();

        public String getResourcePath();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class UnreadSmartClassPath
    implements SmartClassPath {
        SmartClassPathImpl delegate = new SmartClassPathImpl();
        static final long serialVersionUID = -8345533515600461349L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        UnreadSmartClassPath() {
        }

        @Override
        public void addContainer(Container container) {
            this.delegate.addContainer(container);
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.delegate.addArtifactContainer(container);
        }

        @Override
        public synchronized ByteResourceInformation getByteResourceInformation(String path) throws IOException {
            this.unwrap();
            return this.delegate.getByteResourceInformation(path);
        }

        @Override
        public synchronized URL getResourceURL(String path) {
            this.unwrap();
            return this.delegate.getResourceURL(path);
        }

        @Override
        public synchronized Collection<URL> getResourceURLs(String path) {
            this.unwrap();
            return this.delegate.getResourceURLs(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unwrap() {
            String methodName = "UnreadSmartClassPath.unwrap(): ";
            if (ContainerClassLoader.this.smartClassPath == this.delegate) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): Another thread has snuck in and performed the lazy initialisation already", (Object[])new Object[0]);
                }
                return;
            }
            UnreadSmartClassPath unreadSmartClassPath = this;
            synchronized (unreadSmartClassPath) {
                if (ContainerClassLoader.this.smartClassPath == this) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): First read operation on class loader: perform lazy initialisation", (Object[])new Object[0]);
                        }
                        ContainerClassLoader.this.lazyInit();
                    }
                    finally {
                        ContainerClassLoader.this.smartClassPath = this.delegate;
                    }
                }
            }
        }

        @Trivial
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.delegate.containsContainer(container);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UnreadSmartClassPath.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class SmartClassPathImpl
    implements SmartClassPath {
        final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
        final AtomicInteger outstandingContainers = new AtomicInteger(0);
        static final boolean usePackageMap;
        static final Integer maxLastNotFound;
        static final Integer maxLastFound;
        static final Integer maxLastReallyNotFound;
        static final boolean propsInUse;
        final List<UniversalContainer> classPath = new CopyOnWriteArrayList<UniversalContainer>();
        final int MAX_LASTNOTFOUND = maxLastNotFound;
        final List<Set<String>> lastNotFound = new CopyOnWriteArrayList<Set<String>>();
        final int MAX_LASTFOUND = maxLastFound;
        final Map<String, URL> lastFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTFOUND));
        final int MAX_LASTREALLYNOTFOUND = maxLastReallyNotFound;
        final Map<String, Object> lastReallyNotFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTREALLYNOTFOUND));
        final Map<Integer, List<UniversalContainer>> packageMap = usePackageMap ? new HashMap() : null;
        final Set<Container> containers = Collections.newSetFromMap(new WeakHashMap());
        static final long serialVersionUID = -1017399707774944722L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SmartClassPathImpl() {
        }

        private synchronized void addUniversalContainers(final UniversalContainer uc) {
            if (tc.isDebugEnabled()) {
                if (uc instanceof ArtifactContainerUniversalContainer) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + "wraps " + ((ArtifactContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " ART url " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " wraps " + ((ContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " CON url " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                }
            }
            if (usePackageMap) {
                this.outstandingContainers.incrementAndGet();
                mapCreationQueue.submit(new Runnable(){
                    static final long serialVersionUID = -2946150208078364083L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        if (tc.isDebugEnabled()) {
                            if (uc instanceof ArtifactContainerUniversalContainer) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            } else {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            }
                        }
                        ReentrantReadWriteLock.WriteLock write = SmartClassPathImpl.this.rwLock.writeLock();
                        write.lock();
                        try {
                            uc.updatePackageMap(SmartClassPathImpl.this.packageMap);
                            SmartClassPathImpl.this.outstandingContainers.decrementAndGet();
                        }
                        finally {
                            write.unlock();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " done building package map."), (Object[])new Object[0]);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            this.classPath.add(uc);
            this.lastNotFound.add(Collections.synchronizedSet(new LinkedHashSet()));
        }

        @Override
        public void addContainer(Container container) {
            this.containers.add(container);
            this.addUniversalContainers(new ContainerUniversalContainer(container));
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.addUniversalContainers(new ArtifactContainerUniversalContainer(container));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<UniversalContainer> getUniversalContainersForPath(String path, List<UniversalContainer> classpath) {
            if (this.outstandingContainers.get() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: request for " + path + " made to use map while map update pending, reverting request to full classpath"), (Object[])new Object[0]);
                }
                return classpath;
            }
            int startidx = (path = PathUtils.normalizeUnixStylePath((String)path)).startsWith("/") ? 1 : 0;
            int slashidx = path.lastIndexOf(47);
            if (slashidx > 0) {
                List<UniversalContainer> containersForKey;
                Integer key = path.substring(startidx, slashidx).hashCode();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: checking map using key {" + key + "} for path '" + path.substring(0, slashidx) + "'    :    origpath: '" + path + "'"), (Object[])new Object[0]);
                }
                ReentrantReadWriteLock.ReadLock read = this.rwLock.readLock();
                read.lock();
                try {
                    containersForKey = this.packageMap.get(key);
                }
                finally {
                    read.unlock();
                }
                if (containersForKey != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: got hit for key, returning container set with " + containersForKey.size() + " containers."), (Object[])new Object[0]);
                    }
                    return containersForKey;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: key was unknown, returning empty set. ", (Object[])new Object[0]);
                }
                return Collections.emptyList();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: request for a root level resource... : '" + path + "' returning original set with " + classpath.size()), (Object[])new Object[0]);
            }
            return classpath;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String path) throws IOException {
            int idx = 0;
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        ByteResourceInformation is = ur.getByteResourceInformation();
                        if (is != null) {
                            return is;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            return null;
        }

        @Override
        public URL getResourceURL(String path) {
            URL cached = this.lastFoundURL.get(path);
            if (cached != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastFound hit."), (Object[])new Object[0]);
                }
                return cached;
            }
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastReallyNotFound hit."), (Object[])new Object[0]);
                }
                return null;
            }
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            int skipped = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL();
                        if (url != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' found at classpath index " + idx + " local not found caches allowed us to skip " + skipped + " locations. Found cache is now.. " + this.lastFoundURL.size() + " and path was known to cache? " + this.lastFoundURL.containsKey(path)), (Object[])new Object[0]);
                            }
                            this.lastFoundURL.put(path, url);
                            return url;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                } else {
                    ++skipped;
                }
                ++idx;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' really not found. Cache size is now.. " + this.lastReallyNotFoundURL.size() + " path already known to cache? " + this.lastReallyNotFoundURL.containsKey(path)), (Object[])new Object[0]);
            }
            this.lastReallyNotFoundURL.put(path, null);
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String path) {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                return urls;
            }
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL();
                        if (url != null) {
                            urls.add(url);
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            if (urls.isEmpty()) {
                this.lastReallyNotFoundURL.put(path, null);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPath(Set<String> lastNotFoundForThisContainer, String path) {
            Set<String> set = lastNotFoundForThisContainer;
            synchronized (set) {
                if (lastNotFoundForThisContainer.size() >= this.MAX_LASTNOTFOUND) {
                    Iterator<String> i = lastNotFoundForThisContainer.iterator();
                    i.next();
                    i.remove();
                }
                lastNotFoundForThisContainer.add(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean pathNotInlastNotFound(String path, Set<String> lastNotFoundForThisContainer) {
            boolean pathFound = false;
            if (lastNotFoundForThisContainer != null) {
                Set<String> set = lastNotFoundForThisContainer;
                synchronized (set) {
                    pathFound = lastNotFoundForThisContainer.contains(path);
                }
            }
            return !pathFound;
        }

        @Trivial
        public String toString() {
            return String.valueOf(this.classPath);
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.containers.contains(container);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SmartClassPathImpl.class);
            usePackageMap = !Boolean.getBoolean("com.ibm.ws.classloading.container.disableMap");
            maxLastNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastNotFound", 250);
            maxLastFound = Integer.getInteger("com.ibm.ws.classloading.container.lastFound", 900);
            maxLastReallyNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastReallyNotFound", 900);
            boolean bl = propsInUse = !usePackageMap || System.getProperty("com.ibm.ws.classloading.container.lastNotFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastReallyNotFound") != null;
            if (propsInUse && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: custom cache properties in use : lastNotFound=" + maxLastNotFound + " lastFound=" + maxLastFound + " lastReallyNotFound=" + maxLastReallyNotFound), (Object[])new Object[0]);
                if (usePackageMap) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: experimental package map engaged.. utoh!", (Object[])new Object[0]);
                }
            }
        }
    }

    private static interface SmartClassPath {
        public void addContainer(Container var1);

        public void addArtifactContainer(ArtifactContainer var1);

        public ByteResourceInformation getByteResourceInformation(String var1) throws IOException;

        public URL getResourceURL(String var1);

        public Collection<URL> getResourceURLs(String var1);

        public boolean containsContainer(Container var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ArtifactContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final ArtifactContainer container;
        static final long serialVersionUID = 6052650257043442471L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalResource(ArtifactContainer c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL() {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            return (URL)urls.iterator().next();
        }

        @Override
        public ByteResourceInformation getByteResourceInformation() throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactContainerUniversalResource.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ArtifactContainerUniversalContainer
    implements UniversalContainer {
        final ArtifactContainer container;
        final boolean isRoot;
        static final long serialVersionUID = 4379869765614519424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalContainer(ArtifactContainer container) {
            this.container = container;
            this.isRoot = container.isRoot();
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ArtifactContainerUniversalResource(this.container);
            }
            try {
                ArtifactEntry e = this.container.getEntry(path);
                if (e != null) {
                    return new ArtifactEntryUniversalResource(this.container, e, path);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalContainer", (String)"496", (Object)this, (Object[])new Object[]{path});
                return null;
            }
        }

        private void processContainer(ArtifactContainer c, Map<Integer, List<UniversalContainer>> map, int chop) {
            for (ArtifactEntry e : c) {
                ArtifactContainer child = e.convertToContainer(true);
                if (child == null) continue;
                Integer key = child.getPath().substring(chop).hashCode();
                List<UniversalContainer> listForThisPath = map.get(key);
                if (listForThisPath == null) {
                    listForThisPath = new ArrayList<UniversalContainer>();
                    map.put(key, listForThisPath);
                }
                if (!listForThisPath.contains(this)) {
                    listForThisPath.add(this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                    }
                }
                this.processContainer(child, map, chop);
            }
        }

        @Override
        public synchronized void updatePackageMap(Map<Integer, List<UniversalContainer>> map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for artifact container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactContainerUniversalContainer.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ArtifactEntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final ArtifactContainer container;
        final ArtifactEntry entry;
        final String resourceName;
        static final long serialVersionUID = -4180497231463061931L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactEntryUniversalResource(ArtifactContainer container, ArtifactEntry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL() {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation() throws IOException {
            InputStream is = this.entry.getInputStream();
            byte[] bytes = ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
            return new ArtifactEntryByteResourceInformation(bytes, this.entry, this.container, this.resourceName);
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                File f = NativeLibraryAdapter.getFileForLibraryEntry(this.entry);
                if (f != null) {
                    return f.getPath();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", (String)"443", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactEntryUniversalResource.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ContainerUniversalContainer
    implements UniversalContainer {
        private final Container container;
        private final boolean isRoot;
        private String debugString;
        static final long serialVersionUID = -6091517091828528360L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalContainer(Container container) {
            this.container = container;
            this.isRoot = container.isRoot();
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ContainerUniversalResource(this.container);
            }
            Entry e = this.container.getEntry(path);
            if (e != null) {
                return new EntryUniversalResource(this.container, e, path);
            }
            return null;
        }

        private void processContainer(Container c, Map<Integer, List<UniversalContainer>> map, int chop) {
            for (Entry e : c) {
                try {
                    Container child = (Container)e.adapt(Container.class);
                    if (child == null || child.isRoot()) continue;
                    Integer key = child.getPath().substring(chop).hashCode();
                    List<UniversalContainer> listForThisPath = map.get(key);
                    if (listForThisPath == null) {
                        listForThisPath = new ArrayList<UniversalContainer>();
                        map.put(key, listForThisPath);
                    }
                    if (!listForThisPath.contains(this)) {
                        listForThisPath.add(this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                        }
                    }
                    this.processContainer(child, map, chop);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", (String)"356", (Object)this, (Object[])new Object[]{c, map, chop});
                }
            }
        }

        @Override
        public synchronized void updatePackageMap(Map<Integer, List<UniversalContainer>> map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for adaptable container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop);
        }

        public String toString() {
            if (this.debugString == null) {
                String physicalPath = this.container.getPhysicalPath();
                if (physicalPath == null) {
                    physicalPath = this.container.getPath();
                }
                this.debugString = physicalPath;
            }
            return this.debugString;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContainerUniversalContainer.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final Container container;
        static final long serialVersionUID = -2071295191562882201L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalResource(Container c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL() {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            return (URL)urls.iterator().next();
        }

        @Override
        public ByteResourceInformation getByteResourceInformation() throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ContainerUniversalResource.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class EntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final Container container;
        final Entry entry;
        final String resourceName;
        static final long serialVersionUID = -1840736822981653700L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EntryUniversalResource(Container container, Entry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL() {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteResourceInformation getByteResourceInformation() throws IOException {
            try {
                InputStream is = (InputStream)this.entry.adapt(InputStream.class);
                byte[] bytes = ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
                return new EntryByteResourceInformation(bytes, this.entry, this.container, this.resourceName);
            }
            catch (UnableToAdaptException is) {
                void e;
                FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"248", (Object)this, (Object[])new Object[0]);
                throw new IOException((Throwable)e);
            }
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                NativeLibrary nl = (NativeLibrary)this.entry.adapt(NativeLibrary.class);
                if (nl != null) {
                    return nl.getLibraryFile().getPath();
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"260", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EntryUniversalResource.class);
        }
    }

    private static interface UniversalContainer {
        public UniversalResource getResource(String var1);

        public void updatePackageMap(Map<Integer, List<UniversalContainer>> var1);

        public static interface UniversalResource {
            public URL getResourceURL();

            public ByteResourceInformation getByteResourceInformation() throws IOException;

            public String getNativeLibraryPath();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class JarCacheDisabler {
        static final long serialVersionUID = -3816849760898710298L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JarCacheDisabler() {
        }

        public static void disableJarCaching() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JarCacheDisabler.class);
            try {
                URLConnection connection = new URL("jar:file://something.jar!/").openConnection();
                connection.setDefaultUseCaches(false);
            }
            catch (MalformedURLException connection) {
                FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"88", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"90", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
        }
    }
}

