/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator;
import com.ibm.ws.webcontainer.security.internal.CertificateLoginAuthenticator;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.internal.FormLoginAuthenticator;
import com.ibm.ws.webcontainer.security.internal.SRTServletRequestUtils;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebAuthenticatorProxy
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebAuthenticatorProxy.class);
    private static final String AUTH_TYPE = "AUTH_TYPE";
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    protected volatile WebAppSecurityConfig webAppSecurityConfig;
    private volatile PostParameterHelper postParameterHelper;
    private final WebProviderAuthenticatorProxy providerAuthenticatorProxy;
    public HashMap<String, Object> extraAuditData = new HashMap();
    static final long serialVersionUID = 4335595118122782273L;

    public WebAuthenticatorProxy(WebAppSecurityConfig webAppSecurityConfig, PostParameterHelper postParameterHelper, AtomicServiceReference<SecurityService> securityServiceRef, WebProviderAuthenticatorProxy providerAuthenticatorProxy) {
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.postParameterHelper = postParameterHelper;
        this.securityServiceRef = securityServiceRef;
        this.providerAuthenticatorProxy = providerAuthenticatorProxy;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        AuthenticationResult authResult = this.providerAuthenticatorProxy.authenticate(webRequest);
        authResult.setTargetRealm(authResult.realm);
        String authType = webRequest.getLoginConfig().getAuthenticationMethod();
        if (authResult.getStatus() == AuthResult.CONTINUE) {
            WebAuthenticator authenticator = this.getWebAuthenticator(webRequest);
            if (authenticator == null) {
                return new AuthenticationResult(AuthResult.FAILURE, "Unable to get the appropriate WebAuthenticator. Unable to get the appropriate WebAuthenticator.");
            }
            authResult = authenticator.authenticate(webRequest);
            if (authenticator instanceof CertificateLoginAuthenticator && authResult != null && authResult.getStatus() != AuthResult.SUCCESS && this.webAppSecurityConfig.allowFailOver() && !webRequest.isDisableClientCertFailOver()) {
                this.extraAuditData.put("originalAuthType", authType);
                authType = this.getFailOverToAuthType(webRequest);
                this.extraAuditData.put("failoverAuthType", authType);
                authenticator = this.getAuthenticatorForFailOver(authType, webRequest);
                DenyReply reply = new DenyReply("AuthenticationFailed");
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_01, (Object[])new Object[]{webRequest, authResult, reply.getStatusCode()});
                if (authenticator == null) {
                    return new AuthenticationResult(AuthResult.FAILURE, "Unable to get the failover WebAuthenticator. Unable to authenticate request.");
                }
                authResult = authenticator.authenticate(webRequest);
                if (authResult != null && authResult.getStatus() == AuthResult.SUCCESS) {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_FAILOVER_01, (Object[])new Object[]{webRequest, authResult, this.extraAuditData, 200});
                } else {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_FAILOVER_01, (Object[])new Object[]{webRequest, authResult, this.extraAuditData, reply.getStatusCode()});
                }
            }
        }
        if (authResult != null && authResult.getStatus() == AuthResult.SUCCESS) {
            SRTServletRequestUtils.setPrivateAttribute(webRequest.getHttpServletRequest(), AUTH_TYPE, authType);
            if ("FORM".equalsIgnoreCase(authType)) {
                this.postParameterHelper.restore(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
            }
        }
        return authResult;
    }

    private WebAuthenticator getAuthenticatorForFailOver(String authType, WebRequest webRequest) {
        WebAuthenticator authenticator = null;
        if ("FORM".equals(authType)) {
            authenticator = this.createFormLoginAuthenticator(webRequest);
        } else if ("BASIC".equals(authType)) {
            authenticator = this.getBasicAuthAuthenticator();
        }
        return authenticator;
    }

    private boolean appHasWebXMLFormLogin(WebRequest webRequest) {
        return webRequest.getFormLoginConfiguration() != null && webRequest.getFormLoginConfiguration().getLoginPage() != null && webRequest.getFormLoginConfiguration().getErrorPage() != null;
    }

    private boolean globalWebAppSecurityConfigHasFormLogin() {
        WebAppSecurityConfig globalConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        return globalConfig != null && globalConfig.getLoginFormURL() != null;
    }

    private String getFailOverToAuthType(WebRequest webRequest) {
        String authType = null;
        if (this.webAppSecurityConfig.getAllowFailOverToAppDefined()) {
            SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
            LoginConfiguration loginConfig = securityMetadata.getLoginConfiguration();
            if (loginConfig != null) {
                authType = loginConfig.getAuthenticationMethod();
            }
        } else if (this.webAppSecurityConfig.getAllowFailOverToBasicAuth() && this.webAppSecurityConfig.getAllowFailOverToFormLogin()) {
            authType = this.appHasWebXMLFormLogin(webRequest) || this.globalWebAppSecurityConfigHasFormLogin() ? "FORM" : "BASIC";
        } else if (this.webAppSecurityConfig.getAllowFailOverToFormLogin()) {
            authType = "FORM";
        } else if (this.webAppSecurityConfig.getAllowFailOverToBasicAuth()) {
            authType = "BASIC";
        }
        return authType;
    }

    public WebAuthenticator getWebAuthenticator(WebRequest webRequest) {
        String authMech = this.webAppSecurityConfig.getOverrideHttpAuthMethod();
        if (authMech != null && authMech.equals("CLIENT_CERT")) {
            return this.createCertificateLoginAuthenticator();
        }
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        LoginConfiguration loginConfig = securityMetadata.getLoginConfiguration();
        if (loginConfig != null) {
            String authenticationMethod = loginConfig.getAuthenticationMethod();
            if ("FORM".equalsIgnoreCase(authenticationMethod)) {
                return this.createFormLoginAuthenticator(webRequest);
            }
            if ("CLIENT_CERT".equalsIgnoreCase(authenticationMethod)) {
                return this.createCertificateLoginAuthenticator();
            }
        }
        return this.getBasicAuthAuthenticator();
    }

    /*
     * WARNING - void declaration
     */
    public BasicAuthAuthenticator getBasicAuthAuthenticator() {
        try {
            return this.createBasicAuthenticator();
        }
        catch (RegistryException registryException) {
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.webcontainer.security.WebAuthenticatorProxy", (String)"215", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"RegistryException while trying to create BasicAuthAuthenticator", (Object[])new Object[]{e});
            }
            return null;
        }
    }

    protected BasicAuthAuthenticator createBasicAuthenticator() throws RegistryException {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        UserRegistryService userRegistryService = securityService.getUserRegistryService();
        UserRegistry userRegistry = null;
        if (userRegistryService.isUserRegistryConfigured()) {
            userRegistry = userRegistryService.getUserRegistry();
        }
        SSOCookieHelper sSOCookieHelper = this.webAppSecurityConfig.createSSOCookieHelper();
        return new BasicAuthAuthenticator(securityService.getAuthenticationService(), userRegistry, sSOCookieHelper, this.webAppSecurityConfig);
    }

    protected FormLoginAuthenticator createFormLoginAuthenticator(WebRequest webRequest) {
        WebAuthenticator ssoAuthenticator = this.providerAuthenticatorProxy.getSSOAuthenticator(webRequest, null);
        return new FormLoginAuthenticator(ssoAuthenticator, this.webAppSecurityConfig, this.providerAuthenticatorProxy);
    }

    public CertificateLoginAuthenticator createCertificateLoginAuthenticator() {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        return new CertificateLoginAuthenticator(securityService.getAuthenticationService(), this.webAppSecurityConfig.createSSOCookieHelper());
    }

    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) {
        return null;
    }
}

