/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.metadata.CollectionMatch;
import com.ibm.ws.webcontainer.security.metadata.URLMatchingUtils;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebResourceCollection {
    private final List<String> urlPatterns;
    private final List<String> methods;
    private final List<String> omissionMethods;
    private final boolean matchAllMethods;
    private final boolean denyUncoveredHttpMethods;
    static final long serialVersionUID = -890176278659265136L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebResourceCollection(List<String> urlPatterns, List<String> methods) {
        this(urlPatterns, methods, Collections.EMPTY_LIST);
    }

    public WebResourceCollection(List<String> urlPatterns, List<String> methods, List<String> omissionMethods) {
        this(urlPatterns, methods, omissionMethods, false);
    }

    public WebResourceCollection(List<String> urlPatterns, List<String> methods, List<String> omissionMethods, boolean denyUncoveredHttpMethods) {
        this.urlPatterns = urlPatterns;
        this.methods = methods;
        this.omissionMethods = omissionMethods;
        this.matchAllMethods = methods.isEmpty() && omissionMethods.isEmpty();
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
    }

    public CollectionMatch performUrlMatch(String resourceName) {
        CollectionMatch match = null;
        String longestUrlPattern = null;
        for (String urlPattern : this.urlPatterns) {
            if (URLMatchingUtils.isExactMatch(resourceName, urlPattern)) {
                return new CollectionMatch(resourceName, CollectionMatch.MatchType.EXACT_MATCH);
            }
            if (URLMatchingUtils.isPathNameMatch(resourceName, urlPattern)) {
                longestUrlPattern = URLMatchingUtils.getLongestUrlPattern(longestUrlPattern, urlPattern);
                continue;
            }
            if (!URLMatchingUtils.isExtensionMatch(resourceName, urlPattern)) continue;
            match = new CollectionMatch(urlPattern, CollectionMatch.MatchType.EXTENSION_MATCH);
        }
        if (longestUrlPattern != null) {
            match = new CollectionMatch(longestUrlPattern, CollectionMatch.MatchType.PATH_MATCH);
        }
        return match;
    }

    public boolean isMethodMatched(String method) {
        return this.matchAllMethods || this.isValidMethod(method) || this.isNotAnOmissionMethod(method);
    }

    public boolean deniedDueToDenyUncoveredHttpMethods(String method) {
        if (!this.denyUncoveredHttpMethods) {
            return false;
        }
        return !this.isMethodMatched(method);
    }

    private boolean isValidMethod(String method) {
        return !this.methods.isEmpty() && this.methods.contains(method);
    }

    private boolean isNotAnOmissionMethod(String method) {
        return !this.omissionMethods.isEmpty() && !this.omissionMethods.contains(method);
    }

    public boolean isSpecifiedOmissionMethod(String method) {
        return !this.omissionMethods.isEmpty() && this.omissionMethods.contains(method);
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public List<String> getHttpMethods() {
        return this.methods;
    }

    public List<String> getOmissionMethods() {
        return this.omissionMethods;
    }

    public boolean getDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    public boolean isMethodListed(String method) {
        return this.methods.contains(method) || this.omissionMethods.contains(method);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebResourceCollection.class);
    }
}

