/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive.internal;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.archive.internal.AbstractArchive;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PaxArchive
extends AbstractArchive {
    private final File archiveFile;
    private Process paxProcess;
    private PrintStream paxStdin;

    public PaxArchive(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    @Override
    public void addFileEntry(String entryPath, File source) throws IOException {
        if (this.paxProcess != null) {
            this.close();
        }
        List<String> args = this.preparePaxCmd(entryPath, true);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        this.paxProcess = processBuilder.start();
        this.paxStdin = new PrintStream(this.paxProcess.getOutputStream(), true);
        this.paxStdin.println(source.getAbsolutePath());
    }

    @Override
    public void addDirEntry(String entryPath, File source, List<String> dirContent) throws IOException {
        if (this.paxProcess != null) {
            this.close();
        }
        List<String> args = this.preparePaxCmd(entryPath, false);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.directory(source);
        this.paxProcess = processBuilder.start();
        this.paxStdin = new PrintStream(this.paxProcess.getOutputStream(), true);
        for (String relativePath : dirContent) {
            this.paxStdin.println(relativePath);
        }
    }

    private List<String> preparePaxCmd(String entryPath, boolean isFileName) throws IOException {
        if (this.paxProcess != null) {
            throw new IOException("Archive already open");
        }
        String paxCommand = null;
        for (String candidate : Arrays.asList("/bin/pax", "/usr/bin/pax")) {
            File pax = new File(candidate);
            if (!pax.exists()) continue;
            paxCommand = candidate;
            break;
        }
        if (paxCommand == null) {
            throw new IOException("pax is not in /bin or /usr/bin");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(paxCommand);
        args.add("-wd");
        if ("z/OS".equalsIgnoreCase(System.getProperty("os.name"))) {
            args.add("-x");
            args.add("pax");
        }
        if (entryPath != null && !entryPath.isEmpty()) {
            args.add("-s");
            if (isFileName) {
                args.add("@.*@" + entryPath + "@");
            } else {
                args.add("@^@" + entryPath + "@");
            }
        }
        if (this.archiveFile.exists()) {
            args.add("-a");
        }
        args.add("-f");
        args.add(this.archiveFile.getAbsolutePath());
        return args;
    }

    @Override
    public void close() throws IOException {
        if (this.paxStdin == null) {
            return;
        }
        this.paxStdin.close();
        this.paxStdin = null;
        this.processOutput(this.paxProcess.getErrorStream());
        this.processOutput(this.paxProcess.getInputStream());
        try {
            int returnCode = this.paxProcess.waitFor();
            if (returnCode != 0) {
                throw new IOException("/bin/pax returned with " + returnCode);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        finally {
            this.paxProcess = null;
        }
    }

    private void processOutput(InputStream inputStream) {
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            Debug.printStackTrace(ioe);
        }
        try {
            inputStream.close();
        }
        catch (IOException ioe) {
            Debug.printStackTrace(ioe);
        }
    }
}

