/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.util;

import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.util.FileSystem;
import com.ibm.ws.kernel.util.MemoryInformationException;
import com.ibm.ws.kernel.util.OperatingSystem;
import com.ibm.ws.kernel.util.OperatingSystemException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class MemoryInformation {
    public static final long BYTES_IN_KB = 1024L;
    public static final long BYTES_IN_MB = 0x100000L;
    public static final long BYTES_IN_GB = 0x40000000L;
    public static final long BYTES_IN_TB = 0x10000000000L;
    public static final long BYTES_IN_PB = 0x4000000000000L;
    public static final long BYTES_IN_EB = 0x1000000000000000L;
    private final boolean cacheTotalRam;
    private long cachedTotalRam = -1L;
    private final boolean useLightweightAvailableRam;
    private static final MemoryInformation instance = new MemoryInformation();
    private static final Pattern spacePattern = Pattern.compile("\\s+");
    private static OperatingSystemMXBean osMxBean;
    private static Method methodGetTotalPhysicalMemorySize;
    private static Method methodGetFreePhysicalMemorySize;
    private static final DateFormat df;

    public static MemoryInformation instance() {
        return instance;
    }

    public synchronized long getTotalMemory() throws MemoryInformationException {
        if (this.cacheTotalRam && this.cachedTotalRam != -1L) {
            return this.cachedTotalRam;
        }
        long result = -1L;
        try {
            result = this.getTotalMemoryJDK();
        }
        catch (MemoryInformationException memoryInformationException) {
            // empty catch block
        }
        if (result == -1L) {
            switch (OperatingSystem.instance().getOperatingSystemType()) {
                case Linux: {
                    result = this.getTotalMemoryLinux();
                    break;
                }
                case AIX: {
                    result = this.getTotalMemoryAix();
                    break;
                }
                case Mac: {
                    result = this.getTotalMemoryMac();
                    break;
                }
                case Windows: {
                    result = this.getTotalMemoryWindows();
                    break;
                }
                case HPUX: {
                    result = this.getTotalMemoryHp();
                    break;
                }
                case IBMi: {
                    result = this.getTotalMemoryIBMi();
                    break;
                }
                case Solaris: {
                    result = this.getTotalMemorySolaris();
                    break;
                }
                case zOS: {
                    result = this.getTotalMemoryzOS();
                    break;
                }
                default: {
                    throw this.getNotImplementedException();
                }
            }
        }
        if (this.cacheTotalRam) {
            this.cachedTotalRam = result;
        }
        return result;
    }

    public long getAvailableMemory() throws MemoryInformationException {
        if (this.useLightweightAvailableRam) {
            try {
                return this.getFreeMemoryJDK();
            }
            catch (MemoryInformationException memoryInformationException) {
                // empty catch block
            }
        }
        switch (OperatingSystem.instance().getOperatingSystemType()) {
            case Linux: {
                return this.getAvailableMemoryLinux();
            }
            case AIX: {
                return this.getAvailableMemoryAix();
            }
            case Mac: {
                return this.getAvailableMemoryMac();
            }
            case Windows: {
                return this.getAvailableMemoryWindows();
            }
            case HPUX: {
                return this.getAvailableMemoryHp();
            }
            case IBMi: {
                return this.getAvailableMemoryIBMi();
            }
            case Solaris: {
                return this.getAvailableMemorySolaris();
            }
            case zOS: {
                return this.getAvailableMemoryzOS();
            }
        }
        throw this.getNotImplementedException();
    }

    public float getAvailableMemoryRatio() throws MemoryInformationException {
        long totalMemory = this.getTotalMemory();
        long availableMemory = this.getAvailableMemory();
        return (float)((double)availableMemory / (double)totalMemory);
    }

    public MemoryInformation() {
        this(true, false);
    }

    public MemoryInformation(boolean cacheTotalRam, boolean useLightweightAvailableRam) {
        this.cacheTotalRam = cacheTotalRam;
        this.useLightweightAvailableRam = useLightweightAvailableRam;
    }

    public static long inferBytes(String line) throws MemoryInformationException {
        long modifier = 1L;
        if ((line = line.toLowerCase()).contains("kb")) {
            modifier = 1024L;
            line = line.replaceAll("kb", "");
        } else if (line.contains("kilobytes")) {
            modifier = 1024L;
            line = line.replaceAll("kilobytes", "");
        } else if (line.contains("mb")) {
            modifier = 0x100000L;
            line = line.replaceAll("mb", "");
        } else if (line.contains("megabytes")) {
            modifier = 0x100000L;
            line = line.replaceAll("megabytes", "");
        } else if (line.contains("gb")) {
            modifier = 0x40000000L;
            line = line.replaceAll("gb", "");
        } else if (line.contains("gigabytes")) {
            modifier = 0x40000000L;
            line = line.replaceAll("gigabytes", "");
        } else if (line.contains("tb")) {
            modifier = 0x10000000000L;
            line = line.replaceAll("tb", "");
        } else if (line.contains("terabytes")) {
            modifier = 0x10000000000L;
            line = line.replaceAll("terabytes", "");
        } else if (line.contains("pb")) {
            modifier = 0x4000000000000L;
            line = line.replaceAll("pb", "");
        } else if (line.contains("petabytes")) {
            modifier = 0x4000000000000L;
            line = line.replaceAll("petabytes", "");
        } else if (line.contains("eb")) {
            modifier = 0x1000000000000000L;
            line = line.replaceAll("eb", "");
        } else if (line.contains("exabytes")) {
            modifier = 0x1000000000000000L;
            line = line.replaceAll("exabytes", "");
        } else {
            line = line.replaceAll("b", "");
            line = line.replaceAll("bytes", "");
        }
        return Long.parseLong(line.trim()) * modifier;
    }

    private MemoryInformationException getNotImplementedException() {
        return new MemoryInformationException("Unimplemented operating system " + (Object)((Object)OperatingSystem.instance().getOperatingSystemType()) + " (" + System.getProperty("os.name") + ")");
    }

    private long getTotalMemoryLinux() throws MemoryInformationException {
        try {
            List<String> lines = FileSystem.readAllLines("/proc/meminfo");
            for (String meminfoLine : lines) {
                if (!meminfoLine.startsWith("MemTotal:")) continue;
                return this.parseLinuxMeminfoLine(meminfoLine);
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/proc/meminfo", lines));
        }
        catch (IOException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long parseLinuxMeminfoLine(String line) throws MemoryInformationException {
        line = line.substring(line.indexOf(58) + 1).trim();
        int i = line.lastIndexOf(32);
        int modifier = 1;
        if (i != -1) {
            String modifierString = line.substring(i + 1);
            line = line.substring(0, i);
            if (modifierString.equals("kB")) {
                modifier = 1024;
            } else {
                throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/proc/meminfo", modifierString));
            }
        }
        return Long.parseLong(line) * (long)modifier;
    }

    private long getAvailableMemoryLinux() throws MemoryInformationException {
        try {
            long fileCache = 0L;
            long slabReclaimable = 0L;
            long buffers = 0L;
            long cached = 0L;
            long free = 0L;
            List<String> lines = FileSystem.readAllLines("/proc/meminfo");
            for (String meminfoLine : lines) {
                if (meminfoLine.startsWith("MemAvailable:")) {
                    return this.parseLinuxMeminfoLine(meminfoLine);
                }
                if (meminfoLine.startsWith("MemFree:")) {
                    free = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Cached:")) {
                    cached = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Buffers:")) {
                    buffers = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("SReclaimable:")) {
                    slabReclaimable = this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (meminfoLine.startsWith("Active(file):")) {
                    fileCache += this.parseLinuxMeminfoLine(meminfoLine);
                    continue;
                }
                if (!meminfoLine.startsWith("Inactive(file):")) continue;
                fileCache += this.parseLinuxMeminfoLine(meminfoLine);
            }
            long watermark_low = 0L;
            for (String zoneinfoLine : FileSystem.readAllLines("/proc/zoneinfo")) {
                if (!(zoneinfoLine = zoneinfoLine.trim()).startsWith("low")) continue;
                watermark_low += Long.parseLong(zoneinfoLine.substring(3).trim());
            }
            long availableFallback = 0L;
            if (fileCache > 0L && slabReclaimable > 0L && (watermark_low *= (long)OperatingSystem.getPageSize()) > 0L) {
                fileCache -= Math.min(fileCache / 2L, watermark_low);
                availableFallback = free - watermark_low + fileCache + slabReclaimable - Math.min(slabReclaimable / 2L, watermark_low);
            } else {
                availableFallback = free + buffers + this.applySwappiness(cached);
            }
            if (availableFallback > 0L) {
                return availableFallback;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/proc/meminfo", lines));
        }
        catch (OperatingSystemException | IOException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long applySwappiness(long cached) throws IOException, MemoryInformationException {
        int swappiness = MemoryInformation.getSwappiness();
        if (swappiness >= 50) {
            cached = (long)((double)cached * ((double)(100 - swappiness) / 100.0));
        }
        return cached;
    }

    public static synchronized int getSwappiness() throws MemoryInformationException {
        try {
            List<String> swappinessLines = FileSystem.readAllLines("/proc/sys/vm/swappiness");
            if (swappinessLines.size() == 1) {
                return Integer.parseInt(swappinessLines.get(0));
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/proc/sys/vm/swappiness", swappinessLines));
        }
        catch (IOException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryMac() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/sbin/sysctl", "hw.memsize");
            if (lines.size() == 1) {
                String line = lines.get(0);
                int i = line.indexOf(": ");
                if (i != -1) {
                    return Long.parseLong(line.substring(i + 2));
                }
                throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/usr/sbin/sysctl", lines));
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "/usr/sbin/sysctl", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getAvailableMemoryMac() throws MemoryInformationException {
        try {
            long available = 0L;
            List<String> vmstatLines = OperatingSystem.executeProgram("/usr/bin/vm_stat");
            for (String vmstatLine : vmstatLines) {
                if (vmstatLine.startsWith("Pages free:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (vmstatLine.startsWith("Pages inactive:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (vmstatLine.startsWith("Pages speculative:")) {
                    available += this.processMacVmStatLine(vmstatLine);
                    continue;
                }
                if (!vmstatLine.startsWith("File-backed pages:")) continue;
                available += this.processMacVmStatLine(vmstatLine);
            }
            if (available <= 0L) {
                throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "vm_stat", vmstatLines));
            }
            return available *= (long)OperatingSystem.getPageSize();
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long processMacVmStatLine(String line) {
        line = line.substring(line.indexOf(58) + 1).trim();
        line = line.substring(0, line.length() - 1);
        return Long.parseLong(line);
    }

    private long getTotalMemoryWindows() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("wmic", "os", "get", "totalvisiblememorysize", "/format:list");
            for (String line : lines) {
                if (!line.startsWith("TotalVisibleMemorySize=")) continue;
                return this.processWmicLine(line) * 1024L;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "wmic", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long processWmicLine(String line) {
        return Long.parseLong(line.substring(line.indexOf(61) + 1));
    }

    private long getAvailableMemoryWindows() throws MemoryInformationException {
        try {
            long available = 0L;
            List<String> lines = OperatingSystem.executeProgram("wmic", "path", "Win32_PerfFormattedData_PerfOS_Memory", "get", "/format:list");
            for (String line : lines) {
                if (line.startsWith("AvailableBytes=")) {
                    available += this.processWmicLine(line);
                    continue;
                }
                if (!line.startsWith("CacheBytes=")) continue;
                available += this.processWmicLine(line);
            }
            if (available <= 0L) {
                throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "wmic", lines));
            }
            return available;
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryAix() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/sbin/lsattr", "-El", "sys0");
            for (String line : lines) {
                if (!line.startsWith("realmem")) continue;
                line = line.substring(7);
                line = line.substring(0, line.indexOf("Amount"));
                line = line.trim();
                return Long.parseLong(line) * 1024L;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "lsattr", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getAvailableMemoryAix() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("/usr/bin/svmon", "-O", "summary=basic,unit=KB");
            for (String line : lines) {
                if (!line.startsWith("memory")) continue;
                String[] pieces = spacePattern.split(line);
                if (pieces.length >= 7) {
                    return Long.parseLong(pieces[6]) * 1024L;
                }
                throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "svmon", lines));
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "svmon", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryHp() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return (Long.parseLong(pieces[3]) + Long.parseLong(pieces[4])) * 1024L;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "vmstat", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getAvailableMemoryHp() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return Long.parseLong(pieces[4]) * 1024L;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "vmstat", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryIBMi() throws MemoryInformationException {
        return this.getTotalMemoryJDK();
    }

    private long getAvailableMemoryIBMi() throws MemoryInformationException {
        return this.getFreeMemoryJDK();
    }

    private long getTotalMemorySolaris() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("prtconf");
            for (String line : lines) {
                if (!line.toLowerCase().startsWith("memory")) continue;
                line = line.substring(line.indexOf(58) + 1).trim();
                return MemoryInformation.inferBytes(line);
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "prtdiag", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getAvailableMemorySolaris() throws MemoryInformationException {
        try {
            List<String> lines = OperatingSystem.executeProgram("vmstat", "1", "1");
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).trim().startsWith("r")) continue;
                String[] pieces = spacePattern.split(lines.get(i + 2));
                return Long.parseLong(pieces[4]) * 1024L;
            }
            throw new MemoryInformationException(MessageFormat.format(BootstrapConstants.messages.getString("memory.information.unexpected"), "vmstat", lines));
        }
        catch (OperatingSystemException e) {
            throw new MemoryInformationException(e);
        }
    }

    private long getTotalMemoryzOS() throws MemoryInformationException {
        return this.getTotalMemoryJDK();
    }

    private long getAvailableMemoryzOS() throws MemoryInformationException {
        long result = this.getFreeMemoryJDK();
        if (result <= 0L) {
            throw new MemoryInformationException(BootstrapConstants.messages.getString("memory.information.unavailable"));
        }
        return result;
    }

    private synchronized long getTotalMemoryJDK() throws MemoryInformationException {
        if (osMxBean == null) {
            osMxBean = ManagementFactory.getOperatingSystemMXBean();
        }
        try {
            if (methodGetTotalPhysicalMemorySize == null) {
                try {
                    methodGetTotalPhysicalMemorySize = osMxBean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    methodGetTotalPhysicalMemorySize = osMxBean.getClass().getMethod("getTotalPhysicalMemory", new Class[0]);
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        methodGetTotalPhysicalMemorySize.setAccessible(true);
                        return null;
                    }
                });
            }
            return (Long)methodGetTotalPhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MemoryInformationException(e);
        }
    }

    private synchronized long getFreeMemoryJDK() throws MemoryInformationException {
        if (osMxBean == null) {
            osMxBean = ManagementFactory.getOperatingSystemMXBean();
        }
        try {
            if (methodGetFreePhysicalMemorySize == null) {
                methodGetFreePhysicalMemorySize = osMxBean.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        methodGetFreePhysicalMemorySize.setAccessible(true);
                        return null;
                    }
                });
            }
            return (Long)methodGetFreePhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MemoryInformationException(e);
        }
    }

    public static void main(String ... args) throws Throwable {
        MemoryInformation.out(MemoryInformation.class.getName() + " started");
        MemoryInformation.out("Operating System: " + (Object)((Object)OperatingSystem.instance().getOperatingSystemType()));
        MemoryInformation.out("Total memory: " + MemoryInformation.instance().getTotalMemory());
        MemoryInformation.out("Available memory: " + MemoryInformation.instance().getAvailableMemory());
        MemoryInformation.out("Available memory %: " + (double)MemoryInformation.instance().getAvailableMemoryRatio() * 100.0);
    }

    private static void out(String message) {
        System.out.println("[" + df.format(new Date()) + "] " + message);
    }

    static {
        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }
}

