/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.util;

import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.util.OperatingSystemException;
import com.ibm.ws.kernel.util.OperatingSystemType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class OperatingSystem {
    private static final OperatingSystem instance = new OperatingSystem();
    private final OperatingSystemType osType = OperatingSystem.parseOperatingSystemType();
    private static int cachedPageSize = -1;

    public static OperatingSystem instance() {
        return instance;
    }

    public OperatingSystemType getOperatingSystemType() {
        return this.osType;
    }

    private static OperatingSystemType parseOperatingSystemType() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if ((osName = osName.toLowerCase().replaceAll("/", "")).contains("linux")) {
                return OperatingSystemType.Linux;
            }
            if (osName.contains("mac") || osName.contains("darwin")) {
                return OperatingSystemType.Mac;
            }
            if (osName.contains("aix")) {
                return OperatingSystemType.AIX;
            }
            if (osName.contains("win")) {
                return OperatingSystemType.Windows;
            }
            if (osName.contains("400")) {
                return OperatingSystemType.IBMi;
            }
            if (osName.contains("os390") || osName.contains("zos")) {
                return OperatingSystemType.zOS;
            }
            if (osName.contains("hp")) {
                return OperatingSystemType.HPUX;
            }
            if (osName.contains("solaris") || osName.contains("sun")) {
                return OperatingSystemType.Solaris;
            }
        }
        return OperatingSystemType.Unknown;
    }

    public static synchronized int getPageSize() throws OperatingSystemException {
        if (cachedPageSize == -1) {
            switch (OperatingSystem.instance().getOperatingSystemType()) {
                case AIX: 
                case HPUX: 
                case IBMi: 
                case Linux: 
                case Mac: 
                case Solaris: 
                case zOS: {
                    cachedPageSize = OperatingSystem.getPageSizePOSIX();
                    break;
                }
                default: {
                    throw new OperatingSystemException(BootstrapConstants.messages.getString("os.pagesize.unavailable"));
                }
            }
        }
        return cachedPageSize;
    }

    private static int getPageSizePOSIX() throws OperatingSystemException {
        List<String> getconfLines = OperatingSystem.executeProgram("/usr/bin/getconf", "PAGE_SIZE");
        return Integer.parseInt(getconfLines.get(0).trim());
    }

    public static List<String> executeProgram(String ... commandLine) throws OperatingSystemException {
        return OperatingSystem.executeProgramWithInput(null, commandLine);
    }

    public static List<String> executeProgramWithInput(String input, String ... commandLine) throws OperatingSystemException {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(commandLine);
            Process process = builder.start();
            if (input != null) {
                try (OutputStream os = process.getOutputStream();
                     OutputStreamWriter osw = new OutputStreamWriter(os);
                     BufferedWriter bw = new BufferedWriter(osw);){
                    bw.write(input);
                    bw.flush();
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            try (InputStream is = process.getInputStream();
                 InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            try {
                int returnCode = process.waitFor();
                if (returnCode != 0) {
                    throw new OperatingSystemException(MessageFormat.format(BootstrapConstants.messages.getString("os.execute.error"), commandLine, returnCode, lines));
                }
                return lines;
            }
            catch (InterruptedException e) {
                throw new OperatingSystemException(e);
            }
        }
        catch (IOException e1) {
            throw new OperatingSystemException(e1);
        }
    }
}

