/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.org.apache.commons.compress.archivers;

import com.ibm.ws.org.apache.commons.compress.archivers.ArchiveEntry;
import com.ibm.ws.org.apache.commons.compress.archivers.ArchiveException;
import com.ibm.ws.org.apache.commons.compress.archivers.ArchiveInputStream;
import com.ibm.ws.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Lister.usage();
            return;
        }
        System.out.println("Analysing " + args[0]);
        File f = new File(args[0]);
        if (!f.isFile()) {
            System.err.println(f + " doesn't exist or is a directory");
        }
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = Lister.createArchiveInputStream(args, fis);){
            ArchiveEntry ae;
            System.out.println("Created " + ais.toString());
            while ((ae = ais.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] args, InputStream fis) throws ArchiveException {
        if (args.length > 1) {
            return factory.createArchiveInputStream(args[1], fis);
        }
        return factory.createArchiveInputStream(fis);
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

