/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.credentials.wscred.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialProvider;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.credentials.wscred.WSCredentialImpl;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.CredentialExpiredException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSCredentialProvider
implements CredentialProvider {
    private static final TraceComponent tc = Tr.register(WSCredentialProvider.class);
    static final String KEY_USER_REGISTYR_SERVICE = "userRegistryService";
    public static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    private final AtomicServiceReference<UserRegistryService> userRegistryServiceRef = new AtomicServiceReference("userRegistryService");
    private final AtomicServiceReference<CredentialsService> credentialsServiceRef = new AtomicServiceReference("credentialsService");
    static final long serialVersionUID = -6589693652933211505L;

    protected void setUserRegistryService(ServiceReference<UserRegistryService> reference) {
        this.userRegistryServiceRef.setReference(reference);
    }

    protected void unsetUserRegistryService(ServiceReference<UserRegistryService> reference) {
        this.userRegistryServiceRef.unsetReference(reference);
    }

    public void setCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.setReference(ref);
    }

    public void unsetCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc) {
        this.userRegistryServiceRef.activate(cc);
        this.credentialsServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.userRegistryServiceRef.deactivate(cc);
        this.credentialsServiceRef.deactivate(cc);
    }

    public void setCredential(Subject subject) throws CredentialException {
        Set<WSPrincipal> principals = subject.getPrincipals(WSPrincipal.class);
        if (principals.isEmpty()) {
            return;
        }
        if (principals.size() != 1) {
            throw new CredentialException("Too many WSPrincipals in the subject");
        }
        WSPrincipal principal = principals.iterator().next();
        this.setCredential(subject, principal);
    }

    private Hashtable<String, ?> getUniqueIdAndSecurityNameHashtableFromSubject(Subject subject) {
        String[] properties = new String[]{"com.ibm.wsspi.security.cred.uniqueId", "com.ibm.wsspi.security.cred.securityName"};
        SubjectHelper subjectHelper = new SubjectHelper();
        return subjectHelper.getHashtableFromSubject(subject, properties);
    }

    private Hashtable<String, ?> getUniqueIdHashtableFromSubject(Subject subject) {
        String[] properties = new String[]{"com.ibm.wsspi.security.cred.uniqueId"};
        SubjectHelper subjectHelper = new SubjectHelper();
        return subjectHelper.getHashtableFromSubject(subject, properties);
    }

    private void setCredential(Subject subject, WSPrincipal principal) throws CredentialException {
        String urType;
        UserRegistryService urService;
        String securityName = principal.getName();
        Hashtable<String, ?> customProperties = this.getUniqueIdHashtableFromSubject(subject);
        if ((customProperties == null || customProperties.isEmpty()) && (urService = (UserRegistryService)this.userRegistryServiceRef.getService()) != null && ("WIM".equalsIgnoreCase(urType = urService.getUserRegistryType()) || "LDAP".equalsIgnoreCase(urType))) {
            try {
                securityName = urService.getUserRegistry().getUserDisplayName(securityName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.credentials.wscred.internal.WSCredentialProvider", (String)"135", (Object)this, (Object[])new Object[]{subject, principal});
            }
        }
        if (securityName == null) {
            securityName = principal.getName();
        }
        String accessId = principal.getAccessId();
        String customRealm = null;
        String realm = null;
        String uniqueName = null;
        if (customProperties != null) {
            customRealm = (String)customProperties.get("com.ibm.wsspi.security.cred.realm");
        }
        if (customRealm != null) {
            realm = customRealm;
            String[] parts = accessId.split(realm + "/");
            if (parts != null && parts.length == 2) {
                uniqueName = parts[1];
            }
        } else {
            realm = AccessIdUtil.getRealm((String)accessId);
            uniqueName = AccessIdUtil.getUniqueId((String)accessId);
        }
        if (AccessIdUtil.isServerAccessId((String)accessId)) {
            this.setCredential(null, subject, realm, securityName, uniqueName, null, accessId, null, null);
        } else {
            CredentialsService cs = (CredentialsService)this.credentialsServiceRef.getService();
            String unauthenticatedUserid = cs.getUnauthenticatedUserid();
            if (securityName != null && unauthenticatedUserid != null && securityName.equals(unauthenticatedUserid)) {
                this.setCredential(unauthenticatedUserid, subject, realm, securityName, uniqueName, null, null, null, null);
            } else if (AccessIdUtil.isUserAccessId((String)accessId)) {
                this.createUserWSCredential(subject, securityName, accessId, realm, uniqueName, unauthenticatedUserid);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createUserWSCredential(Subject subject, String securityName, String accessId, String realm, String uniqueName, String unauthenticatedUserid) throws CredentialException {
        UserRegistryService userRegistryService = (UserRegistryService)this.userRegistryServiceRef.getService();
        try {
            Hashtable<String, ?> customProperties = this.getUniqueIdAndSecurityNameHashtableFromSubject(subject);
            if (customProperties != null && !customProperties.isEmpty()) {
                List<String> uniqueGroupAccessIds = this.getUniqueGroupAccessIds(customProperties, realm);
                this.setCredential(unauthenticatedUserid, subject, realm, securityName, uniqueName, null, accessId, null, uniqueGroupAccessIds);
                return;
            }
            if (!userRegistryService.isUserRegistryConfigured()) {
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (!tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"Unexpected state in WSCredentialProvider, no UserRegistry", (Object[])new Object[0]);
                return;
            }
            UserRegistry userRegistry = userRegistryService.getUserRegistry();
            if (userRegistry.getRealm().equals(realm)) {
                List<String> uniqueGroupAccessIds = this.getUniqueGroupAccessIds(userRegistry, realm, uniqueName);
                String primaryUniqueGroupAccessId = this.getPrimaryGroupId(uniqueGroupAccessIds);
                this.setCredential(unauthenticatedUserid, subject, realm, securityName, uniqueName, primaryUniqueGroupAccessId, accessId, null, uniqueGroupAccessIds);
                return;
            }
            if (!TraceComponent.isAnyTracingEnabled()) throw new CredentialException("Foreign realms are unsupported. The accessId's realm, " + accessId + ", doesn't match the current realm, " + userRegistry.getRealm() + ".");
            if (!tc.isDebugEnabled()) throw new CredentialException("Foreign realms are unsupported. The accessId's realm, " + accessId + ", doesn't match the current realm, " + userRegistry.getRealm() + ".");
            Tr.debug((TraceComponent)tc, (String)"Requested creation of a WSCredential for an unknown realm", (Object[])new Object[]{userRegistry.getRealm(), realm});
            throw new CredentialException("Foreign realms are unsupported. The accessId's realm, " + accessId + ", doesn't match the current realm, " + userRegistry.getRealm() + ".");
        }
        catch (EntryNotFoundException customProperties) {
            void e;
            FFDCFilter.processException((Throwable)customProperties, (String)"com.ibm.ws.security.credentials.wscred.internal.WSCredentialProvider", (String)"221", (Object)this, (Object[])new Object[]{subject, securityName, accessId, realm, uniqueName, unauthenticatedUserid});
            throw new CredentialException("Unable to find the user for this accessId: " + accessId + ". " + e.getMessage());
        }
        catch (RegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.credentials.wscred.internal.WSCredentialProvider", (String)"223", (Object)this, (Object[])new Object[]{subject, securityName, accessId, realm, uniqueName, unauthenticatedUserid});
            throw new CredentialException("Unable to access the UserRegistry: " + e.getMessage());
        }
    }

    private void setCredential(String unauthenticatedId, Subject subject, String realm, String securityName, String uniqueName, String primaryUniqueGroupAccessId, String accessId, List<String> roles, List<String> uniqueGroupAccessIds) throws CredentialException {
        WSCredentialImpl cred = new WSCredentialImpl(realm, securityName, uniqueName, unauthenticatedId, primaryUniqueGroupAccessId, accessId, null, uniqueGroupAccessIds);
        subject.getPublicCredentials().add(cred);
    }

    private List<String> getUniqueGroupAccessIds(UserRegistry userRegistry, String realm, String uniqueName) throws EntryNotFoundException, RegistryException {
        ArrayList<String> uniqueGroupAccessIds = new ArrayList<String>();
        List uniqueGroupIds = userRegistry.getUniqueGroupIdsForUser(uniqueName);
        Iterator groupIter = uniqueGroupIds.iterator();
        while (groupIter.hasNext()) {
            String groupAccessId = AccessIdUtil.createAccessId((String)"group", (String)realm, (String)((String)groupIter.next()));
            uniqueGroupAccessIds.add(groupAccessId);
        }
        return uniqueGroupAccessIds;
    }

    private String getPrimaryGroupId(List<String> uniqueGroupIds) {
        return uniqueGroupIds.isEmpty() ? null : uniqueGroupIds.get(0);
    }

    private List<String> getUniqueGroupAccessIds(Hashtable<String, ?> customProperties, String realm) {
        ArrayList oldGroupList = (ArrayList)customProperties.get("com.ibm.wsspi.security.cred.groups");
        ArrayList<String> uniqueGroupAccessIds = new ArrayList<String>();
        if (oldGroupList != null) {
            uniqueGroupAccessIds.addAll(oldGroupList);
            for (int j = 0; j < uniqueGroupAccessIds.size(); ++j) {
                String old_group = uniqueGroupAccessIds.get(j);
                String new_group = null;
                if (AccessIdUtil.isGroupAccessId((String)old_group)) continue;
                new_group = "group:" + realm + "/" + old_group;
                uniqueGroupAccessIds.set(j, new_group);
            }
        }
        return uniqueGroupAccessIds;
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    @FFDCIgnore(value={CredentialDestroyedException.class, CredentialExpiredException.class})
    public boolean isSubjectValid(Subject subject) {
        boolean valid;
        block7: {
            valid = false;
            try {
                WSCredential wsCredential = this.getWSCredential(subject);
                if (wsCredential != null) {
                    long credentialExpirationInMillis = wsCredential.getExpiration();
                    Date currentTime = new Date();
                    Date expirationTime = new Date(credentialExpirationInMillis);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Current time = " + currentTime + ", expiration time = " + expirationTime), (Object[])new Object[0]);
                    }
                    if (credentialExpirationInMillis == 0L || credentialExpirationInMillis == -1L || currentTime.before(expirationTime)) {
                        valid = true;
                    }
                }
            }
            catch (CredentialDestroyedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CredentialDestroyedException while determining the validity of the subject.", (Object[])new Object[]{e});
                }
            }
            catch (CredentialExpiredException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"CredentialExpiredException while determining the validity of the subject.", (Object[])new Object[]{e});
            }
        }
        return valid;
    }
}

