/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class TimeStatisticImpl
extends AverageStatisticImpl
implements SPITimeStatistic,
WSTimeStatistic {
    private static final long serialVersionUID = 3480487189513289050L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TimeStatisticImpl(int dataId) {
        super(dataId);
    }

    public TimeStatisticImpl(int count, int min, int max, int total, int sumOfSquares, int startTime, int lastSampleTime) {
        super(0);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public TimeStatisticImpl(int dataId, long count, long min, long max, long total, double sumOfSquares, long startTime, long lastSampleTime) {
        super(dataId);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public TimeStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    @Override
    public int getStatisticType() {
        return 4;
    }

    @Override
    public WSStatistic copy() {
        TimeStatisticImpl copy = new TimeStatisticImpl(this.id, this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
        copy.baseValue = this.baseValue;
        return copy;
    }

    @Override
    public long getTotalTime() {
        return this.total;
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("TimeStatistic");
        str.append(", avg=").append(this.getMean());
        str.append(", min=").append(this.min);
        str.append(", max=").append(this.max);
        str.append(", total=").append(this.total);
        str.append(", count=").append(this.count);
        str.append(", sumSq=").append(this.sumOfSquares);
        return str.toString();
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<TS");
        res.append(" id=\"");
        res.append(this.id);
        res.append("\" sT=\"");
        res.append(this.startTime);
        res.append("\" lST=\"");
        res.append(this.lastSampleTime);
        res.append("\" ct=\"");
        res.append(this.count);
        res.append("\" max=\"");
        res.append(this.max);
        res.append("\" min=\"");
        res.append(this.min);
        res.append("\" sOS=\"");
        res.append(this.sumOfSquares);
        res.append("\" tot=\"");
        res.append(this.total);
        res.append("\">\n");
        res.append("</TS>");
        return res.toString();
    }

    private boolean validate(WSStatistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof TimeStatisticImpl)) {
            return false;
        }
        return other.getId() == this.id;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        TimeStatisticImpl other = (TimeStatisticImpl)otherStat;
        TimeStatisticImpl newData = new TimeStatisticImpl(this.id);
        long timeDiff = this.lastSampleTime - other.lastSampleTime;
        if (timeDiff == 0L) {
            return null;
        }
        newData.count = (this.count - other.getCount()) / timeDiff;
        newData.sumOfSquares = (this.sumOfSquares - other.sumOfSquares) / (double)timeDiff;
        newData.total = (this.total - other.getTotal()) / timeDiff;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        newData.max = this.max;
        newData.min = this.min;
        return newData;
    }

    @Override
    public WSStatistic delta(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        TimeStatisticImpl other = (TimeStatisticImpl)otherStat;
        TimeStatisticImpl newData = new TimeStatisticImpl(this.id);
        newData.min = this.min;
        newData.max = this.max;
        newData.count = this.count - other.getCount();
        newData.total = this.total - other.getTotal();
        newData.sumOfSquares = this.sumOfSquares - other.sumOfSquares;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TimeStatisticImpl.class);
    }
}

