/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javamail.internal.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.common.MailSession;
import com.ibm.ws.javamail.internal.injection.MailSessionDefinitionInjectionBinding;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import javax.mail.MailSessionDefinition;
import javax.mail.MailSessionDefinitions;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MailSessionDefinitionInjectionProcessor
extends InjectionProcessor<MailSessionDefinition, MailSessionDefinitions> {
    static final TraceComponent tc = Tr.register(MailSessionDefinitionInjectionProcessor.class, (String)"Mail", (String)"com.ibm.ws.javamail.resources.MailMessages");
    static final long serialVersionUID = -2055573073989215263L;

    public MailSessionDefinitionInjectionProcessor() {
        super(MailSessionDefinition.class, MailSessionDefinitions.class);
    }

    public MailSessionDefinitionInjectionProcessor(Class<MailSessionDefinition> annotationClass, Class<MailSessionDefinitions> annotationsClass) {
        super(MailSessionDefinition.class, MailSessionDefinitions.class);
    }

    @ManualTrace
    public void processXML() throws InjectionException {
        List mailSessionDefinitions;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processXML : " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if ((mailSessionDefinitions = this.ivNameSpaceConfig.getJNDIEnvironmentRefs(MailSession.class)) != null) {
            for (MailSession mailSession : mailSessionDefinitions) {
                MailSessionDefinitionInjectionBinding binding;
                String jndiName = mailSession.getName();
                InjectionBinding injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName);
                if (injectionBinding != null) {
                    binding = (MailSessionDefinitionInjectionBinding)injectionBinding;
                } else {
                    binding = new MailSessionDefinitionInjectionBinding(jndiName, this.ivNameSpaceConfig);
                    this.addInjectionBinding(binding);
                }
                binding.mergeXML(mailSession);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processXML : " + (Object)((Object)this)));
        }
    }

    @Sensitive
    public InjectionBinding<MailSessionDefinition> createInjectionBinding(@Sensitive MailSessionDefinition annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        MailSessionDefinitionInjectionBinding injectionBinding = new MailSessionDefinitionInjectionBinding(jndiName, this.ivNameSpaceConfig);
        injectionBinding.merge((Annotation)annotation, instanceClass, null);
        return injectionBinding;
    }

    public void resolve(InjectionBinding<MailSessionDefinition> injectionBinding) throws InjectionException {
        ((MailSessionDefinitionInjectionBinding)injectionBinding).resolve();
    }

    public String getJndiName(@Sensitive MailSessionDefinition annotation) {
        return annotation.name();
    }

    @Sensitive
    public MailSessionDefinition[] getAnnotations(@Sensitive MailSessionDefinitions pluralAnnotation) {
        return pluralAnnotation.value();
    }
}

