/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.inject;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.inject.InjectInjectionBinding;
import com.ibm.ws.cdi.impl.inject.InjectableNull;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resolution.ResolvableBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InjectInjectionObjectFactory {
    private static final TraceComponent tc = Tr.register(InjectInjectionObjectFactory.class);
    private static final Comparator<InjectionPoint> PARAMETER_INJECTION_POINT_COMPARATOR = new Comparator<InjectionPoint>(){
        static final long serialVersionUID = -1104671589949332188L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public int compare(InjectionPoint o1, InjectionPoint o2) {
            AnnotatedParameter p1 = (AnnotatedParameter)o1.getAnnotated();
            AnnotatedParameter p2 = (AnnotatedParameter)o2.getAnnotated();
            return p1.getPosition() < p2.getPosition() ? -1 : (p1.getPosition() == p2.getPosition() ? 0 : 1);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 2150721428853420169L;

    @ManualTrace
    public static Object getObjectInstance(InjectInjectionBinding iBinding, Object targetObject, final CreationalContext<Object> cc, final CreationalContext<Object> methodInvocactionContext, CDIRuntime cdiRuntime) throws Exception {
        List<InjectionPoint> injectionPoints;
        Set ejbDescriptors;
        WebSphereBeanDeploymentArchive bda;
        BeanManager beanManager;
        Member targetMember;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectInstance", (Object[])new Object[]{iBinding, Util.identity((Object)targetObject), Util.identity(cc), Util.identity(methodInvocactionContext)});
        }
        Class<?> targetClass = Modifier.isStatic((targetMember = iBinding.getInjectionTarget().getMember()).getModifiers()) ? targetMember.getDeclaringClass() : (CDIUtils.isWeldProxy((Object)targetObject) ? targetObject.getClass().getSuperclass() : targetObject.getClass());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target class: " + targetClass.getName()), (Object[])new Object[0]);
        }
        if ((beanManager = cdiRuntime.getClassBeanManager(targetClass)) == null) {
            beanManager = cdiRuntime.getCurrentModuleBeanManager();
        }
        InjectInjectionObjectFactory.allBeanDebug(beanManager, iBinding);
        if (null == beanManager) {
            if (!CDIUtils.isInjectionFailureIgnored()) {
                Tr.error((TraceComponent)tc, (String)"no.injection.target.CWOWB1008E", (Object[])new Object[]{targetMember, targetClass.getName()});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", null);
            }
            return null;
        }
        Set beans = beanManager.getBeans(targetClass, new Annotation[0]);
        Bean bean = beanManager.resolve(beans);
        if (bean == null && (bda = cdiRuntime.getClassBeanDeploymentArchive(targetClass)) != null && (ejbDescriptors = bda.getEjbDescriptor(targetClass)) != null && !ejbDescriptors.isEmpty()) {
            WeldManager weldManager = (WeldManager)beanManager;
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbDescriptors.iterator().next();
            String ejb_name = ejbDescriptor.getEjbName();
            EjbDescriptor realEjbDescriptor = weldManager.getEjbDescriptor(ejb_name);
            bean = weldManager.getBean(realEjbDescriptor);
        }
        if (bean != null && !Modifier.isStatic(targetMember.getModifiers())) {
            injectionPoints = InjectInjectionObjectFactory.findManagedInjectionPoints(bean, targetMember);
        } else {
            bda = cdiRuntime.getClassBeanDeploymentArchive(targetClass);
            injectionPoints = InjectInjectionObjectFactory.findUnmanagedInjectionPoints(beanManager, bda, targetClass, targetMember);
        }
        InjectInjectionObjectFactory.debugInjectionPoints(injectionPoints);
        ArrayList<Object> references = new ArrayList<Object>();
        final BeanManager localBeanManager = beanManager;
        for (final InjectionPoint injectionPoint : injectionPoints) {
            Object injectionObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -873276725900584433L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @ManualTrace
                public Object run() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[0]);
                    }
                    Object ref = null;
                    if (injectionPoint.getAnnotated() instanceof AnnotatedParameter && ((AnnotatedParameter)injectionPoint.getAnnotated()).isAnnotationPresent(TransientReference.class)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting an injectable ref from the bean manager with {0}, {1}", (Object[])new Object[]{injectionPoint, Util.identity((Object)methodInvocactionContext)});
                        }
                        ref = localBeanManager.getInjectableReference(injectionPoint, methodInvocactionContext);
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting an injectable ref from the bean manager with {0}, {1}", (Object[])new Object[]{injectionPoint, Util.identity((Object)cc)});
                        }
                        ref = localBeanManager.getInjectableReference(injectionPoint, cc);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"run", (Object)Util.identity((Object)ref));
                    }
                    return ref;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            if (injectionObject != null) {
                references.add(injectionObject);
                continue;
            }
            BeanManagerImpl beanManagerImpl = (BeanManagerImpl)localBeanManager;
            ResolvableBuilder resolvableBuilder = new ResolvableBuilder(injectionPoint, beanManagerImpl);
            Bean maybeProducerBean = beanManagerImpl.getBean(resolvableBuilder.create());
            if (!(maybeProducerBean instanceof ProducerMethod) || !Dependent.class.isAssignableFrom(maybeProducerBean.getScope())) continue;
            references.add(new InjectableNull());
        }
        InjectInjectionObjectFactory.debugInjectionObjects(references.toArray());
        if (references.size() == 1) {
            Object reference = references.get(0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)Util.identity(reference));
            }
            return reference;
        }
        Object[] referencesArray = references.toArray(new Object[references.size()]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            StringBuilder exitStringBuilder = new StringBuilder("[");
            boolean first = true;
            for (Object object : referencesArray) {
                if (!first) {
                    exitStringBuilder.append(", ");
                } else {
                    first = false;
                }
                exitStringBuilder.append(Util.identity((Object)object));
            }
            exitStringBuilder.append("]");
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)exitStringBuilder.toString());
        }
        return referencesArray;
    }

    private static List<InjectionPoint> findUnmanagedInjectionPoints(BeanManager beanManager, WebSphereBeanDeploymentArchive bda, Class<?> targetClass, Member targetMember) throws CDIException {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList();
        List allInjectionPoints = null;
        if (bda != null) {
            allInjectionPoints = bda.getJEEComponentInjectionPoints(targetClass);
        }
        if (allInjectionPoints == null) {
            injectionPoints = InjectInjectionObjectFactory.createUnmanagedInjectionPoints(beanManager, targetClass, targetMember);
        } else {
            for (InjectionPoint injectionPoint : allInjectionPoints) {
                Member injectionPointMember = injectionPoint.getMember();
                if (!targetMember.equals(injectionPointMember)) continue;
                injectionPoints.add(injectionPoint);
                if (!(targetMember instanceof Field)) continue;
                break;
            }
            if (targetMember instanceof Method) {
                Collections.sort(injectionPoints, PARAMETER_INJECTION_POINT_COMPARATOR);
            }
        }
        return injectionPoints;
    }

    private static List<InjectionPoint> createUnmanagedInjectionPoints(BeanManager beanManager, Class<?> targetClass, Member targetMember) {
        ArrayList<InjectionPoint> injectionPoints;
        block3: {
            AnnotatedType annotatedType;
            block4: {
                injectionPoints = new ArrayList<InjectionPoint>();
                annotatedType = beanManager.createAnnotatedType(targetClass);
                if (!(targetMember instanceof Field)) break block4;
                for (AnnotatedField field : annotatedType.getFields()) {
                    if (!field.getJavaMember().equals(targetMember)) continue;
                    injectionPoints.add(beanManager.createInjectionPoint(field));
                    break block3;
                }
                break block3;
            }
            if (!(targetMember instanceof Method)) break block3;
            for (AnnotatedMethod method : annotatedType.getMethods()) {
                if (!method.getJavaMember().equals(targetMember)) continue;
                for (AnnotatedParameter parameter : method.getParameters()) {
                    injectionPoints.add(beanManager.createInjectionPoint(parameter));
                }
                break;
            }
        }
        return injectionPoints;
    }

    private static List<InjectionPoint> findManagedInjectionPoints(Bean<?> bean, Member member) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            if (!member.equals(injectionPoint.getMember())) continue;
            injectionPoints.add(injectionPoint);
        }
        if (member instanceof Method) {
            Collections.sort(injectionPoints, PARAMETER_INJECTION_POINT_COMPARATOR);
        }
        return injectionPoints;
    }

    @Trivial
    private static final void debugInjectionPoints(List<InjectionPoint> injectionPoints) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("InjectionPoints: SIZE: " + injectionPoints.size()), (Object[])new Object[0]);
            for (InjectionPoint injectionPoint : injectionPoints) {
                Tr.debug((TraceComponent)tc, (String)("\t InjectionPoint: " + injectionPoint), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private static final void allBeanDebug(BeanManager beanManager, InjectInjectionBinding iBinding) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (beanManager == null) {
                Tr.debug((TraceComponent)tc, (String)("CDI runtime cannot resolve " + iBinding.getDisplayName() + " because of a null BeanManager"), (Object[])new Object[0]);
            } else {
                Set allBeans = beanManager.getBeans(Object.class, new Annotation[0]);
                Tr.debug((TraceComponent)tc, (String)"\t \t ***** ALL Beans: ***** ", (Object[])new Object[0]);
                for (Bean bean : allBeans) {
                    Tr.debug((TraceComponent)tc, (String)("Bean: " + bean), (Object[])new Object[0]);
                }
                Tr.debug((TraceComponent)tc, (String)"\t \t ***** ALL Beans: ***** ", (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private static final void debugInjectionObjects(Object[] injectionObjects) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (injectionObjects.length == 0) {
                Tr.debug((TraceComponent)tc, (String)" []", (Object[])new Object[0]);
                return;
            }
            StringBuilder buffer = new StringBuilder(injectionObjects.length * 16);
            buffer.append('[');
            for (int i = 0; i < injectionObjects.length; ++i) {
                if (injectionObjects[i] != injectionObjects) {
                    buffer.append(Util.identity((Object)injectionObjects[i]));
                } else {
                    buffer.append("(this Collection)");
                }
                if (i >= injectionObjects.length - 1) continue;
                buffer.append(',');
            }
            buffer.append(']');
            Tr.debug((TraceComponent)tc, (String)("SUCCESS " + buffer.toString()), (Object[])new Object[0]);
        }
    }
}

