/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PerRequestResourceProvider
implements ResourceProvider {
    private final Constructor<?> c;
    private final Method postConstructMethod;
    private final Method preDestroyMethod;
    private final Class<?>[] params;
    private final Annotation[][] anns;
    private final Type[] genericTypes;
    static final long serialVersionUID = 4330447189587368180L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PerRequestResourceProvider(Class<?> clazz) {
        this.c = ResourceUtils.findResourceConstructor(clazz, true);
        if (this.c == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
        this.params = this.c.getParameterTypes();
        this.anns = this.c.getParameterAnnotations();
        this.genericTypes = this.c.getGenericParameterTypes();
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object getInstance(Message m) {
        return this.createInstance(m);
    }

    protected Object createInstance(Message m) {
        ProviderInfo application = (ProviderInfo)m.getExchange().getEndpoint().get(Application.class.getName());
        Map<Class<?>, Object> mapValues = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m, true, mapValues, this.params, this.anns, this.genericTypes);
        try {
            Object instance = values.length > 0 ? this.c.newInstance(values) : this.c.newInstance(new Object[0]);
            return instance;
        }
        catch (InstantiationException instance) {
            FFDCFilter.processException((Throwable)instance, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"105", (Object)this, (Object[])new Object[]{m});
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
        catch (IllegalAccessException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"108", (Object)this, (Object[])new Object[]{m});
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated due to IllegalAccessException";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
        catch (InvocationTargetException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"112", (Object)this, (Object[])new Object[]{m});
            Response r = JAXRSUtils.convertFaultToResponse(ex.getCause(), m);
            if (r != null) {
                m.getExchange().put(Response.class, r);
                throw new WebApplicationException();
            }
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated due to InvocationTargetException";
            throw ExceptionUtils.toInternalServerErrorException(null, this.serverError(msg));
        }
    }

    private Response serverError(String msg) {
        return JAXRSUtils.toResponseBuilder(500).entity((Object)msg).build();
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        JaxRsFactoryBeanCustomizer beanCustomizer = null;
        if (o != null) {
            Bus bus = m.getExchange().getBus();
            beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(o.getClass(), bus);
        }
        if (beanCustomizer == null) {
            InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
        }
    }

    @Override
    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PerRequestResourceProvider.class);
    }
}

