/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.FilterVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class AppliesToProcessor {
    private static final String BASE = "Base";
    private static final String EXPRESS = "Express";
    private static final String DEVELOPERS = "Developers";
    private static final String ND = "ND";
    private static final String ZOS = "z/OS";
    private static final String CORE = "Liberty Core";
    private static final String BETA = "Beta";
    private static final List<String> nonCoreEditions = Arrays.asList("Base", "Express", "Developers", "ND", "z/OS");
    private static final List<String> allEditions;
    private static final Map<String, List<String>> editionsMap;
    public static final String VERSION_ATTRIB_NAME = "productVersion";
    public static final String EDITION_ATTRIB_NAME = "productEdition";
    public static final String INSTALL_TYPE_ATTRIB_NAME = "productInstallType";
    private static final String EARLY_ACCESS_LABEL = "Beta";
    private static final String EDITION_UNMAPPED = "EDITION_UNMAPPED";
    private static final String EDITION_UNKNOWN = "EDITION_UNKNOWN";
    public static final String BETA_REGEX = "[2-9][0-9][0-9][0-9][.].*";

    private static String getValue(String substring) {
        int index = substring.indexOf(61);
        if ((substring = substring.substring(index + 1).trim()).charAt(0) == '\"') {
            return substring.substring(1, substring.length() - 1);
        }
        return substring;
    }

    private static void add(AppliesToFilterInfo atfi, String substring) {
        substring = substring.trim();
        if (atfi.getProductId() == null) {
            atfi.setProductId(substring);
        } else if (substring.startsWith(VERSION_ATTRIB_NAME)) {
            String version = AppliesToProcessor.getValue(substring);
            boolean unbounded = version.endsWith("+");
            if (unbounded) {
                version = version.substring(0, version.length() - 1);
            }
            String label = null;
            String compatibilityLabel = null;
            if (version.matches("^[2-9][0-9][0-9][0-9][.].*")) {
                label = "Beta";
                compatibilityLabel = "Beta";
            } else {
                compatibilityLabel = version;
                int cutpoint = 0;
                int count = 0;
                while (cutpoint < version.length() && count < 3) {
                    if (version.charAt(cutpoint++) != '.') continue;
                    ++count;
                }
                label = cutpoint == version.length() && count != 3 ? version : version.substring(0, cutpoint - 1);
            }
            FilterVersion minVersion = new FilterVersion();
            minVersion.setLabel(label);
            minVersion.setInclusive(true);
            minVersion.setValue(version);
            minVersion.setCompatibilityLabel(compatibilityLabel);
            atfi.setMinVersion(minVersion);
            if (!unbounded) {
                FilterVersion maxVersion = new FilterVersion();
                maxVersion.setLabel(label);
                maxVersion.setInclusive(true);
                maxVersion.setValue(version);
                maxVersion.setCompatibilityLabel(compatibilityLabel);
                atfi.setMaxVersion(maxVersion);
                atfi.setHasMaxVersion(Boolean.toString(true));
            }
        } else if (substring.startsWith(EDITION_ATTRIB_NAME)) {
            String editionStr = AppliesToProcessor.getValue(substring);
            LinkedHashSet<String> editions = new LinkedHashSet<String>();
            ArrayList<String> rawEditions = new ArrayList<String>();
            atfi.setRawEditions(rawEditions);
            int startIndex = 0;
            int endIndex = editionStr.indexOf(44);
            while (true) {
                String edition = editionStr.substring(startIndex, endIndex == -1 ? editionStr.length() : endIndex);
                rawEditions.add(edition);
                List<String> mappedEdition = AppliesToProcessor.mapRawEditionToHumanReadable(edition);
                if (mappedEdition.size() != 1 || !mappedEdition.get(0).equals(EDITION_UNMAPPED)) {
                    if (mappedEdition.size() == 1 && mappedEdition.get(0).equals(EDITION_UNKNOWN)) {
                        editions.add(edition);
                    } else {
                        editions.addAll(mappedEdition);
                    }
                }
                if (endIndex == -1) break;
                startIndex = endIndex;
                endIndex = editionStr.indexOf(44, ++startIndex);
            }
            atfi.setEditions(new ArrayList<String>(editions));
        } else if (substring.startsWith(INSTALL_TYPE_ATTRIB_NAME)) {
            String installTypeString = AppliesToProcessor.getValue(substring);
            atfi.setInstallType(installTypeString);
        }
    }

    public static List<AppliesToFilterInfo> parseAppliesToHeader(String appliesTo) {
        ArrayList<AppliesToFilterInfo> result = new ArrayList<AppliesToFilterInfo>();
        List<List<String>> parsedProducts = AppliesToProcessor.doParse(appliesTo);
        for (List<String> parsedProduct : parsedProducts) {
            AppliesToFilterInfo atfi = new AppliesToFilterInfo();
            for (String productChunk : parsedProduct) {
                AppliesToProcessor.add(atfi, productChunk);
            }
            AppliesToProcessor.addEditions(atfi);
            result.add(atfi);
        }
        return result;
    }

    private static void addEditions(AppliesToFilterInfo match) {
        List<String> editionsList = allEditions;
        List<String> rawEditions = match.getRawEditions();
        if (rawEditions == null || rawEditions.isEmpty()) {
            ArrayList<String> editions = new ArrayList<String>();
            if (match.getMinVersion() != null && match.getMinVersion().getCompatibilityLabel() != null && match.getMinVersion().getCompatibilityLabel().equals("Beta")) {
                editions.add("Beta");
            } else {
                editions.addAll(editionsList);
            }
            match.setEditions(editions);
        }
    }

    private static List<String> mapRawEditionToHumanReadable(String rawEdition) {
        List<String> result = editionsMap.get(rawEdition);
        return result != null ? result : Arrays.asList(EDITION_UNKNOWN);
    }

    public static void validateEditions(AppliesToFilterInfo info, String appliesToHeader) throws RepositoryResourceCreationException {
        if (info.getRawEditions() != null) {
            for (String rawEdition : info.getRawEditions()) {
                List<String> mappedEditions = AppliesToProcessor.mapRawEditionToHumanReadable(rawEdition);
                if (mappedEditions.size() != 1 || !mappedEditions.get(0).equals(EDITION_UNKNOWN)) continue;
                throw new RepositoryResourceCreationException("Resource applies to at least one unknown edition: " + rawEdition + "; appliesTo= " + appliesToHeader, null);
            }
        }
    }

    public static List<AppliesToEntry> parseAppliesToEntries(String appliesTo) {
        ArrayList<AppliesToEntry> result = new ArrayList<AppliesToEntry>();
        List<List<String>> parsedProducts = AppliesToProcessor.doParse(appliesTo);
        for (List<String> parsedProduct : parsedProducts) {
            AppliesToEntry entry = new AppliesToEntry();
            for (String productChunk : parsedProduct) {
                entry.add(productChunk);
            }
            result.add(entry);
        }
        return result;
    }

    private static List<List<String>> doParse(String appliesTo) {
        boolean quoted = false;
        int index = 0;
        ArrayList<String> entry = new ArrayList<String>();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (int i = 0; i < appliesTo.length(); ++i) {
            char c = appliesTo.charAt(i);
            if (c == '\"') {
                boolean bl = quoted = !quoted;
            }
            if (quoted) continue;
            if (c == ',') {
                entry.add(appliesTo.substring(index, i));
                index = i + 1;
                result.add(entry);
                entry = new ArrayList();
                continue;
            }
            if (c != ';') continue;
            entry.add(appliesTo.substring(index, i));
            index = i + 1;
        }
        entry.add(appliesTo.substring(index));
        result.add(entry);
        return result;
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(CORE);
        temp.addAll(nonCoreEditions);
        allEditions = Collections.unmodifiableList(temp);
        editionsMap = new HashMap<String, List<String>>();
        editionsMap.put("Core", Arrays.asList(CORE));
        editionsMap.put("CORE", Arrays.asList(CORE));
        editionsMap.put("LIBERTY_CORE", Arrays.asList(CORE));
        editionsMap.put("BASE", Arrays.asList(BASE));
        editionsMap.put("DEVELOPERS", Arrays.asList(DEVELOPERS));
        editionsMap.put("EXPRESS", Arrays.asList(EXPRESS));
        editionsMap.put("EARLY_ACCESS", Arrays.asList("Beta"));
        editionsMap.put("zOS", Arrays.asList(ZOS));
        editionsMap.put(ND, Arrays.asList(ND));
        editionsMap.put("BASE_ILAN", Arrays.asList(EDITION_UNMAPPED));
        editionsMap.put("Open", nonCoreEditions);
    }

    public static class AppliesToEntry {
        private String _productId;
        private String _editions;
        private String _version;
        private String _installType;

        private void add(String substring) {
            substring = substring.trim();
            if (this._productId == null) {
                this._productId = substring;
            } else if (substring.startsWith(AppliesToProcessor.VERSION_ATTRIB_NAME)) {
                this._version = AppliesToProcessor.getValue(substring);
            } else if (substring.startsWith(AppliesToProcessor.EDITION_ATTRIB_NAME)) {
                this._editions = AppliesToProcessor.getValue(substring);
            } else if (substring.startsWith(AppliesToProcessor.INSTALL_TYPE_ATTRIB_NAME)) {
                this._installType = AppliesToProcessor.getValue(substring);
            }
        }

        public String getProductId() {
            return this._productId;
        }

        public String getEditions() {
            return this._editions;
        }

        public String getVersion() {
            return this._version;
        }

        public String getInstallType() {
            return this._installType;
        }

        public String toString() {
            return "[AppliesToEntry <productId=" + this._productId + "> <editions=" + this._editions + "> <version=" + this._version + "> <installType=" + this._installType + ">";
        }
    }
}

