/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dynamic.bundle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ManifestFactory {
    private static final String MANIFEST_ATTRIBUTE_SEPARATOR = ",";
    private String manifestVersion = "1.0";
    private String bundleName = null;
    private String bundleVersion = Version.emptyVersion.toString();
    private String bundleVendor = "IBM";
    private String bundleDescription = "A dynamic bundle";
    private String bundleManifestVersion = "2";
    private String bundleSymbolicName = null;
    private Iterable<String> importPackageList = null;
    private Iterable<String> requireBundleList = null;
    private Iterable<String> dynamicImportPackageList = null;
    private Iterable<String> serviceComponentList = null;
    private boolean lazyActivation;
    private final Map<String, Iterable<? extends Object>> otherAttributes = new HashMap<String, Iterable<? extends Object>>();
    static final long serialVersionUID = -8635814953760313658L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ManifestFactory setManifestVersion(String manifestVersion) {
        this.manifestVersion = manifestVersion;
        return this;
    }

    public ManifestFactory setBundleName(String bundleName) {
        this.bundleName = bundleName;
        return this;
    }

    public ManifestFactory setBundleVersion(Version bundleVersion) {
        this.bundleVersion = bundleVersion.toString();
        return this;
    }

    public ManifestFactory setBundleVendor(String vendor) {
        this.bundleVendor = vendor;
        return this;
    }

    public ManifestFactory setBundleDescription(String desc) {
        this.bundleDescription = desc;
        return this;
    }

    public ManifestFactory setBundleManifestVersion(String bundleManifestVersion) {
        this.bundleManifestVersion = bundleManifestVersion;
        return this;
    }

    public ManifestFactory setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
        return this;
    }

    public ManifestFactory importPackages(String ... packages) {
        return this.importPackages(Arrays.asList(packages));
    }

    public ManifestFactory requireBundles(String ... bundles) {
        return this.requireBundles(Arrays.asList(bundles));
    }

    public ManifestFactory dynamicallyImportPackages(String ... packages) {
        return this.dynamicallyImportPackages(Arrays.asList(packages));
    }

    public ManifestFactory declareServiceComponents(String ... components) {
        return this.declareServiceComponents(Arrays.asList(components));
    }

    public ManifestFactory addAttributeValues(String name, Object ... values) {
        return this.addManifestAttribute(name, Arrays.asList(values));
    }

    public ManifestFactory importPackages(Iterable<String> packages) {
        this.importPackageList = packages;
        return this;
    }

    public ManifestFactory requireBundles(Iterable<String> bundles) {
        this.requireBundleList = bundles;
        return this;
    }

    public ManifestFactory dynamicallyImportPackages(Iterable<String> packages) {
        this.dynamicImportPackageList = packages;
        return this;
    }

    public ManifestFactory declareServiceComponents(Iterable<String> components) {
        this.serviceComponentList = components;
        return this;
    }

    public ManifestFactory addManifestAttribute(String name, Iterable<? extends Object> values) {
        this.otherAttributes.put(name, values);
        return this;
    }

    public ManifestFactory setLazyActivation(boolean lazy) {
        this.lazyActivation = lazy;
        return this;
    }

    public final Manifest createManifest() {
        if (this.bundleName == null) {
            throw new IllegalStateException("bundleName = null");
        }
        if (this.bundleSymbolicName == null) {
            throw new IllegalStateException("bundleSymbolicName = null");
        }
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, this.manifestVersion);
        attrs.putValue("Bundle-Name", this.bundleName);
        attrs.putValue("Bundle-Version", this.bundleVersion);
        attrs.putValue("Bundle-Vendor", this.bundleVendor);
        attrs.putValue("Bundle-Description", this.bundleDescription);
        attrs.putValue("Bundle-ManifestVersion", this.bundleManifestVersion);
        attrs.putValue("Bundle-SymbolicName", this.bundleSymbolicName);
        ManifestFactory.putValueList(attrs, "Import-Package", this.importPackageList);
        ManifestFactory.putValueList(attrs, "Require-Bundle", this.requireBundleList);
        ManifestFactory.putValueList(attrs, "DynamicImport-Package", this.dynamicImportPackageList);
        ManifestFactory.putValueList(attrs, "Service-Component", this.serviceComponentList);
        if (this.lazyActivation) {
            attrs.putValue("Bundle-ActivationPolicy", "lazy");
        }
        for (Map.Entry<String, Iterable<? extends Object>> entry : this.otherAttributes.entrySet()) {
            ManifestFactory.putValueList(attrs, entry.getKey(), entry.getValue());
        }
        return manifest;
    }

    private static <T> void putValueList(Attributes attrs, String name, Iterable<T> list) {
        if (list == null) {
            return;
        }
        attrs.putValue(name, ManifestFactory.join(list, MANIFEST_ATTRIBUTE_SEPARATOR));
    }

    static <T> String join(Iterable<T> elems, String delim) {
        if (elems == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (T elem : elems) {
            result.append(elem).append(delim);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - delim.length());
        }
        return result.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ManifestFactory.class);
    }
}

