/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.config.ssl.SSLConfig;
import com.ibm.ws.security.csiv2.config.tss.ServerTransportAddress;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSNULLASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CSSCompoundSecMechConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(CSSCompoundSecMechConfig.class);
    private short supports;
    private short requires;
    private CSSTransportMechConfig transport_mech;
    private CSSASMechConfig as_mech;
    private CSSSASMechConfig sas_mech;
    private String cantHandleMsg;
    private final Map<ServerTransportAddress, CSSTransportMechConfig> addressTransportMechMap = new HashMap<ServerTransportAddress, CSSTransportMechConfig>();

    public CSSTransportMechConfig getTransport_mech() {
        return this.transport_mech;
    }

    public void setTransport_mech(CSSTransportMechConfig transport_mech) {
        this.transport_mech = transport_mech;
        this.supports = (short)(this.supports | transport_mech.getSupports());
        this.requires = (short)(this.requires | transport_mech.getRequires());
    }

    public CSSASMechConfig getAs_mech() {
        return this.as_mech;
    }

    public void setAs_mech(CSSASMechConfig as_mech) {
        this.as_mech = as_mech;
        this.supports = (short)(this.supports | as_mech.getSupports());
        this.requires = (short)(this.requires | as_mech.getRequires());
    }

    public CSSSASMechConfig getSas_mech() {
        return this.sas_mech;
    }

    public void setSas_mech(CSSSASMechConfig sas_mech) {
        this.sas_mech = sas_mech;
        this.supports = (short)(this.supports | sas_mech.getSupports());
        this.requires = (short)(this.requires | sas_mech.getRequires());
    }

    public boolean canHandle(TSSCompoundSecMechConfig requirement) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"canHandle()", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("    CSS SUPPORTS: " + ConfigUtil.flags(this.supports)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("    CSS REQUIRES: " + ConfigUtil.flags(this.requires)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("    TSS SUPPORTS: " + ConfigUtil.flags(requirement.getSupports())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("    TSS REQUIRES: " + ConfigUtil.flags(requirement.getRequires())), (Object[])new Object[0]);
        }
        if (this.transport_mech.getOutboundSSLReference()) {
            return this.extractSSLTransportForEachAddress(requirement);
        }
        if ((this.supports & requirement.getRequires()) != requirement.getRequires()) {
            this.buildSupportsFailedMsg(requirement);
            return false;
        }
        if ((this.requires & requirement.getSupports()) != this.requires) {
            this.buildRequiresFailedMsg(requirement);
            return false;
        }
        if (!this.transport_mech.canHandle(requirement.getTransport_mech(), this.as_mech.getMechanism())) {
            this.cantHandleMsg = this.transport_mech.getCantHandleMsg();
            return false;
        }
        if (!this.as_mech.canHandle(requirement.getAs_mech())) {
            this.buildAsFailedMsg(requirement);
            return false;
        }
        if (!this.sas_mech.canHandle(requirement.getSas_mech(), this.as_mech.getMechanism())) {
            this.cantHandleMsg = this.sas_mech.getCantHandleMsg();
            return false;
        }
        return true;
    }

    private boolean extractSSLTransportForEachAddress(TSSCompoundSecMechConfig requirement) {
        TSSTransportMechConfig transportConfig = requirement.getTransport_mech();
        if (!(transportConfig instanceof TSSSSLTransportConfig)) {
            return false;
        }
        TransportAddress[] addresses = ((TSSSSLTransportConfig)transportConfig).getTransportAddresses();
        if (addresses.length == 0) {
            return false;
        }
        for (TransportAddress addr : addresses) {
            short sslPort = addr.port;
            String sslHost = addr.host_name;
            InetAddress ina = null;
            String sslCfgAlias = null;
            OptionsKey options = null;
            short localSupports = this.supports;
            short localRequires = this.requires;
            try {
                ina = InetAddress.getByName(sslHost);
                sslHost = ina.getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig", (String)"166", (Object)this, (Object[])new Object[]{requirement});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("get sslConfig for target " + sslHost + ":" + sslPort), (Object[])new Object[0]);
            }
            SSLConfig sslConfig = SecurityServices.getSSLConfig();
            try {
                sslCfgAlias = sslConfig.getSSLAlias(sslHost, sslPort);
                options = sslConfig.getAssociationOptions(sslCfgAlias);
                CSSSSLTransportConfig transportLayerConfig = new CSSSSLTransportConfig();
                if (options != null) {
                    transportLayerConfig.setSupports(options.supports);
                    transportLayerConfig.setRequires(options.requires);
                }
                if (((localSupports = (short)(localSupports | transportLayerConfig.getSupports())) & requirement.getRequires()) != requirement.getRequires()) {
                    this.buildSupportsFailedMsg(requirement);
                    continue;
                }
                if (((localRequires = (short)(localRequires | transportLayerConfig.getRequires())) & requirement.getSupports()) != localRequires) {
                    this.buildRequiresFailedMsg(requirement);
                    continue;
                }
                if (!transportLayerConfig.canHandle(requirement.getTransport_mech(), this.as_mech.getMechanism())) {
                    this.cantHandleMsg = transportLayerConfig.getCantHandleMsg();
                    continue;
                }
                if (!this.as_mech.canHandle(requirement.getAs_mech())) {
                    this.buildAsFailedMsg(requirement);
                    continue;
                }
                if (!this.sas_mech.canHandle(requirement.getSas_mech(), this.as_mech.getMechanism())) {
                    this.cantHandleMsg = this.sas_mech.getCantHandleMsg();
                    continue;
                }
                if (sslCfgAlias == null) continue;
                transportLayerConfig.setSslConfigName(sslCfgAlias);
                this.addressTransportMechMap.put(new ServerTransportAddress(addr), transportLayerConfig);
            }
            catch (SSLException sSLException) {
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig", (String)"217", (Object)this, (Object[])new Object[]{requirement});
            }
        }
        return !this.addressTransportMechMap.isEmpty();
    }

    private void buildSupportsFailedMsg(TSSCompoundSecMechConfig requirement) {
        this.cantHandleMsg = !this.as_mech.getMechanism().equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ALL_LAYERS_SUPPORTS_FAILED", (Object[])new Object[]{this.as_mech.getMechanism(), ConfigUtil.flags(this.supports), ConfigUtil.flags(requirement.getRequires())}, (String)"CWWKS9551E: The client security policy has the transport, authentication and attribute layers configured for <{0}> with <{1}> as Supported in the server.xml file and the server security policy is configured with <{2}> as Required.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ALL_LAYERS_SUPPORTS_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.supports), ConfigUtil.flags(requirement.getRequires())}, (String)"CWWKS9552E: The client security policy has the transport and attribute layers configured with <{0}> as Supported in the server.xml file and the server security policy is configured with <{1}> as Required.");
    }

    private void buildRequiresFailedMsg(TSSCompoundSecMechConfig requirement) {
        this.cantHandleMsg = !this.as_mech.getMechanism().equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ALL_LAYERS_REQUIRES_FAILED", (Object[])new Object[]{this.as_mech.getMechanism(), ConfigUtil.flags(this.requires), ConfigUtil.flags(requirement.getSupports())}, (String)"CWWKS9553E: The client security policy has the transport, authentication and attribute layers configured for <{0}> with <{1}> as Required in the server.xml file and the server security policy is configured with <{2}> as Supported.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ALL_LAYERS_REQUIRES_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.requires), ConfigUtil.flags(requirement.getSupports())}, (String)"CWWKS9554E: The client security policy has the transport and attribute layers configured with <{0}> as Required in the server.xml file and the server security policy is configured with <{1}> as Supported.");
    }

    private void buildAsFailedMsg(TSSCompoundSecMechConfig requirement) {
        String client_mechanism = this.as_mech.getMechanism();
        String server_mechanism = requirement.getAs_mech().getMechanism();
        this.cantHandleMsg = client_mechanism.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_AUTTH_CLIENT_DISABLED_FAILED", (Object[])new Object[]{server_mechanism}, (String)"CWWKS9566E: The client security policy authentication layer is disabled in the server.xml file and the server security policy authentication layer is configured with mechanism {0}.") : (server_mechanism.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_AUTH_SERVER_DISABLED_FAILED", (Object[])new Object[]{client_mechanism}, (String)"CWWKS9567E: The client security policy has the authentication layer configured with mechanism {0} in the server.xml file and the server security policy authentication layer is disabled.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_AUTH_MECHANISMS_FAILED", (Object[])new Object[]{client_mechanism, server_mechanism}, (String)"CWWKS9565E: The client security policy has the authentication layer configured with mechanism {0} in the server.xml file and the server security policy configured with mechanism {1}."));
    }

    @Trivial
    public String getCantHandleMsg() {
        return this.cantHandleMsg;
    }

    public ServiceContext generateServiceContext(Codec codec, TSSCompoundSecMechConfig requirement, ClientRequestInfo ri) throws UserException {
        if (this.as_mech instanceof CSSNULLASMechConfig && this.sas_mech.isAssertingITTAbsent(requirement.getSas_mech())) {
            return null;
        }
        EstablishContext msg = new EstablishContext();
        msg.client_context_id = 0L;
        msg.client_authentication_token = this.as_mech.encode(requirement.getAs_mech(), this.sas_mech, ri, codec);
        msg.authorization_token = this.sas_mech.encodeAuthorizationElement();
        msg.identity_token = this.sas_mech.encodeIdentityToken(requirement.getSas_mech(), codec);
        ServiceContext context = new ServiceContext();
        SASContextBody sas = new SASContextBody();
        sas.establish_msg(msg);
        Any sas_any = ORB.init().create_any();
        SASContextBodyHelper.insert((Any)sas_any, (SASContextBody)sas);
        context.context_data = codec.encode_value(sas_any);
        context.context_id = 15;
        return context;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSCompoundSecMechConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS: ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES: ").append(ConfigUtil.flags(this.requires)).append("\n");
        if (this.transport_mech != null) {
            this.transport_mech.toString(moreSpaces, buf);
        }
        if (this.as_mech != null) {
            this.as_mech.toString(moreSpaces, buf);
        }
        if (this.sas_mech != null) {
            this.sas_mech.toString(moreSpaces, buf);
        }
        buf.append(spaces).append("]\n");
    }

    public Map<ServerTransportAddress, CSSTransportMechConfig> getTransportMechMap() {
        return this.addressTransportMechMap;
    }

    public String getSSLCfgForTransportAddress(TransportAddress addr) {
        String sslCfg = null;
        if (this.addressTransportMechMap.isEmpty()) {
            sslCfg = this.transport_mech.getSslConfigName();
        } else {
            CSSTransportMechConfig mech = this.addressTransportMechMap.get(new ServerTransportAddress(addr));
            sslCfg = mech.getSslConfigName();
        }
        return sslCfg;
    }
}

