/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.buffer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collector.manager.buffer.Buffer;
import com.ibm.ws.collector.manager.buffer.BufferManagerEMQHelper;
import com.ibm.ws.collector.manager.buffer.Event;
import com.ibm.ws.collector.manager.buffer.SimpleRotatingSoftQueue;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class BufferManagerImpl
extends BufferManager {
    private static final TraceComponent tc = Tr.register("x.com.ibm.ws.collector.manager.buffer.BufferManagerImpl", BufferManagerImpl.class, (String)null);
    private Buffer<Object> ringBuffer;
    private Set<SynchronousHandler> synchronousHandlerSet = new HashSet<SynchronousHandler>();
    private final int capacity;
    private final String sourceId;
    private final ConcurrentHashMap<String, HandlerStats> handlerEventMap = new ConcurrentHashMap();
    protected Queue<Object> earlyMessageQueue;
    private static final int EARLY_MESSAGE_QUEUE_SIZE = 400;

    public BufferManagerImpl(int capacity, String sourceId) {
        BufferManagerEMQHelper.addBufferManagerList(this);
        this.ringBuffer = null;
        this.sourceId = sourceId;
        this.capacity = capacity;
        if (!BufferManagerEMQHelper.getEMQRemovedFlag()) {
            this.earlyMessageQueue = new SimpleRotatingSoftQueue<Object>(new Object[400]);
            if (BufferManagerEMQHelper.getEMQRemovedFlag()) {
                this.removeEMQ();
            }
        }
    }

    public BufferManagerImpl(int capacity, String sourceId, boolean isEMQ) {
        this.sourceId = sourceId;
        this.capacity = capacity;
        if (!isEMQ) {
            this.earlyMessageQueue = null;
            this.ringBuffer = new Buffer(capacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.earlyMessageQueue != null) {
            Set<SynchronousHandler> synchronousHandlerSetSnapShot;
            BufferManagerImpl bufferManagerImpl = this;
            synchronized (bufferManagerImpl) {
                if (this.earlyMessageQueue != null) {
                    this.earlyMessageQueue.add(event);
                }
                if (this.ringBuffer != null) {
                    this.ringBuffer.add(event);
                }
                synchronousHandlerSetSnapShot = this.synchronousHandlerSet;
            }
            for (SynchronousHandler synchronousHandler : synchronousHandlerSetSnapShot) {
                synchronousHandler.synchronousWrite(event);
            }
        } else {
            for (SynchronousHandler synchronousHandler : this.synchronousHandlerSet) {
                synchronousHandler.synchronousWrite(event);
            }
            if (this.ringBuffer != null) {
                this.addEventToRingBuffer(event);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding event to buffer " + event, new Object[0]);
        }
    }

    @FFDCIgnore(value={NullPointerException.class})
    private void addEventToRingBuffer(Object event) {
        if (this.ringBuffer != null) {
            try {
                this.ringBuffer.add(event);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getNextEvent(String handlerId) throws InterruptedException {
        HandlerStats handlerStats = null;
        if (handlerId != null) {
            handlerStats = this.handlerEventMap.get(handlerId);
        }
        if (handlerStats == null) {
            throw new IllegalArgumentException("Handler not registered with buffer manager : " + handlerId);
        }
        long seqNum = handlerStats.getNextSeqNum();
        Event<Object> event = this.ringBuffer.get(seqNum);
        handlerStats.traceEventLoss(event.getSeqNum());
        long nextSeqNum = event.getSeqNum() + 1L;
        handlerStats.setNextSeqNum(nextSeqNum);
        return event.getEvent();
    }

    @Override
    public Object[] getEvents(String handlerId, int noOfEvents) throws InterruptedException {
        HandlerStats handlerStats = null;
        if (handlerId != null) {
            handlerStats = this.handlerEventMap.get(handlerId);
        }
        if (handlerStats == null) {
            throw new IllegalArgumentException("Handler not registered with buffer manager : " + handlerId);
        }
        long seqNum = handlerStats.getNextSeqNum();
        ArrayList<Event<Object>> events = this.ringBuffer.get(seqNum, noOfEvents);
        handlerStats.traceEventLoss(events.get(0).getSeqNum());
        long nextSeqNum = events.get(0).getSeqNum() + (long)events.size();
        handlerStats.setNextSeqNum(nextSeqNum);
        Object[] e = new Object[events.size()];
        for (int i = 0; i < events.size(); ++i) {
            e[i] = events.get(i).getEvent();
        }
        return e;
    }

    public synchronized void addHandler(String handlerId) {
        if (this.ringBuffer == null) {
            this.ringBuffer = new Buffer(this.capacity);
        }
        if (this.earlyMessageQueue != null && this.earlyMessageQueue.size() != 0) {
            for (Object message : this.earlyMessageQueue.toArray()) {
                this.ringBuffer.add(message);
            }
        }
        this.handlerEventMap.putIfAbsent(handlerId, new HandlerStats(handlerId, this.sourceId));
        Tr.event(tc, "Added Asynchronous Handler: " + handlerId, new Object[0]);
    }

    public synchronized void addSyncHandler(SynchronousHandler syncHandler) {
        if (this.earlyMessageQueue != null && this.earlyMessageQueue.size() != 0 && !this.synchronousHandlerSet.contains(syncHandler)) {
            for (Object message : this.earlyMessageQueue.toArray()) {
                syncHandler.synchronousWrite(message);
            }
        }
        HashSet<SynchronousHandler> synchronousHandlerSetCopy = new HashSet<SynchronousHandler>(this.synchronousHandlerSet);
        synchronousHandlerSetCopy.add(syncHandler);
        Tr.event(tc, "Added Synchronous Handler: " + syncHandler.getHandlerName(), new Object[0]);
        this.synchronousHandlerSet = synchronousHandlerSetCopy;
    }

    public synchronized void removeSyncHandler(SynchronousHandler syncHandler) {
        HashSet<SynchronousHandler> synchronousHandlerSetCopy = new HashSet<SynchronousHandler>(this.synchronousHandlerSet);
        synchronousHandlerSetCopy.remove(syncHandler);
        Tr.event(tc, "Removed Synchronous Handler: " + syncHandler.getHandlerName(), new Object[0]);
        this.synchronousHandlerSet = synchronousHandlerSetCopy;
    }

    public synchronized void removeHandler(String handlerId) {
        this.handlerEventMap.remove(handlerId);
        Tr.event(tc, "Removed Asynchronous Handler: " + handlerId, new Object[0]);
        if (this.handlerEventMap.isEmpty()) {
            this.ringBuffer = null;
            Tr.event(tc, "ringBuffer for this BufferManagerImpl has now been set to null", new Object[0]);
        }
    }

    public synchronized void removeEMQ() {
        this.earlyMessageQueue = null;
    }

    public static class HandlerStats {
        private final String handlerId;
        private final String sourceId;
        private long seqNum;
        private long lostEventsForTrace;
        private long lostEventsForWarning;
        private long totalLostEvents;
        private long lastReportTimeForTrace;
        private long lastReportTimeForWarning;
        private final long intervalForTrace = 60000L;
        private final long intervalForWarning = 300000L;

        public HandlerStats(String handlerId, String sourceId) {
            this.handlerId = handlerId;
            this.sourceId = sourceId;
            this.seqNum = 1L;
            this.totalLostEvents = 0L;
            this.lostEventsForTrace = 0L;
            this.lostEventsForWarning = 0L;
            this.lastReportTimeForWarning = 0L;
            this.lastReportTimeForTrace = System.currentTimeMillis();
        }

        public long getNextSeqNum() {
            return this.seqNum;
        }

        public void setNextSeqNum(long nextSeqNum) {
            this.seqNum = nextSeqNum;
        }

        public void traceEventLoss(long retSeqNum) {
            if (retSeqNum > this.seqNum) {
                long eventsLost = retSeqNum - this.seqNum;
                this.lostEventsForWarning += eventsLost;
                this.lostEventsForTrace += eventsLost;
                this.totalLostEvents += eventsLost;
            }
            long currentTime = System.currentTimeMillis();
            long timeElapsed = currentTime - this.lastReportTimeForWarning;
            if (this.lostEventsForWarning > 0L && timeElapsed >= 300000L) {
                if (this.lastReportTimeForWarning == 0L) {
                    Tr.warning(tc, "HANDLER_STARTED_TO_LOSE_EVENTS_WARNING", this.handlerId, this.lostEventsForWarning, this.sourceId);
                } else {
                    long timeElapsedInMins = TimeUnit.MILLISECONDS.toMinutes(timeElapsed);
                    Tr.warning(tc, "HANDLER_LOST_EVENTS_WARNING", this.handlerId, this.lostEventsForWarning, this.sourceId, timeElapsedInMins, this.totalLostEvents);
                }
                this.lastReportTimeForWarning = currentTime;
                this.lostEventsForWarning = 0L;
            }
            if ((timeElapsed = currentTime - this.lastReportTimeForTrace) >= 60000L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    long timeElapsedInSecs = TimeUnit.MILLISECONDS.toSeconds(timeElapsed);
                    Tr.event(tc, "Handler [{0}] has lost {1} events from source [{2}] in the last {3} second(s), and has lost {4} events from the source since the handler started.", this.handlerId, this.lostEventsForTrace, this.sourceId, timeElapsedInSecs, this.totalLostEvents);
                }
                this.lastReportTimeForTrace = currentTime;
                this.lostEventsForTrace = 0L;
            }
        }
    }
}

