/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.health.center.data.HCGCData;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils1_1 {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String[] tags, int maxFieldLength) {
        if (eventType.equals("liberty_gc")) {
            if (event instanceof GenericData) {
                return CollectorJsonUtils1_1.jsonifyGCEvent(-1, wlpUserDir, serverName, serverHostName, "liberty_gc", event, tags);
            }
            return CollectorJsonUtils1_1.jsonifyGCEvent(serverHostName, wlpUserDir, serverName, (HCGCData)event, tags);
        }
        if (eventType.equals("liberty_message")) {
            return CollectorJsonUtils1_1.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
        }
        if (eventType.equals("liberty_trace")) {
            return CollectorJsonUtils1_1.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
        }
        if (eventType.equals("liberty_ffdc")) {
            return CollectorJsonUtils1_1.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_ffdc", event, tags);
        }
        if (eventType.equals("liberty_accesslog")) {
            return CollectorJsonUtils1_1.jsonifyAccess(-1, wlpUserDir, serverName, serverHostName, "liberty_accesslog", event, tags);
        }
        return "";
    }

    private static String jsonifyGCEvent(String hostName, String wlpUserDir, String serverName, HCGCData hcGCData, String[] tags) {
        String sequenceNum = hcGCData.getSequence();
        StringBuilder sb = CollectorJsonHelpers.startGCJson1_1(hostName, wlpUserDir, serverName);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(hcGCData.getTime());
        CollectorJsonHelpers.addToJSON(sb, "ibm_datetime", datetime, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_sequence", sequenceNum, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_heap", String.valueOf((long)hcGCData.getHeap()), false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_usedHeap", String.valueOf((long)hcGCData.getUsage()), false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_maxHeap", String.valueOf(hcGCData.getMaxHeap()), false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_duration", String.valueOf((long)hcGCData.getDuration() * 1000L), false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_gcType", hcGCData.getType(), false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, "ibm_reason", hcGCData.getReason(), false, false, false, false);
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyGCEvent(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        ArrayList<KeyValuePair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        StringBuilder sb = CollectorJsonHelpers.startGCJson1_1(hostName, wlpUserDir, serverName);
        for (KeyValuePair p : pairs) {
            if (p == null || p.isList()) continue;
            kvp = p;
            key = kvp.getKey();
            if (key.equals("ibm_duration")) {
                long duration = kvp.getLongValue() * 1000L;
                CollectorJsonHelpers.addToJSON(sb, key, Long.toString(duration), false, true, false, false, true);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(kvp.getLongValue());
                CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, false, false);
                continue;
            }
            String value = null;
            value = kvp.isInteger() ? Integer.toString(kvp.getIntValue()) : (kvp.isLong() ? Long.toString(kvp.getLongValue()) : kvp.getStringValue());
            CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, false, !kvp.isString());
        }
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        FFDCData ffdcData = (FFDCData)event;
        StringBuilder sb = CollectorJsonHelpers.startFFDCJson1_1(hostName, wlpUserDir, serverName);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(ffdcData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getDatetimeKey1_1(), datetime, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getMessageKey1_1(), ffdcData.getMessage(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getClassNameKey1_1(), ffdcData.getClassName(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getExceptionNameKey1_1(), ffdcData.getExceptionName(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getProbeIdKey1_1(), ffdcData.getProbeId(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getThreadIdKey1_1(), DataFormatHelper.padHexString((int)ffdcData.getThreadId(), 8), false, true, false, false, false);
        String formattedValue = CollectorJsonHelpers.formatMessage(ffdcData.getStacktrace(), maxFieldLength);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getStacktraceKey1_1(), formattedValue, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getObjectDetailsKey1_1(), ffdcData.getObjectDetails(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getSequenceKey1_1(), ffdcData.getSequence(), false, true, false, false, false);
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsonifyAccess(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        AccessLogData accessLogData = (AccessLogData)event;
        StringBuilder sb = CollectorJsonHelpers.startAccessLogJson1_1(hostName, wlpUserDir, serverName);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getUriPathKey1_1(), accessLogData.getUriPath(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestMethodKey1_1(), accessLogData.getRequestMethod(), false, true, false, false, false);
        String jsonQueryString = accessLogData.getQueryString();
        if (jsonQueryString != null) {
            try {
                jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getQueryStringKey1_1(), jsonQueryString, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestHostKey1_1(), accessLogData.getRequestHost(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestPortKey1_1(), accessLogData.getRequestPort(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRemoteHostKey1_1(), accessLogData.getRemoteHost(), false, true, false, false, false);
        String userAgent = accessLogData.getUserAgent();
        if (userAgent != null && userAgent.length() > 2048) {
            userAgent = userAgent.substring(0, 2048);
        }
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getUserAgentKey1_1(), userAgent, false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestProtocolKey1_1(), accessLogData.getRequestProtocol(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getBytesReceivedKey1_1(), Long.toString(accessLogData.getBytesReceived()), false, true, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getResponseCodeKey1_1(), Integer.toString(accessLogData.getResponseCode()), false, true, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getElapsedTimeKey1_1(), Long.toString(accessLogData.getElapsedTime()), false, true, false, false, true);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(accessLogData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getDatetimeKey1_1(), datetime, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getSequenceKey1_1(), accessLogData.getSequence(), false, true, false, false, false);
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        LogTraceData logData = (LogTraceData)event;
        StringBuilder sb = null;
        ArrayList<KeyValuePair> extensions = null;
        KeyValuePairList kvpl = null;
        if (eventType.equals("liberty_message")) {
            sb = CollectorJsonHelpers.startMessageJson1_1(hostName, wlpUserDir, serverName);
        }
        if (eventType.equals("liberty_trace")) {
            sb = CollectorJsonHelpers.startTraceJson1_1(hostName, wlpUserDir, serverName);
        }
        String message = logData.getMessage();
        String loglevel = logData.getLoglevel();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = CollectorJsonHelpers.jsonRemoveSpace(message);
        }
        StringBuilder formattedValue = new StringBuilder(CollectorJsonHelpers.formatMessage(message, maxFieldLength));
        String throwable = logData.getThrowable();
        if (throwable != null) {
            formattedValue.append(CollectorJsonHelpers.LINE_SEPARATOR).append(throwable);
        }
        CollectorJsonHelpers.addToJSON(sb, logData.getMessageKey1_1(), formattedValue.toString(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getThreadIdKey1_1(), DataFormatHelper.padHexString(logData.getThreadId(), 8), false, true, false, false);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(logData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, logData.getDatetimeKey1_1(), datetime, false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getMessageIdKey1_1(), logData.getMessageId(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getModuleKey1_1(), logData.getModule(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getLoglevelKey1_1(), logData.getLoglevel(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getMethodNameKey1_1(), logData.getMethodName(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getClassNameKey1_1(), logData.getClassName(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getSequenceKey1_1(), logData.getSequence(), false, true, false, false);
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.endsWith("_int")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Integer.toString(k.getIntValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Float.toString(k.getFloatValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Long.toString(k.getLongValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Boolean.toString(k.getBooleanValue()), false, true, false, false, true);
                    continue;
                }
                CollectorJsonHelpers.addToJSON(sb, extKey, k.getStringValue(), false, true, false, false, false);
            }
        }
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"ibm_tags\":");
        return sb;
    }
}

