/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.KeyValueIntegerPair;
import com.ibm.ws.logging.data.KeyValueLongPair;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.KeyValueStringPair;
import java.util.ArrayList;

public class GenericData {
    private final ArrayList<KeyValuePair> pairs;
    private String sourceType;
    private String jsonMessage = null;

    public GenericData() {
        this.pairs = new ArrayList();
    }

    public GenericData(int size) {
        this.pairs = new ArrayList(size);
    }

    public void setPair(int index, String key, String value) {
        KeyValueStringPair kvp = new KeyValueStringPair(key, value);
        this.pairs.add(index, kvp);
    }

    public void setPair(int index, String key, int value) {
        KeyValueIntegerPair kvp = new KeyValueIntegerPair(key, value);
        this.pairs.add(index, kvp);
    }

    public void setPair(int index, String key, long value) {
        KeyValueLongPair kvp = new KeyValueLongPair(key, value);
        this.pairs.add(index, kvp);
    }

    public void setPair(int index, KeyValuePairList kvps) {
        this.pairs.add(index, kvps);
    }

    public void addPair(String key, String value) {
        KeyValueStringPair kvp = new KeyValueStringPair(key, value);
        this.pairs.add(kvp);
    }

    public void addPair(String key, int value) {
        KeyValueIntegerPair kvp = new KeyValueIntegerPair(key, value);
        this.pairs.add(kvp);
    }

    public void addPair(String key, long value) {
        KeyValueLongPair kvp = new KeyValueLongPair(key, value);
        this.pairs.add(kvp);
    }

    public void addPair(KeyValuePairList kvps) {
        this.pairs.add(kvps);
    }

    public ArrayList<KeyValuePair> getPairs() {
        return this.pairs;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String comma = ",";
        sb.append("GenericData [");
        sb.append("type=" + this.sourceType);
        for (KeyValuePair p : this.pairs) {
            if (p == null || p.isList()) continue;
            KeyValuePair kvp = p;
            String key = kvp.getKey();
            sb.append(comma);
            if (this.sourceType.equals("com.ibm.ws.logging.ffdc.source.ffdcsource") && key.equals("ibm_threadId")) {
                key = "threadID";
            }
            if (kvp.isInteger()) {
                sb.append(key + "=" + kvp.getIntValue());
                continue;
            }
            if (kvp.isLong()) {
                sb.append(key + "=" + kvp.getLongValue());
                continue;
            }
            sb.append(key + "=" + kvp.getStringValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getJsonMessage() {
        return this.jsonMessage;
    }

    public void setJsonMessage(String jsonMessage) {
        this.jsonMessage = jsonMessage;
    }
}

