/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.source;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collector.manager.buffer.BufferManagerEMQHelper;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.utils.LogFormatUtils;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogSource
implements Source {
    private static final TraceComponent tc = Tr.register(LogSource.class);
    private final String sourceName = "com.ibm.ws.logging.source.message";
    private final String location = "memory";
    private BufferManager bufferMgr = null;
    static Pattern messagePattern = Pattern.compile("^([A-Z][\\dA-Z]{3,4})(\\d{4})([A-Z])(:)");
    private final SequenceNumber sequenceNumber = new SequenceNumber();

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Activating " + this, new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, " Deactivating " + this, " reason = " + reason);
        }
    }

    @Override
    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = bufferMgr;
    }

    @Override
    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Un-setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = null;
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    @Override
    public String getSourceName() {
        return "com.ibm.ws.logging.source.message";
    }

    @Override
    public String getLocation() {
        return "memory";
    }

    @Trivial
    public void publish(RoutedMessage routedMessage) {
        LogRecord logRecord = routedMessage.getLogRecord();
        if (logRecord != null && this.bufferMgr != null) {
            LogTraceData parsedMessage = this.parse(routedMessage);
            if (!BufferManagerEMQHelper.getEMQRemovedFlag() && this.extractMessage(routedMessage, logRecord).startsWith("CWWKF0011I")) {
                BufferManagerEMQHelper.removeEMQTrigger();
            }
            this.bufferMgr.add(parsedMessage);
        }
    }

    private String extractMessage(RoutedMessage routedMessage, LogRecord logRecord) {
        String messageVal = routedMessage.getFormattedVerboseMsg();
        if (messageVal == null) {
            messageVal = logRecord.getMessage();
        }
        return messageVal;
    }

    public LogTraceData parse(RoutedMessage routedMessage) {
        return this.parse(routedMessage, routedMessage.getLogRecord());
    }

    public LogTraceData parse(RoutedMessage routedMessage, LogRecord logRecord) {
        LogTraceData logData = new LogTraceData();
        long dateVal = logRecord.getMillis();
        logData.setDatetime(dateVal);
        String messageIdVal = null;
        String messageVal = this.extractMessage(routedMessage, logRecord);
        if (messageVal != null) {
            messageIdVal = this.parseMessageId(messageVal);
        }
        logData.setMessageId(messageIdVal);
        int threadIdVal = (int)Thread.currentThread().getId();
        logData.setThreadId(threadIdVal);
        logData.setModule(logRecord.getLoggerName());
        logData.setSeverity(LogFormatUtils.mapLevelToType(logRecord));
        logData.setLoglevel(LogFormatUtils.mapLevelToRawType(logRecord));
        logData.setMethodName(logRecord.getSourceMethodName());
        logData.setClassName(logRecord.getSourceClassName());
        logData.setLevelValue(logRecord.getLevel().intValue());
        String threadName = Thread.currentThread().getName();
        logData.setThreadName(threadName);
        WsLogRecord wsLogRecord = this.getWsLogRecord(logRecord);
        KeyValuePairList extensions = null;
        if (wsLogRecord != null) {
            logData.setCorrelationId(wsLogRecord.getCorrelationId());
            logData.setOrg(wsLogRecord.getOrganization());
            logData.setProduct(wsLogRecord.getProduct());
            logData.setComponent(wsLogRecord.getComponent());
            if (wsLogRecord.getExtensions() != null) {
                extensions = new KeyValuePairList("extensions");
                Map<String, String> extMap = wsLogRecord.getExtensions();
                for (Map.Entry<String, String> entry : extMap.entrySet()) {
                    CollectorJsonHelpers.handleExtensions(extensions, entry.getKey(), entry.getValue());
                }
            }
        } else {
            logData.setCorrelationId(null);
            logData.setOrg(null);
            logData.setProduct(null);
            logData.setComponent(null);
            extensions = null;
        }
        logData.setSequence(this.sequenceNumber.next(dateVal));
        Throwable thrown = logRecord.getThrown();
        if (thrown != null) {
            String stackTrace = DataFormatHelper.throwableToString(thrown);
            logData.setThrowable(stackTrace);
            String s = thrown.getLocalizedMessage();
            if (s == null) {
                s = thrown.toString();
            }
            logData.setThrowableLocalized(s);
        } else {
            logData.setThrowable(null);
            logData.setThrowableLocalized(null);
        }
        logData.setMessage(messageVal);
        if (routedMessage.getFormattedMsg() != null) {
            logData.setFormattedMsg(routedMessage.getFormattedMsg());
        } else {
            logData.setFormattedMsg(null);
        }
        logData.setExtensions(extensions);
        logData.setSourceType("com.ibm.ws.logging.source.message");
        return logData;
    }

    protected String parseMessageId(String msg) {
        String messageId = null;
        Matcher matcher = messagePattern.matcher(msg);
        if (matcher.find()) {
            messageId = msg.substring(matcher.start(), matcher.end() - 1);
        }
        return messageId;
    }

    private WsLogRecord getWsLogRecord(LogRecord logRecord) {
        return logRecord instanceof WsLogRecord ? (WsLogRecord)logRecord : null;
    }
}

