/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.cdi;

import com.ibm.tx.jta.TransactionSynchronizationRegistryFactory;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.Transaction.TransactionScopeDestroyer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.transaction.TransactionScoped;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TransactionContext
implements AlterableContext,
TransactionScopeDestroyer {
    private final UserTransaction ut = UserTransactionImpl.instance();
    private final TransactionSynchronizationRegistry tsr = TransactionSynchronizationRegistryFactory.getTransactionSynchronizationRegistry();
    private final String TXC_STORAGE_ID = "cdi_TXC";
    private static final TraceComponent tc;
    static final long serialVersionUID = 8572990960841840014L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{contextual, creationalContext, this});
        }
        this.performChecks(contextual);
        Map<String, InstanceAndContext<?>> storage = this.getStorage(true);
        InstanceAndContext<Object> data = this.getByContextual(storage, contextual);
        if (data != null) {
            return data.instance;
        }
        if (creationalContext == null) {
            return null;
        }
        Object t = contextual.create(creationalContext);
        String contextId = ((PassivationCapable)contextual).getId();
        data = new InstanceAndContext<Object>(contextual, creationalContext, t);
        storage.put(contextId, data);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)t);
        }
        return (T)t;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public boolean isActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isActive", (Object)this);
        }
        boolean isActive = false;
        try {
            switch (this.ut.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    isActive = true;
                    break;
                }
                default: {
                    isActive = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.tx.jta.cdi.TransactionContext", (String)"116", (Object)this, (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isActive", (Object)isActive);
        }
        return isActive;
    }

    public void destroy(Contextual<?> contextual) {
        Map<String, InstanceAndContext<?>> storage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy(Contextual)", (Object)new Object[]{contextual, this});
        }
        if ((storage = this.getStorage(false)) != null) {
            String contextId = TransactionContext.getContextualId(contextual);
            InstanceAndContext<?> data = this.getByContextual(storage, contextual);
            if (data != null) {
                storage.remove(contextId);
                this.destroyItem(contextId, data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy(Contextual)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object)this);
        }
        if (this.tsr.getTransactionKey() != null) {
            Map<String, InstanceAndContext<?>> storage = this.getStorage(false);
            if (storage != null) {
                try {
                    for (InstanceAndContext<?> entry : storage.values()) {
                        String id = TransactionContext.getContextualId(entry.context);
                        this.destroyItem(id, entry);
                    }
                }
                finally {
                    this.tsr.putResource((Object)"cdi_TXC", null);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Tran synchronization registry not available, skipping destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    private void performChecks(Contextual<?> contextual) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performChecks", (Object)this);
        }
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new IllegalArgumentException("Contextual parameter should not be null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performChecks");
        }
    }

    private <T> InstanceAndContext<T> getByContextual(Map<String, InstanceAndContext<?>> storage, Contextual<T> contextual) {
        String contextId = TransactionContext.getContextualId(contextual);
        return storage.get(contextId);
    }

    private static String getContextualId(Contextual<?> contextual) {
        return ((PassivationCapable)contextual).getId();
    }

    private <T> Map<String, InstanceAndContext<?>> getStorage(boolean create) {
        HashMap storage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStorage", (Object)new Object[]{create, this});
        }
        if ((storage = (HashMap)this.tsr.getResource((Object)"cdi_TXC")) == null && create) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No existing storage for transaction context, creating");
            }
            storage = new HashMap();
            this.tsr.putResource((Object)"cdi_TXC", storage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStorage");
        }
        return storage;
    }

    private <T> void destroyItem(String contextId, InstanceAndContext<T> item) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyItem", (Object)new Object[]{item, this});
        }
        item.context.destroy(item.instance, item.creationalContext);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyItem");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(TransactionContext.class);
        tc = Tr.register(TransactionContext.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class InstanceAndContext<T> {
        Contextual<T> context;
        CreationalContext<T> creationalContext;
        T instance;
        static final long serialVersionUID = 7662004009175270731L;
        private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

        public InstanceAndContext(Contextual<T> context, CreationalContext<T> creationalContext, T instance) {
            this.context = context;
            this.creationalContext = creationalContext;
            this.instance = instance;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(TransactionContext.getContextualId(this.context)).append(", ");
            sb.append(this.creationalContext.toString()).append(", ");
            sb.append(this.instance.toString()).append("]");
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register(InstanceAndContext.class);
        }
    }
}

