/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebUtils {
    private static final TraceComponent tc = Tr.register(WebUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = 615267427695869341L;

    public static String urlEncode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.common.web.WebUtils", (String)"50", null, (Object[])new Object[]{value});
        }
        return value;
    }

    public static String encodeQueryString(String query) {
        String[] queryParams;
        if (query == null) {
            return null;
        }
        StringBuilder rebuiltQuery = new StringBuilder();
        for (String param : queryParams = query.split("&")) {
            String rebuiltParam = WebUtils.urlEncode(param);
            int equalIndex = param.indexOf("=");
            if (equalIndex > -1) {
                String name = param.substring(0, equalIndex);
                String value = equalIndex < param.length() - 1 ? param.substring(equalIndex + 1) : "";
                rebuiltParam = WebUtils.urlEncode(name) + "=" + WebUtils.urlEncode(value);
            }
            if (rebuiltParam.isEmpty()) continue;
            rebuiltQuery.append(rebuiltParam + "&");
        }
        if (rebuiltQuery.length() > 0 && rebuiltQuery.charAt(rebuiltQuery.length() - 1) == '&') {
            rebuiltQuery.deleteCharAt(rebuiltQuery.length() - 1);
        }
        return rebuiltQuery.toString();
    }

    public static String encodeCookie(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%", "%25");
        string = string.replaceAll(";", "%3B");
        string = string.replaceAll(",", "%2C");
        return string;
    }

    public static String decodeCookie(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%2C", ",");
        string = string.replaceAll("%3B", ";");
        string = string.replaceAll("%25", "%");
        return string;
    }

    public static String htmlEncode(String string) {
        return WebUtils.htmlEncode(string, true, true, true);
    }

    public static String htmlEncode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            char c;
            String app;
            block30: {
                block29: {
                    app = null;
                    c = string.charAt(i);
                    if (c >= 'A') break block29;
                    switch (c) {
                        case '\"': {
                            app = "&quot;";
                            break;
                        }
                        case '&': {
                            app = "&amp;";
                            break;
                        }
                        case '<': {
                            app = "&lt;";
                            break;
                        }
                        case '>': {
                            app = "&gt;";
                            break;
                        }
                        case ' ': {
                            if (encodeSubsequentBlanksToNbsp && (i == 0 || i - 1 >= 0 && string.charAt(i - 1) == ' ')) {
                                app = "&#160;";
                                break;
                            }
                            break block30;
                        }
                        case '\n': {
                            if (encodeNewline) {
                                app = "<br/>";
                                break;
                            }
                            break block30;
                        }
                    }
                    break block30;
                }
                if (encodeNonLatin && c > '\u0080') {
                    switch (c) {
                        case '\u00e4': {
                            app = "&auml;";
                            break;
                        }
                        case '\u00c4': {
                            app = "&Auml;";
                            break;
                        }
                        case '\u00f6': {
                            app = "&ouml;";
                            break;
                        }
                        case '\u00d6': {
                            app = "&Ouml;";
                            break;
                        }
                        case '\u00fc': {
                            app = "&uuml;";
                            break;
                        }
                        case '\u00dc': {
                            app = "&Uuml;";
                            break;
                        }
                        case '\u00df': {
                            app = "&szlig;";
                            break;
                        }
                        case '\u20ac': {
                            app = "&euro;";
                            break;
                        }
                        case '\u00ab': {
                            app = "&laquo;";
                            break;
                        }
                        case '\u00bb': {
                            app = "&raquo;";
                            break;
                        }
                        case '\u00a0': {
                            app = "&#160;";
                            break;
                        }
                        default: {
                            app = "&#" + c + ";";
                        }
                    }
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean validateUriFormat(String uri) {
        return WebUtils.validateUriFormat(uri, "https?://[a-zA-Z0-9._~%!$&'()*+,;=:@/-]+");
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static boolean validateUriFormat(final String uri, String regexToMatch) {
        if (uri == null || uri.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provided URI [" + uri + "] was null or empty"), (Object[])new Object[0]);
            }
            return false;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){
                static final long serialVersionUID = -3160082492214724487L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public URI run() throws URISyntaxException {
                    return new URI(uri);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI was not formatted correctly: " + e.getException().getLocalizedMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        if (!Pattern.matches(regexToMatch, uri)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"URI did not match expected URI pattern", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public Integer getRedirectPortFromRequest(HttpServletRequest req) {
        HttpServletRequest sr = this.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return (Integer)((IPrivateRequestAttributes)sr).getPrivateAttribute("SecurityRedirectPort");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRedirectUrl called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    private HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }

    @Trivial
    public static String stripSecretsFromUrl(String orig, String[] secretStrings) {
        String retVal = orig;
        if (secretStrings == null || secretStrings.length == 0) {
            return orig;
        }
        for (int i = 0; i < secretStrings.length; ++i) {
            retVal = WebUtils.stripSecretFromUrl(retVal, secretStrings[i]);
        }
        return retVal;
    }

    @Trivial
    public static String stripSecretFromUrl(String orig, String secretString) {
        if (secretString == null || secretString.length() == 0) {
            return orig;
        }
        String retVal = orig;
        String SECRETequals = secretString + "=";
        int SECRETequalsLen = SECRETequals.length();
        if (orig != null && orig.length() > SECRETequalsLen && orig.indexOf(SECRETequals) > -1) {
            StringBuffer sb = null;
            int i = 0;
            i = orig.indexOf("?");
            if (i > -1) {
                sb = new StringBuffer(orig.substring(0, i + 1));
                if (orig.length() > i + 1) {
                    orig = orig.substring(i + 1);
                }
            } else {
                sb = new StringBuffer();
            }
            String[] strings = orig.split("&");
            int numStrings = strings.length;
            String SECRETregex = SECRETequals + ".*";
            String SECRETreplace = SECRETequals + "*****";
            for (String entry : strings) {
                --numStrings;
                if (entry.startsWith(SECRETequals) && entry.length() > SECRETequalsLen) {
                    entry = entry.replaceAll(SECRETregex, SECRETreplace);
                    sb.append(entry);
                } else {
                    sb.append(entry);
                }
                if (numStrings <= 0) continue;
                sb.append("&");
            }
            retVal = sb.toString();
        }
        return retVal;
    }

    @Trivial
    public static String stripSecretsFromParameters(Map<String, String[]> pMap, String[] secretStrings) {
        String retVal = null;
        if (pMap != null && pMap.size() > 0) {
            List<Object> secretList = null;
            secretList = secretStrings != null && secretStrings.length != 0 ? Arrays.asList(secretStrings) : new ArrayList();
            StringBuffer sb = new StringBuffer();
            Set<String> keys = pMap.keySet();
            for (String key : keys) {
                sb.append("{" + key + "=");
                if (secretList.contains(key)) {
                    sb.append("*****");
                } else {
                    Object[] values = pMap.get(key);
                    sb.append(Arrays.toString(values));
                }
                sb.append("}");
            }
            retVal = sb.toString();
        }
        return retVal;
    }

    @Trivial
    public static String stripSecretFromParameters(Map<String, String[]> pMap, String secretString) {
        return WebUtils.stripSecretsFromParameters(pMap, new String[]{secretString});
    }

    @Trivial
    public static String getRequestStringForTrace(HttpServletRequest request, String[] secretStrings) {
        if (request == null || request.getRequestURL() == null) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[" + WebUtils.stripSecretsFromUrl(request.getRequestURL().toString(), secretStrings) + "]");
        String query = request.getQueryString();
        if (query != null) {
            String queryString = WebUtils.stripSecretsFromUrl(query, secretStrings);
            if (queryString != null) {
                sb.append(", queryString[" + queryString + "]");
            }
        } else {
            Map pMap = request.getParameterMap();
            String paramString = WebUtils.stripSecretsFromParameters(pMap, secretStrings);
            if (paramString != null) {
                sb.append(", parameters[" + paramString + "]");
            }
        }
        return sb.toString();
    }

    @Trivial
    public static String getRequestStringForTrace(HttpServletRequest request, String secretString) {
        return WebUtils.getRequestStringForTrace(request, new String[]{secretString});
    }
}

