/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ModelDeserializer
extends JsonDeserializer<Schema> {
    static final long serialVersionUID = 5728677362815988220L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode allOf = node.get("allOf");
        JsonNode anyOf = node.get("anyOf");
        JsonNode oneOf = node.get("oneOf");
        Schema schema = null;
        if (allOf != null || anyOf != null || oneOf != null) {
            Schema composedSchema = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
            return composedSchema;
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
        } else if (type != null) {
            if (type.textValue().equals("object")) {
                JsonNode additionalProperties = node.get("additionalProperties");
                if (additionalProperties != null && additionalProperties.isObject()) {
                    Schema innerSchema = (Schema)Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                    Schema ms = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
                    ms.setAdditionalProperties(innerSchema);
                    schema = ms;
                } else if (additionalProperties != null && additionalProperties.isBoolean()) {
                    schema = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
                    schema.setAdditionalProperties(Boolean.valueOf(additionalProperties.booleanValue()));
                } else {
                    schema = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
                }
            }
        } else if (node.get("$ref") != null) {
            schema = new SchemaImpl().ref(node.get("$ref").asText());
        } else {
            schema = (Schema)Json.mapper().convertValue((Object)node, Schema.class);
            schema.type(Schema.SchemaType.OBJECT);
        }
        return schema;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModelDeserializer.class);
    }
}

