/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;

@Trivial
public class Utils {
    public static final String NEW_LINE = String.format("%n", new Object[0]);

    public static String getSpaceBufferString(int bufferSpaces) {
        StringBuilder sb = new StringBuilder(bufferSpaces);
        while (bufferSpaces-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean doesFileExistPrivileged(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 3704437075196022676L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public static FileInputStream getFileInputStreamPrivileged(final File file) throws FileNotFoundException {
        final AtomicReference exceptionRef = new AtomicReference();
        FileInputStream fis = AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){
            static final long serialVersionUID = 250857461852956672L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public FileInputStream run() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void e;
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.jca.utils.Utils$2", (String)"76", (Object)this, (Object[])new Object[0]);
                    exceptionRef.set(e);
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (exceptionRef.get() != null) {
            throw (FileNotFoundException)exceptionRef.get();
        }
        return fis;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ConstructType
    extends Enum<ConstructType> {
        public static final /* enum */ ConstructType AdminObject;
        public static final /* enum */ ConstructType ConnectionFactory;
        public static final /* enum */ ConstructType MessageListener;
        public static final /* enum */ ConstructType ResourceAdapter;
        public static final /* enum */ ConstructType Unknown;
        private static final /* synthetic */ ConstructType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ConstructType[] values() {
            return (ConstructType[])$VALUES.clone();
        }

        public static ConstructType valueOf(String name) {
            return Enum.valueOf(ConstructType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConstructType.class);
            AdminObject = new ConstructType();
            ConnectionFactory = new ConstructType();
            MessageListener = new ConstructType();
            ResourceAdapter = new ConstructType();
            Unknown = new ConstructType();
            $VALUES = new ConstructType[]{AdminObject, ConnectionFactory, MessageListener, ResourceAdapter, Unknown};
        }
    }
}

