/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.cdi.ClaimBean;
import com.ibm.ws.security.mp.jwt.cdi.ClaimProducer;
import com.ibm.ws.security.mp.jwt.cdi.ClaimTypeException;
import com.ibm.ws.security.mp.jwt.cdi.JsonWebTokenBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Provider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={WebSphereCDIExtension.class}, property={"api.classes=org.eclipse.microprofile.jwt.Claim;org.eclipse.microprofile.jwt.Claims;org.eclipse.microprofile.jwt.ClaimValue;org.eclipse.microprofile.jwt.JsonWebToken;javax.json.JsonValue;javax.json.JsonNumber;javax.json.JsonString;javax.json.JsonStructure;javax.json.JsonArray;javax.json.JsonObject"}, immediate=true)
public class JwtCDIExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(JwtCDIExtension.class);
    private final Map<Claim, Set<Type>> injectionTypes = new HashMap<Claim, Set<Type>>();
    private boolean addJsonWebTokenBean = false;
    static final long serialVersionUID = -5881728475977288145L;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType producer = bm.createAnnotatedType(ClaimProducer.class);
        bbd.addAnnotatedType(producer, ClaimProducer.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
    }

    @ManualTrace
    public void processInjectionTarget(@Observes ProcessInjectionTarget<?> pit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processInjectionTarget", (Object[])new Object[]{pit});
        }
        Class targetClass = pit.getAnnotatedType().getJavaClass();
        ClassLoader classLoader = targetClass.getClassLoader();
        for (InjectionPoint injectionPoint : pit.getInjectionTarget().getInjectionPoints()) {
            Claim claim = this.getClaimAnnotation(injectionPoint);
            if (claim == null) continue;
            if (!Claims.UNKNOWN.equals((Object)claim.standard()) && !claim.value().trim().isEmpty() && claim.value() != claim.standard().name()) {
                String translatedMsg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_CONFLICTING_CLAIM_NAMES", (Object[])new Object[]{injectionPoint, claim.value(), claim.standard()});
                pit.addDefinitionError((Throwable)new DeploymentException(translatedMsg));
                continue;
            }
            Type type = injectionPoint.getType();
            Throwable configException = null;
            AnnotatedType annotatedType = pit.getAnnotatedType();
            Class annotatedClass = annotatedType.getJavaClass();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                configException = this.processParameterizedType(pit, annotatedClass, injectionPoint, pType, classLoader, claim);
            } else if (!(ClaimValue.class.isAssignableFrom((Class)type) || ((ApplicationScoped[])annotatedClass.getAnnotationsByType(ApplicationScoped.class)).length == 0 && ((SessionScoped[])annotatedClass.getAnnotationsByType(SessionScoped.class)).length == 0)) {
                String translatedMsg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_SCOPE_FOR_RAW_TYPE", (Object[])new Object[]{injectionPoint});
                pit.addDefinitionError((Throwable)new DeploymentException(translatedMsg));
            } else {
                configException = this.validateInjectionPoint(injectionPoint, type, type, classLoader, false, claim);
            }
            if (configException == null) continue;
            Tr.error((TraceComponent)tc, (String)"MPJWT_CDI_CANNOT_RESOLVE_INJECTION_POINT", (Object[])new Object[]{injectionPoint, configException});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processInjectionTarget");
        }
    }

    @ManualTrace
    private Claim getClaimAnnotation(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClaimAnnotation", (Object[])new Object[]{injectionPoint});
        }
        Claim claim = null;
        Set qualifiers = injectionPoint.getQualifiers();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(Claim.class)) continue;
                claim = (Claim)qualifier;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClaimAnnotation", claim);
        }
        return claim;
    }

    @ManualTrace
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"afterBeanDiscovery", (Object[])new Object[]{abd, beanManager});
        }
        if (this.addJsonWebTokenBean || !this.injectionTypes.isEmpty()) {
            abd.addBean((Bean)new JsonWebTokenBean(beanManager));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterBeanDiscovery");
        }
    }

    @ManualTrace
    private Throwable processParameterizedType(ProcessInjectionTarget<?> pit, Class<?> annotatedClass, InjectionPoint injectionPoint, ParameterizedType injectionType, ClassLoader classLoader, Claim claim) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processParameterizedType", (Object[])new Object[]{pit, annotatedClass, injectionPoint, injectionType, classLoader, claim});
        }
        Throwable configException = null;
        Type rawType = injectionType.getRawType();
        Type returnType = injectionType.getActualTypeArguments()[0];
        if (Provider.class.isAssignableFrom((Class)rawType)) {
            configException = this.validateInjectionPoint(injectionPoint, returnType, returnType, classLoader, false, claim);
        } else if (Optional.class.isAssignableFrom((Class)rawType)) {
            Type[] aTypes = injectionType.getActualTypeArguments();
            returnType = aTypes[0];
            Type type = returnType;
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (!(ClaimValue.class.isAssignableFrom((Class)type) || ((ApplicationScoped[])annotatedClass.getAnnotationsByType(ApplicationScoped.class)).length == 0 && ((SessionScoped[])annotatedClass.getAnnotationsByType(SessionScoped.class)).length == 0)) {
                String translatedMsg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_SCOPE_FOR_RAW_TYPE", (Object[])new Object[]{injectionPoint});
                pit.addDefinitionError((Throwable)new DeploymentException(translatedMsg));
            } else {
                configException = this.validateInjectionPoint(injectionPoint, returnType, injectionType, classLoader, true, claim);
            }
        } else {
            if (returnType instanceof ParameterizedType) {
                returnType = ((ParameterizedType)returnType).getRawType();
            }
            if (!(ClaimValue.class.isAssignableFrom((Class)rawType) || ((ApplicationScoped[])annotatedClass.getAnnotationsByType(ApplicationScoped.class)).length == 0 && ((SessionScoped[])annotatedClass.getAnnotationsByType(SessionScoped.class)).length == 0)) {
                String translatedMsg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_SCOPE_FOR_RAW_TYPE", (Object[])new Object[]{injectionPoint});
                pit.addDefinitionError((Throwable)new DeploymentException(translatedMsg));
            } else {
                configException = this.validateInjectionPoint(injectionPoint, returnType, injectionType, classLoader, false, claim);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processParameterizedType", (Object)configException);
        }
        return configException;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private Throwable validateInjectionPoint(InjectionPoint injectionPoint, Type conversionType, Type injectionType, ClassLoader classLoader, boolean optional, Claim claim) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateInjectionPoint", (Object[])new Object[]{injectionPoint, conversionType, injectionType, classLoader, optional, claim});
        }
        Throwable configException = null;
        Type rawInjectionType = injectionType;
        if (injectionType instanceof ParameterizedType) {
            rawInjectionType = ((ParameterizedType)injectionType).getRawType();
        }
        try {
            Set<Type> injectionTypesForQualifier = this.injectionTypes.get(claim);
            if (injectionTypesForQualifier == null) {
                injectionTypesForQualifier = new HashSet<Type>();
                this.injectionTypes.put(claim, injectionTypesForQualifier);
            }
            injectionTypesForQualifier.add(injectionType);
        }
        catch (Throwable injectionTypesForQualifier) {
            void e;
            FFDCFilter.processException((Throwable)injectionTypesForQualifier, (String)"com.ibm.ws.security.mp.jwt.cdi.JwtCDIExtension", (String)"230", (Object)this, (Object[])new Object[]{injectionPoint, conversionType, injectionType, classLoader, optional, claim});
            configException = e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateInjectionPoint", configException);
        }
        return configException;
    }

    @ManualTrace
    private void addClaimBean(AfterBeanDiscovery abd, BeanManager beanManager, Type type, Claim claim) throws ClaimTypeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addClaimBean", (Object[])new Object[]{abd, beanManager, type, claim});
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!clazz.isPrimitive()) {
                this.addClaimBean(abd, beanManager, type, clazz, claim);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.addClaimBean(abd, beanManager, pType, claim);
        } else {
            throw new ClaimTypeException(Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_INJECTION_TYPE", (Object[])new Object[]{type}));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addClaimBean");
        }
    }

    @ManualTrace
    private void addClaimBean(AfterBeanDiscovery abd, BeanManager beanManager, ParameterizedType type, Claim claim) throws ClaimTypeException {
        Type rawInjectionType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addClaimBean", (Object[])new Object[]{abd, beanManager, type, claim});
        }
        if (!((rawInjectionType = type.getRawType()) instanceof Class)) {
            throw new ClaimTypeException(Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CDI_INVALID_INJECTION_TYPE", (Object[])new Object[]{type}));
        }
        Class clazz = (Class)rawInjectionType;
        this.addClaimBean(abd, beanManager, type, clazz, claim);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addClaimBean");
        }
    }

    @ManualTrace
    private <T> void addClaimBean(AfterBeanDiscovery abd, BeanManager beanManager, Type beanType, Class<T> clazz, Claim claim) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addClaimBean", (Object[])new Object[]{abd, beanManager, beanType, clazz, claim});
        }
        ClaimBean<T> converterBean = new ClaimBean<T>(beanManager, beanType, clazz, claim);
        abd.addBean(converterBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addClaimBean");
        }
    }

    @ManualTrace
    public void processInjectionPoint(@Observes ProcessInjectionPoint<?, JsonWebToken> pip, BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processInjectionPoint", (Object[])new Object[]{pip, beanManager});
        }
        this.addJsonWebTokenBean = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processInjectionPoint");
        }
    }
}

