/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.ContractComparator;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public final class MicroProfileClientProviderFactory
extends ProviderFactory {
    static final String CLIENT_FACTORY_NAME = MicroProfileClientProviderFactory.class.getName();
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);
    private final Comparator<ProviderInfo<?>> comparator;

    private MicroProfileClientProviderFactory(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        super(bus);
        this.comparator = comparator;
    }

    public static MicroProfileClientProviderFactory createInstance(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        MicroProfileClientProviderFactory factory = new MicroProfileClientProviderFactory(bus, comparator);
        ProviderFactory.initFactory((ProviderFactory)factory);
        factory.setBusProviders();
        return factory;
    }

    public static MicroProfileClientProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return MicroProfileClientProviderFactory.getInstance(e);
    }

    public static MicroProfileClientProviderFactory getInstance(Endpoint e) {
        return (MicroProfileClientProviderFactory)((Object)e.get((Object)CLIENT_FACTORY_NAME));
    }

    static Comparator<ProviderInfo<?>> createComparator(MicroProfileClientFactoryBean bean) {
        Comparator parent = ProviderFactory::compareCustomStatus;
        return new ContractComparator(bean, parent);
    }

    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo provider : theProviders) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider());
            if (!ResponseExceptionMapper.class.isAssignableFrom(providerCls)) continue;
            this.addProviderToList(this.responseExceptionMappers, provider);
        }
        this.responseExceptionMappers.sort(this.comparator);
        this.injectContextProxies(new Collection[]{this.responseExceptionMappers});
    }

    public List<ResponseExceptionMapper<?>> createResponseExceptionMapper(Message m, Class<?> paramType) {
        if (this.responseExceptionMappers.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.responseExceptionMappers.stream().map(ProviderInfo::getProvider).sorted(new ResponseExceptionMapperComparator()).collect(Collectors.toList()));
    }

    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
    }

    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    private class ResponseExceptionMapperComparator
    implements Comparator<ResponseExceptionMapper<?>> {
        private ResponseExceptionMapperComparator() {
        }

        @Override
        public int compare(ResponseExceptionMapper<?> oLeft, ResponseExceptionMapper<?> oRight) {
            return oLeft.getPriority() - oRight.getPriority();
        }
    }
}

