/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C> {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurableImpl.class);
    private static final Class<?>[] RESTRICTED_CLASSES_IN_SERVER = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class};
    private static final Class<?>[] RESTRICTED_CLASSES_IN_CLIENT = new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class};
    private ConfigurationImpl config;
    private final C configurable;
    private final Class<?>[] restrictedContractTypes;
    static final long serialVersionUID = 2764948436776149439L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, RuntimeType rt) {
        this(configurable, new ConfigurationImpl(rt));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, rt});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, Configuration config) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, config});
        }
        this.configurable = configurable;
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config);
        Class<?>[] classArray = this.restrictedContractTypes = RuntimeType.CLIENT.equals((Object)config.getRuntimeType()) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, RuntimeType rt, Class<?>[] supportedProviderClasses) {
        this(configurable, rt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, rt, supportedProviderClasses});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses, Configuration config) {
        this(configurable, config);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, supportedProviderClasses, config});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static Class<?>[] getImplementedContracts(Object provider, Class<?>[] restrictedClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", new Object[]{provider, restrictedClasses});
        }
        Class<?> providerClass = provider instanceof Class ? (Class<?>)provider : provider.getClass();
        Set interfaces = Arrays.stream(providerClass.getInterfaces()).collect(Collectors.toSet());
        for (providerClass = providerClass.getSuperclass(); providerClass != null && providerClass != Object.class; providerClass = providerClass.getSuperclass()) {
            interfaces.addAll(Arrays.stream(providerClass.getInterfaces()).collect(Collectors.toSet()));
        }
        List<Class> implementedContracts = interfaces.stream().filter(el -> Arrays.stream(restrictedClasses).noneMatch(el::equals)).collect(Collectors.toList());
        Class[] classArray = implementedContracts.toArray(new Class[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected C getConfigurable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", new Object[0]);
        }
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Configuration getConfiguration() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", new Object[0]);
        }
        ConfigurationImpl configurationImpl = this.config;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            configurationImpl = configurationImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", configurationImpl);
        }
        return configurationImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C property(String name, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", new Object[]{name, value});
        }
        this.config.setProperty(name, value);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider});
        }
        C c = this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, bindingPriority});
        }
        C c = this.doRegister(provider, bindingPriority, ConfigurableImpl.getImplementedContracts(provider, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegister(provider, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegister(provider, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass});
        }
        C c = this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, bindingPriority});
        }
        C c = this.doRegister(this.getInstantiator().create(providerClass), bindingPriority, ConfigurableImpl.getImplementedContracts(providerClass, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.doRegister(providerClass, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.register(this.getInstantiator().create(providerClass), contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Instantiator getInstantiator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", new Object[0]);
        }
        Instantiator instantiator = ConfigurationImpl::createProvider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            instantiator = instantiator;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", instantiator);
        }
        return instantiator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", new Object[]{provider, bindingPriority, contracts});
        }
        if (contracts == null || contracts.length == 0) {
            LOG.warning("Null, empty or invalid contracts specified for " + provider + "; ignoring.");
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        C c = this.doRegister(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegister(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", new Object[]{provider, contracts});
        }
        if (!this.checkConstraints(provider)) {
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        this.config.register(provider, contracts);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean checkConstraints(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", new Object[]{provider});
        }
        Class<?> providerClass = provider.getClass();
        ConstrainedTo providerConstraint = providerClass.getAnnotation(ConstrainedTo.class);
        if (providerConstraint != null) {
            Class<?>[] restrictedInterfaces;
            RuntimeType currentRuntime = this.config.getRuntimeType();
            RuntimeType providerRuntime = providerConstraint.value();
            if (!providerRuntime.equals((Object)currentRuntime)) {
                LOG.warning("Provider " + provider + " cannot be registered in this " + currentRuntime + " runtime because it is constrained to " + providerRuntime + " runtimes.");
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
                }
                return bl;
            }
            for (Class<?> restrictedContract : restrictedInterfaces = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER) {
                if (!restrictedContract.isAssignableFrom(providerClass)) continue;
                RuntimeType opposite = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RuntimeType.SERVER : RuntimeType.CLIENT;
                LOG.warning("Provider " + providerClass.getName() + " is invalid - it is constrained to " + providerRuntime + " runtimes but implements a " + opposite + " interface ");
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
        }
        return bl;
    }

    public static interface Instantiator {
        public <T> Object create(Class<T> var1);
    }
}

