/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.utility;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.messaging.security.MessagingSecurityConstants;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImpl;
import com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;

public class MessagingSecurityUtility
implements MessagingSecurityConstants {
    private static TraceComponent tc = SibTr.register(MessagingAuthorizationServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.utility.MessagingSecurityUtility";
    private static SubjectHelper subjectHelper = new SubjectHelper();

    public static AuthenticationData createAuthenticationData(String userName, UserRegistry userRegistry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)userName);
        }
        WSAuthenticationData authData = new WSAuthenticationData();
        if (userName == null) {
            userName = "";
        }
        String realm = MessagingSecurityUtility.getDefaultRealm(userRegistry);
        authData.set("USERNAME", (Object)userName);
        authData.set("REALM", (Object)realm);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)authData);
        }
        return authData;
    }

    public static AuthenticationData createAuthenticationData(byte[] token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)token);
        }
        WSAuthenticationData authData = new WSAuthenticationData();
        authData.set("TOKEN", (Object)token);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)authData);
        }
        return authData;
    }

    public static AuthenticationData createAuthenticationData(String userName, String password) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)new Object[]{userName, "Password Not Traced"});
        }
        WSAuthenticationData authData = new WSAuthenticationData();
        if (userName == null) {
            userName = "";
        }
        if (password == null) {
            password = "";
        }
        authData.set("USERNAME", (Object)userName);
        authData.set("PASSWORD", (Object)new ProtectedString(password.toCharArray()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)authData);
        }
        return authData;
    }

    public static AuthenticationData createAuthenticationData(Certificate[] certs, UserRegistry userRegistry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)certs);
        }
        WSAuthenticationData authData = new WSAuthenticationData();
        X509Certificate[] _certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (!(certs[i] instanceof X509Certificate)) {
                _certs = null;
                break;
            }
            _certs[i] = (X509Certificate)certs[i];
        }
        authData.set("CERTCHAIN", (Object)_certs);
        authData.set("REALM", (Object)MessagingSecurityUtility.getDefaultRealm(userRegistry));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitycreateAuthenticationData", (Object)authData);
        }
        return authData;
    }

    private static String getDefaultRealm(UserRegistry _userRegistry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitygetDefaultRealm");
        }
        String realm = "DEFAULT";
        if (_userRegistry != null) {
            realm = _userRegistry.getRealm();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitygetDefaultRealm", (Object)realm);
        }
        return realm;
    }

    public static String getUniqueUserName(Subject subject) throws MessagingSecurityException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitygetUniqueUserName", (Object)subject);
        }
        if (subject == null) {
            return null;
        }
        WSCredential cred = subjectHelper.getWSCredential(subject);
        String userName = null;
        if (cred != null) {
            try {
                userName = cred.getSecurityName();
            }
            catch (CredentialException ce) {
                throw new MessagingSecurityException((Throwable)ce);
            }
            catch (CredentialDestroyedException e) {
                throw new MessagingSecurityException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilitygetUniqueUserName", (Object)userName);
        }
        return userName;
    }

    public static List<String> getGroupsAssociatedToUser(String userName, MessagingSecurityServiceImpl messagingSecurityService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilityconstructor", (Object)messagingSecurityService);
        }
        List<String> groupsAssociatedWithUser = new ArrayList<String>();
        UserRegistryService userRegistryService = messagingSecurityService.getSecurityService().getUserRegistryService();
        try {
            UserRegistry userRegistry = userRegistryService.getUserRegistry();
            groupsAssociatedWithUser = userRegistry.getGroupsForUser(userName);
        }
        catch (RegistryException registryException) {
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilityconstructor", (Object)messagingSecurityService);
        }
        return groupsAssociatedWithUser;
    }

    public static boolean isUnauthenticated(Subject subject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilityisUnauthenticated", (Object)subject);
        }
        boolean result = subjectHelper.isUnauthenticated(subject);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.utility.MessagingSecurityUtilityisUnauthenticated", (Object)result);
        }
        return result;
    }
}

