/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServiceInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    static final long serialVersionUID = 4343655443914826945L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServiceInvokerInterceptor() {
        super("invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void handleMessage(final Message message) {
        final Exchange exchange = message.getExchange();
        Endpoint endpoint = exchange.getEndpoint();
        Service service = endpoint.getService();
        final Invoker invoker = service.getInvoker();
        Runnable invocation = new Runnable(){
            static final long serialVersionUID = -4344071051335176156L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                Exchange runableEx = message.getExchange();
                Message outMessage = null;
                if (!exchange.isOneWay()) {
                    Endpoint ep = exchange.getEndpoint();
                    outMessage = runableEx.getOutMessage();
                    if (outMessage == null) {
                        outMessage = new MessageImpl(16, 1.0f);
                        outMessage.setExchange(exchange);
                        outMessage = ep.getBinding().createMessage(outMessage);
                        exchange.setOutMessage(outMessage);
                    }
                    ServiceInvokerInterceptor.this.copyJaxwsProperties(message, outMessage);
                }
                Object result = invoker.invoke(runableEx, ServiceInvokerInterceptor.this.getInvokee(message));
                if (!exchange.isOneWay() && result != null) {
                    MessageContentsList resList = null;
                    if (result instanceof MessageContentsList) {
                        resList = (MessageContentsList)result;
                    } else if (result instanceof List) {
                        resList = new MessageContentsList((List)result);
                    } else if (result.getClass().isArray()) {
                        resList = new MessageContentsList((Object[])result);
                    } else {
                        outMessage.setContent(Object.class, result);
                    }
                    if (resList != null) {
                        outMessage.setContent(List.class, resList);
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        Executor executor = this.getExecutor(endpoint);
        Executor executor2 = exchange.get(Executor.class);
        if (executor2 == executor || executor == null || !(message.getInterceptorChain() instanceof PhaseInterceptorChain)) {
            invocation.run();
        } else {
            exchange.put(Executor.class, executor);
            final PhaseInterceptorChain chain = (PhaseInterceptorChain)message.getInterceptorChain();
            final AtomicBoolean contextSwitched = new AtomicBoolean();
            FutureTask<Object> o = new FutureTask<Object>(invocation, null){
                static final long serialVersionUID = 4052946791379362900L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                protected void done() {
                    super.done();
                    if (contextSwitched.get()) {
                        PhaseInterceptorChain.setCurrentMessage(chain, null);
                        message.remove("thread.context.switched");
                    }
                    chain.releaseChain();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (PhaseInterceptorChain.setCurrentMessage(chain, message)) {
                        contextSwitched.set(true);
                        message.put("thread.context.switched", true);
                    }
                    PhaseInterceptorChain phaseInterceptorChain = chain;
                    synchronized (phaseInterceptorChain) {
                        super.run();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
            PhaseInterceptorChain phaseInterceptorChain = chain;
            synchronized (phaseInterceptorChain) {
                executor.execute(o);
                chain.releaseAndAcquireChain();
            }
            try {
                o.get();
            }
            catch (InterruptedException interruptedException) {
                void e;
                FFDCFilter.processException((Throwable)interruptedException, (String)"org.apache.cxf.interceptor.ServiceInvokerInterceptor", (String)"158", (Object)this, (Object[])new Object[]{message});
                throw new Fault((Throwable)e);
            }
            catch (ExecutionException e) {
                FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.interceptor.ServiceInvokerInterceptor", (String)"160", (Object)this, (Object[])new Object[]{message});
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new Fault(e.getCause());
            }
        }
    }

    private Object getInvokee(Message message) {
        Object invokee = message.getContent(List.class);
        if (invokee == null) {
            invokee = message.getContent(Object.class);
        }
        return invokee;
    }

    private Executor getExecutor(Endpoint endpoint) {
        return endpoint.getService().getExecutor();
    }

    private void copyJaxwsProperties(Message inMsg, Message outMsg) {
        outMsg.put("javax.xml.ws.wsdl.operation", inMsg.get("javax.xml.ws.wsdl.operation"));
        outMsg.put("javax.xml.ws.wsdl.service", inMsg.get("javax.xml.ws.wsdl.service"));
        outMsg.put("javax.xml.ws.wsdl.interface", inMsg.get("javax.xml.ws.wsdl.interface"));
        outMsg.put("javax.xml.ws.wsdl.port", inMsg.get("javax.xml.ws.wsdl.port"));
        outMsg.put("javax.xml.ws.wsdl.description", inMsg.get("javax.xml.ws.wsdl.description"));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceInvokerInterceptor.class);
    }
}

