/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cloudant.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.websphere.security.auth.data.AuthDataProvider;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.cloudant.internal.ClientKey;
import com.ibm.ws.cloudant.internal.CloudantApplicationListener;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CloudantService
implements ApplicationRecycleComponent,
LibraryChangeListener,
ResourceFactory {
    private static final String URL = "url";
    private static final String ACCOUNT = "account";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String USERNAME = "username";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_URL = "proxyURL";
    private static final String READ_TIMEOUT = "readTimeout";
    private static final String PASSWORD = "password";
    private static final String MAX_CONNECTIONS = "maxConnections";
    private static final String CONNECT_TIMEOUT = "connectTimeout";
    private static final String SSL_SOCKET_FACTORY = "customSSLSocketFactory";
    private static final String DISABLE_SSL_AUTHENTICATION = "disableSSLAuthentication";
    private static final TraceComponent tc = Tr.register(CloudantService.class, (String)"cloudant", (String)"com.ibm.ws.cloudant.internal.resources.Messages");
    private static final String CLOUDANT_CLIENT_OPTIONS_BUILDER_CLS_STR = "com.cloudant.client.api.ClientBuilder";
    private static final String AUTHENTICATION_ALIAS_LOGIN_NAME = "DefaultPrincipalMapping";
    private CloudantApplicationListener appListener;
    private ClassLoaderIdentifierService classLoaderIdSvc;
    private static final String CONFIG_ID = "config.displayId";
    private final ConcurrentMap<ClientKey, Object> clients = new ConcurrentHashMap<ClientKey, Object>();
    private ComponentContext componentContext;
    private final AtomicServiceReference<AuthData> containerAuthDataRef = new AtomicServiceReference("containerAuthData");
    private Library library;
    private boolean loadFromApp;
    private final AtomicServiceReference<Object> sslConfig = new AtomicServiceReference("ssl");
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, Object> props;
    private String cloudantConfigIdentifier;
    static final long serialVersionUID = -5703317278389474670L;

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.componentContext = context;
        this.containerAuthDataRef.activate(context);
        this.sslConfig.activate(context);
        this.props = props;
        this.cloudantConfigIdentifier = (String)props.get("jndiName");
        if (this.cloudantConfigIdentifier == null || "".equals(this.cloudantConfigIdentifier)) {
            this.cloudantConfigIdentifier = (String)props.get(CONFIG_ID);
        }
        this.loadFromApp = Boolean.parseBoolean((String)props.get("ibm.internal.nonship.function")) && "ibm.internal.simulate.no.library.do.not.ship".equals(this.library.id());
    }

    protected void deactivate(ComponentContext context) {
        this.appListener.unregister(this);
        if (!this.clients.isEmpty()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 7335105191162901496L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    Method shutdown = null;
                    for (Object client : CloudantService.this.clients.values()) {
                        try {
                            if (shutdown == null) {
                                shutdown = client.getClass().getMethod("shutdown", new Class[0]);
                            }
                            shutdown.invoke(client, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cloudant.internal.CloudantService$1", (String)"214", (Object)this, (Object[])new Object[0]);
                        }
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        this.containerAuthDataRef.deactivate(context);
        this.sslConfig.deactivate(context);
    }

    public Object createResource(ResourceInfo info) throws Exception {
        if (info == null) {
            throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"direct.lookup.CWWKD0301E", (Object[])new Object[]{this.cloudantConfigIdentifier}));
        }
        return this.createResource(null, false, info.getAuth(), info.getLoginPropertyList());
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={InvocationTargetException.class, PrivilegedActionException.class})
    Object createResource(String databaseName, boolean createDatabase, int resAuth, List<? extends ResourceInfo.Property> loginPropertyList) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        try {
            void var9_21;
            String appClassLoaderId;
            ClassLoader appClassLoader;
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cData != null) {
                this.applications.add(cData.getJ2EEName().getApplication());
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(this.cloudantConfigIdentifier + " accessed by " + cData), (Object[])new Object[0]);
            }
            AuthData containerAuthData = null;
            if (resAuth == 0) {
                if (!loginPropertyList.isEmpty()) {
                    for (ResourceInfo.Property property : loginPropertyList) {
                        if (!property.getName().equals(AUTHENTICATION_ALIAS_LOGIN_NAME)) continue;
                        String authAliasName = property.getValue();
                        containerAuthData = AuthDataProvider.getAuthData((String)authAliasName);
                        if (!trace || !tc.isDebugEnabled()) break;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("resource ref container auth alias " + authAliasName), (Object[])new Object[]{containerAuthData});
                        break;
                    }
                }
                if (containerAuthData == null) {
                    containerAuthData = (AuthData)this.containerAuthDataRef.getService();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("default container auth " + containerAuthData), (Object[])new Object[0]);
                    }
                }
            }
            String userName = containerAuthData == null ? (String)this.props.get(USERNAME) : containerAuthData.getUserName();
            Object var9_16 = null;
            if (containerAuthData == null) {
                SerializableProtectedString protectedPwd = (SerializableProtectedString)this.props.get(PASSWORD);
                if (protectedPwd != null) {
                    String string2 = String.valueOf(protectedPwd.getChars());
                    string2 = PasswordUtil.getCryptoAlgorithm((String)string2) == null ? string2 : PasswordUtil.decode((String)string2);
                }
            } else {
                String string = String.valueOf(containerAuthData.getPassword());
            }
            if (this.loadFromApp) {
                appClassLoader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                    static final long serialVersionUID = 61001025488522626L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
                if (appClassLoader == null) {
                    throw new ClassNotFoundException(Tr.formatMessage((TraceComponent)tc, (String)"class.not.found.CWWKD0302E", (Object[])new Object[]{CLOUDANT_CLIENT_OPTIONS_BUILDER_CLS_STR, this.cloudantConfigIdentifier}));
                }
                appClassLoaderId = this.classLoaderIdSvc.getClassLoaderIdentifier(appClassLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"classloader identifier", (Object[])new Object[]{appClassLoaderId, appClassLoader});
                }
                if (appClassLoaderId == null) {
                    throw new ClassNotFoundException(Tr.formatMessage((TraceComponent)tc, (String)"class.not.found.CWWKD0302E", (Object[])new Object[]{CLOUDANT_CLIENT_OPTIONS_BUILDER_CLS_STR, this.cloudantConfigIdentifier}));
                }
            } else {
                appClassLoader = null;
                appClassLoaderId = null;
            }
            if (databaseName == null) {
                return this.createClientBuilder(appClassLoader, userName, (String)var9_21);
            }
            final ClientKey key = new ClientKey(appClassLoaderId, userName, (String)var9_21);
            Object client = this.clients.get(key);
            if (client == null) {
                final Object builder = this.createClientBuilder(appClassLoader, userName, (String)var9_21);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("creating Cloudant client with " + builder), (Object[])new Object[0]);
                }
                client = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -738599050185145342L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @Trivial
                    public Object run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                        Object newClient = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                        Object existingClient = CloudantService.this.clients.putIfAbsent(key, newClient);
                        if (existingClient == null) {
                            if (key.getApplicationClassLoaderIdentifier() != null) {
                                CloudantService.this.appListener.register(CloudantService.this, CloudantService.this.clients);
                            }
                            return newClient;
                        }
                        newClient.getClass().getMethod("shutdown", new Class[0]).invoke(newClient, new Object[0]);
                        return existingClient;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class);
                    }
                });
            }
            return client.getClass().getMethod("database", String.class, Boolean.TYPE).invoke(client, databaseName, createDatabase);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"224", (Object)this, (Object[])new Object[]{createDatabase, databaseName, resAuth, loginPropertyList});
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw x;
        }
        catch (PrivilegedActionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            FFDCFilter.processException((Throwable)cause, (String)this.getClass().getName(), (String)"228", (Object)this, (Object[])new Object[]{createDatabase, databaseName, resAuth, loginPropertyList});
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw x;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.cloudant.internal.CloudantService", (String)"374", (Object)this, (Object[])new Object[]{databaseName, createDatabase, resAuth, loginPropertyList});
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.cloudant.internal.CloudantService", (String)"377", (Object)this, (Object[])new Object[]{databaseName, createDatabase, resAuth, loginPropertyList});
            throw x;
        }
    }

    private Object createClientBuilder(ClassLoader loader, String userName, @Sensitive String password) throws Exception {
        Boolean disableSSLAuthentication;
        SerializableProtectedString proxyPass;
        String proxyUser;
        if (loader == null) {
            loader = this.library.getClassLoader();
        }
        Class<?> cloudantClientOptionsBuilderCls = loader.loadClass(CLOUDANT_CLIENT_OPTIONS_BUILDER_CLS_STR);
        Object builderInstance = this.newInstance(cloudantClientOptionsBuilderCls);
        if (userName != null) {
            this.set(cloudantClientOptionsBuilderCls, builderInstance, USERNAME, String.class, userName);
        }
        if (password != null) {
            this.set(cloudantClientOptionsBuilderCls, builderInstance, PASSWORD, String.class, password);
        }
        Integer maxConn = (Integer)this.props.get(MAX_CONNECTIONS);
        this.set(cloudantClientOptionsBuilderCls, builderInstance, MAX_CONNECTIONS, Integer.TYPE, maxConn);
        Long connectTimeout = (Long)this.props.get(CONNECT_TIMEOUT);
        this.set(cloudantClientOptionsBuilderCls, builderInstance, CONNECT_TIMEOUT, Long.TYPE, connectTimeout);
        Long readTimeout = (Long)this.props.get(READ_TIMEOUT);
        this.set(cloudantClientOptionsBuilderCls, builderInstance, READ_TIMEOUT, Long.TYPE, readTimeout);
        String proxyUrl = (String)this.props.get(PROXY_URL);
        if (proxyUrl != null) {
            this.set(cloudantClientOptionsBuilderCls, builderInstance, PROXY_URL, URL.class, AccessController.doPrivileged(new ConstructURLAction(proxyUrl)));
        }
        if ((proxyUser = (String)this.props.get(PROXY_USER)) != null) {
            this.set(cloudantClientOptionsBuilderCls, builderInstance, PROXY_USER, String.class, proxyUser);
        }
        if ((proxyPass = (SerializableProtectedString)this.props.get(PROXY_PASSWORD)) != null) {
            String pwdStr = String.valueOf(proxyPass.getChars());
            pwdStr = PasswordUtil.getCryptoAlgorithm((String)pwdStr) == null ? pwdStr : PasswordUtil.decode((String)pwdStr);
            this.set(cloudantClientOptionsBuilderCls, builderInstance, PROXY_PASSWORD, String.class, pwdStr);
        }
        if ((disableSSLAuthentication = (Boolean)this.props.get(DISABLE_SSL_AUTHENTICATION)).booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"disableSSLAuthentication()", (Object[])new Object[0]);
            }
            cloudantClientOptionsBuilderCls.getMethod(DISABLE_SSL_AUTHENTICATION, new Class[0]).invoke(builderInstance, new Object[0]);
        } else {
            SSLSocketFactory sslSF = this.getSSLSocketFactory();
            if (sslSF != null) {
                this.set(cloudantClientOptionsBuilderCls, builderInstance, SSL_SOCKET_FACTORY, SSLSocketFactory.class, sslSF);
            }
        }
        return builderInstance;
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> appsToStop = new HashSet<String>(this.applications);
        this.applications.clear();
        return appsToStop;
    }

    private Object newInstance(Class<?> clazz) throws Exception {
        Object clientBuilder = null;
        String account = (String)this.props.get(ACCOUNT);
        if (account != null && account.length() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("creating Cloudant client based on account:" + account), (Object[])new Object[0]);
            }
            Method m = clazz.getMethod(ACCOUNT, String.class);
            clientBuilder = m.invoke(null, account);
        } else {
            String url = (String)this.props.get(URL);
            if (url != null && url.length() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("creating Cloudant ClientBuilder based on url:" + url), (Object[])new Object[0]);
                }
                Method m = clazz.getMethod(URL, URL.class);
                clientBuilder = m.invoke(null, AccessController.doPrivileged(new ConstructURLAction(url)));
            } else {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"error.cloudant.config.CWWKD0300E", (Object[])new Object[]{this.cloudantConfigIdentifier}));
            }
        }
        return clientBuilder;
    }

    @Trivial
    private <T> void set(Class<?> clazz, Object clientBuilder, String name, Class<T> type, T value) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(name + '(' + (name.endsWith("ssword") ? "***" : value) + ')'), (Object[])new Object[0]);
        }
        if (type == Long.TYPE && (READ_TIMEOUT.equals(name) || CONNECT_TIMEOUT.equals(name))) {
            Method m = clazz.getMethod(name, type, TimeUnit.class);
            m.invoke(clientBuilder, new Object[]{value, TimeUnit.MILLISECONDS});
        } else {
            Method m = clazz.getMethod(name, type);
            m.invoke(clientBuilder, value);
        }
    }

    public void libraryNotification() {
        if (!this.applications.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"recycle applications", (Object[])new Object[]{this.applications});
            }
            ApplicationRecycleCoordinator appRecycleCoord = (ApplicationRecycleCoordinator)this.componentContext.locateService("appRecycleCoordinator");
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            appRecycleCoord.recycleApplications(members);
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws Exception {
        SSLSocketFactory sslSF = null;
        Object sslConfig = this.sslConfig.getService();
        if (sslConfig != null) {
            Class<?> SSLHelper2 = Class.forName("com.ibm.ws.cloudant.internal.SSLHelper");
            sslSF = (SSLSocketFactory)SSLHelper2.getMethod("getSSLSocketFactory", Object.class).invoke(null, sslConfig);
        }
        return sslSF;
    }

    protected void setAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    protected void unsetAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    protected void setAppListener(ApplicationStateListener svc) {
        this.appListener = (CloudantApplicationListener)svc;
    }

    protected void unsetAppListener(ApplicationStateListener svc) {
        this.appListener = null;
    }

    protected void setClassLoaderIdentifier(ClassLoaderIdentifierService svc) {
        this.classLoaderIdSvc = svc;
    }

    protected void unsetClassLoaderIdentifier(ClassLoaderIdentifierService svc) {
        this.classLoaderIdSvc = null;
    }

    protected void setContainerAuthData(ServiceReference<AuthData> ref) {
        this.containerAuthDataRef.setReference(ref);
    }

    protected void unsetContainerAuthData(ServiceReference<AuthData> ref) {
        this.containerAuthDataRef.unsetReference(ref);
    }

    protected void setLibrary(Library svc) {
        this.library = svc;
    }

    protected void unsetLibrary(Library svc) {
        this.library = null;
    }

    protected void setSsl(ServiceReference<Object> ref) {
        this.sslConfig.setReference(ref);
    }

    protected void unsetSsl(ServiceReference<Object> ref) {
        this.sslConfig.unsetReference(ref);
    }

    @Trivial
    private static class ConstructURLAction
    implements PrivilegedExceptionAction<URL> {
        private final String url;

        private ConstructURLAction(String url) {
            this.url = url;
        }

        @Override
        public URL run() throws MalformedURLException {
            return new URL(this.url);
        }
    }
}

