/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.PropertiesUtils;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.SchemaPerMultitenantPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.StaticWeaveInfo;
import org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.AttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.CollectionAttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.ListAttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.MapAttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.SetAttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.metamodel.proxy.SingularAttributeProxyImpl;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.jpa.metadata.FileBasedProjectCache;
import org.eclipse.persistence.jpa.metadata.MetadataSource;
import org.eclipse.persistence.jpa.metadata.ProjectCache;
import org.eclipse.persistence.jpa.metadata.XMLMetadataSource;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.database.events.DatabaseEventListener;
import org.eclipse.persistence.platform.database.partitioning.DataPartitioningCallback;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.MetadataRefreshListener;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSPublishingTransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.remote.rmi.RMIConnection;
import org.eclipse.persistence.sessions.remote.rmi.RMIServerSessionManager;
import org.eclipse.persistence.sessions.remote.rmi.RMIServerSessionManagerDispatcher;
import org.eclipse.persistence.sessions.serializers.JavaSerializer;
import org.eclipse.persistence.sessions.serializers.Serializer;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceMonitor;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.QueryMonitor;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.tuning.SafeModeTuner;
import org.eclipse.persistence.tools.tuning.SessionTuner;
import org.eclipse.persistence.tools.tuning.StandardTuner;

public class EntityManagerSetupImpl
implements MetadataRefreshListener {
    protected String persistenceUnitUniqueName;
    protected String sessionName;
    protected MetadataProcessor processor = null;
    protected PersistenceWeaver weaver = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected int factoryCount = 0;
    protected AbstractSession session = null;
    protected boolean isInContainerMode = false;
    protected boolean isSessionLoadedFromSessionsXML = false;
    protected ProjectCache projectCacheAccessor = null;
    protected boolean shouldBuildProject = true;
    protected Boolean enableWeaving = null;
    protected boolean isWeavingStatic = false;
    protected StaticWeaveInfo staticWeaveInfo;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    protected ConcurrencyManager deployLock = new ConcurrencyManager();
    protected boolean requiresConnection;
    private Metamodel metaModel;
    protected List<StructConverter> structConverters = null;
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_HALF_DEPLOYED = "HalfDeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    public static final String STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER = "HalfPredeployedCompositeMember";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";
    public static String[] connectionPropertyNames = new String[]{"javax.persistence.transactionType", "javax.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "javax.persistence.jdbc.url", "javax.persistence.jdbc.user", "eclipselink.nosql.connection-spec", "eclipselink.nosql.connection-factory", "eclipselink.nosql.property.user", "eclipselink.jdbc.connector"};
    protected EntityManagerSetupImpl compositeEmSetupImpl;
    protected Set<EntityManagerSetupImpl> compositeMemberEmSetupImpls;
    PersistenceUnitProcessor.Mode mode;
    boolean throwExceptionOnFail;
    boolean weaveChangeTracking;
    boolean weaveLazy;
    boolean weaveEager;
    boolean weaveFetchGroups;
    boolean weaveInternal;
    boolean weaveRest;
    protected boolean isMetadataExpired = false;
    protected PersistenceException persistenceException;

    public EntityManagerSetupImpl(String persistenceUnitUniqueName, String sessionName) {
        this.persistenceUnitUniqueName = persistenceUnitUniqueName;
        this.sessionName = sessionName;
        this.requiresConnection = true;
    }

    public EntityManagerSetupImpl() {
        this("", "");
    }

    protected static String addFileSeperator(String appLocation) {
        int strLength = appLocation.length();
        if (appLocation.substring(strLength - 1, strLength).equals(File.separator)) {
            return appLocation;
        }
        return String.valueOf(appLocation) + File.separator;
    }

    public static String getOrBuildSessionName(Map properties, PersistenceUnitInfo puInfo, String persistenceUnitUniqueName) {
        String persistenceUnitName = EntityManagerSetupImpl.assertCompatiblePersistenceUnitName(persistenceUnitUniqueName);
        String sessionName = (String)properties.get("eclipselink.session-name");
        if (sessionName == null) {
            sessionName = (String)puInfo.getProperties().get("eclipselink.session-name");
        }
        if (sessionName != null && sessionName.length() > 0) {
            return sessionName;
        }
        String applicationId = (String)properties.get("weblogic.application-id");
        if (applicationId == null) {
            applicationId = (String)properties.get("eclipselink.application-id");
        }
        if (EntityManagerSetupImpl.isComposite(puInfo)) {
            if (applicationId != null) {
                return String.valueOf(applicationId) + persistenceUnitName;
            }
            return persistenceUnitName;
        }
        if (applicationId != null) {
            return String.valueOf(applicationId) + persistenceUnitName + EntityManagerSetupImpl.buildSessionNameSuffixFromConnectionProperties(properties);
        }
        return String.valueOf(persistenceUnitName) + EntityManagerSetupImpl.buildSessionNameSuffixFromConnectionProperties(properties);
    }

    private static String assertCompatiblePersistenceUnitName(String persistenceUnitUniqueName) {
        if (persistenceUnitUniqueName != null && !persistenceUnitUniqueName.startsWith("/")) {
            return String.valueOf('/') + persistenceUnitUniqueName;
        }
        return persistenceUnitUniqueName;
    }

    protected static String buildSessionNameSuffixFromConnectionProperties(Map properties) {
        StringBuilder suffix = new StringBuilder(32);
        int i = 0;
        while (i < connectionPropertyNames.length) {
            String name = connectionPropertyNames[i];
            Object value = properties.get(name);
            if (value != null) {
                String strValue = null;
                strValue = value instanceof String ? (String)value : (value instanceof DataSource ? Integer.toString(System.identityHashCode(value)) : (value instanceof PersistenceUnitTransactionType ? value.toString() : Integer.toString(System.identityHashCode(value))));
                if (strValue.length() > 0) {
                    suffix.append("_").append(Helper.getShortClassName(name)).append("=").append(strValue);
                }
            }
            ++i;
        }
        return suffix.toString();
    }

    public void changeSessionName(String newSessionName) {
        if (!this.session.getName().equals(newSessionName)) {
            this.session.log(1, "properties", "session_name_change", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), newSessionName});
            this.sessionName = newSessionName;
            this.session.setName(newSessionName);
        }
    }

    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            try {
                if (this.session.isDatabaseSession() && this.session.isConnected()) {
                    this.getDatabaseSession().logout();
                }
            }
            finally {
                SessionManager manager = SessionManager.getManager();
                manager.getSessions().remove(this.session.getName(), this.session);
                manager.destroy();
            }
        }
    }

    public AbstractSession deploy(ClassLoader realClassLoader, Map additionalProperties) {
        AbstractSession abstractSession;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED && this.state != STATE_HALF_DEPLOYED) {
            if (this.mustBeCompositeMember()) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state, (Exception)((Object)this.persistenceException)));
        }
        this.session.log(1, "jpa", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        ClassLoader classLoaderToUse = realClassLoader;
        if (additionalProperties.containsKey("eclipselink.classloader")) {
            classLoaderToUse = (ClassLoader)additionalProperties.get("eclipselink.classloader");
        } else if (this.processor != null && this.processor.getProject() != null && this.processor.getProject().hasVirtualClasses() && this.state == STATE_PREDEPLOYED && !(classLoaderToUse instanceof DynamicClassLoader)) {
            classLoaderToUse = new DynamicClassLoader(classLoaderToUse);
        }
        boolean isLockAcquired = false;
        try {
            Map deployProperties = EntityManagerFactoryProvider.mergeMaps(additionalProperties, this.persistenceUnitInfo.getProperties());
            this.updateTunerPreDeploy(deployProperties, classLoaderToUse);
            EntityManagerFactoryProvider.translateOldProperties(deployProperties, this.session);
            if (this.isComposite()) {
                this.updateCompositeMembersProperties(deployProperties);
            }
            if (this.state == STATE_PREDEPLOYED) {
                this.deployLock.acquire();
                isLockAcquired = true;
                if (this.state == STATE_PREDEPLOYED) {
                    if (this.shouldBuildProject && !this.isSessionLoadedFromSessionsXML) {
                        if (this.isComposite()) {
                            this.deployCompositeMembers(deployProperties, classLoaderToUse);
                        } else {
                            Map<String, Object> metadataProperties;
                            if (this.processor.getMetadataSource() != null && (metadataProperties = this.processor.getMetadataSource().getPropertyOverrides(deployProperties, classLoaderToUse, this.session.getSessionLog())) != null && !metadataProperties.isEmpty()) {
                                EntityManagerFactoryProvider.translateOldProperties(metadataProperties, this.session);
                                deployProperties = EntityManagerFactoryProvider.mergeMaps(metadataProperties, deployProperties);
                            }
                            this.processor.setClassLoader(classLoaderToUse);
                            this.processor.createDynamicClasses();
                            if (classLoaderToUse instanceof DynamicClassLoader) {
                                this.processor.createRestInterfaces();
                            }
                            this.processor.addEntityListeners();
                            if (this.projectCacheAccessor != null) {
                                this.projectCacheAccessor.storeProject(this.session.getProject(), deployProperties, this.session.getSessionLog());
                            }
                            this.session.getProject().convertClassNamesToClasses(classLoaderToUse);
                            if (!this.isCompositeMember()) {
                                this.addBeanValidationListeners(deployProperties, classLoaderToUse);
                            }
                            this.processor.processCustomizers();
                        }
                        this.processor = null;
                    } else {
                        this.session.getProject().convertClassNamesToClasses(classLoaderToUse);
                        if (!this.shouldBuildProject) {
                            if (!this.isCompositeMember()) {
                                this.addBeanValidationListeners(deployProperties, classLoaderToUse);
                            }
                            this.processDescriptorsFromCachedProject(classLoaderToUse);
                        }
                    }
                    this.finishProcessingDescriptorEvents(classLoaderToUse);
                    this.structConverters = this.getStructConverters(classLoaderToUse);
                    this.updateRemote(deployProperties, classLoaderToUse);
                    this.initSession();
                    if (this.session.getIntegrityChecker().hasErrors()) {
                        this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                    }
                    this.session.getDatasourcePlatform().getConversionManager().setLoader(classLoaderToUse);
                    this.state = STATE_HALF_DEPLOYED;
                } else {
                    this.deployLock.release();
                    isLockAcquired = false;
                    if (this.state == STATE_DEPLOY_FAILED) {
                        throw this.persistenceException;
                    }
                }
            }
            if (!this.isCompositeMember()) {
                if (this.session.isDatabaseSession() && !((DatabaseSessionImpl)this.session).isLoggedIn()) {
                    if (!isLockAcquired) {
                        this.deployLock.acquire();
                        isLockAcquired = true;
                    }
                    if (!((DatabaseSessionImpl)this.session).isLoggedIn()) {
                        if (this.state == STATE_DEPLOY_FAILED) {
                            throw this.persistenceException;
                        }
                        this.session.setProperties(deployProperties);
                        this.updateSession(deployProperties, classLoaderToUse);
                        if (this.isValidationOnly(deployProperties, false)) {
                            if (this.state == STATE_HALF_DEPLOYED) {
                                this.getDatabaseSession().initializeDescriptors();
                                this.state = STATE_DEPLOYED;
                            }
                        } else {
                            try {
                                this.updateTunerDeploy(deployProperties, classLoaderToUse);
                                this.updateFreeMemory(deployProperties);
                                if (this.isSessionLoadedFromSessionsXML) {
                                    this.getDatabaseSession().login();
                                } else {
                                    EntityManagerFactoryProvider.login(this.getDatabaseSession(), deployProperties, this.requiresConnection);
                                }
                                DatabasePlatform platform = this.getDatabaseSession().getPlatform();
                                PropertiesUtils.set(platform, "eclipselink.target-database-properties", (String)deployProperties.get("eclipselink.target-database-properties"));
                                if (this.session.hasExternalTransactionController() && this.session.getExternalTransactionController().getExceptionHandler() == null) {
                                    this.session.getExternalTransactionController().setExceptionHandler(new ExceptionHandler(){

                                        @Override
                                        public Object handleException(RuntimeException exception) {
                                            if (exception instanceof org.eclipse.persistence.exceptions.OptimisticLockException) {
                                                throw new OptimisticLockException((Throwable)exception);
                                            }
                                            if (exception instanceof EclipseLinkException) {
                                                throw new PersistenceException((Throwable)exception);
                                            }
                                            throw exception;
                                        }
                                    });
                                }
                                this.state = STATE_DEPLOYED;
                            }
                            catch (Throwable loginException) {
                                if (this.state == STATE_HALF_DEPLOYED && this.session.isConnected()) {
                                    try {
                                        this.getDatabaseSession().logout();
                                    }
                                    catch (Throwable throwable) {}
                                    this.state = STATE_DEPLOY_FAILED;
                                }
                                throw loginException;
                            }
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.addStructConverters();
                            }
                            this.writeDDL(deployProperties, this.getDatabaseSession(deployProperties), classLoaderToUse);
                        }
                    }
                    this.updateTunerPostDeploy(deployProperties, classLoaderToUse);
                    this.deployLock.release();
                    isLockAcquired = false;
                }
                try {
                    this.getMetamodel(classLoaderToUse);
                }
                catch (Exception e) {
                    this.session.log(1, "metamodel", "metamodel_init_failed", new Object[]{e.getMessage()});
                }
            }
            if (this.weaver != null) {
                this.weaver.clear();
                this.weaver = null;
            }
            abstractSession = this.session;
        }
        catch (Throwable exception) {
            try {
                if (this.state == STATE_PREDEPLOYED) {
                    this.state = STATE_DEPLOY_FAILED;
                }
                PersistenceException persistenceEx = this.state == STATE_DEPLOY_FAILED ? (exception == this.persistenceException ? new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state, (Exception)((Object)this.persistenceException))) : this.createDeployFailedPersistenceException(exception)) : (exception instanceof PersistenceException ? (PersistenceException)exception : new PersistenceException(exception));
                if (isLockAcquired) {
                    this.deployLock.release();
                }
                this.session.logThrowable(7, "ejb", exception);
                throw persistenceEx;
            }
            catch (Throwable throwable) {
                this.session.log(1, "jpa", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "jpa", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        return abstractSession;
    }

    private void processDescriptorsFromCachedProject(ClassLoader realClassLoader) throws ClassNotFoundException, PrivilegedActionException, IllegalAccessException, InstantiationException {
        for (ClassDescriptor descriptor : this.session.getProject().getDescriptors().values()) {
            if (descriptor.getDescriptorCustomizerClassName() == null) continue;
            Class listenerClass = EntityManagerSetupImpl.findClass(descriptor.getDescriptorCustomizerClassName(), realClassLoader);
            DescriptorCustomizer customizer = (DescriptorCustomizer)EntityManagerSetupImpl.buildObjectForClass(listenerClass, DescriptorCustomizer.class);
            try {
                customizer.customize(descriptor);
            }
            catch (Exception e) {
                this.session.getSessionLog().logThrowable(2, "metadata", e);
            }
        }
    }

    private void finishProcessingDescriptorEvents(ClassLoader realClassLoader) {
        for (ClassDescriptor descriptor : this.session.getProject().getDescriptors().values()) {
            if (!descriptor.hasEventManager()) continue;
            descriptor.getEventManager().processDescriptorEventHolders(this.session, realClassLoader);
        }
    }

    protected PersistenceException createDeployFailedPersistenceException(Throwable ex) {
        PersistenceException perEx = new PersistenceException((Throwable)EntityManagerSetupException.deployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
        if (this.persistenceException == null) {
            this.persistenceException = perEx;
        }
        return perEx;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        SessionManager sm = SessionManager.getManager();
        ConcurrentMap<String, Session> sessions = sm.getSessions();
        AbstractSession oldSession = (AbstractSession)sessions.get(this.session.getName());
        if (oldSession != null) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.attemptedRedeployWithoutClose(this.session.getName()));
        }
        sm.addSession(this.session);
    }

    public void addStructConverters() {
        if (this.compositeMemberEmSetupImpls == null) {
            for (StructConverter structConverter : this.structConverters) {
                if (this.session.getPlatform().getTypeConverters().get(structConverter.getJavaType()) != null) {
                    throw ValidationException.twoStructConvertersAddedForSameClass(structConverter.getJavaType().getName());
                }
                this.session.getPlatform().addStructConverter(structConverter);
            }
        } else {
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                if (compositeMemberEmSetupImpl.structConverters.isEmpty()) continue;
                String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
                compositeMemberEmSetupImpl.addStructConverters();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
            }
        }
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            OptimisticLockingPolicy olp;
            if (descriptor.getCMPPolicy() == null) {
                descriptor.setCMPPolicy(new CMP3Policy());
            }
            if ((olp = descriptor.getOptimisticLockingPolicy()) == null || olp.getLockOnChangeMode() != null) continue;
            olp.setLockOnChangeMode(OptimisticLockingPolicy.LockOnChange.OWNING);
        }
    }

    protected boolean updateServerPlatform(Map m, ClassLoader loader) {
        String serverPlatformClassName = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-server", m, this.session);
        if (serverPlatformClassName == null && (serverPlatformClassName = ServerPlatformUtils.detectServerPlatform(this.getSession())) == null) {
            return false;
        }
        ServerPlatform originalServerPlatform = this.session.getServerPlatform();
        String originalServerPlatformClassName = originalServerPlatform.getClass().getName();
        if (originalServerPlatformClassName.equals(serverPlatformClassName)) {
            return false;
        }
        ServerPlatform serverPlatform = null;
        Class cls = EntityManagerSetupImpl.findClassForProperty(serverPlatformClassName, "eclipselink.target-server", loader);
        try {
            Constructor constructor = cls.getConstructor(DatabaseSession.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception ex) {
            if (ExternalTransactionController.class.isAssignableFrom(cls)) {
                if (originalServerPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform originalCustomServerPlatform = (CustomServerPlatform)originalServerPlatform;
                    if (!cls.equals(originalCustomServerPlatform.getExternalTransactionControllerClass())) {
                        originalCustomServerPlatform.setExternalTransactionControllerClass(cls);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform(this.getDatabaseSession());
                    customServerPlatform.setExternalTransactionControllerClass(cls);
                    serverPlatform = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(serverPlatformClassName, "eclipselink.target-server", ex);
        }
        if (serverPlatform != null) {
            this.getDatabaseSession().setServerPlatform(serverPlatform);
            return true;
        }
        return false;
    }

    protected void updatePartitioning(Map m, ClassLoader loader) {
        String callbackClassName;
        String partitioning = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning", m, this.session);
        if (partitioning != null) {
            PartitioningPolicy partitioningPolicy = this.session.getProject().getPartitioningPolicy(partitioning);
            if (partitioningPolicy == null) {
                throw DescriptorException.missingPartitioningPolicy(partitioning, null, null);
            }
            this.session.setPartitioningPolicy(partitioningPolicy);
        }
        if ((callbackClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning.callback", m, this.session)) != null) {
            Class cls = EntityManagerSetupImpl.findClassForProperty(callbackClassName, "eclipselink.partitioning.callback", loader);
            DataPartitioningCallback callback = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                callback = (DataPartitioningCallback)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty(callbackClassName, "eclipselink.partitioning.callback", exception);
            }
            this.session.getLogin().setPartitioningCallback(callback);
        }
    }

    protected void updateRemote(Map m, ClassLoader loader) {
        String protocol = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.remote.protocol", m, this.session);
        String serverName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.remote.server.name", m, this.session);
        if (serverName == null) {
            if (protocol != null) {
                RemoteConnection connection = null;
                if (protocol.equalsIgnoreCase("rmi")) {
                    String url = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.remote.client.url", m, this.session);
                    if (url == null) {
                        throw EntityManagerSetupException.missingProperty("eclipselink.remote.client.url");
                    }
                    try {
                        connection = new RMIConnection(((RMIServerSessionManager)Naming.lookup(url)).createRemoteSessionController());
                    }
                    catch (Exception exception) {
                        throw ValidationException.invalidValueForProperty(url, "eclipselink.remote.client.url", exception);
                    }
                }
                Class cls = EntityManagerSetupImpl.findClassForProperty(protocol, "eclipselink.remote.protocol", loader);
                try {
                    Constructor constructor = cls.getConstructor(new Class[0]);
                    connection = (RemoteConnection)constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw ValidationException.invalidValueForProperty(protocol, "eclipselink.remote.protocol", exception);
                }
                RemoteSession remoteSession = new RemoteSession();
                remoteSession.setIsMetadataRemote(false);
                remoteSession.setProject(this.session.getProject());
                remoteSession.setProfiler(this.session.getProfiler());
                remoteSession.setSessionLog(this.session.getSessionLog());
                remoteSession.setEventManager(this.session.getEventManager());
                remoteSession.setQueries(this.session.getQueries());
                remoteSession.setProperties(this.session.getProperties());
                remoteSession.setName(this.session.getName());
                remoteSession.setRemoteConnection(connection);
                this.session = remoteSession;
            }
        } else if (protocol.equalsIgnoreCase("rmi")) {
            RMIServerSessionManagerDispatcher manager = null;
            try {
                LocateRegistry.createRegistry(1099);
            }
            catch (Exception exception) {
                System.out.println("Security violation " + exception.toString());
            }
            try {
                manager = new RMIServerSessionManagerDispatcher(this.session);
            }
            catch (RemoteException exception) {
                ValidationException.invalidValueForProperty(serverName, "eclipselink.remote.server.name", exception);
            }
            try {
                Naming.unbind(serverName);
            }
            catch (Exception exception) {}
            try {
                Naming.rebind(serverName, manager);
            }
            catch (Exception exception) {
                ValidationException.invalidValueForProperty(serverName, "eclipselink.remote.server.name", exception);
            }
        }
    }

    protected void updateDatabaseEventListener(Map m, ClassLoader loader) {
        String listenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.database-event-listener", m, this.session);
        if (listenerClassName != null) {
            if (listenerClassName.equalsIgnoreCase("DCN") || listenerClassName.equalsIgnoreCase("QCN")) {
                listenerClassName = "org.eclipse.persistence.platform.database.oracle.dcn.OracleChangeNotificationListener";
            }
            Class cls = EntityManagerSetupImpl.findClassForProperty(listenerClassName, "eclipselink.cache.database-event-listener", loader);
            DatabaseEventListener listener = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                listener = (DatabaseEventListener)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty(listenerClassName, "eclipselink.cache.database-event-listener", exception);
            }
            this.getDatabaseSession().setDatabaseEventListener(listener);
        }
    }

    protected void updateLoggers(Map persistenceProperties, boolean serverPlatformChanged, ClassLoader loader) {
        block15: {
            String loggerClassName = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.logger", persistenceProperties, this.session);
            SessionLog singletonLog = null;
            SessionLog sessionLog = null;
            if (loggerClassName != null) {
                SessionLog currentLog = this.session.getSessionLog();
                if (loggerClassName.equals("ServerLogger")) {
                    ServerPlatform serverPlatform = this.session.getServerPlatform();
                    singletonLog = serverPlatform.getServerLog();
                    sessionLog = serverPlatform.getServerLog();
                } else if (!currentLog.getClass().getName().equals(loggerClassName)) {
                    Class sessionLogClass = EntityManagerSetupImpl.findClassForProperty(loggerClassName, "eclipselink.logging.logger", loader);
                    try {
                        singletonLog = (SessionLog)sessionLogClass.newInstance();
                        sessionLog = (SessionLog)sessionLogClass.newInstance();
                    }
                    catch (Exception ex) {
                        throw EntityManagerSetupException.failedToInstantiateLogger(loggerClassName, "eclipselink.logging.logger", ex);
                    }
                }
            } else if (serverPlatformChanged) {
                ServerPlatform serverPlatform = this.session.getServerPlatform();
                singletonLog = serverPlatform.getServerLog();
                sessionLog = serverPlatform.getServerLog();
            }
            if (singletonLog != null && sessionLog != null) {
                AbstractSessionLog.setLog(singletonLog);
                this.session.setSessionLog(sessionLog);
            }
            this.initOrUpdateLogging(persistenceProperties, AbstractSessionLog.getLog());
            this.initOrUpdateLogging(persistenceProperties, this.session.getSessionLog());
            String loggingFileString = (String)persistenceProperties.get("eclipselink.logging.file");
            if (loggingFileString != null) {
                if (!loggingFileString.trim().equals("")) {
                    try {
                        if (sessionLog == null) break block15;
                        if (sessionLog instanceof AbstractSessionLog) {
                            FileOutputStream fos = new FileOutputStream(loggingFileString);
                            ((AbstractSessionLog)sessionLog).setWriter(fos);
                            break block15;
                        }
                        FileWriter fw = new FileWriter(loggingFileString);
                        sessionLog.setWriter(fw);
                    }
                    catch (IOException e) {
                        this.session.handleException(ValidationException.invalidLoggingFile(loggingFileString, e));
                    }
                } else {
                    this.session.handleException(ValidationException.invalidLoggingFile());
                }
            }
        }
    }

    protected void updateProfiler(Map persistenceProperties, ClassLoader loader) {
        String newProfilerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.profiler", persistenceProperties, this.session);
        if (newProfilerClassName == null) {
            ServerPlatformBase plaftorm = (ServerPlatformBase)this.session.getServerPlatform();
            if (plaftorm != null) {
                plaftorm.configureProfiler(this.session);
            }
        } else {
            if (newProfilerClassName.equals("NoProfiler")) {
                this.session.setProfiler(null);
                return;
            }
            if (newProfilerClassName.equals("QueryMonitor")) {
                this.session.setProfiler(null);
                QueryMonitor.shouldMonitor = true;
                return;
            }
            if (newProfilerClassName.equals("PerformanceProfiler")) {
                this.session.setProfiler(new PerformanceProfiler());
                return;
            }
            if (newProfilerClassName.equals("PerformanceMonitor")) {
                this.session.setProfiler(new PerformanceMonitor());
                return;
            }
            if (newProfilerClassName.equals("DMSProfiler")) {
                newProfilerClassName = "org.eclipse.persistence.tools.profiler.oracle.DMSPerformanceProfiler";
            }
            String originalProfilerClassNamer = null;
            if (this.session.getProfiler() != null && (originalProfilerClassNamer = this.session.getProfiler().getClass().getName()).equals(newProfilerClassName)) {
                return;
            }
            try {
                Class newProfilerClass = EntityManagerSetupImpl.findClassForProperty(newProfilerClassName, "eclipselink.profiler", loader);
                SessionProfiler sessionProfiler = (SessionProfiler)EntityManagerSetupImpl.buildObjectForClass(newProfilerClass, SessionProfiler.class);
                if (sessionProfiler != null) {
                    this.session.setProfiler(sessionProfiler);
                } else {
                    this.session.handleException(ValidationException.invalidProfilerClass(newProfilerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
        }
    }

    protected static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
        }
        return PrivilegedAccessHelper.getClassForName(className, true, loader);
    }

    protected static Class findClassForProperty(String className, String propertyName, ClassLoader loader) {
        boolean multipleLoaders;
        ClassLoader eclipselinkLoader = EntityManagerSetupImpl.class.getClassLoader();
        boolean bl = multipleLoaders = eclipselinkLoader != loader;
        if (multipleLoaders) {
            return EntityManagerSetupImpl.findClassForPropertyInternal(className, propertyName, loader, eclipselinkLoader);
        }
        return EntityManagerSetupImpl.findClassForPropertyInternal(className, propertyName, loader);
    }

    private static Class findClassForPropertyInternal(String clsName, String propName, ClassLoader ... loaders) {
        EntityManagerSetupException e = null;
        ClassLoader[] classLoaderArray = loaders;
        int n = loaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader loader = classLoaderArray[n2];
            try {
                return EntityManagerSetupImpl.findClass(clsName, loader);
            }
            catch (PrivilegedActionException exception1) {
                e = EntityManagerSetupException.classNotFoundForProperty(clsName, propName, exception1.getException());
            }
            catch (ClassNotFoundException exception2) {
                e = EntityManagerSetupException.classNotFoundForProperty(clsName, propName, exception2);
            }
            ++n2;
        }
        throw e;
    }

    protected List<StructConverter> getStructConverters(ClassLoader realClassLoader) {
        ArrayList<StructConverter> structConverters = new ArrayList<StructConverter>();
        if (this.session.getProject().getStructConverters() != null) {
            for (String converter : this.session.getProject().getStructConverters()) {
                Class clazz = null;
                try {
                    clazz = EntityManagerSetupImpl.findClass(converter, realClassLoader);
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(converter, exception.getException());
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.unableToLoadClass(converter, exception);
                }
                try {
                    structConverters.add((StructConverter)EntityManagerSetupImpl.buildObjectForClass(clazz, clazz));
                }
                catch (PrivilegedActionException e) {
                    throw ValidationException.errorInstantiatingClass(clazz, e.getException());
                }
                catch (IllegalAccessException e) {
                    throw ValidationException.errorInstantiatingClass(clazz, e);
                }
                catch (InstantiationException e) {
                    throw ValidationException.errorInstantiatingClass(clazz, e);
                }
            }
        }
        return structConverters;
    }

    protected boolean hasSchemaDatabaseGeneration(Map m) {
        if (EntityManagerFactoryProvider.hasConfigProperty("javax.persistence.schema-generation.database.action", m)) {
            return EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.database.action", m) != null && !EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.database.action", m).equals("none");
        }
        return false;
    }

    protected boolean hasSchemaScriptsGeneration(Map m) {
        if (EntityManagerFactoryProvider.hasConfigProperty("javax.persistence.schema-generation.scripts.action", m)) {
            return EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.scripts.action", m) != null && !EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.scripts.action", m).equals("none");
        }
        return false;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public DatabaseSessionImpl getDatabaseSession() {
        return (DatabaseSessionImpl)this.session;
    }

    public DatabaseSessionImpl getDatabaseSession(Map props) {
        DatabaseSessionImpl databaseSession = this.getDatabaseSession();
        Object connection = EntityManagerFactoryProvider.getConfigProperty("javax.persistence.schema-generation.connection", props);
        if (connection == null) {
            return databaseSession;
        }
        DatabaseSessionImpl newDatabaseSession = new DatabaseSessionImpl();
        newDatabaseSession.setAccessor(new DatabaseAccessor(connection));
        newDatabaseSession.setLogLevel(databaseSession.getLogLevel());
        newDatabaseSession.setProject(databaseSession.getProject().clone());
        return newDatabaseSession;
    }

    protected static Object buildObjectForClass(Class clazz, Class mustBeImplementedInterface) throws IllegalAccessException, PrivilegedActionException, InstantiationException {
        if (clazz != null && Helper.classImplementsInterface(clazz, mustBeImplementedInterface)) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            }
            return PrivilegedAccessHelper.newInstanceFromClass(clazz);
        }
        return null;
    }

    protected void updateDescriptorCacheSettings(Map m, ClassLoader loader) {
        String queryCache = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.query-results", m, this.session);
        if (queryCache != null && queryCache.equalsIgnoreCase("true")) {
            this.session.getProject().setDefaultQueryResultsCachePolicy(new QueryResultsCachePolicy());
        }
        Map typeMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.type.", m, this.session);
        Map sizeMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.size.", m, this.session);
        Map sharedMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.shared.", m, this.session);
        if (typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty()) {
            return;
        }
        String defaultTypeName = (String)typeMap.remove("default");
        if (defaultTypeName != null) {
            Class defaultType = EntityManagerSetupImpl.findClassForProperty(defaultTypeName, "eclipselink.cache.type.default", this.getClass().getClassLoader());
            this.session.getProject().setDefaultIdentityMapClass(defaultType);
        }
        String value = null;
        try {
            String defaultSharedString;
            String defaultSizeString = (String)sizeMap.remove("default");
            if (defaultSizeString != null) {
                value = defaultSizeString;
                int defaultSize = Integer.parseInt(defaultSizeString);
                this.session.getProject().setDefaultIdentityMapSize(defaultSize);
            }
            if ((defaultSharedString = (String)sharedMap.remove("default")) != null) {
                boolean defaultShared = Boolean.parseBoolean(defaultSharedString);
                this.session.getProject().setDefaultIsIsolated(!defaultShared);
            }
            Iterator<ClassDescriptor> it = this.session.getDescriptors().values().iterator();
            while (!(!it.hasNext() || typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty())) {
                String sharedString;
                String sizeString;
                ClassDescriptor descriptor = it.next();
                if (descriptor.isDescriptorTypeAggregate()) continue;
                String entityName = descriptor.getAlias();
                String className = descriptor.getJavaClass().getName();
                String name = entityName;
                String typeName = (String)typeMap.remove(name);
                if (typeName == null) {
                    name = className;
                    typeName = (String)typeMap.remove(name);
                }
                if (typeName != null) {
                    Class type = EntityManagerSetupImpl.findClassForProperty(typeName, "eclipselink.cache.type." + name, this.getClass().getClassLoader());
                    descriptor.setIdentityMapClass(type);
                }
                if ((sizeString = (String)sizeMap.remove(name = entityName)) == null) {
                    name = className;
                    sizeString = (String)sizeMap.remove(name);
                }
                if (sizeString != null) {
                    value = sizeString;
                    int size = Integer.parseInt(sizeString);
                    descriptor.setIdentityMapSize(size);
                }
                if ((sharedString = (String)sharedMap.remove(name = entityName)) == null) {
                    name = className;
                    sharedString = (String)sharedMap.remove(name);
                }
                if (sharedString == null) continue;
                boolean shared = Boolean.parseBoolean(sharedString);
                descriptor.setIsIsolated(!shared);
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(value, "eclipselink.cache.size.", exception));
        }
    }

    protected void updateConnectionSettings(ServerSession serverSession, Map properties) {
        Map connectionsMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.connection-pool.", properties, serverSession);
        if (connectionsMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : connectionsMap.entrySet()) {
            String poolName = "default";
            String attribute = null;
            try {
                boolean shared;
                if (((String)entry.getKey()).indexOf(".") == -1) {
                    attribute = (String)entry.getKey();
                } else {
                    poolName = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("."));
                    attribute = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1, ((String)entry.getKey()).length());
                }
                ConnectionPool pool = null;
                if (poolName.equals("write")) {
                    poolName = "default";
                }
                if (poolName.equals("read")) {
                    pool = serverSession.getReadConnectionPool();
                    if (pool == null || pool == serverSession.getDefaultConnectionPool()) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        serverSession.setReadConnectionPool(pool);
                    }
                } else if (poolName.equals("sequence")) {
                    pool = this.getDatabaseSession().getSequencingControl().getConnectionPool();
                    if (pool == null) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        this.getDatabaseSession().getSequencingControl().setConnectionPool(pool);
                    }
                } else {
                    pool = serverSession.getConnectionPool(poolName);
                    if (pool == null) {
                        pool = this.session.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                        serverSession.addConnectionPool(pool);
                    }
                }
                if (attribute.equals("initial")) {
                    pool.setInitialNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("min")) {
                    pool.setMinNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("max")) {
                    pool.setMaxNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("url")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setURL((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("nonJtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("jtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("user")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setUserName((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("password")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setPassword((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("wait")) {
                    pool.setWaitTimeout(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("failover")) {
                    String failoverPools = (String)entry.getValue();
                    if (failoverPools.indexOf(44) != -1 || failoverPools.indexOf(32) != -1) {
                        StringTokenizer tokenizer = new StringTokenizer(failoverPools, " ,");
                        while (tokenizer.hasMoreTokens()) {
                            pool.addFailoverConnectionPool(tokenizer.nextToken());
                        }
                        continue;
                    }
                    pool.addFailoverConnectionPool((String)entry.getValue());
                    continue;
                }
                if (!poolName.equals("read") || !attribute.equals("shared") || !(shared = Boolean.parseBoolean((String)entry.getValue()))) continue;
                ReadConnectionPool readPool = new ReadConnectionPool(poolName, serverSession.getDatasourceLogin(), serverSession);
                readPool.setInitialNumberOfConnections(pool.getInitialNumberOfConnections());
                readPool.setMinNumberOfConnections(pool.getMinNumberOfConnections());
                readPool.setMaxNumberOfConnections(pool.getMaxNumberOfConnections());
                readPool.setWaitTimeout(pool.getWaitTimeout());
                readPool.setLogin(pool.getLogin());
                serverSession.setReadConnectionPool(readPool);
            }
            catch (RuntimeException exception) {
                this.session.handleException(ValidationException.invalidValueForProperty(entry.getValue(), (String)entry.getKey(), exception));
            }
        }
    }

    protected void updateConnectionPolicy(ServerSession serverSession, Map m) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", m, this.session);
        if (isLazyString != null) {
            serverSession.getDefaultConnectionPolicy().setIsLazy(Boolean.parseBoolean(isLazyString));
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(m, this.session, true)) != null) {
            serverSession.getDefaultConnectionPolicy().setExclusiveMode(exclusiveMode);
        }
    }

    public static ConnectionPolicy.ExclusiveMode getConnectionPolicyExclusiveModeFromProperties(Map m, AbstractSession abstractSession, boolean useSystemAsDefault) {
        String exclusiveConnectionModeString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.exclusive-connection.mode", m, abstractSession, useSystemAsDefault);
        if (exclusiveConnectionModeString != null) {
            if (exclusiveConnectionModeString == "Isolated") {
                return ConnectionPolicy.ExclusiveMode.Isolated;
            }
            if (exclusiveConnectionModeString == "Always") {
                return ConnectionPolicy.ExclusiveMode.Always;
            }
            return ConnectionPolicy.ExclusiveMode.Transactional;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized ClassTransformer predeploy(PersistenceUnitInfo info, Map extendedProperties) {
        ClassLoader classLoaderToUse = null;
        if (this.state == STATE_DEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state, (Exception)((Object)this.persistenceException)));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED || this.state == STATE_HALF_DEPLOYED) {
            this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            ++this.factoryCount;
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            return null;
        }
        if (this.state == STATE_INITIAL) {
            this.persistenceUnitInfo = info;
            if (!this.isCompositeMember() && EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo)) {
                if (this.staticWeaveInfo == null) {
                    return null;
                }
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
        } else if (this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
            this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
        }
        try {
            Map predeployProperties = null;
            boolean isComposite = false;
            if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                Project project;
                classLoaderToUse = this.persistenceUnitInfo.getClassLoader();
                predeployProperties = EntityManagerFactoryProvider.mergeMaps(extendedProperties, this.persistenceUnitInfo.getProperties());
                EntityManagerFactoryProvider.translateOldProperties(predeployProperties, null);
                String sessionsXMLStr = (String)predeployProperties.get("eclipselink.sessions-xml");
                if (sessionsXMLStr != null) {
                    this.isSessionLoadedFromSessionsXML = true;
                }
                if (isComposite = EntityManagerSetupImpl.isComposite(this.persistenceUnitInfo)) {
                    if (this.isSessionLoadedFromSessionsXML) {
                        throw EntityManagerSetupException.compositeIncompatibleWithSessionsXml(this.persistenceUnitInfo.getPersistenceUnitName());
                    }
                    this.session = new SessionBroker();
                    ((SessionBroker)this.session).setShouldUseDescriptorAliases(true);
                } else {
                    this.session = new ServerSession(new Project(new DatabaseLogin()));
                    this.session.setRefreshMetadataListener(this);
                }
                this.session.setName(this.sessionName);
                this.updateTunerPreDeploy(predeployProperties, classLoaderToUse);
                this.updateTolerateInvalidJPQL(predeployProperties);
                if (this.compositeEmSetupImpl == null) {
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.updateLoggers(predeployProperties, true, classLoaderToUse);
                        this.updateProfiler(predeployProperties, classLoaderToUse);
                    } else {
                        Writer writer = this.staticWeaveInfo.getLogWriter();
                        if (writer != null) {
                            ((DefaultSessionLog)this.session.getSessionLog()).setWriter(writer);
                        }
                        this.session.setLogLevel(this.staticWeaveInfo.getLogLevel());
                    }
                } else {
                    this.session.setSessionLog(this.compositeEmSetupImpl.session.getSessionLog());
                    this.session.setProfiler(this.compositeEmSetupImpl.session.getProfiler());
                }
                this.session.log(1, "jpa", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                this.updateProjectCache(predeployProperties, classLoaderToUse);
                if (this.projectCacheAccessor != null && (project = this.projectCacheAccessor.retrieveProject(predeployProperties, classLoaderToUse, this.session.getSessionLog())) != null) {
                    try {
                        DatabaseSessionImpl tempSession = (DatabaseSessionImpl)((Object)project.createServerSession());
                        tempSession.setName(this.sessionName);
                        tempSession.setSessionLog(this.session.getSessionLog());
                        tempSession.getSessionLog().setSession(tempSession);
                        if (this.staticWeaveInfo != null) {
                            tempSession.setLogLevel(this.staticWeaveInfo.getLogLevel());
                        }
                        tempSession.setProfiler(this.session.getProfiler());
                        tempSession.setRefreshMetadataListener(this);
                        this.session = tempSession;
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.shouldBuildProject = false;
                    }
                    catch (Exception e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
                if (this.isSessionLoadedFromSessionsXML) {
                    if (this.compositeEmSetupImpl == null && this.staticWeaveInfo == null) {
                        JPAClassLoaderHolder privateClassLoaderHolder = this.session.getServerPlatform().getNewTempClassLoader(this.persistenceUnitInfo);
                        classLoaderToUse = privateClassLoaderHolder.getClassLoader();
                    } else {
                        classLoaderToUse = this.persistenceUnitInfo.getNewTempClassLoader();
                    }
                    String tempSessionName = this.sessionName;
                    if (this.isCompositeMember()) {
                        tempSessionName = (String)predeployProperties.get("eclipselink.session-name");
                    }
                    this.session.log(1, "properties", "loading_session_xml", sessionsXMLStr, tempSessionName);
                    if (tempSessionName == null) {
                        throw EntityManagerSetupException.sessionNameNeedBeSpecified(this.persistenceUnitInfo.getPersistenceUnitName(), sessionsXMLStr);
                    }
                    XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader(sessionsXMLStr);
                    AbstractSession tempSession = new SessionManager().getSession(xmlLoader, tempSessionName, classLoaderToUse, false, false);
                    this.session.log(1, "properties", "sessions_xml_path_where_session_load_from", xmlLoader.getSessionName(), xmlLoader.getResourcePath());
                    if (tempSession == null) {
                        throw ValidationException.noSessionFound(this.sessionName, sessionsXMLStr);
                    }
                    if (tempSession.isServerSession() || tempSession.isSessionBroker()) {
                        this.session = (DatabaseSessionImpl)tempSession;
                        if (tempSessionName != this.sessionName) {
                            this.session.setName(this.sessionName);
                        }
                    } else {
                        throw EntityManagerSetupException.sessionLoadedFromSessionsXMLMustBeServerSession(this.persistenceUnitInfo.getPersistenceUnitName(), (String)predeployProperties.get("eclipselink.sessions-xml"), tempSession);
                    }
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, classLoaderToUse);
                        this.updateLoggers(predeployProperties, true, classLoaderToUse);
                    }
                } else {
                    classLoaderToUse = this.persistenceUnitInfo.getClassLoader();
                }
                EntityManagerFactoryProvider.warnOldProperties(predeployProperties, this.session);
                this.session.getPlatform().setConversionManager(new JPAConversionManager());
                if (this.staticWeaveInfo == null) {
                    if (!isComposite) {
                        PersistenceUnitTransactionType transactionType = null;
                        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", predeployProperties, this.session);
                        if (transTypeString != null && transTypeString.length() > 0) {
                            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
                        } else if (this.persistenceUnitInfo != null) {
                            transactionType = this.persistenceUnitInfo.getTransactionType();
                        }
                        if (!(this.isValidationOnly(predeployProperties, false) || this.persistenceUnitInfo == null || transactionType != PersistenceUnitTransactionType.JTA || predeployProperties.get("javax.persistence.jtaDataSource") != null || this.persistenceUnitInfo.getJtaDataSource() != null || predeployProperties.get("javax.persistence.database-product-name") != null && predeployProperties.get("javax.persistence.database-major-version") != null && predeployProperties.get("javax.persistence.database-minor-version") != null)) {
                            throw EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource(this.persistenceUnitInfo.getPersistenceUnitName());
                        }
                    }
                    if (this.state == STATE_INITIAL) {
                        String weaving;
                        if (this.compositeEmSetupImpl == null) {
                            if (this.enableWeaving == null) {
                                this.enableWeaving = Boolean.TRUE;
                            }
                            this.isWeavingStatic = false;
                            weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties);
                            if (weaving != null && weaving.equalsIgnoreCase("false")) {
                                this.enableWeaving = Boolean.FALSE;
                            } else if (weaving != null && weaving.equalsIgnoreCase("static")) {
                                this.isWeavingStatic = true;
                            }
                        } else {
                            if (!this.compositeEmSetupImpl.enableWeaving.booleanValue()) {
                                this.enableWeaving = Boolean.FALSE;
                            } else {
                                if (this.enableWeaving == null) {
                                    this.enableWeaving = Boolean.TRUE;
                                }
                                if ((weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties)) != null && weaving.equalsIgnoreCase("false")) {
                                    this.enableWeaving = Boolean.FALSE;
                                }
                            }
                            this.isWeavingStatic = this.compositeEmSetupImpl.isWeavingStatic;
                        }
                    }
                    this.throwExceptionOnFail = this.compositeEmSetupImpl == null ? "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.orm.throw.exceptions", predeployProperties, "true", this.session)) : this.compositeEmSetupImpl.throwExceptionOnFail;
                } else {
                    this.enableWeaving = Boolean.TRUE;
                }
                this.weaveChangeTracking = false;
                this.weaveLazy = false;
                this.weaveEager = false;
                this.weaveFetchGroups = false;
                this.weaveInternal = false;
                this.weaveRest = false;
                if (this.enableWeaving.booleanValue()) {
                    this.weaveChangeTracking = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.changetracking", predeployProperties, "true", this.session));
                    this.weaveLazy = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.lazy", predeployProperties, "true", this.session));
                    this.weaveEager = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.eager", predeployProperties, "false", this.session));
                    this.weaveFetchGroups = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.fetchgroups", predeployProperties, "true", this.session));
                    this.weaveInternal = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.internal", predeployProperties, "true", this.session));
                    this.weaveRest = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.rest", predeployProperties, "true", this.session));
                }
            }
            if (this.shouldBuildProject && !this.isSessionLoadedFromSessionsXML) {
                if (isComposite) {
                    this.predeployCompositeMembers(predeployProperties, classLoaderToUse);
                } else {
                    MetadataProcessor compositeProcessor = null;
                    if (this.compositeEmSetupImpl == null) {
                        this.mode = PersistenceUnitProcessor.Mode.ALL;
                    } else {
                        if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                            this.state = STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
                            this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL;
                        }
                        compositeProcessor = this.compositeEmSetupImpl.processor;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.ALL || this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        boolean usesMultitenantSharedEmf = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-emf", predeployProperties, "true", this.session));
                        boolean usesMultitenantSharedCache = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-cache", predeployProperties, "false", this.session));
                        this.processor = new MetadataProcessor(this.persistenceUnitInfo, this.session, classLoaderToUse, this.weaveLazy, this.weaveEager, this.weaveFetchGroups, usesMultitenantSharedEmf, usesMultitenantSharedCache, predeployProperties, compositeProcessor);
                        this.updateMetadataRepository(predeployProperties, classLoaderToUse);
                        EntityManagerSetupImpl.updateCaseSensitivitySettings(predeployProperties, this.processor.getProject(), this.session);
                    }
                    this.updateSharedCacheMode(predeployProperties);
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                PersistenceUnitProcessor.processORMetadata(EntityManagerSetupImpl.this.processor, EntityManagerSetupImpl.this.throwExceptionOnFail, EntityManagerSetupImpl.this.mode);
                                return null;
                            }
                        });
                    } else {
                        PersistenceUnitProcessor.processORMetadata(this.processor, this.throwExceptionOnFail, this.mode);
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE;
                        this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_FINAL;
                        this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), String.valueOf(this.state) + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    this.mode = null;
                    if (this.session.getIntegrityChecker().hasErrors()) {
                        this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                    }
                    if (this.enableWeaving.booleanValue()) {
                        Collection<MetadataClass> entities = PersistenceUnitProcessor.buildEntityList(this.processor, classLoaderToUse);
                        this.weaver = TransformerFactory.createTransformerAndModifyProject(this.session, entities, classLoaderToUse, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
                        this.session.getProject().setClassNamesForWeaving(new ArrayList<String>(this.processor.getProject().getWeavableClassNames()));
                    }
                    this.processor.addNamedQueries();
                    this.processor.addStructConverterNames();
                }
            } else if (this.enableWeaving.booleanValue()) {
                ArrayList<MetadataClass> persistenceClasses = new ArrayList<MetadataClass>();
                MetadataAsmFactory factory = new MetadataAsmFactory(new MetadataLogger(this.session), classLoaderToUse);
                if (this.shouldBuildProject) {
                    Iterator<Class> iterator = this.session.getProject().getDescriptors().keySet().iterator();
                    while (iterator.hasNext()) {
                        persistenceClasses.add(factory.getMetadataClass(iterator.next().getName()));
                    }
                } else {
                    for (String className : this.session.getProject().getClassNamesForWeaving()) {
                        persistenceClasses.add(factory.getMetadataClass(className));
                    }
                }
                this.weaver = TransformerFactory.createTransformerAndModifyProject(this.session, persistenceClasses, classLoaderToUse, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal, this.weaveRest);
            }
            if (!this.isCompositeMember()) {
                if (this.state != STATE_INITIAL || this.isInContainerMode()) {
                    ++this.factoryCount;
                }
                this.preInitializeMetamodel();
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.isWeavingStatic) {
                return null;
            }
            return this.weaver;
        }
        catch (Throwable ex) {
            this.state = STATE_PREDEPLOY_FAILED;
            PersistenceException persistenceEx = this.createPredeployFailedPersistenceException(ex);
            this.session.log(1, "jpa", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            this.session = null;
            this.mode = null;
            throw persistenceEx;
        }
    }

    protected PersistenceException createPredeployFailedPersistenceException(Throwable ex) {
        PersistenceException perEx = new PersistenceException((Throwable)EntityManagerSetupException.predeployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
        if (this.persistenceException == null) {
            this.persistenceException = perEx;
        }
        return perEx;
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map m) {
        return this.isValidationOnly(m, true);
    }

    protected boolean isValidationOnly(Map m, boolean shouldMergeMap) {
        String validationOnlyString;
        if (shouldMergeMap) {
            m = this.mergeWithExistingMap(m);
        }
        if ((validationOnlyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.validation-only", m, this.session)) != null) {
            return Boolean.parseBoolean(validationOnlyString);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map m) {
        if (this.isValidationOnly(m = this.mergeWithExistingMap(m), false)) {
            return true;
        }
        String deployString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.deploy-on-startup", m, this.session);
        if (deployString != null) {
            return Boolean.parseBoolean(deployString);
        }
        return this.hasSchemaDatabaseGeneration(m) || this.hasSchemaScriptsGeneration(m);
    }

    protected Map mergeWithExistingMap(Map m) {
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.persistenceUnitInfo.getProperties());
        }
        return m;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateCacheCoordination(Map m, ClassLoader loader) {
        String protocol = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.protocol", m, this.session);
        String value = "";
        String property = "";
        try {
            if (protocol != null) {
                String channel;
                String asynch;
                String removeOnError;
                String context;
                String password;
                String user;
                String naming;
                String serializer;
                Class transportClass;
                RemoteCommandManager rcm = new RemoteCommandManager(this.session);
                if (protocol.equalsIgnoreCase("jgroups")) {
                    property = "eclipselink.cache.coordination.protocol";
                    value = "org.eclipse.persistence.sessions.coordination.jgroups.JGroupsTransportManager";
                    transportClass = EntityManagerSetupImpl.findClassForProperty(value, "eclipselink.cache.coordination.protocol", loader);
                    TransportManager transport = (TransportManager)transportClass.newInstance();
                    rcm.setTransportManager(transport);
                    String config = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jgroups.config", m, this.session);
                    if (config != null) {
                        transport.setConfig(config);
                    }
                } else if (protocol.equalsIgnoreCase("jms") || protocol.equalsIgnoreCase("jms-publishing")) {
                    String reuse_publisher;
                    String factory;
                    String topic;
                    JMSPublishingTransportManager transport = null;
                    transport = protocol.equalsIgnoreCase("jms") ? new JMSTopicTransportManager(rcm) : new JMSPublishingTransportManager(rcm);
                    rcm.setTransportManager(transport);
                    String host = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.host", m, this.session);
                    if (host != null) {
                        transport.setTopicHostUrl(host);
                    }
                    if ((topic = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.topic", m, this.session)) != null) {
                        transport.setTopicName(topic);
                    }
                    if ((factory = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.factory", m, this.session)) != null) {
                        transport.setTopicConnectionFactoryName(factory);
                    }
                    if ((reuse_publisher = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.reuse-topic-publisher", m, this.session)) != null) {
                        transport.setShouldReuseJMSTopicPublisher(reuse_publisher.equalsIgnoreCase("true"));
                    }
                } else if (protocol.equalsIgnoreCase("rmi") || protocol.equalsIgnoreCase("rmi-iiop")) {
                    String url;
                    String multicast;
                    if (protocol.equalsIgnoreCase("rmi-iiop")) {
                        ((RMITransportManager)rcm.getTransportManager()).setIsRMIOverIIOP(true);
                    }
                    String delay = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.announcement-delay", m, this.session);
                    property = "eclipselink.cache.coordination.rmi.announcement-delay";
                    value = delay;
                    if (delay != null) {
                        rcm.getDiscoveryManager().setAnnouncementDelay(Integer.parseInt(delay));
                    }
                    if ((multicast = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group", m, this.session)) != null) {
                        rcm.getDiscoveryManager().setMulticastGroupAddress(multicast);
                    }
                    String port = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group.port", m, this.session);
                    property = "eclipselink.cache.coordination.rmi.multicast-group.port";
                    value = port;
                    if (port != null) {
                        rcm.getDiscoveryManager().setMulticastPort(Integer.parseInt(port));
                    }
                    String timeToLive = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.packet-time-to-live", m, this.session);
                    property = "eclipselink.cache.coordination.rmi.packet-time-to-live";
                    value = timeToLive;
                    if (timeToLive != null) {
                        rcm.getDiscoveryManager().setPacketTimeToLive(Integer.parseInt(timeToLive));
                    }
                    if ((url = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.url", m, this.session)) != null) {
                        rcm.setUrl(url);
                    }
                } else {
                    property = "eclipselink.cache.coordination.protocol";
                    value = protocol;
                    transportClass = EntityManagerSetupImpl.findClassForProperty(protocol, "eclipselink.cache.coordination.protocol", loader);
                    rcm.setTransportManager((TransportManager)transportClass.newInstance());
                }
                if ((serializer = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.serializer", m, this.session)) != null) {
                    property = "eclipselink.cache.coordination.serializer";
                    value = serializer;
                    Class transportClass2 = EntityManagerSetupImpl.findClassForProperty(serializer, "eclipselink.cache.coordination.serializer", loader);
                    rcm.setSerializer((Serializer)transportClass2.newInstance());
                }
                if ((naming = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.naming-service", m, this.session)) != null) {
                    if (naming.equalsIgnoreCase("jndi")) {
                        rcm.getTransportManager().setNamingServiceType(0);
                    } else if (naming.equalsIgnoreCase("rmi")) {
                        rcm.getTransportManager().setNamingServiceType(1);
                    }
                }
                if ((user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.user", m, this.session)) != null) {
                    rcm.getTransportManager().setUserName(user);
                }
                if ((password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.password", m, this.session)) != null) {
                    rcm.getTransportManager().setPassword(password);
                }
                if ((context = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.initial-context-factory", m, this.session)) != null) {
                    rcm.getTransportManager().setInitialContextFactoryName(context);
                }
                if ((removeOnError = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.remove-connection-on-error", m, this.session)) != null) {
                    rcm.getTransportManager().setShouldRemoveConnectionOnError(removeOnError.equalsIgnoreCase("true"));
                }
                if ((asynch = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.propagate-asynchronously", m, this.session)) != null) {
                    rcm.setShouldPropagateAsynchronously(asynch.equalsIgnoreCase("true"));
                }
                String threadPoolSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.thread.pool.size", m, this.session);
                property = "eclipselink.cache.coordination.thread.pool.size";
                value = threadPoolSize;
                if (threadPoolSize != null) {
                    this.session.getServerPlatform().setThreadPoolSize(Integer.parseInt(threadPoolSize));
                }
                if ((channel = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.channel", m, this.session)) != null) {
                    rcm.setChannel(channel);
                }
                this.session.setCommandManager(rcm);
                this.session.setShouldPropagateChanges(true);
            }
        }
        catch (Exception exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(value, property, exception));
        }
    }

    protected void updateSerializer(Map m, ClassLoader loader) {
        String serializer = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.serializer", m, this.session);
        if (serializer != null) {
            if (serializer.length() > 0) {
                try {
                    Class transportClass = EntityManagerSetupImpl.findClassForProperty(serializer, "eclipselink.serializer", loader);
                    this.session.setSerializer((Serializer)transportClass.newInstance());
                }
                catch (Exception exception) {
                    this.session.handleException(ValidationException.invalidValueForProperty(serializer, "eclipselink.serializer", exception));
                }
            } else {
                this.session.setSerializer(JavaSerializer.instance);
            }
        }
    }

    protected void updateShouldOptimizeResultSetAccess(Map m) {
        String resultSetAccessOptimization = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.result-set-access-optimization", m, this.session);
        if (resultSetAccessOptimization != null) {
            this.session.setShouldOptimizeResultSetAccess(resultSetAccessOptimization.equals("true"));
        }
    }

    protected void updateTenancy(Map m, ClassLoader loader) {
        String tenantStrategy = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.strategy", m, this.session);
        if (tenantStrategy != null) {
            if ("external".equalsIgnoreCase(tenantStrategy)) {
                SchemaPerMultitenantPolicy policy = new SchemaPerMultitenantPolicy();
                String prop = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-emf", m, this.session);
                if (prop != null) {
                    policy.setShouldUseSharedEMF(Boolean.valueOf(prop));
                }
                if ((prop = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-cache", m, this.session)) != null) {
                    policy.setShouldUseSharedCache(Boolean.valueOf(prop));
                }
                this.session.getProject().setMultitenantPolicy(policy);
            } else {
                Class cls = EntityManagerSetupImpl.findClassForProperty(tenantStrategy, "eclipselink.multitenant.strategy", loader);
                MultitenantPolicy policy = null;
                try {
                    Constructor constructor = cls.getConstructor(new Class[0]);
                    policy = (MultitenantPolicy)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw EntityManagerSetupException.failedToInstantiateProperty(tenantStrategy, "eclipselink.multitenant.strategy", ex);
                }
                this.session.getProject().setMultitenantPolicy(policy);
            }
        }
    }

    protected void updateTolerateInvalidJPQL(Map m) {
        String config = PropertiesHandler.getPropertyValueLogDebug("eclipselink.tolerate-invalid-jpql", m, this.session);
        if (config != null && !this.isValidationOnly(m)) {
            this.session.setTolerateInvalidJPQL(config.equals("true"));
        }
    }

    protected void updateLogins(Map m) {
        DatasourceLogin login = (DatasourceLogin)this.session.getDatasourceLogin();
        String eclipselinkPlatform = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-database", m, this.session);
        if (eclipselinkPlatform != null) {
            login.setPlatformClassName(eclipselinkPlatform, this.persistenceUnitInfo.getClassLoader());
        }
        boolean isEIS = false;
        if (login.getDatasourcePlatform() instanceof EISPlatform) {
            isEIS = true;
            EISLogin newLogin = new EISLogin();
            newLogin.setDatasourcePlatform(login.getDatasourcePlatform());
            this.session.setDatasourceLogin(newLogin);
            if (this.session.isServerSession()) {
                for (ConnectionPool pool : ((ServerSession)this.session).getConnectionPools().values()) {
                    pool.setLogin(newLogin);
                }
            }
            login = newLogin;
        }
        Object connectorValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.nosql.connection-spec", m, this.session);
        String connectorProperty = "eclipselink.nosql.connection-spec";
        if (connectorValue == null) {
            connectorValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.jdbc.connector", m, this.session);
            connectorProperty = "eclipselink.jdbc.connector";
        }
        if (connectorValue instanceof Connector) {
            login.setConnector((Connector)connectorValue);
        } else if (connectorValue instanceof String) {
            Class cls = null;
            try {
                cls = EntityManagerSetupImpl.findClassForProperty((String)connectorValue, connectorProperty, this.persistenceUnitInfo.getClassLoader());
            }
            catch (Throwable throwable) {
                cls = EntityManagerSetupImpl.findClassForProperty((String)connectorValue, connectorProperty, this.getClass().getClassLoader());
            }
            Connector connector = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                connector = (Connector)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateProperty((String)connectorValue, connectorProperty, exception);
            }
            if (connector != null) {
                login.setConnector(connector);
            }
        } else if (connectorValue != null) {
            ((EISConnectionSpec)login.getConnector()).setConnectionSpecObject(connectorValue);
        }
        Object factoryValue = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.nosql.connection-factory", m, this.session);
        if (factoryValue instanceof String) {
            ((EISConnectionSpec)login.getConnector()).setName((String)factoryValue);
        } else if (factoryValue != null) {
            ((EISConnectionSpec)login.getConnector()).setConnectionFactoryObject(factoryValue);
        }
        Map propertiesMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.nosql.property.", m, this.session);
        if (propertiesMap.isEmpty()) {
            propertiesMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.jdbc.property.", m, this.session);
        }
        for (Map.Entry entry : propertiesMap.entrySet()) {
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            login.setProperty(property, value);
        }
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.user", m, this.session);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.password", m, this.session);
        if (user != null) {
            login.setUserName(user);
        }
        if (password != null) {
            login.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(password));
        }
        PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, this.session);
        if (transTypeString != null && transTypeString.length() > 0) {
            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
        }
        DataSource jtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource nonjtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(m, false) && transactionType == PersistenceUnitTransactionType.JTA && jtaDatasource == null) {
            this.updateLoginDefaultConnector(login, m);
            return;
        }
        login.setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        if (isEIS) {
            return;
        }
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = jtaDatasource;
            readDatasource = nonjtaDatasource;
        } else {
            if (jtaDatasource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (nonjtaDatasource != null) {
                mainDatasource = nonjtaDatasource;
            } else {
                this.updateLoginDefaultConnector(login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = mainDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)mainDatasource).getName()) : new JNDIConnector(mainDatasource);
            login.setConnector(jndiConnector);
            String useInternalConnectionPool = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.connection-pool.force-internal-pool", m, this.session);
            if (!"true".equalsIgnoreCase(useInternalConnectionPool)) {
                login.setUsesExternalConnectionPooling(true);
            }
        }
        if (this.session.isServerSession() && readDatasource != null) {
            DatasourceLogin readLogin = login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = readDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)readDatasource).getName()) : new JNDIConnector(readDatasource);
            readLogin.setConnector(jndiConnector);
            ((ServerSession)this.session).setReadConnectionPool(readLogin);
        }
    }

    protected DataSource getDatasourceFromProperties(Map m, String property, DataSource defaultDataSource) {
        Object datasource = EntityManagerFactoryProvider.getConfigPropertyLogDebug(property, m, this.session);
        if (datasource == null) {
            return defaultDataSource;
        }
        if (datasource instanceof String) {
            if (((String)datasource).length() > 0) {
                return new DataSourceImpl((String)datasource, null, null, null);
            }
            return null;
        }
        if (!(datasource instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", property, datasource);
            return defaultDataSource;
        }
        return (DataSource)datasource;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.driver", m, this.session);
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.url", m, this.session);
            if (connectionString != null) {
                dbLogin.setConnectionString(connectionString);
            }
            if (jdbcDriver != null) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected void updatePools(ServerSession serverSession, Map m) {
        String value = null;
        String property = null;
        try {
            String sequenceDataSource;
            String sequence;
            if (!serverSession.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                property = "eclipselink.jdbc.connections.min";
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property, m, serverSession);
                if (value != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.max", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.initial", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.min", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.max", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.initial", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                String wait;
                String initial;
                String max;
                String shared = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.shared", m, serverSession);
                boolean isShared = false;
                if (shared != null) {
                    isShared = Boolean.parseBoolean(shared);
                }
                ConnectionPool pool = null;
                pool = isShared ? new ReadConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession) : new ConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession);
                String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.min", m, serverSession);
                if (min != null) {
                    value = min;
                    property = "eclipselink.jdbc.read-connections.min";
                    pool.setMinNumberOfConnections(Integer.parseInt(min));
                }
                if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.max", m, serverSession)) != null) {
                    value = max;
                    property = "eclipselink.jdbc.read-connections.max";
                    pool.setMaxNumberOfConnections(Integer.parseInt(max));
                }
                if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.initial", m, serverSession)) != null) {
                    value = initial;
                    property = "eclipselink.jdbc.read-connections.initial";
                    pool.setInitialNumberOfConnections(Integer.parseInt(initial));
                }
                if (isShared || min != null || max != null || initial != null) {
                    serverSession.setReadConnectionPool(pool);
                }
                if ((wait = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.wait-timeout", m, serverSession)) != null) {
                    value = wait;
                    property = "eclipselink.jdbc.connections.wait-timeout";
                    serverSession.getDefaultConnectionPool().setWaitTimeout(Integer.parseInt(wait));
                    pool.setWaitTimeout(Integer.parseInt(wait));
                }
            }
            if ((sequence = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool", m, serverSession)) != null) {
                serverSession.getSequencingControl().setShouldUseSeparateConnection(Boolean.parseBoolean(sequence));
            }
            if ((sequenceDataSource = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.non-jta-data-source", m, serverSession)) != null) {
                DatasourceLogin login = this.session.getLogin().clone();
                login.dontUseExternalTransactionController();
                JNDIConnector jndiConnector = new JNDIConnector(sequenceDataSource);
                login.setConnector(jndiConnector);
                serverSession.getSequencingControl().setLogin(login);
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.min", m, serverSession);
                if (value != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.min";
                    serverSession.getSequencingControl().setMinPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.max", m, serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.max";
                    serverSession.getSequencingControl().setMaxPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.initial", m, serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.initial";
                    serverSession.getSequencingControl().setInitialPoolSize(Integer.parseInt(value));
                }
            }
        }
        catch (NumberFormatException exception) {
            serverSession.handleException(ValidationException.invalidValueForProperty(value, property, exception));
        }
    }

    protected void initSession() {
        this.assignCMP3Policy();
        if (!this.isCompositeMember()) {
            this.addSessionToGlobalSessionManager();
        }
    }

    protected void updateSession(Map m, ClassLoader loader) {
        if (this.session == null || this.session.isDatabaseSession() && ((DatabaseSessionImpl)this.session).isLoggedIn()) {
            return;
        }
        boolean serverPlatformChanged = this.updateServerPlatform(m, loader);
        this.updateJPQLParser(m);
        if (!this.session.hasBroker()) {
            this.updateLoggers(m, serverPlatformChanged, loader);
            this.updateProfiler(m, loader);
        }
        if (this.session.isBroker()) {
            PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
            String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, this.session);
            if (transTypeString != null) {
                transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
            }
            ((DatasourceLogin)this.session.getDatasourceLogin()).setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        } else {
            String shouldBindString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.bind-parameters", m, this.session);
            if (shouldBindString != null) {
                this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(shouldBindString));
            }
            this.updateLogins(m);
        }
        if (!this.session.getDatasourceLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        if (this.session.isServerSession()) {
            this.updatePools((ServerSession)this.session, m);
            this.updateConnectionSettings((ServerSession)this.session, m);
            if (!this.isSessionLoadedFromSessionsXML) {
                this.updateDescriptorCacheSettings(m, loader);
            }
            this.updateConnectionPolicy((ServerSession)this.session, m);
        }
        if (this.session.isBroker()) {
            if (this.compositeMemberEmSetupImpls != null) {
                Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", m);
                for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                    String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                    Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberPuName);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                    compositeMemberEmSetupImpl.updateSession(compositeMemberProperties, loader);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                }
            }
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateAllowZeroIdSetting(m);
            this.updateCacheCoordination(m, loader);
            this.processSessionCustomizer(m, loader);
        } else {
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateBatchWritingSetting(m, loader);
            this.updateNativeSQLSetting(m);
            this.updateSequencing(m);
            this.updateSequencingStart(m);
            this.updateAllowNativeSQLQueriesSetting(m);
            this.updateSQLCastSetting(m);
            this.updateUppercaseSetting(m);
            this.updateCacheStatementSettings(m);
            this.updateTemporalMutableSetting(m);
            this.updateTableCreationSettings(m);
            this.updateIndexForeignKeys(m);
            if (!this.session.hasBroker()) {
                this.updateAllowZeroIdSetting(m);
            }
            this.updateIdValidation(m);
            this.updatePessimisticLockTimeout(m);
            this.updateQueryTimeout(m);
            this.updateQueryTimeoutUnit(m);
            this.updateLockingTimestampDefault(m);
            this.updateSQLCallDeferralDefault(m);
            if (!this.session.hasBroker()) {
                this.updateCacheCoordination(m, loader);
            }
            this.updatePartitioning(m, loader);
            this.updateDatabaseEventListener(m, loader);
            this.updateSerializer(m, loader);
            this.updateShouldOptimizeResultSetAccess(m);
            this.updateTolerateInvalidJPQL(m);
            this.updateTenancy(m, loader);
            this.processDescriptorCustomizers(m, loader);
            this.processSessionCustomizer(m, loader);
            this.setDescriptorNamedQueries(m);
        }
    }

    public void setIsInContainerMode(boolean isInContainerMode) {
        this.isInContainerMode = isInContainerMode;
    }

    public void setIsMetadataExpired(boolean hasExpiredMetadata) {
        this.isMetadataExpired = hasExpiredMetadata;
    }

    protected void processSessionCustomizer(Map m, ClassLoader loader) {
        SessionCustomizer sessionCustomizer;
        Object customizer = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.session.customizer", m, this.session);
        if (customizer == null) {
            return;
        }
        if (customizer instanceof String) {
            Class sessionCustomizerClass = EntityManagerSetupImpl.findClassForProperty((String)customizer, "eclipselink.session.customizer", loader);
            try {
                sessionCustomizer = (SessionCustomizer)sessionCustomizerClass.newInstance();
            }
            catch (Exception ex) {
                throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.session.customizer", (String)customizer, ex);
            }
        } else {
            sessionCustomizer = (SessionCustomizer)customizer;
        }
        try {
            sessionCustomizer.customize(this.session);
        }
        catch (Exception ex) {
            throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.session.customizer", customizer.toString(), ex);
        }
    }

    protected void initOrUpdateLogging(Map m, SessionLog log) {
        String shouldDisplayData;
        String exString;
        String connectionString;
        String sessionString;
        String threadString;
        String tsString;
        Map categoryLogLevelMap;
        String logLevelString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.level", m, this.session);
        if (logLevelString != null) {
            log.setLevel(AbstractSessionLog.translateStringToLoggingLevel(logLevelString));
        }
        if (!(categoryLogLevelMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.logging.level.", m, this.session)).isEmpty()) {
            for (Map.Entry entry : categoryLogLevelMap.entrySet()) {
                String category = (String)entry.getKey();
                String value = (String)entry.getValue();
                log.setLevel(AbstractSessionLog.translateStringToLoggingLevel(value), category);
            }
        }
        if ((tsString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.timestamp", m, this.session)) != null) {
            log.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.thread", m, this.session)) != null) {
            log.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.session", m, this.session)) != null) {
            log.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.connection", m, this.session)) != null) {
            log.setShouldPrintConnection(Boolean.parseBoolean(connectionString));
        }
        if ((exString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.exceptions", m, this.session)) != null) {
            log.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
        if ((shouldDisplayData = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.parameters", m, this.session)) != null) {
            log.setShouldDisplayData(Boolean.parseBoolean(shouldDisplayData));
        }
    }

    protected void processDescriptorCustomizers(Map m, ClassLoader loader) {
        Map customizerMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.descriptor.customizer.", m, this.session);
        if (customizerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : customizerMap.entrySet()) {
            String name = (String)entry.getKey();
            String customizerClassName = (String)entry.getValue();
            ClassDescriptor descriptor = this.session.getDescriptorForAlias(name);
            if (descriptor == null) {
                try {
                    Class javaClass = EntityManagerSetupImpl.findClass(name, loader);
                    descriptor = this.session.getDescriptor(javaClass);
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, ex);
                }
            }
            if (descriptor != null) {
                Class customizerClass = EntityManagerSetupImpl.findClassForProperty(customizerClassName, "eclipselink.descriptor.customizer." + name, loader);
                try {
                    DescriptorCustomizer customizer = (DescriptorCustomizer)customizerClass.newInstance();
                    customizer.customize(descriptor);
                    continue;
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, ex);
                }
            }
            throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, null);
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isMetadataExpired() {
        return this.isMetadataExpired;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isHalfDeployed() {
        return this.state == STATE_HALF_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public boolean isHalfPredeployedCompositeMember() {
        return this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
    }

    public String getPersistenceUnitUniqueName() {
        return this.persistenceUnitUniqueName;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean shouldSendMetadataRefreshCommand(Map m) {
        String sendCommand = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.metadata-source.send-refresh-command", m, this.session);
        if (sendCommand != null) {
            return Boolean.parseBoolean(sendCommand);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block11: {
            if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                return;
            }
            this.session.log(1, "jpa", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            try {
                --this.factoryCount;
                if (this.factoryCount <= 0) break block11;
            }
            catch (Throwable throwable) {
                this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                throw throwable;
            }
            this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.state == STATE_UNDEPLOYED) {
                this.session = null;
            }
            return;
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            this.state = STATE_UNDEPLOYED;
            this.removeSessionFromGlobalSessionManager();
            EntityManagerSetupImpl emSetupImpl = EntityManagerFactoryProvider.emSetupImpls.get(this.sessionName);
            if (emSetupImpl != null && emSetupImpl.equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(this.sessionName);
            }
        }
        this.session.log(1, "jpa", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }

    public void setRequiresConnection(boolean requiresConnection) {
        this.requiresConnection = requiresConnection;
    }

    protected void setSessionEventListener(Map m, ClassLoader loader) {
        String sessionEventListenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-event-listener", m, this.session);
        if (sessionEventListenerClassName != null) {
            Class sessionEventListenerClass = EntityManagerSetupImpl.findClassForProperty(sessionEventListenerClassName, "eclipselink.session-event-listener", loader);
            try {
                SessionEventListener sessionEventListener = (SessionEventListener)EntityManagerSetupImpl.buildObjectForClass(sessionEventListenerClass, SessionEventListener.class);
                if (sessionEventListener != null) {
                    this.session.getEventManager().addListener(sessionEventListener);
                } else {
                    this.session.handleException(ValidationException.invalidSessionEventListenerClass(sessionEventListenerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
        }
    }

    protected void setExceptionHandler(Map m, ClassLoader loader) {
        String exceptionHandlerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.exception-handler", m, this.session);
        if (exceptionHandlerClassName != null) {
            Class exceptionHandlerClass = EntityManagerSetupImpl.findClassForProperty(exceptionHandlerClassName, "eclipselink.exception-handler", loader);
            try {
                ExceptionHandler exceptionHandler = (ExceptionHandler)EntityManagerSetupImpl.buildObjectForClass(exceptionHandlerClass, ExceptionHandler.class);
                if (exceptionHandler != null) {
                    this.session.setExceptionHandler(exceptionHandler);
                } else {
                    this.session.handleException(ValidationException.invalidExceptionHandlerClass(exceptionHandlerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
        }
    }

    protected void updateBatchWritingSetting(Map persistenceProperties, ClassLoader loader) {
        String sizeString;
        String batchWritingSettingString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.batch-writing", persistenceProperties, this.session);
        if (batchWritingSettingString != null) {
            this.session.getPlatform().setUsesBatchWriting(batchWritingSettingString != "None");
            if (batchWritingSettingString == "JDBC") {
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Buffered") {
                this.session.getPlatform().setUsesJDBCBatchWriting(false);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Oracle-JDBC") {
                this.session.getPlatform().setUsesNativeBatchWriting(true);
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
            } else if (batchWritingSettingString != "None") {
                if (batchWritingSettingString.equalsIgnoreCase("ExaLogic")) {
                    batchWritingSettingString = "oracle.toplink.exalogic.batch.DynamicParameterizedBatchWritingMechanism";
                }
                Class cls = EntityManagerSetupImpl.findClassForProperty(batchWritingSettingString, "eclipselink.jdbc.batch-writing", loader);
                BatchWritingMechanism mechanism = null;
                try {
                    Constructor constructor = cls.getConstructor(new Class[0]);
                    mechanism = (BatchWritingMechanism)constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    if (batchWritingSettingString.indexOf(46) == -1) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{"eclipselink.jdbc.batch-writing", batchWritingSettingString}));
                    }
                    throw EntityManagerSetupException.failedToInstantiateProperty(batchWritingSettingString, "eclipselink.jdbc.batch-writing", exception);
                }
                this.session.getPlatform().setBatchWritingMechanism(mechanism);
            }
        }
        if ((sizeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.batch-writing.size", persistenceProperties, this.session)) != null) {
            try {
                this.session.getPlatform().setMaxBatchWritingSize(Integer.parseInt(sizeString));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException(ValidationException.invalidValueForProperty(sizeString, "eclipselink.jdbc.batch-writing.size", invalid));
            }
        }
    }

    protected void updateMetadataRepository(Map m, ClassLoader loader) {
        Object metadataSource = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.metadata-source", m, this.session);
        if (metadataSource != null && metadataSource instanceof MetadataSource) {
            this.processor.setMetadataSource((MetadataSource)metadataSource);
        } else if (metadataSource != null) {
            String repository = (String)metadataSource;
            if (repository.equalsIgnoreCase("XML")) {
                this.processor.setMetadataSource(new XMLMetadataSource());
            } else {
                Class transportClass = EntityManagerSetupImpl.findClassForProperty(repository, "eclipselink.metadata-source", loader);
                try {
                    this.processor.setMetadataSource((MetadataSource)transportClass.newInstance());
                }
                catch (Exception invalid) {
                    this.session.handleException(EntityManagerSetupException.failedToInstantiateProperty(repository, "eclipselink.metadata-source", invalid));
                }
            }
        }
    }

    protected void updateTunerPreDeploy(Map m, ClassLoader loader) {
        String tuning = (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.tuning", m, this.session);
        if (tuning != null) {
            SessionTuner tuner = null;
            if (tuning.equalsIgnoreCase("Safe")) {
                tuner = new SafeModeTuner();
            } else if (tuning.equalsIgnoreCase("Standard")) {
                tuner = new StandardTuner();
            } else {
                if (tuning.equalsIgnoreCase("ExaLogic")) {
                    tuning = "oracle.toplink.exalogic.tuning.ExaLogicTuner";
                }
                Class tunerClass = EntityManagerSetupImpl.findClassForProperty(tuning, "eclipselink.tuning", loader);
                try {
                    tuner = (SessionTuner)tunerClass.newInstance();
                }
                catch (Exception invalid) {
                    this.session.handleException(EntityManagerSetupException.failedToInstantiateProperty(tuning, "eclipselink.tuning", invalid));
                }
            }
            this.getDatabaseSession().setTuner(tuner);
            tuner.tunePreDeploy(m);
        }
    }

    protected void updateTunerDeploy(Map m, ClassLoader loader) {
        if (this.getDatabaseSession().getTuner() != null) {
            this.getDatabaseSession().getTuner().tuneDeploy(this.getDatabaseSession());
        }
    }

    protected void updateTunerPostDeploy(Map m, ClassLoader loader) {
        if (this.getDatabaseSession().getTuner() != null) {
            this.getDatabaseSession().getTuner().tunePostDeploy(this.getDatabaseSession());
        }
    }

    protected void updateFreeMemory(Map m) {
        String freeMemory = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.memory.free-metadata", m, this.session);
        if (freeMemory != null) {
            if (freeMemory.equalsIgnoreCase("true")) {
                XMLEntityMappingsReader.clear();
            } else if (!freeMemory.equalsIgnoreCase("false")) {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(freeMemory, "eclipselink.memory.free-metadata"));
            }
        }
    }

    protected void updateNativeSQLSetting(Map m) {
        String nativeSQLString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.native-sql", m, this.session);
        if (nativeSQLString != null) {
            if (nativeSQLString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().useNativeSQL();
            } else if (nativeSQLString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().dontUseNativeSQL();
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForSettingNativeSQL(nativeSQLString));
            }
        }
    }

    protected void updateSequencing(Map m) {
        String useTable = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.sequencing.default-sequence-to-table", m, this.session);
        if (useTable != null) {
            if (useTable.equalsIgnoreCase("true")) {
                this.session.getPlatform().setDefaultNativeSequenceToTable(true);
            } else if (useTable.equalsIgnoreCase("false")) {
                this.session.getPlatform().setDefaultNativeSequenceToTable(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(useTable, "eclipselink.sequencing.default-sequence-to-table"));
            }
        }
    }

    protected void updateSequencingStart(Map m) {
        String local = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.sequencing.start-sequence-at-nextval", m, this.session);
        try {
            if (local != null) {
                this.session.getPlatform().setDefaultSeqenceAtNextValue(Boolean.parseBoolean(local));
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(local, "eclipselink.locking.timestamp.local.default", exception));
        }
    }

    protected void updateProjectCache(Map m, ClassLoader loader) {
        Object accessor = EntityManagerFactoryProvider.getConfigPropertyLogDebug("eclipselink.project-cache", m, this.session);
        if (accessor != null) {
            if (accessor instanceof ProjectCache) {
                this.projectCacheAccessor = (ProjectCache)accessor;
            } else {
                String accessorType = (String)accessor;
                if (accessorType.equalsIgnoreCase("java-serialization")) {
                    this.projectCacheAccessor = new FileBasedProjectCache();
                } else {
                    Class transportClass = EntityManagerSetupImpl.findClassForProperty(accessorType, "eclipselink.project-cache", loader);
                    try {
                        this.projectCacheAccessor = (ProjectCache)transportClass.newInstance();
                    }
                    catch (Exception invalid) {
                        this.session.handleException(EntityManagerSetupException.failedToInstantiateProperty(accessorType, "eclipselink.metadata-source", invalid));
                    }
                }
            }
        }
    }

    protected void updateJPQLParser(Map m) {
        String validation;
        String parser = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpql.parser", m, this.session);
        if (parser != null) {
            if (parser.equalsIgnoreCase("Hermes")) {
                parser = "org.eclipse.persistence.internal.jpa.jpql.HermesParser";
            } else if (parser.equalsIgnoreCase("ANTLR")) {
                parser = "org.eclipse.persistence.queries.ANTLRQueryBuilder";
            }
            this.session.setProperty("eclipselink.jpql.parser", parser);
        }
        if ((validation = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpql.validation", m, this.session)) != null) {
            this.session.setProperty("eclipselink.jpql.validation", validation);
        }
    }

    protected void updateAllowNativeSQLQueriesSetting(Map m) {
        String allowNativeSQLQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.allow-native-sql-queries", m, this.session);
        if (allowNativeSQLQueriesString != null) {
            if (allowNativeSQLQueriesString.equalsIgnoreCase("true")) {
                this.session.getProject().setAllowNativeSQLQueries(true);
            } else if (allowNativeSQLQueriesString.equalsIgnoreCase("false")) {
                this.session.getProject().setAllowNativeSQLQueries(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForSettingAllowNativeSQLQueries(allowNativeSQLQueriesString));
            }
        }
    }

    protected void updateSQLCastSetting(Map m) {
        String sqlCastString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sql-cast", m, this.session);
        if (sqlCastString != null) {
            if (sqlCastString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(true);
            } else if (sqlCastString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(sqlCastString, "eclipselink.jdbc.sql-cast"));
            }
        }
    }

    protected void updateUppercaseSetting(Map m) {
        String uppercaseString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.uppercase-columns", m, this.session);
        if (uppercaseString != null) {
            if (uppercaseString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (uppercaseString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(uppercaseString, "eclipselink.jdbc.uppercase-columns"));
            }
        }
    }

    public static void updateCaseSensitivitySettings(Map m, MetadataProject project, AbstractSession session) {
        String insensitiveString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpa.uppercase-column-names", m, session);
        if (insensitiveString == null || insensitiveString.equalsIgnoreCase("true")) {
            project.setShouldForceFieldNamesToUpperCase(true);
            session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
        } else if (insensitiveString.equalsIgnoreCase("false")) {
            project.setShouldForceFieldNamesToUpperCase(false);
            session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
        } else {
            session.handleException(ValidationException.invalidBooleanValueForProperty(insensitiveString, "eclipselink.jpa.uppercase-column-names"));
        }
    }

    protected void updatePessimisticLockTimeout(Map persistenceProperties) {
        String pessimisticLockTimeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.lock.timeout", persistenceProperties, this.session);
        if (pessimisticLockTimeout != null) {
            try {
                this.session.setPessimisticLockTimeoutDefault(Integer.parseInt(pessimisticLockTimeout));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException(ValidationException.invalidValueForProperty(pessimisticLockTimeout, "javax.persistence.lock.timeout", invalid));
            }
        }
    }

    protected void updateCacheStatementSettings(Map m) {
        String cacheStatementsSize;
        String statmentsNeedBeCached = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements", m, this.session);
        if (statmentsNeedBeCached != null) {
            if (statmentsNeedBeCached.equalsIgnoreCase("true")) {
                if (this.session.isServerSession() && ((ServerSession)this.session).getConnectionPools().isEmpty()) {
                    this.session.log(6, "properties", "persistence_unit_ignores_statments_cache_setting", new Object[1]);
                } else {
                    this.session.getProject().getLogin().setShouldCacheAllStatements(true);
                }
            } else if (statmentsNeedBeCached.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCacheAllStatements(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForEnableStatmentsCached(statmentsNeedBeCached));
            }
        }
        if ((cacheStatementsSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements.size", m, this.session)) != null) {
            try {
                this.session.getProject().getLogin().setStatementCacheSize(Integer.parseInt(cacheStatementsSize));
            }
            catch (NumberFormatException e) {
                this.session.handleException(ValidationException.invalidCacheStatementsSize(cacheStatementsSize, e.getMessage()));
            }
        }
    }

    protected void updateAllowZeroIdSetting(Map m) {
        String allowZero = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.allow-zero-id", m, this.session);
        if (allowZero != null) {
            if (allowZero.equalsIgnoreCase("true")) {
                Helper.isZeroValidPrimaryKey = true;
            } else if (allowZero.equalsIgnoreCase("false")) {
                Helper.isZeroValidPrimaryKey = false;
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(allowZero, "eclipselink.allow-zero-id"));
            }
        }
    }

    protected void updateIdValidation(Map m) {
        String idValidationString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.id-validation", m, this.session);
        if (idValidationString != null) {
            this.session.getProject().setDefaultIdValidation(IdValidation.valueOf(idValidationString));
        }
    }

    protected void updateSharedCacheMode(Map m) {
        String sharedCacheMode = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.sharedCache.mode", m, this.session);
        if (sharedCacheMode != null) {
            this.processor.getProject().setSharedCacheMode(SharedCacheMode.valueOf((String)sharedCacheMode));
        }
    }

    protected void updateTableCreationSettings(Map m) {
        String tableCreationSuffix = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.ddl-generation.table-creation-suffix", m, this.session);
        if (tableCreationSuffix != null && tableCreationSuffix.length() > 0) {
            this.session.getPlatform().setTableCreationSuffix(tableCreationSuffix);
        }
    }

    protected void updateIndexForeignKeys(Map m) {
        String indexForeignKeys = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.ddl-generation.index-foreign-keys", m, this.session);
        if (indexForeignKeys != null && indexForeignKeys.length() > 0) {
            if (indexForeignKeys.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldCreateIndicesOnForeignKeys(true);
            } else if (indexForeignKeys.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCreateIndicesOnForeignKeys(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(indexForeignKeys, "eclipselink.ddl-generation.index-foreign-keys"));
            }
        }
    }

    protected void updateTemporalMutableSetting(Map m) {
        String temporalMutable = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.temporal.mutable", m, this.session);
        if (temporalMutable != null) {
            if (temporalMutable.equalsIgnoreCase("true")) {
                this.session.getProject().setDefaultTemporalMutable(true);
            } else if (temporalMutable.equalsIgnoreCase("false")) {
                this.session.getProject().setDefaultTemporalMutable(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(temporalMutable, "eclipselink.temporal.mutable"));
            }
        }
    }

    protected void setDescriptorNamedQueries(Map m) {
        String addNamedQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.include.descriptor.queries", m, this.session);
        if (addNamedQueriesString != null) {
            if (addNamedQueriesString.equalsIgnoreCase("true")) {
                this.session.copyDescriptorNamedQueries(false);
            } else if (!addNamedQueriesString.equalsIgnoreCase("false")) {
                this.session.handleException(ValidationException.invalidBooleanValueForAddingNamedQueries(addNamedQueriesString));
            }
        }
    }

    private void updateQueryTimeout(Map persistenceProperties) {
        String timeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.query.timeout", persistenceProperties, this.session);
        try {
            if (timeout != null) {
                this.session.setQueryTimeoutDefault(Integer.parseInt(timeout));
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(timeout, "javax.persistence.query.timeout", exception));
        }
    }

    private void updateQueryTimeoutUnit(Map persistenceProperties) {
        String timeoutUnit = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.query.timeout.unit", persistenceProperties, this.session);
        try {
            if (timeoutUnit != null) {
                TimeUnit unit = TimeUnit.valueOf(timeoutUnit);
                this.session.setQueryTimeoutUnitDefault(unit);
            }
        }
        catch (IllegalArgumentException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(timeoutUnit, "eclipselink.query.timeout.unit", exception));
        }
    }

    private void updateLockingTimestampDefault(Map persistenceProperties) {
        String local = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.locking.timestamp.local.default", persistenceProperties, this.session);
        try {
            if (local != null) {
                for (ClassDescriptor descriptor : this.session.getProject().getDescriptors().values()) {
                    OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                    if (!(policy instanceof TimestampLockingPolicy)) continue;
                    ((TimestampLockingPolicy)policy).setUsesServerTime(!Boolean.parseBoolean(local));
                }
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(local, "eclipselink.locking.timestamp.local.default", exception));
        }
    }

    private void updateSQLCallDeferralDefault(Map persistenceProperties) {
        String defer = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpa.sql-call-deferral", persistenceProperties, this.session);
        if (defer != null) {
            if (defer.equalsIgnoreCase("true")) {
                this.session.getProject().setAllowSQLDeferral(true);
            } else if (defer.equalsIgnoreCase("false")) {
                this.session.getProject().setAllowSQLDeferral(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(defer, "eclipselink.jpa.sql-call-deferral"));
            }
        }
    }

    private void addBeanValidationListeners(Map puProperties, ClassLoader appClassLoader) {
        ValidationMode validationMode = EntityManagerSetupImpl.getValidationMode(this.persistenceUnitInfo, puProperties);
        if (validationMode == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            String helperClassName = "org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper$BeanValidationInitializationHelperImpl";
            ClassLoader eclipseLinkClassLoader = EntityManagerSetupImpl.class.getClassLoader();
            try {
                Class helperClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(helperClassName, true, eclipseLinkClassLoader)) : PrivilegedAccessHelper.getClassForName(helperClassName, true, eclipseLinkClassLoader);
                BeanValidationInitializationHelper beanValidationInitializationHelper = (BeanValidationInitializationHelper)helperClass.newInstance();
                beanValidationInitializationHelper.bootstrapBeanValidation(puProperties, this.session, appClassLoader);
            }
            catch (Throwable e) {
                if (validationMode == ValidationMode.CALLBACK) {
                    throw PersistenceUnitLoadingException.exceptionObtainingRequiredBeanValidatorFactory(e);
                }
                this.session.log(1, "jpa", "validation_factory_not_initialized", new Object[]{e.getMessage()});
            }
        }
    }

    private static ValidationMode getValidationMode(PersistenceUnitInfo persitenceUnitInfo, Map puProperties) {
        String validationModeAtEMFCreation = (String)puProperties.get("javax.persistence.validation.mode");
        if (validationModeAtEMFCreation != null) {
            return ValidationMode.valueOf((String)validationModeAtEMFCreation.toUpperCase());
        }
        ValidationMode validationMode = null;
        try {
            Method method = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null));
                validationMode = (ValidationMode)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, persitenceUnitInfo));
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null);
                validationMode = (ValidationMode)PrivilegedAccessHelper.invokeMethod(method, persitenceUnitInfo, null);
            }
        }
        catch (Throwable throwable) {}
        if (validationMode == null) {
            validationMode = ValidationMode.AUTO;
        }
        return validationMode;
    }

    public Metamodel getMetamodel(ClassLoader classLoader) {
        this.preInitializeMetamodel();
        if (!((MetamodelImpl)this.metaModel).isInitialized()) {
            ((MetamodelImpl)this.metaModel).initialize(classLoader);
            this.initializeCanonicalMetamodel(this.metaModel);
        }
        return this.metaModel;
    }

    protected void initializeCanonicalMetamodel(Metamodel model) {
        if (model.getManagedTypes() == null || model.getManagedTypes().isEmpty()) {
            this.getSession().log(2, "metamodel", "metamodel_type_collection_empty");
        }
        for (ManagedType manType : model.getManagedTypes()) {
            boolean classInitialized = false;
            String className = MetadataHelper.getQualifiedCanonicalName(manType.getJavaType().getName(), this.getSession());
            try {
                Class clazz = (Class)this.getSession().getDatasourcePlatform().convertObject(className, ClassConstants.CLASS);
                classInitialized = true;
                this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_found", className);
                String fieldName = "";
                for (Object attribute : manType.getDeclaredAttributes()) {
                    try {
                        fieldName = ((Attribute)attribute).getName();
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            ((Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clazz, fieldName, false))).set(clazz, attribute);
                            continue;
                        }
                        PrivilegedAccessHelper.getDeclaredField(clazz, fieldName, false).set(clazz, attribute);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (Exception e) {
                        ValidationException v = ValidationException.invalidFieldForClass(fieldName, clazz);
                        v.setInternalException(e);
                        throw v;
                    }
                }
            }
            catch (ConversionException conversionException) {}
            if (classInitialized) continue;
            this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_not_found", className);
        }
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.metaModel = aMetamodel;
    }

    public boolean mustBeCompositeMember() {
        return EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo);
    }

    public boolean isCompositeMember() {
        return this.compositeEmSetupImpl != null;
    }

    public boolean isComposite() {
        return this.compositeMemberEmSetupImpls != null;
    }

    public static boolean mustBeCompositeMember(PersistenceUnitInfo puInfo) {
        String mustBeCompositeMemberStr = PropertiesHandler.getPropertyValue("eclipselink.composite-unit.member", puInfo.getProperties(), false);
        if (mustBeCompositeMemberStr != null) {
            return mustBeCompositeMemberStr.equals("true");
        }
        return false;
    }

    public static boolean isComposite(PersistenceUnitInfo puInfo) {
        String isCompositeString = PropertiesHandler.getPropertyValue("eclipselink.composite-unit", puInfo.getProperties(), false);
        if (isCompositeString != null) {
            return isCompositeString.equals("true");
        }
        return false;
    }

    public void setCompositeEmSetupImpl(EntityManagerSetupImpl compositeEmSetupImpl) {
        this.compositeEmSetupImpl = compositeEmSetupImpl;
    }

    public EntityManagerSetupImpl getCompositeEmSetupImpl() {
        return this.compositeEmSetupImpl;
    }

    public void setStaticWeaveInfo(StaticWeaveInfo staticWeaveInfo) {
        this.staticWeaveInfo = staticWeaveInfo;
    }

    protected void predeployCompositeMembers(Map predeployProperties, ClassLoader tempClassLoader) {
        Set<SEPersistenceUnitInfo> compositeMemberPuInfos = EntityManagerSetupImpl.getCompositeMemberPuInfoSet(this.persistenceUnitInfo, predeployProperties);
        this.updateCompositeMembersProperties(compositeMemberPuInfos, predeployProperties);
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", predeployProperties);
        this.compositeMemberEmSetupImpls = new HashSet<EntityManagerSetupImpl>(compositeMemberPuInfos.size());
        this.processor = new MetadataProcessor();
        if (this.enableWeaving.booleanValue()) {
            this.weaver = new PersistenceWeaver(this.session, new HashMap());
        }
        for (SEPersistenceUnitInfo compositeMemberPuInfo : compositeMemberPuInfos) {
            compositeMemberPuInfo.setNewTempClassLoader(tempClassLoader);
            String containedPuName = compositeMemberPuInfo.getPersistenceUnitName();
            EntityManagerSetupImpl containedEmSetupImpl = new EntityManagerSetupImpl(containedPuName, containedPuName);
            containedEmSetupImpl.setCompositeEmSetupImpl(this);
            containedEmSetupImpl.setStaticWeaveInfo(this.staticWeaveInfo);
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(containedPuName);
            containedEmSetupImpl.predeploy(compositeMemberPuInfo, compositeMemberProperties);
            compositeMemberPuInfo.setNewTempClassLoader(compositeMemberPuInfo.getClassLoader());
            this.compositeMemberEmSetupImpls.add(containedEmSetupImpl);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            containedEmSetupImpl.predeploy(null, null);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            PersistenceWeaver containedWeaver = (PersistenceWeaver)containedEmSetupImpl.predeploy(null, null);
            if (!this.enableWeaving.booleanValue() || containedWeaver == null) continue;
            this.weaver.getClassDetailsMap().putAll(containedWeaver.getClassDetailsMap());
        }
        if (this.enableWeaving.booleanValue() && this.weaver.getClassDetailsMap().isEmpty()) {
            this.weaver = null;
        }
    }

    protected void deployCompositeMembers(Map deployProperties, ClassLoader realClassLoader) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", deployProperties);
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
            compositeMemberEmSetupImpl.deploy(realClassLoader, compositeMemberProperties);
            AbstractSession containedSession = compositeMemberEmSetupImpl.getSession();
            ((SessionBroker)this.session).registerSession(containedSession.getName(), containedSession);
        }
    }

    public void preInitializeMetamodel() {
        MetamodelImpl tempMetaModel = null;
        if (this.metaModel == null) {
            tempMetaModel = new MetamodelImpl(this);
            this.metaModel = tempMetaModel;
        }
    }

    public void preInitializeCanonicalMetamodel(EntityManagerFactoryImpl factory) {
        if (this.metaModel.getManagedTypes() == null || this.metaModel.getManagedTypes().isEmpty()) {
            this.getSession().log(2, "metamodel", "metamodel_type_collection_empty");
        }
        for (ManagedType manType : this.metaModel.getManagedTypes()) {
            boolean classInitialized = false;
            String className = MetadataHelper.getQualifiedCanonicalName(((ManagedTypeImpl)manType).getJavaTypeName(), this.getSession());
            try {
                Class clazz = (Class)this.getSession().getDatasourcePlatform().convertObject(className, ClassConstants.CLASS);
                classInitialized = true;
                this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_found", className);
                Field[] fields = null;
                fields = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(clazz)) : PrivilegedAccessHelper.getDeclaredFields(clazz);
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field attribute = fieldArray[n2];
                    if (Attribute.class.isAssignableFrom(attribute.getType())) {
                        Object assignedAttribute = null;
                        assignedAttribute = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetValueFromField(attribute, null)) : PrivilegedAccessHelper.getValueFromField(attribute, null);
                        AttributeProxyImpl proxy = null;
                        if (assignedAttribute == null) {
                            if (SingularAttribute.class.isAssignableFrom(attribute.getType())) {
                                proxy = new SingularAttributeProxyImpl();
                            } else if (MapAttribute.class.isAssignableFrom(attribute.getType())) {
                                proxy = new MapAttributeProxyImpl();
                            } else if (SetAttribute.class.isAssignableFrom(attribute.getType())) {
                                proxy = new SetAttributeProxyImpl();
                            } else if (ListAttribute.class.isAssignableFrom(attribute.getType())) {
                                proxy = new ListAttributeProxyImpl();
                            } else if (CollectionAttribute.class.isAssignableFrom(attribute.getType())) {
                                proxy = new CollectionAttributeProxyImpl();
                            }
                            if (proxy != null) {
                                attribute.setAccessible(true);
                                attribute.set(null, proxy);
                            }
                        } else if (assignedAttribute instanceof AttributeProxyImpl) {
                            proxy = (SingularAttributeProxyImpl)assignedAttribute;
                        }
                        if (proxy != null) {
                            proxy.addFactory(factory);
                        }
                    }
                    ++n2;
                }
            }
            catch (PrivilegedActionException pae) {
                this.getSession().logThrowable(1, "metamodel", pae);
            }
            catch (IllegalAccessException iae) {
                this.getSession().logThrowable(1, "metamodel", iae);
            }
            catch (ConversionException conversionException) {}
            if (classInitialized) continue;
            this.getSession().log(2, "metamodel", "metamodel_canonical_model_class_not_found", className);
        }
    }

    protected void updateCompositeMembersProperties(Map compositeProperties) {
        HashSet<SEPersistenceUnitInfo> compositePuInfos = new HashSet<SEPersistenceUnitInfo>(this.compositeMemberEmSetupImpls.size());
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            compositePuInfos.add((SEPersistenceUnitInfo)compositeMemberEmSetupImpl.persistenceUnitInfo);
        }
        this.updateCompositeMembersProperties(compositePuInfos, compositeProperties);
    }

    protected void updateCompositeMembersProperties(Set<SEPersistenceUnitInfo> compositePuInfos, Map compositeProperties) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", compositeProperties);
        HashMap newCompositeMemberMapOfProperties = compositeMemberMapOfProperties == null ? new HashMap(compositePuInfos.size()) : new HashMap(compositeMemberMapOfProperties);
        for (SEPersistenceUnitInfo compositePuInfo : compositePuInfos) {
            String compositeMemberPuName = compositePuInfo.getPersistenceUnitName();
            Map compositeMemberProperties = (Map)newCompositeMemberMapOfProperties.get(compositeMemberPuName);
            Map newCompositeMemberProperties = compositeMemberProperties == null ? new HashMap() : new HashMap(compositeMemberProperties);
            EntityManagerSetupImpl.overrideMemberProperties(newCompositeMemberProperties, compositeProperties);
            newCompositeMemberProperties = EntityManagerFactoryProvider.mergeMaps(newCompositeMemberProperties, compositePuInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(newCompositeMemberProperties, this.session);
            newCompositeMemberMapOfProperties.put(compositeMemberPuName, newCompositeMemberProperties);
        }
        compositeProperties.put("eclipselink.composite-unit.properties", newCompositeMemberMapOfProperties);
    }

    protected static void overrideMemberProperties(Map memberProperties, Map compositeProperties) {
        String transactionTypeProp = (String)compositeProperties.get("javax.persistence.transactionType");
        if (transactionTypeProp != null) {
            memberProperties.put("javax.persistence.transactionType", transactionTypeProp);
        } else {
            memberProperties.remove("javax.persistence.transactionType");
        }
        String serverPlatformProp = (String)compositeProperties.get("eclipselink.target-server");
        if (serverPlatformProp != null) {
            memberProperties.put("eclipselink.target-server", serverPlatformProp);
        } else {
            memberProperties.remove("eclipselink.target-server");
        }
        Boolean isValidationOnly = (Boolean)compositeProperties.get("eclipselink.validation-only");
        if (isValidationOnly != null) {
            memberProperties.put("eclipselink.validation-only", isValidationOnly);
        } else {
            memberProperties.remove("eclipselink.validation-only");
        }
    }

    protected static Map<String, SEPersistenceUnitInfo> getCompositeMemberPuInfoMap(PersistenceUnitInfo puInfo, Map predeployProperties) {
        Set<SEPersistenceUnitInfo> memeberPuInfoSet = PersistenceUnitProcessor.getPersistenceUnits(puInfo.getClassLoader(), predeployProperties, puInfo.getJarFileUrls());
        HashMap<String, SEPersistenceUnitInfo> memberPuInfoMap = new HashMap<String, SEPersistenceUnitInfo>(memeberPuInfoSet.size());
        for (SEPersistenceUnitInfo memberPuInfo : memeberPuInfoSet) {
            memberPuInfo.setTransactionType(puInfo.getTransactionType());
            EntityManagerSetupImpl.overrideMemberProperties(memberPuInfo.getProperties(), puInfo.getProperties());
            if (EntityManagerSetupImpl.isComposite(memberPuInfo)) {
                Map<String, SEPersistenceUnitInfo> containedMemberPuInfoMap = EntityManagerSetupImpl.getCompositeMemberPuInfoMap(memberPuInfo, memberPuInfo.getProperties());
                for (Map.Entry<String, SEPersistenceUnitInfo> entry : containedMemberPuInfoMap.entrySet()) {
                    String containedMemberPuName = entry.getKey();
                    SEPersistenceUnitInfo containedMemberPuInfo = entry.getValue();
                    SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(containedMemberPuName);
                    if (anotherMemeberPuInfo == null) {
                        memberPuInfoMap.put(containedMemberPuName, containedMemberPuInfo);
                        continue;
                    }
                    EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(containedMemberPuName, containedMemberPuInfo, anotherMemeberPuInfo);
                }
                continue;
            }
            String memberPuName = memberPuInfo.getPersistenceUnitName();
            SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(memberPuName);
            if (anotherMemeberPuInfo == null) {
                memberPuInfoMap.put(memberPuName, memberPuInfo);
                continue;
            }
            EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(memberPuName, memberPuInfo, anotherMemeberPuInfo);
        }
        return memberPuInfoMap;
    }

    protected static Set<SEPersistenceUnitInfo> getCompositeMemberPuInfoSet(PersistenceUnitInfo puInfo, Map predeployProperties) {
        return new HashSet<SEPersistenceUnitInfo>(EntityManagerSetupImpl.getCompositeMemberPuInfoMap(puInfo, predeployProperties).values());
    }

    public static void throwPersistenceUnitNameAlreadyInUseException(String puName, PersistenceUnitInfo newPuInfo, PersistenceUnitInfo exsitingPuInfo) {
        String anotherPuUrl;
        String puUrl;
        try {
            puUrl = URLDecoder.decode(newPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
            anotherPuUrl = URLDecoder.decode(exsitingPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            puUrl = newPuInfo.getPersistenceUnitRootUrl().toString();
            anotherPuUrl = exsitingPuInfo.getPersistenceUnitRootUrl().toString();
        }
        throw PersistenceUnitLoadingException.persistenceUnitNameAlreadyInUse(puName, puUrl, anotherPuUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerSetupImpl refreshMetadata(Map properties) {
        String sessionName = this.getSessionName();
        String uniqueName = this.getPersistenceUnitUniqueName();
        EntityManagerSetupImpl newSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
        newSetupImpl.setIsInContainerMode(this.isInContainerMode);
        newSetupImpl.enableWeaving = this.enableWeaving;
        HashMap refreshProperties = new HashMap();
        refreshProperties.putAll(this.getSession().getProperties());
        if (properties != null) {
            refreshProperties.putAll(properties);
        }
        newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        if (!this.isInContainerMode) {
            newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            SessionManager.getManager().getSessions().remove(sessionName, this.getSession());
            if (EntityManagerFactoryProvider.emSetupImpls.get(sessionName).equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(sessionName);
            }
            this.setIsMetadataExpired(true);
            this.getSession().setRefreshMetadataListener(null);
            EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, newSetupImpl);
        }
        return newSetupImpl;
    }

    @Override
    public void triggerMetadataRefresh(Map properties) {
        this.refreshMetadata(properties);
    }

    public void writeDDL(Map props, DatabaseSessionImpl session, ClassLoader classLoader) {
        if (this.compositeMemberEmSetupImpls == null) {
            if (EntityManagerFactoryProvider.hasConfigProperty("eclipselink.ddl-generation", props)) {
                String ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation", props).toLowerCase();
                if (!ddlGeneration.equals("none")) {
                    this.writeDDL(ddlGeneration, props, session, classLoader);
                }
            } else {
                String scriptsGenerationAction;
                String validOptions;
                String databaseGenerationAction;
                if (EntityManagerFactoryProvider.hasConfigProperty("javax.persistence.schema-generation.database.action", props) && !(databaseGenerationAction = EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.database.action", props).toLowerCase()).equals("none")) {
                    if (databaseGenerationAction.equals("create")) {
                        this.writeDDL("javax.persistence.schema-generation.create-source", "javax.persistence.schema-generation.create-script-source", TableCreationType.CREATE, props, session, classLoader);
                    } else if (databaseGenerationAction.equals("create-or-extend-tables")) {
                        this.writeDDL("javax.persistence.schema-generation.create-source", "javax.persistence.schema-generation.create-script-source", TableCreationType.EXTEND, props, session, classLoader);
                    } else if (databaseGenerationAction.equals("drop")) {
                        this.writeDDL("javax.persistence.schema-generation.drop-source", "javax.persistence.schema-generation.drop-script-source", TableCreationType.DROP, props, session, classLoader);
                    } else if (databaseGenerationAction.equals("drop-and-create")) {
                        this.writeDDL("javax.persistence.schema-generation.drop-source", "javax.persistence.schema-generation.drop-script-source", TableCreationType.DROP, props, session, classLoader);
                        this.writeDDL("javax.persistence.schema-generation.create-source", "javax.persistence.schema-generation.create-script-source", TableCreationType.CREATE, props, session, classLoader);
                    } else {
                        validOptions = "create, drop, drop-and-create, create-or-extend-tables";
                        session.log(6, "properties", "ddl_generation_unknown_property_value", new Object[]{"javax.persistence.schema-generation.database.action", databaseGenerationAction, this.persistenceUnitInfo.getPersistenceUnitName(), validOptions});
                    }
                }
                if (EntityManagerFactoryProvider.hasConfigProperty("javax.persistence.schema-generation.scripts.action", props) && !(scriptsGenerationAction = EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.scripts.action", props).toLowerCase()).equals("none")) {
                    if (scriptsGenerationAction.equals("create")) {
                        this.writeMetadataDDLToScript(TableCreationType.CREATE, props, session, classLoader);
                    } else if (scriptsGenerationAction.equals("create-or-extend-tables")) {
                        this.writeMetadataDDLToScript(TableCreationType.EXTEND, props, session, classLoader);
                    } else if (scriptsGenerationAction.equals("drop")) {
                        this.writeMetadataDDLToScript(TableCreationType.DROP, props, session, classLoader);
                    } else if (scriptsGenerationAction.equals("drop-and-create")) {
                        this.writeMetadataDDLToScript(TableCreationType.DROP_AND_CREATE, props, session, classLoader);
                    } else {
                        validOptions = "create, drop, drop-and-create";
                        session.log(6, "properties", "ddl_generation_unknown_property_value", new Object[]{"javax.persistence.schema-generation.scripts.action", scriptsGenerationAction, this.persistenceUnitInfo.getPersistenceUnitName(), validOptions});
                    }
                }
                this.writeSourceScriptToDatabase(EntityManagerFactoryProvider.getConfigProperty("javax.persistence.sql-load-script-source", props), session, classLoader);
            }
        } else {
            Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", props);
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
                compositeMemberEmSetupImpl.writeDDL(compositeMemberProperties, session, classLoader);
            }
        }
    }

    protected void writeDDL(String ddlGeneration, Map props, DatabaseSessionImpl session, ClassLoader classLoader) {
        String ddlGenerationMode;
        TableCreationType ddlType = TableCreationType.NONE;
        if (ddlGeneration.equals("create-tables")) {
            ddlType = TableCreationType.CREATE;
        } else if (ddlGeneration.equals("drop-tables")) {
            ddlType = TableCreationType.DROP;
        } else if (ddlGeneration.equals("drop-and-create-tables")) {
            ddlType = TableCreationType.DROP_AND_CREATE;
        } else if (ddlGeneration.equals("create-or-extend-tables")) {
            ddlType = TableCreationType.EXTEND;
        } else {
            String validOptions = "none, create-tables, drop-tables, drop-and-create-tables, create-or-extend-tables";
            session.log(6, "properties", "ddl_generation_unknown_property_value", new Object[]{"eclipselink.ddl-generation", ddlGeneration, this.persistenceUnitInfo.getPersistenceUnitName(), validOptions});
        }
        if (ddlType != TableCreationType.NONE && !(ddlGenerationMode = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation.output-mode", props, "database")).equals("none")) {
            if (this.isCompositeMember()) {
                session.log(1, "properties", "composite_member_begin_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
            }
            SchemaManager mgr = new SchemaManager(session);
            if (ddlGenerationMode.equals("database") || ddlGenerationMode.equals("both")) {
                this.writeDDLToDatabase(mgr, ddlType);
            }
            if (ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both")) {
                String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", props, PersistenceUnitProperties.DEFAULT_APP_LOCATION);
                Object createDDLJdbc = EntityManagerFactoryProvider.getConfigProperty("eclipselink.create-ddl-jdbc-file-name", props, "createDDL.jdbc");
                Object dropDDLJdbc = EntityManagerFactoryProvider.getConfigProperty("eclipselink.drop-ddl-jdbc-file-name", props, "dropDDL.jdbc");
                this.writeDDLToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc, ddlType, props);
            }
            if (!(ddlGenerationMode.equals("database") || ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both"))) {
                String validOptions = "database, sql-script, both";
                session.log(6, "properties", "ddl_generation_unknown_property_value", new Object[]{"eclipselink.ddl-generation.output-mode", ddlGenerationMode, this.persistenceUnitInfo.getPersistenceUnitName(), validOptions});
            }
            if (this.isCompositeMember()) {
                session.log(1, "properties", "composite_member_end_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
            }
        }
    }

    protected void writeDDL(String generationSourceProperty, String scriptGenerationSourceProperty, TableCreationType tableCreationType, Map props, DatabaseSessionImpl session, ClassLoader loader) {
        String generationSource = EntityManagerFactoryProvider.getConfigPropertyAsString(generationSourceProperty, props);
        Object scriptGenerationSource = EntityManagerFactoryProvider.getConfigProperty(scriptGenerationSourceProperty, props);
        if (generationSource == null) {
            if (scriptGenerationSource == null) {
                this.writeMetadataDDLToDatabase(tableCreationType, props, session, loader);
            } else {
                this.writeSourceScriptToDatabase(scriptGenerationSource, session, loader);
            }
        } else if (generationSource.equals("metadata")) {
            this.writeMetadataDDLToDatabase(tableCreationType, props, session, loader);
        } else if (generationSource.equals("script")) {
            this.writeSourceScriptToDatabase(scriptGenerationSource, session, loader);
        } else if (generationSource.equals("metadata-then-script")) {
            this.writeMetadataDDLToDatabase(tableCreationType, props, session, loader);
            this.writeSourceScriptToDatabase(scriptGenerationSource, session, loader);
        } else if (generationSource.equals("script-then-metadata")) {
            this.writeSourceScriptToDatabase(scriptGenerationSource, session, loader);
            this.writeMetadataDDLToDatabase(tableCreationType, props, session, loader);
        } else {
            String validOptions = "metadata, script, metadata-then-script, script-then-metadata";
            session.log(6, "properties", "ddl_generation_unknown_property_value", new Object[]{generationSourceProperty, generationSource, this.persistenceUnitInfo.getPersistenceUnitName(), validOptions});
        }
    }

    protected void writeDDLToDatabase(SchemaManager mgr, TableCreationType ddlType) {
        String str = EntityManagerFactoryProvider.getConfigPropertyAsString("INTERACT_WITH_DB", null, "true");
        boolean interactWithDB = Boolean.valueOf(str.toLowerCase());
        if (!interactWithDB) {
            return;
        }
        EntityManagerFactoryProvider.generateDefaultTables(mgr, ddlType);
    }

    protected void writeDDLToFiles(SchemaManager mgr, String appLocation, Object createDDLJdbc, Object dropDDLJdbc, TableCreationType ddlType) {
        this.writeDDLToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc, ddlType, Collections.EMPTY_MAP);
    }

    protected void writeDDLToFiles(SchemaManager mgr, String appLocation, Object createDDLJdbc, Object dropDDLJdbc, TableCreationType ddlType, Map props) {
        String appLocationPrefix;
        String string = appLocationPrefix = appLocation == null ? "" : EntityManagerSetupImpl.addFileSeperator(appLocation);
        if (ddlType.equals((Object)TableCreationType.CREATE) || ddlType.equals((Object)TableCreationType.DROP_AND_CREATE) || ddlType.equals((Object)TableCreationType.EXTEND)) {
            if (createDDLJdbc == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21-ddl-create-script-target-not-specified"));
            }
            if (createDDLJdbc instanceof Writer) {
                mgr.outputCreateDDLToWriter((Writer)createDDLJdbc);
            } else {
                mgr.outputCreateDDLToFile(String.valueOf(appLocationPrefix) + createDDLJdbc);
            }
        }
        if (ddlType.equals((Object)TableCreationType.DROP) || ddlType.equals((Object)TableCreationType.DROP_AND_CREATE)) {
            if (dropDDLJdbc == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21-ddl-drop-script-target-not-specified"));
            }
            if (dropDDLJdbc instanceof Writer) {
                mgr.outputDropDDLToWriter((Writer)dropDDLJdbc);
            } else if (dropDDLJdbc instanceof String) {
                mgr.outputDropDDLToFile(String.valueOf(appLocationPrefix) + dropDDLJdbc);
            } else {
                throw new PersistenceException(ExceptionLocalization.buildMessage("jpa21-ddl-invalid-target-script-type", new Object[]{dropDDLJdbc, dropDDLJdbc.getClass()}));
            }
        }
        String propString = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddlgen-terminate-statements", props);
        boolean terminator = Boolean.parseBoolean(propString);
        mgr.setCreateSQLFiles(terminator);
        EntityManagerFactoryProvider.generateDefaultTables(mgr, ddlType);
        mgr.closeDDLWriter();
    }

    protected void writeMetadataDDLToDatabase(TableCreationType tableCreationType, Map props, DatabaseSessionImpl session, ClassLoader classLoader) {
        SchemaManager mgr = new SchemaManager(session);
        String createSchemas = EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.create-database-schemas", props);
        mgr.setCreateDatabaseSchemas(createSchemas != null && createSchemas.equalsIgnoreCase("true"));
        this.writeDDLToDatabase(mgr, tableCreationType);
    }

    protected void writeMetadataDDLToScript(TableCreationType tableCreationType, Map props, DatabaseSessionImpl session, ClassLoader classLoader) {
        SchemaManager mgr = new SchemaManager(session);
        String createSchemas = EntityManagerFactoryProvider.getConfigPropertyAsString("javax.persistence.schema-generation.create-database-schemas", props);
        mgr.setCreateDatabaseSchemas(createSchemas != null && createSchemas.equalsIgnoreCase("true"));
        this.writeDDLToFiles(mgr, EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", props), EntityManagerFactoryProvider.getConfigProperty("javax.persistence.schema-generation.scripts.create-target", props), EntityManagerFactoryProvider.getConfigProperty("javax.persistence.schema-generation.scripts.drop-target", props), tableCreationType, props);
    }

    protected void writeSourceScriptToDatabase(Object source, DatabaseSessionImpl session, ClassLoader loader) {
        if (source != null) {
            Reader reader;
            block23: {
                reader = null;
                try {
                    try {
                        if (source instanceof Reader) {
                            reader = (Reader)source;
                        } else if (source instanceof String) {
                            URL sourceURL = loader.getResource((String)source);
                            if (sourceURL == null) {
                                try {
                                    sourceURL = new URL((String)source);
                                }
                                catch (MalformedURLException e) {
                                    throw new PersistenceException(ExceptionLocalization.buildMessage("jpa21-ddl-source-script-not-found", new Object[]{source}), (Throwable)e);
                                }
                            }
                            URLConnection connection = sourceURL.openConnection();
                            connection.setUseCaches(false);
                            reader = new InputStreamReader(connection.getInputStream(), "UTF-8");
                        } else {
                            throw new PersistenceException(ExceptionLocalization.buildMessage("jpa21-ddl-invalid-source-script-type", new Object[]{source, source.getClass()}));
                        }
                        if (reader == null) break block23;
                        int data = reader.read();
                        while (data != -1) {
                            StringBuffer sqlBuffer = new StringBuffer();
                            char aChar = (char)data;
                            while (aChar != '\n' && data != -1) {
                                sqlBuffer.append(aChar);
                                data = reader.read();
                                aChar = (char)data;
                            }
                            String sqlString = sqlBuffer.toString().trim();
                            if (!sqlString.equals("") && !sqlString.startsWith("#")) {
                                try {
                                    session.executeNonSelectingSQL(sqlString);
                                }
                                catch (DatabaseException databaseException) {}
                            }
                            data = reader.read();
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        throw new PersistenceException(ExceptionLocalization.buildMessage("jpa21-ddl-source-script-io-exception", new Object[]{source}), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static enum TableCreationType {
        NONE,
        CREATE,
        DROP,
        DROP_AND_CREATE,
        EXTEND;

    }
}

