/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.core.mappings.converters.CoreConverter;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.AnyAttributeMapping;
import org.eclipse.persistence.internal.oxm.mappings.AnyCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.AnyObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelOutputResolver;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

public class SchemaModelGenerator {
    protected static final String SCHEMA_FILE_NAME = "schema";
    protected static final String SCHEMA_FILE_EXT = ".xsd";
    protected static final String TEXT = "text()";
    protected static final String ID = "ID";
    protected static final String IDREF = "IDREF";
    protected static String SWAREF_LOCATION;
    private ConversionManager conversionManager;

    public SchemaModelGenerator(ConversionManager conversionManager) {
        this(conversionManager, false);
    }

    public SchemaModelGenerator(ConversionManager conversionManager, boolean customSwaRefSchema) {
        this.conversionManager = conversionManager;
        SWAREF_LOCATION = customSwaRefSchema ? String.valueOf("swaRef".toLowerCase()) + SCHEMA_FILE_EXT : "http://ws-i.org/profiles/basic/1.1/swaref.xsd";
    }

    public Map<String, Schema> generateSchemas(java.util.List<Descriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, Map<QName, Type> additionalGlobalElements) throws DescriptorException {
        Map<String, Schema> schemaForNamespace = this.generateSchemas(descriptorsToProcess, properties);
        if (additionalGlobalElements != null) {
            for (Map.Entry<QName, Type> entry : additionalGlobalElements.entrySet()) {
                QName qname = entry.getKey();
                Type type = entry.getValue();
                if (!(type instanceof Class)) continue;
                Class tClass = (Class)type;
                String nsKey = qname.getNamespaceURI();
                Schema schema = schemaForNamespace.get(nsKey);
                QName typeAsQName = this.conversionManager.schemaType(tClass);
                if (typeAsQName == null) {
                    Descriptor desc = this.getDescriptorByClass(tClass, descriptorsToProcess);
                    if (desc == null) continue;
                    if (schema == null) {
                        schema = this.buildNewSchema(nsKey, new org.eclipse.persistence.oxm.NamespaceResolver(), schemaForNamespace.size(), properties);
                        schemaForNamespace.put(nsKey, schema);
                        typeAsQName = desc.getSchemaReference().getSchemaContextAsQName();
                        Schema schemaForUri = schemaForNamespace.get(typeAsQName.getNamespaceURI());
                        if (!this.importExists(schema, schemaForUri.getTargetNamespace())) {
                            Import newImport = new Import();
                            newImport.setNamespace(schemaForUri.getTargetNamespace());
                            newImport.setSchemaLocation(schemaForUri.getName());
                            schema.getImports().add(newImport);
                        }
                    } else {
                        typeAsQName = desc.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver());
                    }
                }
                if (schema == null) {
                    schema = this.buildNewSchema(nsKey, new org.eclipse.persistence.oxm.NamespaceResolver(), schemaForNamespace.size(), properties);
                    schemaForNamespace.put(nsKey, schema);
                }
                Element element = new Element();
                element.setName(qname.getLocalPart());
                element.setType(this.getSchemaTypeString(typeAsQName, schema));
                schema.addTopLevelElement(element);
            }
        }
        return schemaForNamespace;
    }

    public Map<String, Schema> generateSchemas(java.util.List<Descriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties) throws DescriptorException {
        HashMap<String, Schema> schemaForNamespace = new HashMap<String, Schema>();
        Schema workingSchema = null;
        if (properties == null) {
            properties = new SchemaModelGeneratorProperties();
        }
        for (Descriptor desc : descriptorsToProcess) {
            String namespace;
            XMLSchemaReference schemaRef = desc.getSchemaReference();
            if (schemaRef != null) {
                namespace = schemaRef.getSchemaContextAsQName((NamespaceResolver)desc.getNamespaceResolver()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, (NamespaceResolver)desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema((NamespaceResolver)desc.getNamespaceResolver(), workingSchema);
                continue;
            }
            for (DatabaseTable table : desc.getTables()) {
                namespace = this.getDefaultRootElementAsQName(desc, table.getName()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, (NamespaceResolver)desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema((NamespaceResolver)desc.getNamespaceResolver(), workingSchema);
            }
        }
        for (Descriptor xdesc : descriptorsToProcess) {
            this.processDescriptor(xdesc, schemaForNamespace, workingSchema, properties, descriptorsToProcess);
        }
        return schemaForNamespace;
    }

    public Map<String, Schema> generateSchemas(java.util.List<Descriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, SchemaModelOutputResolver outputResolver, Map<QName, Type> additionalGlobalElements) throws DescriptorException {
        Map<String, Schema> schemas = this.generateSchemas(descriptorsToProcess, properties, additionalGlobalElements);
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext(proj);
        XMLMarshaller marshaller = context.createMarshaller();
        Descriptor schemaDescriptor = (Descriptor)((Object)proj.getDescriptor(Schema.class));
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            try {
                org.eclipse.persistence.oxm.NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
                schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
                schemaDescriptor.setNamespaceResolver(schemaNamespaces);
                Result target = outputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                marshaller.marshal((Object)schema, target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return schemas;
    }

    public Map<String, Schema> generateSchemas(java.util.List<Descriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, SchemaModelOutputResolver outputResolver) throws DescriptorException {
        return this.generateSchemas(descriptorsToProcess, properties, outputResolver, null);
    }

    protected void processDescriptor(Descriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        boolean simple = this.isSimple(desc);
        XMLSchemaReference schemaRef = desc.getSchemaReference();
        if (schemaRef != null) {
            if (schemaRef.getType() == 1) {
                workingSchema.addTopLevelComplexTypes(this.buildComplexType(false, desc, schemaForNamespace, workingSchema, properties, descriptors));
            } else if (schemaRef.getType() == 2) {
                workingSchema.addTopLevelSimpleTypes(this.buildSimpleType(desc, workingSchema, true));
            } else if (schemaRef.getType() == 3) {
                workingSchema.addTopLevelElement(this.buildElement(desc, schemaForNamespace, workingSchema, properties, descriptors, simple));
            }
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                if (workingSchema.getTopLevelElements().get(localName) != null) continue;
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                QName qname = schemaRef.getSchemaContextAsQName(workingSchema.getNamespaceResolver());
                String elementType = qname.getLocalPart();
                String elementTypeUri = qname.getNamespaceURI();
                String elementTypePrefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(elementTypeUri);
                if (elementTypePrefix != null) {
                    elementType = String.valueOf(elementTypePrefix) + ':' + elementType;
                }
                topLevelElement.setType(elementType);
                workingSchema.addTopLevelElement(topLevelElement);
            }
        } else {
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                if (workingSchema.getTopLevelElements().get(localName) != null) continue;
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                if (simple) {
                    if (this.isComplexTypeWithSimpleContentRequired(desc)) {
                        topLevelElement.setComplexType(this.buildComplexTypeWithSimpleContent(desc, schemaForNamespace, workingSchema, properties, descriptors));
                    } else {
                        topLevelElement.setSimpleType(this.buildSimpleType(desc, workingSchema, false));
                    }
                } else {
                    topLevelElement.setComplexType(this.buildComplexType(true, desc, schemaForNamespace, workingSchema, properties, descriptors));
                }
                workingSchema.addTopLevelElement(topLevelElement);
            }
        }
    }

    protected Schema getSchema(String uri, NamespaceResolver nr, HashMap<String, Schema> schemaForNamespace, SchemaModelGeneratorProperties properties) {
        Schema schema = schemaForNamespace.get(uri);
        if (schema == null) {
            schema = this.buildNewSchema(uri, nr, schemaForNamespace.size(), properties);
            schemaForNamespace.put(uri, schema);
        }
        return schema;
    }

    protected Element buildElement(Descriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors, boolean simple) {
        Element element = new Element();
        element.setName(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        if (simple) {
            if (this.isComplexTypeWithSimpleContentRequired(desc)) {
                element.setComplexType(this.buildComplexTypeWithSimpleContent(desc, schemaForNamespace, workingSchema, properties, descriptors));
            } else {
                element.setSimpleType(this.buildSimpleType(desc, workingSchema, false));
            }
        } else {
            element.setComplexType(this.buildComplexType(true, desc, schemaForNamespace, workingSchema, properties, descriptors));
        }
        return element;
    }

    protected SimpleType buildSimpleType(Descriptor desc, Schema workingSchema, boolean global) {
        SimpleType st = global ? this.buildNewSimpleType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart()) : new SimpleType();
        CoreMapping mapping = (CoreMapping)desc.getMappings().get(0);
        QName qname = this.conversionManager.schemaType(mapping.getAttributeClassification());
        String baseType = qname.getLocalPart();
        if (qname.getNamespaceURI() != null) {
            String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI());
            if (prefix == null) {
                prefix = workingSchema.getNamespaceResolver().generatePrefix();
                workingSchema.getNamespaceResolver().put(prefix, qname.getNamespaceURI());
            }
            baseType = String.valueOf(prefix) + ':' + baseType;
        }
        Restriction restriction = new Restriction();
        restriction.setBaseType(baseType);
        st.setRestriction(restriction);
        return st;
    }

    protected SimpleType buildNewSimpleType(String name) {
        SimpleType st = new SimpleType();
        st.setName(name);
        return st;
    }

    protected ComplexType buildComplexType(boolean anonymous, Descriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        ComplexType ct = new ComplexType();
        if (!anonymous) {
            ct.setName(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        }
        Object inheritancePolicy = desc.getInheritancePolicyOrNull();
        Extension extension = null;
        if (inheritancePolicy != null && ((CoreInheritancePolicy)inheritancePolicy).getParentClass() != null) {
            extension = new Extension();
            extension.setBaseType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
            ComplexContent complexContent = new ComplexContent();
            complexContent.setExtension(extension);
            ct.setComplexContent(complexContent);
        }
        Sequence seq = new Sequence();
        for (CoreMapping mapping : desc.getMappings()) {
            this.processMapping(mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        }
        if (extension != null) {
            extension.setSequence(seq);
        } else {
            ct.setSequence(seq);
        }
        return ct;
    }

    private ComplexType buildComplexTypeWithSimpleContent(Descriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        ComplexType ct = new ComplexType();
        SimpleContent sc = new SimpleContent();
        Extension extension = new Extension();
        sc.setExtension(extension);
        ct.setSimpleContent(sc);
        for (CoreMapping mapping : desc.getMappings()) {
            Field xFld = (Field)mapping.getField();
            if (xFld.getXPath().equals(TEXT)) {
                extension.setBaseType(this.getSchemaTypeForDirectMapping((DirectMapping)((Object)mapping), workingSchema));
                continue;
            }
            if (!xFld.getXPathFragment().isAttribute()) continue;
            String schemaTypeString = this.getSchemaTypeForDirectMapping((DirectMapping)((Object)mapping), workingSchema);
            Attribute attr = this.buildAttribute((DirectMapping)((Object)mapping), schemaTypeString);
            extension.getOrderedAttributes().add(attr);
        }
        return ct;
    }

    protected String getSchemaTypeForDirectMapping(DirectMapping mapping, Schema workingSchema) {
        return this.getSchemaTypeForElement((Field)mapping.getField(), mapping.getAttributeClassification(), workingSchema);
    }

    protected String getSchemaTypeForElement(Field xmlField, Class attrClass, Schema workingSchema) {
        String schemaTypeString = null;
        QName schemaType = xmlField.getSchemaType();
        if (schemaType != null) {
            schemaTypeString = this.getSchemaTypeString(schemaType, workingSchema);
        } else if (attrClass != null && !attrClass.equals(CoreClassConstants.STRING)) {
            QName qName = this.conversionManager.schemaType(attrClass);
            if (qName != null) {
                schemaTypeString = this.getSchemaTypeString(qName, workingSchema);
            }
        } else {
            schemaTypeString = this.getSchemaTypeString(Constants.STRING_QNAME, workingSchema);
        }
        return schemaTypeString;
    }

    protected Descriptor getDescriptorByName(String javaClassName, java.util.List<Descriptor> descriptors) {
        for (Descriptor xDesc : descriptors) {
            if (!xDesc.getJavaClassName().equals(javaClassName)) continue;
            return xDesc;
        }
        return null;
    }

    protected Descriptor getDescriptorByClass(Class javaClass, java.util.List<Descriptor> descriptors) {
        for (Descriptor xDesc : descriptors) {
            if (xDesc.getJavaClass() == null || xDesc.getJavaClass() != javaClass) continue;
            return xDesc;
        }
        return null;
    }

    protected void processAnyMapping(Sequence seq, boolean isCollection) {
        Any any = new Any();
        any.setProcessContents("lax");
        any.setMinOccurs("0");
        if (isCollection) {
            any.setMaxOccurs("unbounded");
        }
        seq.addAny(any);
    }

    protected void processXMLBinaryDataMapping(BinaryDataMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        String schemaTypeString;
        Field xmlField = (Field)mapping.getField();
        XPathFragment frag = xmlField.getXPathFragment();
        if (mapping.isSwaRef()) {
            schemaTypeString = this.getSchemaTypeString(Constants.SWA_REF_QNAME, workingSchema);
            Import newImport = new Import();
            newImport.setNamespace("http://ws-i.org/profiles/basic/1.1/xsd");
            newImport.setSchemaLocation(SWAREF_LOCATION);
            workingSchema.getImports().add(newImport);
        } else {
            schemaTypeString = this.getSchemaTypeString(Constants.BASE_64_BINARY_QNAME, workingSchema);
        }
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        frag = this.getTargetXPathFragment(frag);
        Element elem = this.elementExistsInSequence(frag.getLocalName(), frag.getShortName(), seq);
        if (elem == null) {
            elem = frag.getNamespaceURI() != null ? this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, elem, schemaTypeString) : this.buildElement(frag, schemaTypeString, "0", null);
            if (mapping.getNullPolicy().isNullRepresentedByXsiNil()) {
                elem.setNillable(true);
            }
            if (xmlField.isRequired()) {
                elem.setMinOccurs("1");
            }
            if (mapping.getMimeType() != null) {
                elem.getAttributesMap().put(Constants.EXPECTED_CONTENT_TYPES_QNAME, mapping.getMimeType());
            }
            seq.addElement(elem);
        }
    }

    protected void processXMLBinaryDataCollectionMapping(BinaryDataCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        Field xmlField = (Field)mapping.getField();
        XPathFragment frag = xmlField.getXPathFragment();
        String schemaTypeString = mapping.isSwaRef() ? this.getSchemaTypeString(Constants.SWA_REF_QNAME, workingSchema) : this.getSchemaTypeString(Constants.BASE_64_BINARY_QNAME, workingSchema);
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        Element elem = this.elementExistsInSequence((frag = this.getTargetXPathFragment(frag)).getLocalName(), frag.getShortName(), seq);
        if (elem == null) {
            if (frag.getNamespaceURI() != null) {
                elem = this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, elem, schemaTypeString);
                elem.setMaxOccurs("unbounded");
            } else {
                elem = this.buildElement(frag, schemaTypeString, "0", "unbounded");
            }
            if (mapping.getNullPolicy().isNullRepresentedByXsiNil()) {
                elem.setNillable(true);
            }
            if (xmlField.isRequired()) {
                elem.setMinOccurs("1");
            }
            if (mapping.getMimeType() != null) {
                elem.getAttributesMap().put(Constants.EXPECTED_CONTENT_TYPES_QNAME, mapping.getMimeType());
            }
            seq.addElement(elem);
        }
    }

    protected void processXMLDirectMapping(DirectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        Object converter;
        Field xmlField = (Field)mapping.getField();
        XPathFragment frag = xmlField.getXPathFragment();
        if (frag.isSelfFragment()) {
            return;
        }
        boolean isPk = this.isFragPrimaryKey(frag, mapping);
        String schemaTypeString = null;
        schemaTypeString = isPk ? "xsd:ID" : this.getSchemaTypeForDirectMapping(mapping, workingSchema);
        Class attributeClassification = mapping.getAttributeClassification();
        if (attributeClassification != null && Enum.class.isAssignableFrom(attributeClassification) && (converter = mapping.getConverter()) != null && converter instanceof EnumTypeConverter) {
            this.processEnumeration(schemaTypeString, frag, mapping, seq, ct, workingSchema, (CoreConverter)converter);
            return;
        }
        if (frag.isAttribute()) {
            Attribute attr = this.buildAttribute(mapping, schemaTypeString);
            if (xmlField.isRequired()) {
                attr.setUse("required");
            }
            ct.getOrderedAttributes().add(attr);
        } else {
            seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
            Element elem = this.elementExistsInSequence((frag = this.getTargetXPathFragment(frag)).getLocalName(), frag.getShortName(), seq);
            if (elem == null) {
                elem = frag.getNamespaceURI() != null ? this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, elem, schemaTypeString) : this.buildElement(frag, schemaTypeString, "0", null);
                if (mapping.getNullPolicy().isNullRepresentedByXsiNil()) {
                    elem.setNillable(true);
                }
                if (xmlField.isRequired()) {
                    elem.setMinOccurs("1");
                }
                seq.addElement(elem);
            }
        }
    }

    protected void processXMLCompositeDirectCollectionMapping(DirectCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        Field xmlField = (Field)mapping.getField();
        XPathFragment frag = xmlField.getXPathFragment();
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        frag = this.getTargetXPathFragment(frag);
        String schemaTypeString = this.getSchemaTypeForElement(xmlField, mapping.getAttributeElementClass(), workingSchema);
        Element element = null;
        if (xmlField.usesSingleNode()) {
            SimpleType st = new SimpleType();
            List list = new List();
            if (schemaTypeString == null) {
                schemaTypeString = this.getSchemaTypeString(Constants.ANY_SIMPLE_TYPE_QNAME, workingSchema);
            }
            list.setItemType(schemaTypeString);
            st.setList(list);
            element = this.buildElement(xmlField.getXPathFragment(), null, "0", null);
            element.setSimpleType(st);
        } else if (frag.getNamespaceURI() != null) {
            element = this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, element, schemaTypeString);
            element.setMaxOccurs("unbounded");
        } else {
            element = this.buildElement(frag, schemaTypeString, "0", "unbounded");
        }
        if (mapping.getNullPolicy().isNullRepresentedByXsiNil()) {
            element.setNillable(true);
        }
        if (xmlField.isRequired()) {
            element.setMinOccurs("1");
        }
        seq.addElement(element);
    }

    protected void processXMLCompositeMapping(CompositeObjectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors, boolean collection) {
        Field xmlField = (Field)mapping.getField();
        String refClassName = mapping.getReferenceClassName();
        Descriptor refDesc = this.getDescriptorByName(refClassName, descriptors);
        if (refDesc == null) {
            throw DescriptorException.descriptorIsMissing(refClassName, (DatabaseMapping)((Object)mapping));
        }
        XPathFragment frag = xmlField.getXPathFragment();
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        frag = this.getTargetXPathFragment(frag);
        Element element = this.buildElement(frag, null, "0", collection ? "unbounded" : null);
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        if (frag.getNamespaceURI() != null) {
            element = this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, element, ctype, refDesc);
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        boolean isNillable = false;
        isNillable = !collection ? mapping.getNullPolicy().isNullRepresentedByXsiNil() : ((CompositeCollectionMapping)mapping).getNullPolicy().isNullRepresentedByXsiNil();
        element.setNillable(isNillable);
        if (xmlField.isRequired()) {
            element.setMinOccurs("1");
        }
        seq.addElement(element);
    }

    protected void processXMLChoiceCollectionMapping(ChoiceCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        Map<Field, Class> fieldToClassMap = mapping.getFieldToClassMappings();
        java.util.List<XMLChoiceFieldToClassAssociation> choiceFieldToClassList = mapping.getChoiceFieldToClassAssociations();
        this.processChoiceMapping(fieldToClassMap, choiceFieldToClassList, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
    }

    protected void processXMLChoiceObjectMapping(ChoiceObjectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        Map<Field, Class> fieldToClassMap = mapping.getFieldToClassMappings();
        java.util.List<XMLChoiceFieldToClassAssociation> choiceFieldToClassList = mapping.getChoiceFieldToClassAssociations();
        this.processChoiceMapping(fieldToClassMap, choiceFieldToClassList, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
    }

    protected void processChoiceMapping(Map<Field, Class> fieldToClassMap, java.util.List<XMLChoiceFieldToClassAssociation> choiceFieldToClassList, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors, boolean isCollection) {
        Choice theChoice = new Choice();
        if (isCollection) {
            theChoice.setMaxOccurs("unbounded");
        }
        for (XMLChoiceFieldToClassAssociation next : choiceFieldToClassList) {
            Object field = next.getXmlField();
            Element element = this.buildElement(field.getXPathFragment().getShortName(), "0", null);
            QName schemaTypeQName = field.getSchemaType();
            if (schemaTypeQName != null) {
                element.setType(this.getSchemaTypeString(schemaTypeQName, workingSchema));
            } else {
                element = this.processReferenceDescriptor(element, this.getDescriptorByClass(fieldToClassMap.get(field), descriptors), schemaForNamespace, workingSchema, properties, descriptors, (Field)field, false);
            }
            theChoice.addElement(element);
        }
        seq.addChoice(theChoice);
    }

    protected void processXMLObjectReferenceMapping(ObjectReferenceMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors, boolean isCollection) {
        String tgtClassName = mapping.getReferenceClassName();
        Descriptor tgtDesc = this.getDescriptorByName(tgtClassName, descriptors);
        if (tgtDesc == null) {
            throw DescriptorException.descriptorIsMissing(tgtClassName, (DatabaseMapping)((Object)mapping));
        }
        String schemaTypeString = null;
        Map associations = mapping.getSourceToTargetKeyFieldAssociations();
        for (Map.Entry entry : associations.entrySet()) {
            XPathFragment frag;
            Field tgtField = (Field)entry.getValue();
            Vector mappings = tgtDesc.getMappings();
            Enumeration mappingsNum = mappings.elements();
            while (mappingsNum.hasMoreElements()) {
                Field xFld;
                Mapping nextMapping = (Mapping)mappingsNum.nextElement();
                if (nextMapping.getField() == null || !(nextMapping.getField() instanceof Field) || (xFld = (Field)nextMapping.getField()) != tgtField) continue;
                schemaTypeString = this.getSchemaTypeForElement(tgtField, nextMapping.getAttributeClassification(), workingSchema);
            }
            if (schemaTypeString == null) {
                schemaTypeString = this.getSchemaTypeString(Constants.STRING_QNAME, workingSchema);
            }
            if ((frag = ((Field)entry.getKey()).getXPathFragment()).isAttribute()) {
                Attribute attr = this.buildAttribute(frag, schemaTypeString);
                ct.getOrderedAttributes().add(attr);
                continue;
            }
            Element elem = this.buildElement(frag, schemaTypeString, "0", null);
            if (isCollection) {
                elem.setMaxOccurs("unbounded");
            }
            seq.addElement(elem);
        }
    }

    protected void processMapping(CoreMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors) {
        if (mapping instanceof BinaryDataMapping) {
            this.processXMLBinaryDataMapping((BinaryDataMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof BinaryDataCollectionMapping) {
            this.processXMLBinaryDataCollectionMapping((BinaryDataCollectionMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof DirectMapping) {
            this.processXMLDirectMapping((DirectMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof DirectCollectionMapping) {
            this.processXMLCompositeDirectCollectionMapping((DirectCollectionMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof CompositeCollectionMapping) {
            this.processXMLCompositeMapping((CompositeCollectionMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
        } else if (mapping instanceof CompositeObjectMapping) {
            this.processXMLCompositeMapping((CompositeObjectMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
        } else if (mapping instanceof AnyAttributeMapping) {
            AnyAttribute anyAttribute = new AnyAttribute();
            anyAttribute.setProcessContents("lax");
            ct.setAnyAttribute(anyAttribute);
        } else if (mapping instanceof AnyObjectMapping) {
            this.processAnyMapping(seq, false);
        } else if (mapping instanceof AnyCollectionMapping) {
            this.processAnyMapping(seq, true);
        } else if (mapping instanceof ChoiceObjectMapping) {
            this.processXMLChoiceObjectMapping((ChoiceObjectMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        } else if (mapping instanceof ChoiceCollectionMapping) {
            this.processXMLChoiceCollectionMapping((ChoiceCollectionMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        } else if (mapping instanceof CollectionReferenceMapping) {
            this.processXMLObjectReferenceMapping((CollectionReferenceMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
        } else if (mapping instanceof ObjectReferenceMapping) {
            this.processXMLObjectReferenceMapping((ObjectReferenceMapping)((Object)mapping), seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
        }
    }

    protected Element handleFragNamespace(XPathFragment frag, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, Element element, String schemaTypeString) {
        String fragUri = frag.getNamespaceURI();
        Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
        String targetNS = workingSchema.getTargetNamespace();
        if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && fragUri.length() > 0) {
            if (s.getTopLevelElements().get(frag.getLocalName()) == null) {
                Element globalElement = new Element();
                globalElement.setName(frag.getLocalName());
                globalElement.setType(schemaTypeString);
                s.addTopLevelElement(globalElement);
            }
            element = new Element();
            element.setRef(frag.getShortName());
        } else {
            element = this.buildElement(frag, schemaTypeString, "0", null);
        }
        return element;
    }

    protected Element handleFragNamespace(XPathFragment frag, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, Element element, ComplexType ctype, Descriptor refDesc) {
        String fragUri = frag.getNamespaceURI();
        Element globalElement = null;
        Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
        String targetNS = workingSchema.getTargetNamespace();
        if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && fragUri.length() > 0) {
            globalElement = (Element)s.getTopLevelElements().get(frag.getLocalName());
            if (globalElement == null) {
                globalElement = new Element();
                globalElement.setName(frag.getLocalName());
                if (ctype != null) {
                    globalElement.setComplexType(ctype);
                } else {
                    globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                }
                s.addTopLevelElement(globalElement);
            }
            element = new Element();
            element.setMaxOccurs("unbounded");
            element.setRef(frag.getShortName());
        }
        if (globalElement == null && ctype != null) {
            element.setComplexType(ctype);
        }
        return element;
    }

    /*
     * Unable to fully structure code
     */
    protected XPathFragment getTargetXPathFragment(XPathFragment frag) {
        if (!frag.isAttribute() && !frag.isSelfFragment()) ** GOTO lbl-1000
        return frag;
        while ((frag = frag.getNextFragment()).getNextFragment() != null && !frag.getNextFragment().nameIsText()) lbl-1000:
        // 2 sources

        {
            if (frag.getNextFragment() != null && !frag.getNextFragment().nameIsText()) continue;
        }
        return frag;
    }

    protected Sequence buildSchemaComponentsForXPath(XPathFragment frag, Sequence seq, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        boolean currentElementExists;
        if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
            return seq;
        }
        Sequence currentSequence = seq;
        Element currentElement = this.elementExistsInSequence(frag.getLocalName(), frag.getShortName(), currentSequence);
        boolean bl = currentElementExists = currentElement != null;
        if (currentElement == null) {
            currentElement = new Element();
            ComplexType cType = new ComplexType();
            Sequence sequence = new Sequence();
            cType.setSequence(sequence);
            currentElement.setComplexType(cType);
        }
        Element globalElement = null;
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && fragUri.length() > 0) {
                globalElement = (Element)s.getTopLevelElements().get(frag.getLocalName());
                if (globalElement == null) {
                    globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    ComplexType gCType = new ComplexType();
                    Sequence gSequence = new Sequence();
                    gCType.setSequence(gSequence);
                    globalElement.setComplexType(gCType);
                    s.addTopLevelElement(globalElement);
                }
                if (!currentElementExists) {
                    currentElement.setComplexType(null);
                    currentElement.setRef(frag.getShortName());
                    currentSequence.addElement(currentElement);
                    currentElementExists = true;
                }
                currentElement = globalElement;
            }
        }
        if (!currentElementExists && globalElement == null) {
            currentElement.setName(frag.getLocalName());
            currentSequence.addElement(currentElement);
        }
        currentSequence = currentElement.getComplexType().getSequence();
        if ((frag = frag.getNextFragment()).getNextFragment() != null && !frag.getNextFragment().nameIsText()) {
            Element childElt = this.buildElement(frag, null, "0", null);
            currentSequence.addElement(childElt);
        }
        return this.buildSchemaComponentsForXPath(frag, currentSequence, schemaForNamespace, workingSchema, properties);
    }

    protected Attribute buildAttribute(DirectMapping mapping, String schemaType) {
        XPathFragment frag = ((Field)mapping.getField()).getXPathFragment();
        Attribute attr = new Attribute();
        attr.setName(frag.getShortName());
        attr.setType(schemaType);
        return attr;
    }

    protected Attribute buildAttribute(XPathFragment frag, String schemaType) {
        Attribute attr = new Attribute();
        attr.setName(frag.getShortName());
        attr.setType(schemaType);
        return attr;
    }

    protected Element buildElement(XPathFragment frag, String schemaType, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(frag.getLocalName());
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(frag.containsIndex() ? "unbounded" : maxOccurs);
        if (schemaType != null) {
            element.setType(schemaType);
        }
        return element;
    }

    protected Element buildElement(String name, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(name);
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        return element;
    }

    public boolean areNamespacesEqual(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || ns2.equals("");
        }
        return ns1.equals(ns2) || ns1.equals("") && ns2 == null;
    }

    protected String getSchemaTypeString(QName schemaType, Schema workingSchema) {
        String schemaTypeString = schemaType.getLocalPart();
        String uri = schemaType.getNamespaceURI();
        String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(uri);
        if (prefix == null && !this.areNamespacesEqual(uri, workingSchema.getDefaultNamespace())) {
            prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? workingSchema.getNamespaceResolver().generatePrefix("xsd") : (uri.equals("http://www.w3.org/2001/XMLSchema-instance") ? workingSchema.getNamespaceResolver().generatePrefix("xsi") : (uri.equals("http://ws-i.org/profiles/basic/1.1/xsd") ? workingSchema.getNamespaceResolver().generatePrefix("ref") : workingSchema.getNamespaceResolver().generatePrefix()));
            workingSchema.getNamespaceResolver().put(prefix, uri);
        }
        if (prefix != null) {
            schemaTypeString = String.valueOf(prefix) + ':' + schemaTypeString;
        }
        return schemaTypeString;
    }

    protected void addNamespacesToWorkingSchema(NamespaceResolver nr, Schema workingSchema) {
        if (nr != null) {
            Vector descNamespaces = nr.getNamespaces();
            for (Namespace nextNamespace : descNamespaces) {
                workingSchema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
            }
        }
    }

    protected Schema buildNewSchema(String uri, NamespaceResolver nr, int schemaCount, SchemaModelGeneratorProperties properties) {
        Properties props;
        Schema schema = new Schema();
        schema.setName(SCHEMA_FILE_NAME + schemaCount + SCHEMA_FILE_EXT);
        ++schemaCount;
        String defaultNamespace = null;
        if (nr != null && (defaultNamespace = nr.getDefaultNamespaceURI()) != null) {
            schema.setDefaultNamespace(defaultNamespace);
            schema.getNamespaceResolver().setDefaultNamespaceURI(defaultNamespace);
        }
        if (!uri.equals("")) {
            schema.setTargetNamespace(uri);
            String prefix = null;
            if (nr != null) {
                prefix = nr.resolveNamespaceURI(uri);
            }
            if (prefix == null && !uri.equals(defaultNamespace)) {
                prefix = schema.getNamespaceResolver().generatePrefix();
                schema.getNamespaceResolver().put(prefix, uri);
            }
        }
        if (properties != null && (props = properties.getProperties(uri)) != null) {
            if (props.containsKey("elementFormQualified")) {
                schema.setElementFormDefault((Boolean)props.get("elementFormQualified"));
            }
            if (props.containsKey("attributeFormQualified")) {
                schema.setAttributeFormDefault((Boolean)props.get("attributeFormQualified"));
            }
        }
        return schema;
    }

    protected boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (Import nextImport : imports) {
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    protected QName getDefaultRootElementAsQName(Descriptor desc, String qualifiedTableName) {
        QName qName = null;
        int idx = qualifiedTableName.indexOf(58);
        String localName = qualifiedTableName.substring(idx + 1);
        Object nsResolver = desc.getNamespaceResolver();
        if (nsResolver == null) {
            qName = new QName(localName);
        } else if (idx > -1) {
            String prefix = qualifiedTableName.substring(0, idx);
            String uri = ((NamespaceResolver)nsResolver).resolveNamespacePrefix(prefix);
            qName = new QName(uri, localName);
        } else {
            qName = ((NamespaceResolver)nsResolver).getDefaultNamespaceURI() != null ? new QName(((NamespaceResolver)nsResolver).getDefaultNamespaceURI(), localName) : new QName(localName);
        }
        return qName;
    }

    protected Element processReferenceDescriptor(Element element, Descriptor refDesc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<Descriptor> descriptors, Field field, boolean isCollection) {
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        XPathFragment frag = field.getXPathFragment();
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && fragUri.length() > 0) {
                if (s.getTopLevelElements().get(frag.getShortName()) == null) {
                    Element globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    if (ctype != null) {
                        globalElement.setComplexType(ctype);
                    } else {
                        globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                    }
                    s.getTopLevelElements().put(frag.getShortName(), globalElement);
                }
                element = new Element();
                element.setMinOccurs("0");
                if (isCollection) {
                    element.setMaxOccurs("unbounded");
                }
                element.setRef(frag.getShortName());
            } else {
                element.setComplexType(ctype);
            }
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        return element;
    }

    protected Element elementExistsInSequence(String elementName, String refString, Sequence seq) {
        if (seq.isEmpty()) {
            return null;
        }
        java.util.List existingElements = seq.getOrderedElements();
        if (existingElements != null) {
            Iterator elementIt = existingElements.iterator();
            while (elementIt.hasNext()) {
                Element element;
                try {
                    element = (Element)elementIt.next();
                }
                catch (ClassCastException classCastException) {
                    continue;
                }
                if ((element.getRef() == null || !element.getRef().equals(refString)) && (element.getName() == null || !element.getName().equals(elementName))) continue;
                return element;
            }
        }
        return null;
    }

    protected boolean isSimple(Descriptor desc) {
        boolean isSimple = false;
        for (CoreMapping mapping : desc.getMappings()) {
            if (!mapping.isDirectToFieldMapping()) break;
            Field xFld = (Field)mapping.getField();
            if (!xFld.getXPath().equals(TEXT)) continue;
            isSimple = true;
            break;
        }
        return isSimple;
    }

    protected boolean isComplexTypeWithSimpleContentRequired(Descriptor desc) {
        return desc.getMappings().size() > 1;
    }

    protected void processEnumeration(String schemaTypeString, XPathFragment frag, DirectMapping mapping, Sequence seq, ComplexType ct, Schema workingSchema, CoreConverter converter) {
        Element elem = null;
        Attribute attr = null;
        if (frag.isAttribute()) {
            attr = this.buildAttribute(mapping, schemaTypeString);
        } else {
            elem = this.buildElement(frag, schemaTypeString, "0", null);
        }
        Collection fieldValues = ((EnumTypeConverter)converter).getAttributeToFieldValues().values();
        ArrayList<String> facets = new ArrayList<String>();
        for (String field : fieldValues) {
            facets.add(field);
        }
        Restriction restriction = new Restriction();
        restriction.setEnumerationFacets(facets);
        SimpleType st = new SimpleType();
        st.setRestriction(restriction);
        if (frag.isAttribute()) {
            attr.setSimpleType(st);
            ct.getOrderedAttributes().add(attr);
        } else {
            elem.setSimpleType(st);
            seq.addElement(elem);
        }
    }

    protected boolean isFragPrimaryKey(XPathFragment frag, DirectMapping mapping) {
        return false;
    }
}

