/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.osgi.internal;

import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.TimerNpRunnable;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.osgi.EJBPersistentTimerRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBTimerRuntime;
import com.ibm.ws.ejbcontainer.timer.osgi.internal.TimerNpSERunnable;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.ejbcontainer.osgi.EJBTimerRuntime", service={EJBTimerRuntime.class}, configurationPid={"com.ibm.ws.ejbcontainer.timer.runtime"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
public class EJBTimerRuntimeImpl
implements EJBTimerRuntime {
    private static final TraceComponent tc = Tr.register(EJBTimerRuntimeImpl.class);
    private static final String REFERENCE_PERSISTENT_EXECUTOR = "persistentExecutor";
    private static final String REFERENCE_EJB_PERSISTENT_TIMER_RUNTIME = "ejbPersistentTimerRuntime";
    private static final String PERSISTENT_EXECUTOR_REF = "persistentExecutorRef";
    private static final String LATE_TIMER_THRESHOLD = "lateTimerThreshold";
    private static final String NP_RETRY_INTERVAL = "nonPersistentRetryInterval";
    private static final String NP_MAX_RETRIES = "nonPersistentMaxRetries";
    private ScheduledExecutorService executorService;
    private volatile String configuredPersistentExecutor;
    private final AtomicServiceReference<ScheduledExecutorService> persistentExecutorRef = new AtomicServiceReference("persistentExecutor");
    private final AtomicServiceReference<EJBPersistentTimerRuntime> ejbPersistentTimerRuntimeServiceRef = new AtomicServiceReference("ejbPersistentTimerRuntime");
    private volatile long lateTimerThreshold = 300000L;
    private volatile int npTimerServiceTimerRetryCount = -1;
    private volatile long npTimerServiceTimerRetryInterval = 300000L;
    static final long serialVersionUID = -5691531877557301427L;

    @Reference
    protected void setExecutorService(ScheduledExecutorService executor) {
        this.executorService = executor;
    }

    protected void unsetExecutorService(ScheduledExecutorService executor) {
        this.executorService = null;
    }

    @Reference(name="persistentExecutor", service=ScheduledExecutorService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(id=unbound)")
    protected void setPersistentExecutor(ServiceReference<ScheduledExecutorService> ref) {
        this.persistentExecutorRef.setReference(ref);
        EJBPersistentTimerRuntime pTRuntime = this.getPersistentTimerRuntime();
        if (pTRuntime != null) {
            pTRuntime.resetAndCheckDatabasePolling();
        }
    }

    protected void unsetPersistentExecutor(ServiceReference<ScheduledExecutorService> ref) {
        this.persistentExecutorRef.unsetReference(ref);
        EJBPersistentTimerRuntime pTRuntime = this.getPersistentTimerRuntime();
        if (pTRuntime != null) {
            pTRuntime.resetAndCheckDatabasePolling();
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.persistentExecutorRef.activate(cc);
        this.ejbPersistentTimerRuntimeServiceRef.activate(cc);
        this.updateConfiguration(properties);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> properties) {
        this.updateConfiguration(properties);
    }

    @Trivial
    private void updateConfiguration(Map<String, Object> properties) {
        this.configuredPersistentExecutor = (String)properties.get(PERSISTENT_EXECUTOR_REF);
        Long lateTimerThresholdMinutes = (Long)properties.get(LATE_TIMER_THRESHOLD);
        Integer npMaxRetries = (Integer)properties.get(NP_MAX_RETRIES);
        Long npRetryIntervalSeconds = (Long)properties.get(NP_RETRY_INTERVAL);
        if (lateTimerThresholdMinutes != null) {
            this.lateTimerThreshold = TimeUnit.MINUTES.toMillis(lateTimerThresholdMinutes);
        }
        if (npMaxRetries != null) {
            this.npTimerServiceTimerRetryCount = npMaxRetries;
        }
        if (npRetryIntervalSeconds != null) {
            this.npTimerServiceTimerRetryInterval = TimeUnit.MILLISECONDS.convert(npRetryIntervalSeconds, TimeUnit.SECONDS);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lateTimerThreshold=" + this.lateTimerThreshold + ", " + NP_MAX_RETRIES + "=" + this.npTimerServiceTimerRetryCount + ", " + NP_RETRY_INTERVAL + "=" + this.npTimerServiceTimerRetryInterval), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.persistentExecutorRef.deactivate(cc);
        this.ejbPersistentTimerRuntimeServiceRef.deactivate(cc);
    }

    public TimerNpRunnable createNonPersistentTimerTaskHandler(TimerNpImpl timer) {
        return new TimerNpSERunnable(this.executorService, timer, this.npTimerServiceTimerRetryCount, this.npTimerServiceTimerRetryInterval);
    }

    public long getLateTimerThreshold() {
        return this.lateTimerThreshold;
    }

    public ScheduledExecutorService getPersistentExecutor() {
        ScheduledExecutorService pExecutor = (ScheduledExecutorService)this.persistentExecutorRef.getService();
        if (pExecutor == null && this.configuredPersistentExecutor != null) {
            throw new IllegalStateException("The ejbPersistentTimer feature is enabled, but the " + this.configuredPersistentExecutor + " persistent executor configured for the timerService element in the server.xml file cannot be resolved. Correct the configuration of the " + this.configuredPersistentExecutor + " persistent executor and ensure the referenced datasource is configured properly.");
        }
        return pExecutor;
    }

    public ServiceReference<ScheduledExecutorService> getPersistentExecutorRef() {
        return this.persistentExecutorRef.getReference();
    }

    private EJBPersistentTimerRuntime getPersistentTimerRuntime() {
        return (EJBPersistentTimerRuntime)this.ejbPersistentTimerRuntimeServiceRef.getService();
    }

    @Reference(name="ejbPersistentTimerRuntime", service=EJBPersistentTimerRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setEJBPersistentTimerRuntime(ServiceReference<EJBPersistentTimerRuntime> ref) {
        this.ejbPersistentTimerRuntimeServiceRef.setReference(ref);
    }

    protected void unsetEJBPersistentTimerRuntime(ServiceReference<EJBPersistentTimerRuntime> ref) {
        this.ejbPersistentTimerRuntimeServiceRef.unsetReference(ref);
    }
}

