/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParserException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ejb.TimerMethodData;
import java.util.Date;
import java.util.List;
import javax.ejb.ScheduleExpression;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class AutomaticTimerBean {
    private static final String CLASS_NAME = AutomaticTimerBean.class.getName();
    private static final TraceComponent tc = Tr.register(AutomaticTimerBean.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final BeanMetaData ivBMD;
    private final List<TimerMethodData> ivMethods;
    private final int ivNumPersistent;
    private final int ivNumNonPersistent;
    private BeanId ivBeanId;

    AutomaticTimerBean(BeanMetaData bmd, List<TimerMethodData> methods) {
        this.ivBMD = bmd;
        this.ivMethods = methods;
        int numPersistent = 0;
        int numNonPersistent = 0;
        for (TimerMethodData timerMethod : methods) {
            for (TimerMethodData.AutomaticTimer timer : timerMethod.getAutomaticTimers()) {
                if (timer.isPersistent()) {
                    ++numPersistent;
                    continue;
                }
                ++numNonPersistent;
            }
        }
        this.ivNumPersistent = numPersistent;
        this.ivNumNonPersistent = numNonPersistent;
    }

    public BeanMetaData getBeanMetaData() {
        return this.ivBMD;
    }

    public List<TimerMethodData> getMethods() {
        return this.ivMethods;
    }

    public int getNumPersistentTimers() {
        return this.ivNumPersistent;
    }

    public int getNumNonPersistentTimers() {
        return this.ivNumNonPersistent;
    }

    public BeanId getBeanId() {
        if (this.ivBeanId == null) {
            this.ivBeanId = new BeanId(this.ivBMD.j2eeName, null, false);
        }
        return this.ivBeanId;
    }

    public ParsedScheduleExpression parseScheduleExpression(TimerMethodData.AutomaticTimer timer) {
        ScheduleExpression schedule = timer.getSchedule();
        String start = timer.getStart();
        String end = timer.getEnd();
        try {
            if (start != null) {
                schedule.start(this.parseXSDDateTime("start", start));
            }
            if (end != null) {
                schedule.end(this.parseXSDDateTime("end", end));
            }
            return ScheduleExpressionParser.parse(schedule);
        }
        catch (ScheduleExpressionParserException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".parseScheduleExpression"), (String)"541", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to parse schedule expression", (Object[])new Object[]{ex});
            }
            ex.logError(this.ivBMD.j2eeName.getModule(), this.ivBMD.j2eeName.getComponent(), timer.getMethod().getMethod().getName());
            throw ex;
        }
    }

    private Date parseXSDDateTime(String fieldName, String dateTime) {
        try {
            return new Date(DateHelper.parse(dateTime));
        }
        catch (IllegalArgumentException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".parseXSDDateTime"), (String)"566", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to parse schedule date/time", (Object[])new Object[]{ex});
            }
            throw new ScheduleExpressionParserException(ScheduleExpressionParserException.Error.VALUE, fieldName, dateTime);
        }
    }

    private static final class DateHelper {
        private DateHelper() {
        }

        public static long parse(String dateTime) {
            return DatatypeConverter.parseDateTime((String)dateTime).getTimeInMillis();
        }

        static {
            try {
                JAXBContext.newInstance((Class[])new Class[]{DateHelper.class});
            }
            catch (JAXBException jAXBException) {
                // empty catch block
            }
        }
    }
}

