/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.metatype.OutputVersion;
import com.ibm.websphere.metatype.SchemaVersion;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.Generator;
import com.ibm.ws.config.schemagen.internal.SchemaGeneratorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class GeneratorOptions {
    public static final ResourceBundle messages;
    public static final ResourceBundle options;
    private final HashSet<String> ignoredPids = new HashSet();
    private String outputFile;
    private String encoding = "UTF-8";
    private Locale locale = Locale.getDefault();
    private SchemaVersion schemaVersion = SchemaVersion.getEnum((String)"");
    private OutputVersion outputVersion = OutputVersion.getEnum((String)"");
    private boolean compactOutput = false;
    static final long serialVersionUID = 8953535594185102169L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Set<String> getIgnoredPids() {
        return this.ignoredPids;
    }

    public void addExcludeFile(PidFileArgument pidFileArgument) throws IOException {
        String temp;
        FileInputStream stream = pidFileArgument.getFileInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((temp = reader.readLine()) != null) {
            this.ignoredPids.add(temp.trim());
        }
        reader.close();
    }

    public Generator.ReturnCode processArgs(String[] args) {
        Generator.ReturnCode rc = Generator.ReturnCode.OK;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String argToLower = arg.toLowerCase();
            if (arg.startsWith("-")) {
                if (argToLower.contains("-help")) {
                    return Generator.ReturnCode.HELP_ACTION;
                }
                if (argToLower.contains("-ignorepidsfile")) {
                    try {
                        this.addExcludeFile(new PidFileArgument(args[i]));
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.schemagen.internal.GeneratorOptions", (String)"92", (Object)this, (Object[])new Object[]{args});
                        System.out.println(MessageFormat.format(messages.getString("error.fileNotFound"), args[i]));
                        System.out.println();
                        rc = Generator.ReturnCode.BAD_ARGUMENT;
                    }
                    continue;
                }
                if (argToLower.contains("-encoding")) {
                    this.setEncoding(this.getArgumentValue(args[i]));
                    continue;
                }
                if (argToLower.contains("-locale")) {
                    this.setLocale(new LocaleArgument(args[i]).getLocale());
                    continue;
                }
                if (argToLower.contains("-schemaversion")) {
                    this.setSchemaVersion(SchemaVersion.getEnum((String)this.getArgumentValue(argToLower)));
                    continue;
                }
                if (argToLower.contains("-outputversion")) {
                    this.setOutputVersion(OutputVersion.getEnum((String)this.getArgumentValue(argToLower)));
                    continue;
                }
                if (argToLower.contains("-compactoutput")) {
                    this.setCompactOutput(Boolean.parseBoolean(this.getArgumentValue(args[i])));
                    continue;
                }
                System.out.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                System.out.println();
                rc = Generator.ReturnCode.BAD_ARGUMENT;
                continue;
            }
            if (this.outputFile != null) {
                System.out.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                continue;
            }
            this.outputFile = arg;
            rc = Generator.ReturnCode.GENERATE_ACTION;
        }
        if (this.outputFile == null) {
            System.out.println(messages.getString("error.targetRequired"));
            rc = Generator.ReturnCode.BAD_ARGUMENT;
        }
        return rc;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public File getLibraryDir() {
        File libDir = this.getLibLocation();
        if (libDir == null) {
            throw new SchemaGeneratorException(messages.getString("error.schemaGenInvalidJarLocation"));
        }
        return libDir;
    }

    /*
     * WARNING - void declaration
     */
    private File getLibLocation() {
        String classFullPath = Generator.class.getName().replace('.', '/') + ".class";
        ClassLoader classloader = Generator.class.getClassLoader();
        if (classloader != null) {
            URI libURI;
            URL libURL = classloader.getResource(classFullPath);
            try {
                libURI = new URI(libURL.getFile());
            }
            catch (URISyntaxException uRISyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.config.schemagen.internal.GeneratorOptions", (String)"163", (Object)this, (Object[])new Object[0]);
                throw new RuntimeException((Throwable)e);
            }
            String libLocation = libURI.getPath();
            if (!libLocation.endsWith(classFullPath)) {
                throw new SchemaGeneratorException(messages.getString("error.schemaGenInvalidJarLocation"));
            }
            libLocation = libLocation.substring(0, libLocation.indexOf(classFullPath) - 2);
            final File configJar = new File(libLocation);
            if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 1987591147053961932L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return configJar.isFile() && configJar.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }).booleanValue()) {
                return configJar.getParentFile();
            }
            throw new SchemaGeneratorException(messages.getString("error.schemaGenInvalidJarLocation"));
        }
        return null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private String getArgumentValue(String arg) {
        int idx = arg.lastIndexOf("=");
        if (idx < 1) {
            throw new SchemaGeneratorException(MessageFormat.format(messages.getString("error.invalidArgument"), arg));
        }
        return arg.substring(idx + 1);
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public OutputVersion getOutputVersion() {
        return this.outputVersion;
    }

    public boolean getCompactOutput() {
        return this.compactOutput;
    }

    public void setSchemaVersion(SchemaVersion v) {
        this.schemaVersion = v;
    }

    public void setOutputVersion(OutputVersion v) {
        this.outputVersion = v;
    }

    public void setCompactOutput(boolean compactOutput) {
        this.compactOutput = compactOutput;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GeneratorOptions.class);
        messages = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigMessages");
        options = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigOptions");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class LocaleArgument {
        private final Locale locale;
        static final long serialVersionUID = -3078022371476582537L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LocaleArgument(String arg) {
            String localeVal = GeneratorOptions.this.getArgumentValue(arg);
            if (localeVal != null) {
                int index = localeVal.indexOf(95);
                String lang = index == -1 ? localeVal : localeVal.substring(0, index);
                this.locale = index == -1 ? new Locale(lang) : new Locale(lang, localeVal.substring(index + 1));
            } else {
                this.locale = Locale.ROOT;
            }
        }

        public Locale getLocale() {
            return this.locale;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LocaleArgument.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class PidFileArgument {
        private final String fileName;
        static final long serialVersionUID = -1471203393602505940L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PidFileArgument(String arg) {
            this.fileName = GeneratorOptions.this.getArgumentValue(arg);
        }

        /*
         * WARNING - void declaration
         */
        protected FileInputStream getFileInputStream() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){
                    static final long serialVersionUID = 6575741931433386171L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(PidFileArgument.this.fileName);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.config.schemagen.internal.GeneratorOptions$PidFileArgument", (String)"247", (Object)this, (Object[])new Object[0]);
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw new RuntimeException((Throwable)e);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PidFileArgument.class);
        }
    }
}

