/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.ffdc.source;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.logging.Incident;
import com.ibm.wsspi.logging.IncidentForwarder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FFDCSource
implements Source {
    private static final TraceComponent tc = Tr.register(FFDCSource.class);
    public static final int CALLER_DETAILS_CHARS_MAX_SIZE = 2048;
    public static final String NEWLINE_CHARS = System.getProperty("line.separator");
    private final String sourceName = "com.ibm.ws.logging.ffdc.source.ffdcsource";
    private final String location = "memory";
    private BufferManager bufferMgr = null;
    private IncidentHandler incidentHandler;
    static final long serialVersionUID = 285885014848109957L;

    protected synchronized void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
    }

    public String getSourceName() {
        return "com.ibm.ws.logging.ffdc.source.ffdcsource";
    }

    public String getLocation() {
        return "memory";
    }

    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.bufferMgr = bufferMgr;
        this.startSource();
    }

    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Un-setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.stopSource();
        this.bufferMgr = null;
    }

    private void startSource() {
        this.incidentHandler = new IncidentHandler();
        FFDC.registerIncidentForwarder((IncidentForwarder)this.incidentHandler);
    }

    private void stopSource() {
        FFDC.deregisterIncidentForwarder((IncidentForwarder)this.incidentHandler);
        this.incidentHandler = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class IncidentHandler
    implements IncidentForwarder {
        private final AtomicLong seq = new AtomicLong();
        static final long serialVersionUID = 2744717641563309049L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private IncidentHandler() {
        }

        public void process(Incident in, Throwable th) {
            int countVal = in.getCount();
            if (countVal == 1) {
                FFDCData ffdcData = new FFDCData();
                long timeStampVal = in.getTimeStamp();
                ffdcData.setDatetime(timeStampVal);
                ffdcData.setDateOfFirstOccurence(in.getDateOfFirstOccurrence().getTime());
                ffdcData.setCount(countVal);
                ffdcData.setMessage(th.getMessage());
                ffdcData.setClassName(in.getSourceId());
                ffdcData.setLabel(in.getLabel());
                ffdcData.setExceptionName(in.getExceptionName());
                ffdcData.setProbeId(in.getProbeId());
                ffdcData.setSourceId(in.getSourceId());
                ffdcData.setThreadId(in.getThreadId());
                ffdcData.setStacktrace(this.getStackTraceAsString(th));
                ffdcData.setObjectDetails(this.getCallerDetails(in));
                String sequenceVal = timeStampVal + "_" + String.format("%013X", this.seq.incrementAndGet());
                ffdcData.setSequence(sequenceVal);
                ffdcData.setSourceType("com.ibm.ws.logging.ffdc.source.ffdcsource");
                FFDCSource.this.bufferMgr.add((Object)ffdcData);
            }
        }

        private String getCallerDetails(Incident in) {
            String details = null;
            String dump = in.getIntrospectedCallerDump();
            if (dump != null) {
                int firstLineEnd = dump.indexOf(NEWLINE_CHARS);
                int start = firstLineEnd + NEWLINE_CHARS.length();
                int len = dump.length() - start;
                if (len > 2048) {
                    int end = start + 2045;
                    details = dump.substring(start, end) + "...";
                } else {
                    details = dump.substring(start);
                }
            }
            return details;
        }

        private String getStackTraceAsString(Throwable th) {
            StringWriter strBuf = new StringWriter();
            PrintWriter writer = new PrintWriter(strBuf);
            th.printStackTrace(writer);
            writer.close();
            strBuf.flush();
            return strBuf.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(IncidentHandler.class);
        }
    }
}

