/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http2.upgrade.H2UpgradeHandler;
import com.ibm.ws.webcontainer.servlet.H2Handler;
import com.ibm.ws.webcontainer31.upgrade.H2UpgradeHandlerWrapper;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.ee8.Http2InboundConnection;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class H2HandlerImpl
implements H2Handler {
    private static final TraceComponent tc = Tr.register(H2HandlerImpl.class);

    public boolean isH2Request(HttpInboundConnection hic, ServletRequest request) throws ServletException {
        if (!((Http2InboundConnection)hic).isHTTP2UpgradeRequest(null, true)) {
            return false;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpServletRequest hsrt = (HttpServletRequest)request;
        Enumeration headerNames = hsrt.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = hsrt.getHeader(key);
            headers.put(key, value);
        }
        return ((Http2InboundConnection)hic).isHTTP2UpgradeRequest(headers, false);
    }

    public void handleRequest(HttpInboundConnection hic, HttpServletRequest request, HttpServletResponse response) {
        Http2InboundConnection h2ic = (Http2InboundConnection)hic;
        H2UpgradeHandlerWrapper h2uh = null;
        try {
            h2uh = (H2UpgradeHandlerWrapper)request.upgrade(H2UpgradeHandlerWrapper.class);
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw an IOException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        catch (ServletException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw a ServletException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        if (h2uh != null) {
            h2uh.init(new H2UpgradeHandler());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpServletRequest hsrt = request;
        Enumeration headerNames = hsrt.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = hsrt.getHeader(key);
            headers.put(key, value);
        }
        boolean upgraded = h2ic.handleHTTP2UpgradeRequest(headers);
        if (!upgraded) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"returning: http2 connection initialization failed", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
    }
}

