/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.registry.RegistryClaims;
import com.ibm.ws.security.jwt.utils.JwsSigner;
import com.ibm.ws.security.jwt.utils.JwtData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtCreator {
    private static final String JTI_CLAIM = "jti";
    static final long serialVersionUID = -7065558432940573287L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={Exception.class})
    public static String createJwtAsString(JwtData jwtData, Claims jwtclaims) throws JwtTokenException {
        boolean bJwt = jwtData.isJwt();
        String jwt = null;
        try {
            List<String> audiences = null;
            JwtClaims claims = new JwtClaims();
            if (bJwt) {
                String issuer;
                String username;
                String token_type = (String)jwtclaims.get("token_type");
                if (token_type != null) {
                    claims.setClaim("token_type", (Object)token_type);
                }
                if ((audiences = jwtclaims.getAudience()) != null && audiences.size() > 0) {
                    claims.setAudience(audiences);
                }
                if ((username = jwtclaims.getSubject()) != null) {
                    claims.setSubject(username);
                    if (jwtData.getConfig().getClaims() != null) {
                        JwtCreator.addCustomClaims(claims, jwtData.getConfig(), username);
                    }
                }
                for (Map.Entry<String, Object> e : jwtclaims.getAllClaims().entrySet()) {
                    if (e.getKey() == "aud" || e.getKey() == "exp" || e.getKey() == JTI_CLAIM || e.getKey() == "iss" || e.getKey() == "iat" || e.getKey() == "nbf") continue;
                    claims.setClaim(e.getKey(), e.getValue());
                }
                String jti = null;
                jti = jwtclaims.getJwtId();
                if (jti != null) {
                    claims.setClaim(JTI_CLAIM, (Object)jti);
                }
                if ((issuer = jwtclaims.getIssuer()) != null) {
                    claims.setIssuer(jwtclaims.getIssuer());
                }
                long validForInSeconds = jwtData.getConfig().getValidTime();
                long expTimeInSeconds = jwtclaims.getExpiration();
                long issueTimeInSeconds = jwtclaims.getIssuedAt();
                long timeInSeconds = System.currentTimeMillis() / 1000L;
                if (expTimeInSeconds > 0L) {
                    claims.setExpirationTime(NumericDate.fromSeconds((long)expTimeInSeconds));
                } else if (expTimeInSeconds == -2L) {
                    claims.setExpirationTime(NumericDate.fromSeconds((long)(timeInSeconds + validForInSeconds)));
                }
                if (issueTimeInSeconds > 0L) {
                    claims.setIssuedAt(NumericDate.fromSeconds((long)issueTimeInSeconds));
                } else if (issueTimeInSeconds == -2L) {
                    claims.setIssuedAt(NumericDate.fromSeconds((long)timeInSeconds));
                }
                long notBeforeInSeconds = jwtclaims.getNotBefore();
                if (notBeforeInSeconds > 0L) {
                    claims.setNotBefore(NumericDate.fromSeconds((long)notBeforeInSeconds));
                }
            }
            jwt = JwsSigner.getSignedJwt(claims, jwtData);
        }
        catch (Exception e) {
            JwtTokenException jte = JwtTokenException.newInstance(false, "JWT_CREATE_FAIL", new Object[]{e.getLocalizedMessage()});
            jte.initCause(e);
            throw jte;
        }
        return jwt;
    }

    private static void addCustomClaims(JwtClaims claims, JwtConfig jwtConfig, String username) {
        Map<String, Object> customMap = null;
        RegistryClaims regClaims = new RegistryClaims(username);
        customMap = regClaims.fetchExtraClaims(jwtConfig);
        Set<Map.Entry<String, Object>> entries = customMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            claims.setClaim(entry.getKey(), entry.getValue());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JwtCreator.class);
    }
}

