/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigParserException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigParserTolerableException;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.config.xml.internal.validator.XMLConfigValidator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ServerXMLConfiguration {
    private static final TraceComponent tc = Tr.register(ServerXMLConfiguration.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final WsResource configRoot;
    private final WsResource configDropinDefaults;
    private final WsResource configDropinOverrides;
    private final BundleContext bundleContext;
    private ServerConfiguration serverConfiguration;
    private static final String CONFIG_DROPINS = "configDropins";
    private static final String CONFIG_DROPIN_DEFAULTS = "configDropins/defaults/";
    private static final String CONFIG_DROPIN_OVERRIDES = "configDropins/overrides/";
    private volatile long configReadTime = 0L;
    private final XMLConfigParser parser;
    static final long serialVersionUID = -173981188152250166L;

    ServerXMLConfiguration(BundleContext bundleContext, WsLocationAdmin locationService, XMLConfigParser parser) {
        this.bundleContext = bundleContext;
        this.parser = parser;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WsLocationAdmin locations=" + locationService.printLocations(false)), (Object[])new Object[0]);
        }
        this.configRoot = locationService.resolveResource("${server.config.dir}//${wlp.process.type}.xml");
        this.configDropinDefaults = locationService.resolveResource("${server.config.dir}//configDropins/defaults/");
        this.configDropinOverrides = locationService.resolveResource("${server.config.dir}//configDropins/overrides/");
        this.configReadTime = ServerXMLConfiguration.getInitialConfigReadTime(bundleContext);
    }

    boolean hasConfigRoot() {
        return this.configRoot != null;
    }

    private static long getInitialConfigReadTime(BundleContext bundleContext) {
        if (bundleContext == null) {
            return 0L;
        }
        File configStamp = bundleContext.getDataFile("configStamp");
        if (configStamp != null && configStamp.exists() && configStamp.canRead()) {
            return TimestampUtils.readTimeFromFile((File)configStamp);
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigParserTolerableException.class})
    public void loadInitialConfiguration(ConfigVariableRegistry variableRegistry) throws ConfigValidationException, ConfigParserTolerableException {
        block7: {
            if (this.configRoot != null && this.configRoot.exists()) {
                try {
                    this.serverConfiguration = this.loadServerConfiguration();
                    if (this.serverConfiguration == null) {
                        this.serverConfiguration = new ServerConfiguration();
                    }
                }
                catch (ConfigParserTolerableException ex) {
                    throw ex;
                }
                catch (ConfigParserException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"129", (Object)this, (Object[])new Object[]{variableRegistry});
                    Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{ex.getMessage()});
                    this.serverConfiguration = new ServerConfiguration();
                }
                this.serverConfiguration.setDefaultConfiguration(new BaseConfiguration());
            }
            try {
                variableRegistry.updateSystemVariables(this.getVariables());
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("service.vendor", "IBM");
                this.bundleContext.registerService(ConfigVariables.class, (Object)variableRegistry, properties);
            }
            catch (ConfigMergeException properties) {
                void e;
                FFDCFilter.processException((Throwable)properties, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"144", (Object)this, (Object[])new Object[]{variableRegistry});
                if (!ErrorHandler.INSTANCE.fail()) break block7;
                throw new ConfigParserTolerableException((Throwable)e);
            }
        }
    }

    public void setConfigReadTime() {
        long time = this.getLastResourceModifiedTime();
        TimestampUtils.writeTimeToFile((File)this.bundleContext.getDataFile("configStamp"), (long)time);
        this.configReadTime = time;
    }

    private long getLastResourceModifiedTime() {
        long modified;
        String name;
        Iterator defaults;
        long lastModified = this.configRoot.getLastModified();
        if (this.serverConfiguration != null) {
            for (WsResource resource : this.serverConfiguration.getIncludes()) {
                long modified2 = resource.getLastModified();
                if (modified2 <= lastModified) continue;
                lastModified = modified2;
            }
        }
        if (this.configDropinDefaults != null) {
            defaults = this.configDropinDefaults.getChildren();
            while (defaults.hasNext()) {
                name = (String)defaults.next();
                WsResource resource = this.configDropinDefaults.getChild(name);
                modified = resource.getLastModified();
                if (modified <= lastModified) continue;
                lastModified = modified;
            }
        }
        if (this.configDropinOverrides != null) {
            defaults = this.configDropinOverrides.getChildren();
            while (defaults.hasNext()) {
                name = (String)defaults.next();
                WsResource resource = this.configDropinOverrides.getChild(name);
                modified = resource.getLastModified();
                if (modified <= lastModified) continue;
                lastModified = modified;
            }
        }
        return lastModified;
    }

    public boolean isModified() {
        return this.getLastResourceModifiedTime() != this.configReadTime;
    }

    public Collection<String> getFilesToMonitor() {
        HashSet<String> files = new HashSet<String>();
        files.add(this.configRoot.toRepositoryPath());
        for (WsResource resource : this.serverConfiguration.getIncludes()) {
            String path = resource.toRepositoryPath();
            if (path == null) continue;
            files.add(path);
        }
        return files;
    }

    public Collection<String> getDirectoriesToMonitor() {
        HashSet<String> files = new HashSet<String>();
        if (this.configDropinDefaults != null) {
            files.add(this.configDropinDefaults.toRepositoryPath());
        }
        if (this.configDropinOverrides != null) {
            files.add(this.configDropinOverrides.toRepositoryPath());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ConfigParserException.class, ConfigParserTolerableException.class})
    private ServerConfiguration loadServerConfiguration() throws ConfigValidationException, ConfigParserException {
        ServerConfiguration configuration = null;
        XMLConfigValidator configValidator = this.parser.getConfigValidator();
        try {
            try {
                configuration = new ServerConfiguration();
                this.parseDirectoryFiles(this.configDropinDefaults, configuration);
                this.parser.parseServerConfiguration(this.configRoot, configuration);
                this.parseDirectoryFiles(this.configDropinOverrides, configuration);
                configuration.updateLastModified(this.configRoot.getLastModified());
                configValidator.validateConfig(configuration);
            }
            catch (ConfigParserTolerableException ex) {
                throw ex;
            }
            catch (ConfigParserException cpe) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"287", (Object)this, (Object[])new Object[0]);
                }
                finally {
                    configuration = new ServerConfiguration();
                    this.parser.parseServerConfiguration(this.configRoot, configuration);
                    configValidator.validateConfig(configuration);
                }
            }
        }
        catch (ConfigParserException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing root and referenced config documents.  Message=" + ex.getMessage()), (Object[])new Object[0]);
            }
            this.parser.handleParseError(ex, null);
            if (ErrorHandler.INSTANCE.fail()) {
                throw ex;
            }
            if (ex instanceof ConfigParserTolerableException) {
                configuration.updateLastModified(this.configRoot.getLastModified());
            }
            configuration = null;
        }
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    private void parseDirectoryFiles(WsResource directory, ServerConfiguration configuration) throws ConfigParserException, ConfigValidationException {
        if (directory != null) {
            File defaultsDir = directory.asFile();
            if (defaultsDir == null || !defaultsDir.exists()) {
                return;
            }
            File[] defaultFiles = defaultsDir.listFiles(new FilenameFilter(){
                static final long serialVersionUID = -1504909452580965676L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean accept(File dir, String name) {
                    if (name != null) {
                        name = name.toLowerCase();
                        return name.endsWith(".xml");
                    }
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            Arrays.sort(defaultFiles, new AlphaComparator());
            for (int i = 0; i < defaultFiles.length; ++i) {
                File file = defaultFiles[i];
                WsResource defaultFile = directory.getChild(file.getName());
                if (defaultFile == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(file.getName() + " was not found in directory " + directory.getName() + ". Ignoring. "), (Object[])new Object[0]);
                    continue;
                }
                Tr.audit((TraceComponent)tc, (String)"audit.dropin.being.processed", (Object[])new Object[]{defaultFile.asFile()});
                try {
                    this.parser.parseServerConfiguration(defaultFile, configuration);
                    continue;
                }
                catch (ConfigParserException configParserException) {
                    void ex;
                    FFDCFilter.processException((Throwable)configParserException, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"356", (Object)this, (Object[])new Object[]{directory, configuration});
                    this.parser.handleParseError((ConfigParserException)ex, null);
                    if (ErrorHandler.INSTANCE.fail()) {
                        throw ex;
                    }
                    configuration.updateLastModified(this.configRoot.getLastModified());
                }
            }
        }
    }

    @FFDCIgnore(value={ConfigParserTolerableException.class})
    ServerConfiguration loadNewConfiguration() {
        ServerConfiguration newConfiguration = null;
        if (this.configRoot.exists()) {
            try {
                newConfiguration = this.loadServerConfiguration();
                this.setConfigReadTime();
            }
            catch (ConfigParserTolerableException e) {
                String message = e.getMessage() == null ? "Parser Failure" : e.getMessage();
                Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{message});
            }
            catch (ConfigParserException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"383", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e.getMessage()});
            }
            catch (ConfigValidationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ServerXMLConfiguration", (String)"385", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"warn.configValidator.refreshFailed", (Object[])new Object[0]);
            }
            if (newConfiguration == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doRefreshConfiguration(): Error loading new configuration - leaving existing configuration unchanged", (Object[])new Object[0]);
                }
                return null;
            }
        } else {
            newConfiguration = new ServerConfiguration();
        }
        newConfiguration.setDefaultConfiguration(this.serverConfiguration.getDefaultConfiguration());
        return newConfiguration;
    }

    public ServerConfiguration getConfiguration() {
        return this.serverConfiguration;
    }

    public BaseConfiguration getDefaultConfiguration() {
        return this.serverConfiguration.getDefaultConfiguration();
    }

    public Map<String, ConfigVariable> getVariables() throws ConfigMergeException {
        return this.serverConfiguration.getVariables();
    }

    public void setNewConfiguration(ServerConfiguration newConfiguration) {
        this.serverConfiguration = newConfiguration;
    }

    public ServerConfiguration copyConfiguration() {
        ServerConfiguration copy = new ServerConfiguration();
        BaseConfiguration dflt = new BaseConfiguration();
        copy.add(this.getConfiguration());
        dflt.add(this.getDefaultConfiguration());
        copy.setDefaultConfiguration(dflt);
        return copy;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class AlphaComparator
    implements Comparator<File> {
        static final long serialVersionUID = 6998762187785384657L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AlphaComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AlphaComparator.class);
        }
    }
}

